/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.domain.service.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.ptmm.business.domain.repository.AdminOrgStructureRepository;
import kd.hr.ptmm.business.domain.service.IAdminOrgStructureService;

public class AdminOrgStructureServiceImpl
implements IAdminOrgStructureService {
    private static final AdminOrgStructureRepository ADMIN_ORG_STRUCTURE_REPOSITORY = AdminOrgStructureRepository.getInstance();
    private static final Log log = LogFactory.getLog(AdminOrgStructureServiceImpl.class);

    @Override
    public List<Long> listProjectTeamChildIdsById(long id) {
        log.info("listProjectTeamChildIdsById_param_id:{}", (Object)id);
        DynamicObject projectTeam = ADMIN_ORG_STRUCTURE_REPOSITORY.getStructLongNumberByOTId(id);
        if (HRObjectUtils.isEmpty((Object)projectTeam)) {
            return Collections.emptyList();
        }
        String structLongNumber = projectTeam.getString("structlongnumber");
        log.info("listProjectTeamChildIdsById_param_structLongNumber:{}", (Object)structLongNumber);
        DynamicObject[] childProjectTeams = ADMIN_ORG_STRUCTURE_REPOSITORY.queryProjectTeamChildIdsBy(structLongNumber);
        List<Long> childTeamIds = Arrays.stream(childProjectTeams).map(obj -> obj.getLong("orgteam.id")).collect(Collectors.toList());
        log.info("listProjectTeamChildIdsById_param_childTeamIds:{}", childTeamIds);
        return childTeamIds;
    }
}

