/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.domain.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.ptmm.business.domain.bo.ProjectTeamChangeBO;
import kd.hr.ptmm.business.domain.repository.ProjectMemberRepository;
import kd.hr.ptmm.business.domain.repository.TeamMemberRepository;
import kd.hr.ptmm.business.domain.repository.TeamMemberRoleRepository;
import kd.hr.ptmm.business.domain.service.ChangeMemberHisFunc;
import kd.hr.ptmm.business.domain.service.IProAdjustService;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.business.domain.sync.SyncRequestData;
import kd.hr.ptmm.common.constants.ProjectTeamBillConstants;
import kd.hr.ptmm.common.util.DateUtils;
import kd.hr.ptmm.common.util.PtmmDateUtils;

public class ProAdjustServiceImpl
implements IProAdjustService,
ProjectTeamBillConstants {
    private static final Log logger = LogFactory.getLog(ProAdjustServiceImpl.class);
    private final ProjectMemberRepository projectMemberRepository = ProjectMemberRepository.getInstance();
    private final TeamMemberRepository teamMemberRepository = TeamMemberRepository.getInstance();
    private final TeamMemberRoleRepository teamMemberRoleRepository = TeamMemberRoleRepository.getInstance();
    private static final String quitDesc = "Superior adjustment_ Cross project adjustment trigger_quit";
    private static final String newDesc = "Superior adjustment_ Cross project adjustment trigger_new";

    @Override
    public void updateRelation(ProjectTeamChangeBO projectTeamChangeBO) {
        Long teamId = projectTeamChangeBO.getTeamBoId();
        String oldProId = projectTeamChangeBO.getBeforeProjectId();
        String newProId = projectTeamChangeBO.getAfterProjectId();
        String newProNum = "";
        Map<String, Object> newProName = projectTeamChangeBO.getAfterProjectName();
        Date msgDate = projectTeamChangeBO.getChangeTime();
        String proIdField = "projectidentify";
        ArrayList proMemIds = Lists.newArrayListWithExpectedSize((int)16);
        Object[] teamMems = this.teamMemberRepository.loadDynamicObjectArray(new QFilter[]{new QFilter("projectteam", "in", (Object)Sets.newHashSet((Object[])new Long[]{teamId}))});
        if (teamMems.length == 0) {
            return;
        }
        logger.info("ProAdjustServiceImpl updateRelation teamMems: {}", teamMems);
        Set perIds = Arrays.stream(teamMems).map(obj -> obj.getLong("person.id")).collect(Collectors.toSet());
        DynamicObject[] proMems = this.projectMemberRepository.loadDynamicObjectArray(new QFilter[]{new QFilter("person", "in", perIds), new QFilter(proIdField, "in", (Object)Lists.newArrayList((Object[])new String[]{newProId, oldProId}))});
        HashMap per2proMem = Maps.newHashMapWithExpectedSize((int)16);
        Arrays.stream(proMems).forEach(proMem -> {
            if (newProId.equals(proMem.getString(proIdField))) {
                per2proMem.put(proMem.getLong("person.id"), proMem);
            } else {
                proMemIds.add(proMem.getLong("id"));
            }
        });
        logger.info("ProAdjustServiceImpl updateRelation per2proMem: {}", (Object)per2proMem);
        logger.info("ProAdjustServiceImpl updateRelation proMemIds: {}", (Object)proMemIds);
        long[] newProMemIds = ORM.create().genLongIds("ptmm_projectmember", perIds.size() - per2proMem.size());
        int newProMemIdIndex = 0;
        ArrayList saveProMems = Lists.newArrayListWithExpectedSize((int)16);
        HashMap per2proMemDy = Maps.newHashMapWithExpectedSize((int)16);
        for (Long perId : perIds) {
            if (per2proMem.containsKey(perId)) {
                per2proMemDy.put(perId, per2proMem.get(perId));
                proMemIds.add(((DynamicObject)per2proMem.get(perId)).getLong("id"));
                continue;
            }
            DynamicObject newProMem = this.projectMemberRepository.generateEmptyDynamicObject();
            newProMem.set("id", (Object)newProMemIds[newProMemIdIndex]);
            proMemIds.add(newProMemIds[newProMemIdIndex]);
            per2proMemDy.put(perId, newProMem);
            ++newProMemIdIndex;
            this.setHisModelAttr(newProMem, msgDate);
            newProMem.set("projectnumber", (Object)newProNum);
            newProMem.set("projectname", newProName);
            newProMem.set("person", (Object)perId);
            newProMem.set("joindate", (Object)msgDate);
            newProMem.set(proIdField, (Object)newProId);
            newProMem.set("createtime", (Object)new Date());
            saveProMems.add(newProMem);
        }
        logger.info("ProAdjustServiceImpl updateRelation saveProMems: {}", (Object)saveProMems);
        try (TXHandle txHandle = TX.required((String)"IProAdjustService");){
            try {
                this.projectMemberRepository.save(saveProMems.toArray(new DynamicObject[0]));
                ArrayList saveTeamMems = Lists.newArrayListWithExpectedSize((int)16);
                HashMap per2TeamMemDy = Maps.newHashMapWithExpectedSize((int)16);
                List serviceTeamMems = Arrays.stream(teamMems).filter(teamMem -> HRStringUtils.equals((String)teamMem.getString("servicestate"), (String)"B")).collect(Collectors.toList());
                long[] teamMemIds = ORM.create().genLongIds("ptmm_teammember", serviceTeamMems.size());
                for (int i = 0; i < serviceTeamMems.size(); ++i) {
                    DynamicObject teamMem2 = (DynamicObject)serviceTeamMems.get(i);
                    if (msgDate.compareTo(teamMem2.getDate("joindate")) > 0) {
                        DynamicObject newTeamMem = this.teamMemberRepository.generateEmptyDynamicObject();
                        HRDynamicObjectUtils.copy((DynamicObject)teamMem2, (DynamicObject)newTeamMem, (Set)Sets.newHashSet((Object[])new String[]{"quitdate", "endbillno"}));
                        newTeamMem.set("id", (Object)teamMemIds[i]);
                        per2TeamMemDy.put(teamMem2.getLong("person.id"), newTeamMem);
                        newTeamMem.set("projectmember", per2proMemDy.get(newTeamMem.getLong("person.id")));
                        newTeamMem.set("joindate", (Object)msgDate);
                        newTeamMem.set("description", (Object)newDesc);
                        newTeamMem.set("createtime", (Object)new Date());
                        saveTeamMems.add(newTeamMem);
                        teamMem2.set("servicestate", (Object)"C");
                        teamMem2.set("quitdate", (Object)HRDateTimeUtils.addDay((Date)msgDate, (long)-1L));
                        teamMem2.set("description", (Object)quitDesc);
                    } else {
                        teamMem2.set("projectmember", per2proMemDy.get(teamMem2.getLong("person.id")));
                        per2TeamMemDy.put(teamMem2.getLong("person.id"), teamMem2);
                    }
                    saveTeamMems.add(teamMem2);
                }
                List reServiceTeamMems = Arrays.stream(teamMems).filter(teamMem -> HRStringUtils.equals((String)teamMem.getString("servicestate"), (String)"A")).collect(Collectors.toList());
                reServiceTeamMems.stream().forEach(reServiceTeamMem -> {
                    reServiceTeamMem.set("projectmember", per2proMemDy.get(reServiceTeamMem.getLong("person.id")));
                    saveTeamMems.add(reServiceTeamMem);
                    per2TeamMemDy.put(reServiceTeamMem.getLong("person.id"), reServiceTeamMem);
                });
                logger.info("ProAdjustServiceImpl updateRelation saveTeamMems: {}", (Object)saveTeamMems);
                this.teamMemberRepository.save(saveTeamMems.toArray(new DynamicObject[0]));
                ArrayList saveTeamMemRoles = Lists.newArrayListWithExpectedSize((int)16);
                ArrayList newTeamMemRoles = Lists.newArrayListWithExpectedSize((int)16);
                ArrayList oldTeamMemRoles = Lists.newArrayListWithExpectedSize((int)16);
                DynamicObject[] teamMemRoles = this.teamMemberRoleRepository.loadDynamicObjectArray(new QFilter[]{new QFilter("projectteam", "=", (Object)teamId)});
                List serviceTeamMemRoles = Arrays.stream(teamMemRoles).filter(teamMemRole -> HRStringUtils.equals((String)teamMemRole.getString("servicestate"), (String)"B")).collect(Collectors.toList());
                long[] newMemRoleIds = ORM.create().genLongIds("ptmm_teammemberrole", serviceTeamMemRoles.size());
                HashSet teamMemRoleIds = Sets.newHashSetWithExpectedSize((int)16);
                for (int i = 0; i < serviceTeamMemRoles.size(); ++i) {
                    DynamicObject teamMemRole2 = (DynamicObject)serviceTeamMemRoles.get(i);
                    if (msgDate.compareTo(teamMemRole2.getDate("joindate")) > 0) {
                        DynamicObject newTeamMemRole = this.teamMemberRoleRepository.generateEmptyDynamicObject();
                        HRDynamicObjectUtils.copy((DynamicObject)teamMemRole2, (DynamicObject)newTeamMemRole, (Set)Sets.newHashSet((Object[])new String[]{"quitdate", "endbillno"}));
                        newTeamMemRole.set("id", (Object)newMemRoleIds[i]);
                        newTeamMemRole.set("projectmember", per2proMemDy.get(newTeamMemRole.getLong("person.id")));
                        newTeamMemRole.set("teammember", per2TeamMemDy.get(newTeamMemRole.getLong("person.id")));
                        newTeamMemRole.set("joindate", (Object)msgDate);
                        newTeamMemRole.set("projectname", newProName);
                        newTeamMemRole.set("description", (Object)newDesc);
                        newTeamMemRole.set("createtime", (Object)new Date());
                        saveTeamMemRoles.add(newTeamMemRole);
                        newTeamMemRoles.add(newTeamMemRole);
                        teamMemRole2.set("servicestate", (Object)"C");
                        teamMemRole2.set("quitdate", (Object)HRDateTimeUtils.addDay((Date)msgDate, (long)-1L));
                        teamMemRole2.set("description", (Object)quitDesc);
                        oldTeamMemRoles.add(teamMemRole2);
                    } else {
                        teamMemRole2.set("projectmember", per2proMemDy.get(teamMemRole2.getLong("person.id")));
                        teamMemRole2.set("teammember", per2TeamMemDy.get(teamMemRole2.getLong("person.id")));
                        teamMemRole2.set("projectname", newProName);
                        teamMemRoleIds.add(teamMemRole2.getLong("id"));
                    }
                    saveTeamMemRoles.add(teamMemRole2);
                }
                List reServiceTeamMemRoles = Arrays.stream(teamMemRoles).filter(teamMem -> HRStringUtils.equals((String)teamMem.getString("servicestate"), (String)"A")).collect(Collectors.toList());
                reServiceTeamMemRoles.stream().forEach(reServiceTeamMemRole -> {
                    reServiceTeamMemRole.set("projectmember", per2proMemDy.get(reServiceTeamMemRole.getLong("person.id")));
                    reServiceTeamMemRole.set("teammember", per2TeamMemDy.get(reServiceTeamMemRole.getLong("person.id")));
                    saveTeamMemRoles.add(reServiceTeamMemRole);
                });
                logger.info("ProAdjustServiceImpl updateRelation saveTeamMemRoles: {}", (Object)saveTeamMemRoles);
                this.teamMemberRoleRepository.save(saveTeamMemRoles.toArray(new DynamicObject[0]));
                logger.info("ProAdjustServiceImpl updateRelation proMemIds: {}", (Object)proMemIds);
                PTMMServiceFactory.teamMemberBillService.refreshProjectMember(proMemIds);
                PTMMServiceFactory.teamMemberBillService.checkAndDeleteNoServiceStateProjectMember(proMemIds);
                logger.info("ProAdjustServiceImpl updateRelation newTeamMemRoles: {}", (Object)newTeamMemRoles);
                logger.info("ProAdjustServiceImpl updateRelation oldTeamMemRoles: {}", (Object)oldTeamMemRoles);
                logger.info("ProAdjustServiceImpl updateRelation teamMemRoleIds: {}", (Object)teamMemRoleIds);
                ArrayList syncRequestDataList = Lists.newArrayListWithExpectedSize((int)16);
                if (!CollectionUtils.isEmpty((Collection)newTeamMemRoles)) {
                    PTMMServiceFactory.roleHisServiceAdapter.createRoleHisByTeamMemberRole(newTeamMemRoles);
                    newTeamMemRoles.stream().forEach(teamMemRole -> {
                        SyncRequestData syncRequestData = new SyncRequestData();
                        syncRequestData.setPersonId(teamMemRole.getLong("person.id"));
                        syncRequestData.setTeamMemberId(teamMemRole.getLong("teammember.id"));
                        syncRequestData.setTeamMemberRoleId(teamMemRole.getLong("id"));
                        syncRequestData.setTeamMemberRole((DynamicObject)teamMemRole);
                        syncRequestData.setSyncType(HRStringUtils.equals((String)teamMemRole.getString("isteammainrole"), (String)"1") ? "1" : "2");
                        syncRequestDataList.add(syncRequestData);
                    });
                }
                if (!CollectionUtils.isEmpty((Collection)oldTeamMemRoles)) {
                    PTMMServiceFactory.roleHisServiceAdapter.quitRoleHisByTeamMemberRole(oldTeamMemRoles);
                    oldTeamMemRoles.stream().forEach(teamMemRole -> {
                        SyncRequestData syncRequestData = new SyncRequestData();
                        syncRequestData.setTeamMemberId(teamMemRole.getLong("teammember.id"));
                        syncRequestData.setTeamMemberRoleId(teamMemRole.getLong("id"));
                        syncRequestData.setTeamMemberRole((DynamicObject)teamMemRole);
                        syncRequestData.setPersonId(teamMemRole.getLong("person.id"));
                        syncRequestData.setSyncType(HRStringUtils.equals((String)teamMemRole.getString("isteammainrole"), (String)"1") ? "3" : "4");
                        syncRequestDataList.add(syncRequestData);
                    });
                }
                if (!CollectionUtils.isEmpty((Collection)teamMemRoleIds)) {
                    PTMMServiceFactory.memberRoleHisService.changeRoleHisVersion(projectTeamChangeBO.getChangeTime(), ChangeMemberHisFunc.changeByTeamMemberRole(new ArrayList<Long>(teamMemRoleIds), PtmmDateUtils.date2LocalDate((Date)projectTeamChangeBO.getChangeTime()), teamMemberRoleHisDOArr -> {
                        for (DynamicObject teamMemberRoleHisDO : teamMemberRoleHisDOArr) {
                            teamMemberRoleHisDO.set("projectname", projectTeamChangeBO.getAfterProjectName());
                            HRBaseServiceHelper orgServiceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
                            DynamicObject orgDO = orgServiceHelper.generateEmptyDynamicObject();
                            orgDO.set("id", (Object)projectTeamChangeBO.getAfterOrgId());
                            teamMemberRoleHisDO.set("belongadminorg", (Object)orgDO);
                            teamMemberRoleHisDO.set("projectidentify", (Object)projectTeamChangeBO.getAfterProjectId());
                        }
                    }));
                }
                if (!CollectionUtils.isEmpty((Collection)syncRequestDataList)) {
                    PTMMServiceFactory.syncTeamMemberService.syncData(syncRequestDataList);
                }
            }
            catch (Exception exception) {
                txHandle.markRollback();
                logger.error("IProAdjustService error: ", (Throwable)exception);
                throw exception;
            }
            logger.info("IProAdjustService execute end");
        }
    }

    private void setHisModelAttr(DynamicObject projectTeamMember, Date value) {
        projectTeamMember.set("bsed", (Object)value);
        projectTeamMember.set("bsled", (Object)DateUtils.getHisMaxDate());
        projectTeamMember.set("iscurrentversion", (Object)"1");
        projectTeamMember.set("datastatus", (Object)"1");
        projectTeamMember.set("enable", (Object)"1");
        projectTeamMember.set("status", (Object)"C");
    }
}

