/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.domain.service.impl;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.ptmm.business.domain.bo.ProjectTeamChangeBO;
import kd.hr.ptmm.business.domain.repository.ProjectMemberRepository;
import kd.hr.ptmm.business.domain.repository.TeamMemberRoleRepository;
import kd.hr.ptmm.business.domain.service.IProjectMemberService;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;

public class ProjectMemberServiceImpl
implements IProjectMemberService {
    private static final ProjectMemberRepository PROJECT_MEMBER_REPOSITORY = ProjectMemberRepository.getInstance();
    private static final TeamMemberRoleRepository MEMBER_ROLE_REPOSITORY = TeamMemberRoleRepository.getInstance();
    private static final Log log = LogFactory.getLog(ProjectMemberServiceImpl.class);

    @Override
    public void updateProjectMemberProjectName(DynamicObject projectTeam, ProjectTeamChangeBO prjTeamChange) {
        DynamicObject[] memberRoles;
        long projectTeamId = projectTeam.getLong("id");
        Map<String, Object> afterProjectName = prjTeamChange.getAfterProjectName();
        Map<Long, String> projectIdentifyMap = PTMMServiceFactory.projectTeamService.listProjectTeamProjectIdentify(Lists.newArrayList((Object[])new Long[]{projectTeamId}));
        String projectIdentify = projectIdentifyMap.get(projectTeamId);
        log.info("updateProjectMemberProjectName_projectIdentify:{},projectName:{}", (Object)projectIdentify, afterProjectName);
        DynamicObject[] projectMembers = PROJECT_MEMBER_REPOSITORY.listProjectMember(projectIdentify);
        Object[] projectMemberIds = Arrays.stream(projectMembers).map(obj -> obj.getLong("id")).toArray();
        log.info("updateProjectMemberProjectName_projectMemberIds:{}", projectMemberIds);
        for (DynamicObject projectMember : projectMembers) {
            projectMember.set("projectname", afterProjectName);
        }
        PROJECT_MEMBER_REPOSITORY.update(projectMembers);
        for (DynamicObject memberRole : memberRoles = PTMMServiceFactory.teamMemberService.listTeamMemberRoleByProjectMemberIds(projectMemberIds)) {
            DynamicObject projectMember = memberRole.getDynamicObject("projectmember");
            memberRole.set("projectname", afterProjectName);
            memberRole.set("projectnumber", projectMember.get("projectnumber"));
        }
        MEMBER_ROLE_REPOSITORY.update(memberRoles);
    }
}

