/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.domain.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.ptmm.business.domain.bo.ProjectTeamChangeBO;
import kd.hr.ptmm.business.domain.repository.ProjectMemberRepository;
import kd.hr.ptmm.business.domain.repository.TeamMemberBillRepository;
import kd.hr.ptmm.business.domain.repository.TeamMemberRepository;
import kd.hr.ptmm.business.domain.repository.TeamMemberRoleRepository;
import kd.hr.ptmm.business.domain.service.ITeamMemberBillService;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.business.domain.sync.SyncRequestData;
import kd.hr.ptmm.business.domain.vid.UpdateVidDto;
import kd.hr.ptmm.common.bean.ProjectMemberKey;
import kd.hr.ptmm.common.constants.ProjectTeamBillConstants;
import kd.hr.ptmm.common.entity.ProjectMemberEntryWrapper;
import kd.hr.ptmm.common.entity.ProjectMemberEntryWrapperFactory;
import kd.hr.ptmm.common.entity.VidPropTypeConfig;
import kd.hr.ptmm.common.enums.AdjustEntryEnum;
import kd.hr.ptmm.common.enums.MemberAdjustAuditStatusEnum;
import kd.hr.ptmm.common.util.DateUtils;
import kd.hr.ptmm.common.util.PropUtils;
import kd.hr.ptmm.common.util.PtmmNPEExpUtil;
import kd.sdk.hr.ptmm.IBillExPoint;
import kd.sdk.hr.ptmm.common.model.SetMemberRoleFromEntryArgs;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class TeamMemberBillServiceImpl
implements ITeamMemberBillService,
ProjectTeamBillConstants {
    private static final Log log = LogFactory.getLog(TeamMemberBillServiceImpl.class);
    private final ProjectMemberRepository projectMemberRepository = ProjectMemberRepository.getInstance();
    private final TeamMemberRepository teamMemberRepository = TeamMemberRepository.getInstance();
    private final TeamMemberRoleRepository teamMemberRoleRepository = TeamMemberRoleRepository.getInstance();
    private final TeamMemberBillRepository teamMemberBillRepository = TeamMemberBillRepository.getInstance();
    Consumer<List<SyncRequestData>> syncMemberRoleHisQuit = syncRequestDataList -> {
        List<DynamicObject> memberRoleList = syncRequestDataList.stream().map(SyncRequestData::getTeamMemberRole).collect(Collectors.toList());
        PTMMServiceFactory.roleHisServiceAdapter.quitRoleHisByTeamMemberRole(memberRoleList);
    };
    Consumer<List<SyncRequestData>> syncMemberRoleHisJoin = syncRequestDataList -> {
        List<DynamicObject> memberRoleList = syncRequestDataList.stream().map(SyncRequestData::getTeamMemberRole).collect(Collectors.toList());
        PTMMServiceFactory.roleHisServiceAdapter.createRoleHisByTeamMemberRole(memberRoleList);
    };

    private static void getTeamAndPersonIds(DynamicObjectCollection adjEntry2, List<Long> afterProjectTeamIds, List<Long> personIds) {
        for (DynamicObject row : adjEntry2) {
            afterProjectTeamIds.add(row.getLong("projectteamadjnew.id"));
            personIds.add(row.getLong("personbaseadj.person.id"));
        }
    }

    private static void assembleSyncQuitData(List<SyncRequestData> syncRequestDataList, ProjectMemberEntryWrapper entryWrapper, SyncRequestData syncRequestData, DynamicObject newRoleObj) {
        if (!entryWrapper.getJoinDate().after(DateUtils.getNowDate())) {
            syncRequestData.setTeamMemberRoleId(newRoleObj.getLong("id"));
            syncRequestData.setSyncType("2");
            syncRequestData.setTeamMemberRole(newRoleObj);
            syncRequestDataList.add(syncRequestData);
        }
    }

    private static void assembleSyncJoinData(List<SyncRequestData> syncRequestDataList, ProjectMemberEntryWrapper entryWrapper, SyncRequestData syncRequestData, long projectTeamMemberId, DynamicObject newRoleObj) {
        if (!entryWrapper.getJoinDate().after(DateUtils.getNowDate())) {
            syncRequestData.setTeamMemberId(projectTeamMemberId);
            syncRequestData.setTeamMemberRoleId(newRoleObj.getLong("id"));
            syncRequestData.setSyncType("1");
            syncRequestData.setTeamMemberRole(newRoleObj);
            syncRequestDataList.add(syncRequestData);
        }
    }

    private static void updateAdjustAuditStatus(DynamicObject adjustBill, String adjustStatus, String auditStatus) {
        adjustBill.set("adjuststatus", (Object)adjustStatus);
        adjustBill.set("auditstatus", (Object)auditStatus);
    }

    @Override
    public void updateTeamMemberBaseAndEntryStatus(DynamicObject[] objs) {
        this.teamMemberJoin(objs);
        this.memberRoleAdjust(objs);
        this.quitTeamMemberOnSummit(Arrays.asList(objs));
    }

    @Override
    public void refreshTeamMemberState(List<DynamicObject> roles) {
        DynamicObject[] teamMembers;
        HashMap mainRoleStatusMap = Maps.newHashMapWithExpectedSize((int)roles.size());
        for (DynamicObject role : roles) {
            if (!"1".equals(role.getString("isteammainrole"))) continue;
            String roleStatus = role.getString("servicestate");
            long teamMemberId = role.getLong("teammember.id");
            mainRoleStatusMap.put(teamMemberId, roleStatus);
        }
        QFilter[] idFilter = new QFilter[]{new QFilter("id", "in", mainRoleStatusMap.keySet())};
        for (DynamicObject teamMember : teamMembers = this.teamMemberRepository.query("servicestate,quitdate", idFilter)) {
            long teamMemberId = teamMember.getLong("id");
            String serviceStatus = (String)mainRoleStatusMap.get(teamMemberId);
            teamMember.set("servicestate", (Object)serviceStatus);
        }
        this.teamMemberRepository.update(teamMembers);
    }

    @Override
    public void refreshProjectMemberJoinDate(List<DynamicObject> teamMemberRoles, boolean isPageData) {
        DynamicObject[] projectMembers;
        Map<Long, DynamicObject> minDateTeamMemberRole = teamMemberRoles.stream().collect(Collectors.toMap(obj -> {
            if (obj.get("projectmember") instanceof DynamicObject) {
                return obj.getLong("projectmember.id");
            }
            return obj.getLong("projectmember");
        }, Function.identity(), BinaryOperator.minBy(Comparator.comparingLong(teamMemberRole -> teamMemberRole.getDate("joindate").getTime()))));
        for (DynamicObject projectMember : projectMembers = this.projectMemberRepository.query("joindate,quitdate", new QFilter[]{new QFilter("id", "in", minDateTeamMemberRole.keySet())})) {
            long projectMemberId = projectMember.getLong("id");
            DynamicObject minDateObj = minDateTeamMemberRole.get(projectMemberId);
            Date minDate = minDateObj.getDate("joindate");
            if (isPageData) {
                Date dbDate = projectMember.getDate("joindate");
                if (!minDate.before(dbDate)) continue;
                projectMember.set("joindate", (Object)minDate);
                continue;
            }
            projectMember.set("joindate", (Object)minDate);
        }
        this.projectMemberRepository.update(projectMembers);
    }

    @Override
    public void refreshProjectMemberStatusAndQuitDate(DynamicObject[] teamMemberRoleObjs) {
        Map<Long, List<DynamicObject>> projectAllRoles = this.getProjectAllRolesByRoles(Lists.newArrayList((Object[])teamMemberRoleObjs));
        this.refreshProjectMemberStatusAndQuitDate(projectAllRoles);
    }

    @Override
    public void refreshProjectMemberStatusAndQuitDateByAllRoles(DynamicObject[] teamMemberRoleObjs) {
        Map<Long, List<DynamicObject>> projectAllRoles = Arrays.stream(teamMemberRoleObjs).collect(Collectors.groupingBy(role -> role.getLong("projectmember.id")));
        this.refreshProjectMemberStatusAndQuitDate(projectAllRoles);
    }

    private void refreshProjectMemberStatusAndQuitDate(Map<Long, List<DynamicObject>> projectAllRoles) {
        DynamicObject[] dbProjectMembers;
        ArrayList quitProjectMember = Lists.newArrayList();
        projectAllRoles.forEach((projectMemberId, roles) -> {
            boolean allQuit = roles.stream().allMatch(role -> "C".equals(role.getString("servicestate")));
            if (allQuit) {
                Optional<DynamicObject> maxDateRole = roles.parallelStream().max(Comparator.comparingLong(role -> role.getDate("quitdate").getTime()));
                maxDateRole.ifPresent(role -> {
                    Date quitDate = role.getDate("quitdate");
                    DynamicObject projectMember = role.getDynamicObject("projectmember");
                    projectMember.set("quitdate", (Object)quitDate);
                    projectMember.set("servicestate", (Object)"C");
                    quitProjectMember.add(projectMember);
                });
            } else {
                boolean noEffect = roles.stream().noneMatch(role -> "B".equals(role.getString("servicestate")));
                DynamicObject projectMember = ((DynamicObject)roles.get(0)).getDynamicObject("projectmember");
                if (noEffect) {
                    projectMember.set("servicestate", (Object)"A");
                    quitProjectMember.add(projectMember);
                } else {
                    log.info("refreshProjectMemberStatusAndQuitDate_active_roles:{}", (Object)projectMember);
                    if (!HRObjectUtils.isEmpty((Object)projectMember)) {
                        projectMember.set("servicestate", (Object)"B");
                        quitProjectMember.add(projectMember);
                    }
                }
            }
        });
        log.info("refreshProjectMemberStatusAndQuitDate_quitProjectMember:{}", (Object)quitProjectMember);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)quitProjectMember)) {
            return;
        }
        Map quitProjectMemberMap = quitProjectMember.stream().collect(Collectors.toMap(obj -> obj.getLong("id"), Function.identity()));
        Long[] updateIds = (Long[])quitProjectMember.stream().map(obj -> obj.getLong("id")).toArray(Long[]::new);
        for (DynamicObject dbProjectMember : dbProjectMembers = this.projectMemberRepository.query("servicestate,quitdate", new QFilter[]{new QFilter("id", "in", (Object)updateIds)})) {
            long projectMemberId2 = dbProjectMember.getLong("id");
            DynamicObject updateProjectMember = (DynamicObject)quitProjectMemberMap.get(projectMemberId2);
            dbProjectMember.set("quitdate", updateProjectMember.get("quitdate"));
            dbProjectMember.set("servicestate", updateProjectMember.get("servicestate"));
            log.info("refreshProjectMemberStatusAndQuitDate_projectMemberId:{},quitDate:{},servicestate:{}", new Object[]{projectMemberId2, updateProjectMember.get("quitdate"), updateProjectMember.get("servicestate")});
        }
        this.projectMemberRepository.update(dbProjectMembers);
    }

    private Map<Long, List<DynamicObject>> getProjectAllRolesByRoles(List<DynamicObject> memberRoles) {
        Long[] projectMemberIds = (Long[])memberRoles.stream().map(role -> role.getLong("projectmember.id")).toArray(Long[]::new);
        DynamicObject[] allMemberRoles = this.teamMemberRoleRepository.query("quitdate,projectmember.servicestate,servicestate", new QFilter[]{new QFilter("projectmember.id", "in", (Object)projectMemberIds)});
        return Arrays.stream(allMemberRoles).collect(Collectors.groupingBy(role -> role.getLong("projectmember.id")));
    }

    @Override
    public void refreshProjectMemberState(List<DynamicObject> joinChangeTeamMemberRoles) {
        DynamicObject[] effectProjectMembers;
        Map<Long, List<DynamicObject>> projectAllRoles = this.getProjectAllRolesByRoles(joinChangeTeamMemberRoles);
        HashMap projectMemberStateMap = Maps.newHashMapWithExpectedSize((int)projectAllRoles.size());
        projectAllRoles.forEach((projectMemberId, roles) -> {
            boolean allQuit = roles.stream().allMatch(role -> "C".equals(role.getString("servicestate")));
            if (allQuit) {
                projectMemberStateMap.put(projectMemberId, "C");
            } else {
                boolean noEffect = roles.stream().noneMatch(role -> "B".equals(role.getString("servicestate")));
                if (noEffect) {
                    projectMemberStateMap.put(projectMemberId, "A");
                } else {
                    projectMemberStateMap.put(projectMemberId, "B");
                }
            }
        });
        for (DynamicObject projectMember : effectProjectMembers = this.projectMemberRepository.query("servicestate", new QFilter[]{new QFilter("id", "in", projectMemberStateMap.keySet())})) {
            projectMember.set("servicestate", projectMemberStateMap.get(projectMember.getLong("id")));
        }
        this.projectMemberRepository.update(effectProjectMembers);
    }

    @Override
    public void refreshProjectMember(List<Long> projectMemberIds) {
        DynamicObject[] allMemberRoles = this.teamMemberRoleRepository.listMemberRoleByProjectMemberIds(projectMemberIds);
        this.refreshProjectMemberJoinDate(Arrays.asList(allMemberRoles), false);
        this.refreshProjectMemberStatusAndQuitDateByAllRoles(allMemberRoles);
    }

    @Override
    public void checkAndDeleteNoServiceStateProjectMember(List<Long> projectMemberIds) {
        QFilter idFilter = new QFilter("id", "in", projectMemberIds);
        QFilter defaultBlankStrFilter = new QFilter("servicestate", "=", (Object)" ");
        this.projectMemberRepository.deleteByFilter(new QFilter[]{idFilter, defaultBlankStrFilter});
    }

    @Override
    public void teamMemberJoin(DynamicObject[] adjustObjs) {
        DynamicObject adjustBill = adjustObjs[0];
        String adjustBillNo = adjustBill.getString("billno");
        DynamicObjectCollection joinEntry = adjustBill.getDynamicObjectCollection("memberjoinentry");
        List<Long> personIds = joinEntry.stream().map(entry -> entry.getLong(PropUtils.getIdDot((String)"personfield"))).collect(Collectors.toList());
        Map<Long, DynamicObject> projectIdentifiesRootProjectTeam = this.getEntryRowProjectIdentifiesRootProjectTeam(adjustBill, "memberjoinentry", "projectteamadd");
        Map<Long, String> projectIdentifies = this.getProjectIdentifyByRootTeam(projectIdentifiesRootProjectTeam);
        Map<ProjectMemberKey, DynamicObject> projectMemberMap = this.listProjectMemberMap(projectIdentifies.values(), personIds);
        Map<ProjectMemberKey, DynamicObject> newProjectMemberMap = this.createOrUpdateProjectMember(joinEntry, projectMemberMap, projectIdentifiesRootProjectTeam);
        List<DynamicObject> newTeamMemberRes = this.createOrUpdateTeamMember(joinEntry, newProjectMemberMap, adjustBillNo, projectIdentifies);
        Map<Pair<Long, Long>, Long> personTeamMemberIdMap = this.getPersonTeamBaseId(newTeamMemberRes.toArray(new DynamicObject[0]));
        ArrayList syncRequestDataList = Lists.newArrayListWithCapacity((int)joinEntry.size());
        List<DynamicObject> newTeamMemberRoles = this.createOrUpdateTeamMemberRole(adjustBill, newProjectMemberMap, personTeamMemberIdMap, syncRequestDataList, projectIdentifiesRootProjectTeam);
        this.projectMemberRepository.save(newProjectMemberMap.values().toArray(new DynamicObject[0]));
        this.teamMemberRepository.save(newTeamMemberRes.toArray(new DynamicObject[0]));
        this.teamMemberRoleRepository.save(newTeamMemberRoles.toArray(new DynamicObject[0]));
        String adjustStatus = this.syncDataAndUpdateRowJoinStatus(syncRequestDataList);
        this.updateEntryRowAdjustStatus(adjustBill, "memberjoinentry", "joinstartdate", "adjuststatusjoin", adjustStatus);
    }

    private Map<Long, String> getProjectIdentifyByRootTeam(Map<Long, DynamicObject> rootTeamMap) {
        HashMap projectIdentifyMap = Maps.newHashMapWithExpectedSize((int)rootTeamMap.size());
        rootTeamMap.forEach((projectTeamId, rootProjectTeam) -> projectIdentifyMap.put(projectTeamId, rootProjectTeam.getString("projectidentify")));
        return projectIdentifyMap;
    }

    @Override
    public void memberRoleAdjust(DynamicObject[] adjustBills) {
        DynamicObject adjustBill = adjustBills[0];
        DynamicObjectCollection entryRoleJoin = adjustBill.getDynamicObjectCollection("memberadjjentry");
        DynamicObjectCollection entryRoleAdjust = adjustBill.getDynamicObjectCollection("memberadjaentry");
        DynamicObjectCollection entryRoleQuit = adjustBill.getDynamicObjectCollection("memberadjqentry");
        ArrayList<Long> entryPersonIds = new ArrayList<Long>();
        ArrayList<Long> entryTeamMemberIds = new ArrayList<Long>();
        ArrayList<Long> entryTeamMemberRoleIds = new ArrayList<Long>();
        this.entryMainIds(entryRoleJoin, entryPersonIds, entryTeamMemberIds, "personbaseadja");
        this.entryMainIds(entryRoleAdjust, entryPersonIds, entryTeamMemberRoleIds, "personbaseadj");
        this.entryMainIds(entryRoleQuit, entryPersonIds, entryTeamMemberRoleIds, "personbaseadjq");
        Map<Long, DynamicObject> dbProjectTeamMap = this.getEntryProjectTeam(adjustBills);
        Map<Long, String> roleJoinProjectIdentifies = this.getEntryRowProjectIdentifies(adjustBill, "memberadjjentry", "personbaseadja.projectteam");
        Map<Long, String> projectIdentifies = this.getEntryRowProjectIdentifies(adjustBill, "memberadjaentry", "projectteamadjnew");
        projectIdentifies.putAll(roleJoinProjectIdentifies);
        Map<ProjectMemberKey, DynamicObject> projectMemberMap = this.listProjectMemberMap(projectIdentifies.values(), entryPersonIds);
        DynamicObject[] memberRoles = this.teamMemberRoleRepository.listTeamMemberRoleArr(entryTeamMemberRoleIds);
        DynamicObject[] teamMembers = this.getTeamMemberObjs(entryTeamMemberIds, memberRoles);
        Map<Long, DynamicObject> teamMemberMap = this.dyObjArrayToMap(teamMembers, "id");
        Map<AdjustEntryEnum, List<ProjectMemberEntryWrapper>> wrapperEntryRow = this.wrapperEntryRow(adjustBill);
        this.execRoleJoinAndQuit(adjustBill, projectMemberMap, memberRoles, teamMemberMap, wrapperEntryRow, dbProjectTeamMap, projectIdentifies);
    }

    @Override
    public void quitTeamMember(List<DynamicObject> submitedTeamMemberBills) {
        List quitBills = submitedTeamMemberBills.stream().filter(bill -> !bill.getDynamicObjectCollection("memberquitentry").isEmpty()).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(quitBills)) {
            return;
        }
        LocalDate now = LocalDate.now();
        ZoneId zoneId = ZoneId.systemDefault();
        HashSet teamMemQuitIds = Sets.newHashSetWithExpectedSize((int)16);
        HashMap teamMem2QuitDateMaps = Maps.newHashMapWithExpectedSize((int)16);
        submitedTeamMemberBills.stream().forEach(bill -> {
            DynamicObjectCollection quitEntryList = bill.getDynamicObjectCollection("memberquitentry");
            quitEntryList.stream().forEach(entry -> {
                Date quitDate = entry.getDate("quitdate");
                Instant instan = quitDate.toInstant();
                if (HRStringUtils.equals((String)entry.getString("adjuststatusquit"), (String)"A") && now.isAfter(instan.atZone(zoneId).toLocalDate())) {
                    teamMemQuitIds.add(entry.getLong("personbaseq.id"));
                    teamMem2QuitDateMaps.put(entry.getLong("personbaseq.id"), quitDate);
                }
            });
        });
        log.info("TeamMemberBillService quitTeamMember teamMemQuitIds: {}", (Object)JSONObject.toJSONString((Object)teamMemQuitIds));
        DynamicObject[] teamMemRoles = this.teamMemberRoleRepository.listNoQuitTeamMemberRole(teamMemQuitIds);
        Arrays.stream(teamMemRoles).forEach(teamMemRole -> {
            teamMemRole.set("servicestate", (Object)"C");
            teamMemRole.set("quitdate", teamMem2QuitDateMaps.get(teamMemRole.getLong("teammember.id")));
        });
        log.info("TeamMemberBillService quitTeamMember teamMemQuitIds: {}", (Object)JSONObject.toJSONString((Object)teamMemQuitIds));
        this.teamMemberRepository.save(teamMemRoles);
        ArrayList syncRequestDataListQuit = Lists.newArrayListWithExpectedSize((int)16);
        Arrays.stream(teamMemRoles).forEach(teamMemRole -> {
            SyncRequestData syncRequestData = new SyncRequestData();
            syncRequestData.setTeamMemberId(teamMemRole.getLong("teammember.id"));
            syncRequestData.setTeamMemberRoleId(teamMemRole.getLong("id"));
            syncRequestData.setTeamMemberRole((DynamicObject)teamMemRole);
            syncRequestData.setPersonId(teamMemRole.getLong("person.id"));
            syncRequestData.setSyncType(HRStringUtils.equals((String)teamMemRole.getString("isteammainrole"), (String)"1") ? "3" : "4");
            syncRequestDataListQuit.add(syncRequestData);
        });
        String roleAdjustQuitStatus = this.syncDataAndUpdateRowQuitStatus(syncRequestDataListQuit);
        log.info("TeamMemberBillService quitTeamMember syncData end");
        this.updateEntryRowAdjustQuitStatus((DynamicObject)quitBills.get(0), "memberquitentry", "quitdate", "adjuststatusquit", roleAdjustQuitStatus);
    }

    @Override
    public void quitTeamMemberOnSummit(List<DynamicObject> submitedTeamMemberBills) {
        List quitBills = submitedTeamMemberBills.stream().filter(bill -> !bill.getDynamicObjectCollection("memberquitentry").isEmpty()).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(quitBills)) {
            return;
        }
        LocalDate now = LocalDate.now();
        ZoneId zoneId = ZoneId.systemDefault();
        HashSet teamMemIds = Sets.newHashSetWithExpectedSize((int)16);
        HashMap endBillNoMaps = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList handledTeamMemberBills = Lists.newArrayListWithExpectedSize((int)16);
        HashSet teamMemQuitIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet noQuitProjectMemberIds = Sets.newHashSetWithExpectedSize((int)16);
        HashMap teamMem2QuitDateMaps = Maps.newHashMapWithExpectedSize((int)16);
        HashMap proMem2QuitDateMaps = Maps.newHashMapWithExpectedSize((int)16);
        quitBills.stream().forEach(bill -> {
            handledTeamMemberBills.add(bill);
            DynamicObjectCollection quitEntryList = bill.getDynamicObjectCollection("memberquitentry");
            quitEntryList.stream().forEach(entry -> {
                endBillNoMaps.put(entry.getLong("personbaseq.id"), bill.getString("billno"));
                Date quitDate = entry.getDate("quitdate");
                teamMem2QuitDateMaps.put(entry.getLong("personbaseq.id"), quitDate);
                teamMemIds.add(entry.getLong("personbaseq.id"));
                Instant instan = quitDate.toInstant();
                if (HRStringUtils.equals((String)entry.getString("adjuststatusquit"), (String)"A")) {
                    if (now.isAfter(instan.atZone(zoneId).toLocalDate())) {
                        teamMemQuitIds.add(entry.getLong("personbaseq.id"));
                        noQuitProjectMemberIds.add(entry.getLong("personbaseq.projectmember.id"));
                        proMem2QuitDateMaps.put(entry.getLong("personbaseq.projectmember.id"), quitDate);
                    } else {
                        handledTeamMemberBills.remove(bill);
                    }
                }
            });
        });
        DynamicObject[] teamMemList = this.teamMemberRepository.listTeamMember(Lists.newArrayList((Iterable)teamMemIds));
        Arrays.stream(teamMemList).forEach(teamMem -> {
            teamMem.set("endbillno", endBillNoMaps.get(teamMem.getLong("id")));
            teamMem.set("quitdate", teamMem2QuitDateMaps.get(teamMem.getLong("id")));
        });
        log.info("TeamMemberBillService quitTeamMemberOnSummit teamMemIds: {}", (Object)JSONObject.toJSONString((Object)teamMemIds));
        this.teamMemberRepository.save(teamMemList);
        DynamicObject[] teamMemRoleList = this.teamMemberRoleRepository.listNoQuitTeamMemberRole(teamMemIds);
        Arrays.stream(teamMemRoleList).forEach(teamMemRole -> teamMemRole.set("endbillno", endBillNoMaps.get(teamMemRole.getLong("teammember.id"))));
        log.info("TeamMemberBillService quitTeamMemberOnSummit teamMemIds: {}", (Object)JSONObject.toJSONString((Object)teamMemIds));
        this.teamMemberRoleRepository.save(teamMemRoleList);
        log.info("TeamMemberBillService quitTeamMember noQuitProjectMemberIds: {}", (Object)JSONObject.toJSONString((Object)noQuitProjectMemberIds));
        DynamicObject[] teamMemListOfProject = this.teamMemberRepository.listNoQuitTeamMember(noQuitProjectMemberIds);
        ArrayList teamMemQuitList = Lists.newArrayListWithExpectedSize((int)16);
        HashSet quitTeamMemberIds = Sets.newHashSetWithExpectedSize((int)16);
        Arrays.stream(teamMemListOfProject).forEach(teamMem -> {
            if (teamMemQuitIds.contains(teamMem.getLong("id"))) {
                teamMem.set("servicestate", (Object)"C");
                teamMem.set("quitdate", teamMem2QuitDateMaps.get(teamMem.getLong("id")));
                teamMemQuitList.add(teamMem);
                quitTeamMemberIds.add(teamMem.getLong("id"));
            } else {
                String serviceState = teamMem.getString("servicestate");
                if (HRStringUtils.equals((String)serviceState, (String)"B") && noQuitProjectMemberIds.contains(teamMem.getLong("projectmember.id"))) {
                    noQuitProjectMemberIds.remove(teamMem.getLong("projectmember.id"));
                }
            }
        });
        log.info("TeamMemberBillService quitTeamMember teamMemQuitIds: {}", (Object)JSONObject.toJSONString((Object)teamMemQuitIds));
        this.teamMemberRepository.save(teamMemQuitList.toArray(new DynamicObject[0]));
        ArrayList reUpdateProjectMems = Lists.newArrayListWithExpectedSize((int)16);
        DynamicObject[] projectMemberList = this.projectMemberRepository.listProjectMember(noQuitProjectMemberIds);
        DynamicObject[] noQuitProjectMemRoles = this.teamMemberRoleRepository.listNoQuitProjectMemberRole(noQuitProjectMemberIds, quitTeamMemberIds);
        HashMap noQuitProjectMemIdMap = Maps.newHashMapWithExpectedSize((int)16);
        Arrays.stream(noQuitProjectMemRoles).forEach(projectMemRole -> {
            if (!noQuitProjectMemIdMap.containsKey(projectMemRole.getLong(PropUtils.getIdDot((String)PropUtils.getIdDot((String)"projectmember")))) || noQuitProjectMemIdMap.containsKey(projectMemRole.getLong(PropUtils.getIdDot((String)"projectmember"))) && HRStringUtils.equals((String)"B", (String)projectMemRole.getString("servicestate"))) {
                noQuitProjectMemIdMap.put(projectMemRole.getLong(PropUtils.getIdDot((String)"projectmember")), projectMemRole.getString("servicestate"));
            }
        });
        DynamicObject[] quitProjectMemRoles = this.teamMemberRoleRepository.listQuitProjectMemberRole(noQuitProjectMemberIds, quitTeamMemberIds);
        HashMap quitProjectMemIdMap = Maps.newHashMapWithExpectedSize((int)16);
        Arrays.stream(quitProjectMemRoles).forEach(projectMemRole -> quitProjectMemIdMap.put(projectMemRole.getLong(PropUtils.getIdDot((String)"projectmember")), projectMemRole.getString("servicestate")));
        for (DynamicObject projectMember : projectMemberList) {
            if (noQuitProjectMemIdMap.containsKey(projectMember.getLong("id")) && HRStringUtils.equals((String)"B", (String)((String)noQuitProjectMemIdMap.get(projectMember.getLong("id"))))) continue;
            if (noQuitProjectMemIdMap.containsKey(projectMember.getLong("id")) && HRStringUtils.equals((String)"A", (String)((String)noQuitProjectMemIdMap.get(projectMember.getLong("id"))))) {
                projectMember.set("servicestate", (Object)"A");
                projectMember.set("quitdate", proMem2QuitDateMaps.get(projectMember.getLong("id")));
                reUpdateProjectMems.add(projectMember);
                continue;
            }
            if (quitProjectMemIdMap.containsKey(projectMember.getLong("id")) && HRStringUtils.equals((String)"A", (String)((String)quitProjectMemIdMap.get(projectMember.getLong("id"))))) {
                projectMember.set("servicestate", (Object)"A");
                projectMember.set("quitdate", proMem2QuitDateMaps.get(projectMember.getLong("id")));
                reUpdateProjectMems.add(projectMember);
                continue;
            }
            projectMember.set("servicestate", (Object)"C");
            projectMember.set("quitdate", proMem2QuitDateMaps.get(projectMember.getLong("id")));
            reUpdateProjectMems.add(projectMember);
        }
        this.projectMemberRepository.save(reUpdateProjectMems.toArray(new DynamicObject[0]));
        DynamicObject[] teamMemRoles = this.teamMemberRoleRepository.listNoQuitTeamMemberRole(teamMemQuitIds);
        Arrays.stream(teamMemRoles).forEach(teamMemRole -> {
            teamMemRole.set("servicestate", (Object)"C");
            teamMemRole.set("quitdate", teamMem2QuitDateMaps.get(teamMemRole.getLong("teammember.id")));
        });
        log.info("TeamMemberBillService quitTeamMember teamMemQuitIds: {}", (Object)JSONObject.toJSONString((Object)teamMemQuitIds));
        this.teamMemberRepository.save(teamMemRoles);
        ArrayList syncRequestDataListQuit = Lists.newArrayListWithExpectedSize((int)16);
        Arrays.stream(teamMemRoles).forEach(teamMemRole -> {
            SyncRequestData syncRequestData = new SyncRequestData();
            syncRequestData.setTeamMemberId(teamMemRole.getLong("teammember.id"));
            syncRequestData.setTeamMemberRoleId(teamMemRole.getLong("id"));
            syncRequestData.setTeamMemberRole((DynamicObject)teamMemRole);
            syncRequestData.setPersonId(teamMemRole.getLong("person.id"));
            syncRequestData.setSyncType(HRStringUtils.equals((String)teamMemRole.getString("isteammainrole"), (String)"1") ? "3" : "4");
            syncRequestDataListQuit.add(syncRequestData);
        });
        String roleAdjustQuitStatus = this.syncDataAndUpdateRowQuitStatus(syncRequestDataListQuit);
        this.refreshProjectMemberStatusAndQuitDate(teamMemRoles);
        log.info("TeamMemberBillService quitTeamMember syncData end");
        this.updateEntryRowAdjustQuitStatus((DynamicObject)quitBills.get(0), "memberquitentry", "quitdate", "adjuststatusquit", roleAdjustQuitStatus);
    }

    @Override
    public Map<Long, DynamicObject> getEntryProjectTeam(DynamicObject[] dataEntities) {
        HashSet<Long> projectTeamIds = new HashSet<Long>();
        for (DynamicObject dataEntity : dataEntities) {
            long projectTeamId;
            DynamicObjectCollection roleJoinEntry = dataEntity.getDynamicObjectCollection("memberadjjentry");
            DynamicObjectCollection roleAdjustEntry = dataEntity.getDynamicObjectCollection("memberadjaentry");
            for (DynamicObject entryRow : roleJoinEntry) {
                projectTeamId = entryRow.getLong("personbaseadja.projectteam.id");
                projectTeamIds.add(projectTeamId);
            }
            for (DynamicObject entryRow : roleAdjustEntry) {
                projectTeamId = entryRow.getLong("projectteamadjnew.id");
                projectTeamIds.add(projectTeamId);
            }
        }
        return PTMMServiceFactory.projectTeamService.listProjectTeamMapById(projectTeamIds);
    }

    public Map<Long, String> getEntryRowProjectIdentifies(DynamicObject dataEntity, String entryKey, String filedKey) {
        DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection(entryKey);
        List<Long> projectTeamIds = entryCol.stream().map(entry -> entry.getLong(filedKey + ".id")).collect(Collectors.toList());
        return PTMMServiceFactory.projectTeamService.listProjectTeamProjectIdentify(projectTeamIds);
    }

    public Map<Long, DynamicObject> getEntryRowProjectIdentifiesRootProjectTeam(DynamicObject dataEntity, String entryKey, String filedKey) {
        DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection(entryKey);
        List<Long> projectTeamIds = entryCol.stream().map(entry -> entry.getLong(filedKey + ".id")).collect(Collectors.toList());
        return PTMMServiceFactory.projectTeamService.listProjectTeamRootTeamMapById(projectTeamIds);
    }

    @Override
    public void doUpdateVid(List<DynamicObject> dynamicObjectList) {
        log.info("TeamMemberBillServiceImpl doUpdateVid start ids: {}", dynamicObjectList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty(dynamicObjectList)) {
            return;
        }
        ArrayList<UpdateVidDto> updateVidDtos = new ArrayList<UpdateVidDto>(dynamicObjectList.size());
        ((Stream)dynamicObjectList.stream().parallel()).forEach(dynamicObject -> {
            DynamicObjectCollection memberAdjQuitDOs;
            DynamicObjectCollection memberAdjJoinDOs;
            DynamicObjectCollection memberJoinDOs = dynamicObject.getDynamicObjectCollection("memberjoinentry");
            if (!CollectionUtils.isEmpty((Collection)memberJoinDOs)) {
                UpdateVidDto updateVidDtoJoin = new UpdateVidDto();
                updateVidDtoJoin.setDynamicObjectList(memberJoinDOs.stream().filter(memberJoinDO -> HRStringUtils.equals((String)"B", (String)memberJoinDO.getString("adjuststatusjoin"))).collect(Collectors.toList())).setPropMapping(VidPropTypeConfig.PROP_TYPE_MAP_JOIN);
                updateVidDtos.add(updateVidDtoJoin);
                log.info("TeamMemberBillServiceImpl doUpdateVid memberjoinentry param:{}", (Object)updateVidDtoJoin);
            }
            if (!CollectionUtils.isEmpty((Collection)(memberAdjJoinDOs = dynamicObject.getDynamicObjectCollection("memberadjjentry")))) {
                UpdateVidDto updateVidDtoAdjustJoin = new UpdateVidDto();
                updateVidDtoAdjustJoin.setDynamicObjectList(memberAdjJoinDOs.stream().filter(memberAdjJoinDO -> HRStringUtils.equals((String)"B", (String)memberAdjJoinDO.getString("adjuststatusadja"))).collect(Collectors.toList())).setPropMapping(VidPropTypeConfig.PROP_TYPE_MAP_JOIN_ADJUST);
                updateVidDtos.add(updateVidDtoAdjustJoin);
                log.info("TeamMemberBillServiceImpl doUpdateVid ENTITY_MEMBERADJJENTRY param:{}", (Object)updateVidDtoAdjustJoin);
            }
            if (!CollectionUtils.isEmpty((Collection)(memberAdjQuitDOs = dynamicObject.getDynamicObjectCollection("memberadjqentry")))) {
                UpdateVidDto updateVidDtoAdjustQuit = new UpdateVidDto();
                updateVidDtoAdjustQuit.setDynamicObjectList(memberAdjQuitDOs.stream().filter(memberAdjQuitDO -> HRStringUtils.equals((String)"B", (String)memberAdjQuitDO.getString("adjuststatusadjq"))).collect(Collectors.toList())).setPropMapping(VidPropTypeConfig.PROP_TYPE_MAP_QUIT_ADJUST);
                updateVidDtos.add(updateVidDtoAdjustQuit);
                log.info("TeamMemberBillServiceImpl doUpdateVid ENTITY_MEMBERADJQENTRY param:{}", (Object)updateVidDtoAdjustQuit);
            }
        });
        PTMMServiceFactory.updateVidService.updateHistoryVid(updateVidDtos);
        log.info("TeamMemberBillServiceImpl doUpdateVid end");
    }

    @Override
    public void effectAdjustBillByTask(DynamicObject adjustBill) {
        String billNo = adjustBill.getString("billno");
        DynamicObject[] teamMemberRoles = this.teamMemberRoleRepository.listTeamMemberRoleArrByBillNo(new String[]{billNo});
        this.processMemberJoinEntry(adjustBill, teamMemberRoles);
        this.processRoleAdjust(adjustBill, teamMemberRoles);
        this.quitTeamMember(Collections.singletonList(adjustBill));
        List<Long> roleIds = Arrays.stream(teamMemberRoles).map(role -> role.getLong("id")).collect(Collectors.toList());
        DynamicObject[] dbRoles = this.teamMemberRoleRepository.listTeamMemberRoleArr(roleIds);
        this.refreshTeamMemberState(Arrays.asList(dbRoles));
        this.refreshProjectMemberState(Arrays.asList(dbRoles));
        this.refreshProjectMemberStatusAndQuitDate(dbRoles);
        PTMMServiceFactory.teamMemberBillService.doUpdateVid(Collections.singletonList(adjustBill));
        this.updateStatusByRowStatus(new DynamicObject[]{adjustBill});
        this.teamMemberBillRepository.update(new DynamicObject[]{adjustBill});
    }

    @Override
    public DynamicObject[] query(Long[] ids) {
        return this.teamMemberBillRepository.query("adjuststatus,billstatus,auditstatus,memberjoinentry.personorg,memberjoinentry.adjuststatusjoin,memberadjjentry.adjuststatusadja,memberadjaentry.adjuststatusadj,memberadjqentry.adjuststatusadjq,memberquitentry.adjuststatusquit", new QFilter[]{new QFilter("id", "in", (Object)ids)});
    }

    @Override
    public DynamicObject[] queryArray(Long[] ids) {
        return this.teamMemberBillRepository.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", (Object)ids)});
    }

    @Override
    public DynamicObject queryOne(Object id) {
        return this.teamMemberBillRepository.queryOne("id,adjuststatus", id);
    }

    @Override
    public void update(DynamicObject[] objs) {
        this.teamMemberBillRepository.update(objs);
    }

    @Override
    public void updateStatusByRowStatus(DynamicObject[] adjObjs) {
        for (DynamicObject adjustBill : adjObjs) {
            boolean rowFinishMemberJoin = this.allRowFinish(adjustBill, "memberjoinentry", "adjuststatusjoin");
            boolean rowFinishRoleJoin = this.allRowFinish(adjustBill, "memberadjjentry", "adjuststatusadja");
            boolean rowFinishRoleAdjust = this.allRowFinish(adjustBill, "memberadjaentry", "adjuststatusadj");
            boolean rowFinishRoleQuit = this.allRowFinish(adjustBill, "memberadjqentry", "adjuststatusadjq");
            boolean rowFinishMemberQuit = this.allRowFinish(adjustBill, "memberquitentry", "adjuststatusquit");
            if (rowFinishMemberJoin && rowFinishRoleJoin && rowFinishRoleAdjust && rowFinishRoleQuit && rowFinishMemberQuit) {
                TeamMemberBillServiceImpl.updateAdjustAuditStatus(adjustBill, "C", MemberAdjustAuditStatusEnum.PROCESSED.getCode());
                continue;
            }
            boolean rowWaitProcessMemberJoin = this.allRowWait(adjustBill, "memberjoinentry", "adjuststatusjoin");
            boolean rowWaitProcessRoleJoin = this.allRowWait(adjustBill, "memberadjjentry", "adjuststatusadja");
            boolean rowWaitProcessRoleAdjust = this.allRowWait(adjustBill, "memberadjaentry", "adjuststatusadj");
            boolean rowWaitProcessRoleQuit = this.allRowWait(adjustBill, "memberadjqentry", "adjuststatusadjq");
            boolean rowWaitProcessMemberQuit = this.allRowWait(adjustBill, "memberquitentry", "adjuststatusquit");
            if (rowWaitProcessMemberJoin && rowWaitProcessRoleJoin && rowWaitProcessRoleAdjust && rowWaitProcessRoleQuit && rowWaitProcessMemberQuit) {
                TeamMemberBillServiceImpl.updateAdjustAuditStatus(adjustBill, "B", MemberAdjustAuditStatusEnum.APPROVEED.getCode());
                continue;
            }
            TeamMemberBillServiceImpl.updateAdjustAuditStatus(adjustBill, "D", MemberAdjustAuditStatusEnum.APPROVEED.getCode());
        }
    }

    @Override
    public void updateChangeProjectName(Long projectTeamBOId, ProjectTeamChangeBO prjTeamChange) {
        log.info("updateChangeProjectName_projectTeamBOId:{}", (Object)projectTeamBOId);
        DynamicObject projectTeam = PTMMServiceFactory.projectTeamService.getProjectTeamById(projectTeamBOId);
        PTMMServiceFactory.projectMemberService.updateProjectMemberProjectName(projectTeam, prjTeamChange);
        this.updateBillProjectName(projectTeam, prjTeamChange);
    }

    @Override
    public void updateBillProjectName(DynamicObject projectTeam, ProjectTeamChangeBO prjTeamChange) {
        DynamicObject[] teamMemberBills;
        for (DynamicObject teamMemberBill : teamMemberBills = this.teamMemberBillRepository.listTeamMemberBill(projectTeam.getLong("id"))) {
            teamMemberBill.set("projectname", prjTeamChange.getAfterProjectName());
        }
        this.update(teamMemberBills);
    }

    private void processMemberJoinEntry(DynamicObject adjustBill, DynamicObject[] teamMemberRoles) {
        DynamicObjectCollection memberJoinEntry = adjustBill.getDynamicObjectCollection("memberjoinentry");
        Map<Triple, DynamicObject> memberRoleMap = Arrays.stream(teamMemberRoles).collect(Collectors.toMap(role -> Triple.of((Object)role.getLong("person.id"), (Object)role.getLong("projectteam.id"), (Object)role.getLong("projectrole.id")), role -> role, (v1, v2) -> v1));
        ArrayList<SyncRequestData> syncRequestDataList = new ArrayList<SyncRequestData>();
        for (DynamicObject entryRow : memberJoinEntry) {
            log.info("effectJoinMemberRoleBill_row:{}", entryRow.getPkValue());
            String needEffectRow = this.needEffectRow(entryRow, "adjuststatusjoin", "joinstartdate");
            if (!"1".equals(needEffectRow)) continue;
            long personId = entryRow.getLong("personfield.id");
            long projectTeamId = entryRow.getLong("projectteamadd.id");
            long projectRoleId = entryRow.getLong("projectrole.id");
            Triple curKey = Triple.of((Object)personId, (Object)projectTeamId, (Object)projectRoleId);
            DynamicObject dbMemberRole = memberRoleMap.get(curKey);
            boolean mainRoleRemoved = HRObjectUtils.isEmpty((Object)dbMemberRole);
            if (!HRObjectUtils.isEmpty((Object)dbMemberRole) && "A".equals(dbMemberRole.getString("servicestate"))) {
                log.info("effectJoinMemberRoleBill_row_update:{}_{}", entryRow.getPkValue(), dbMemberRole.getPkValue());
                dbMemberRole.set("servicestate", (Object)"B");
                SyncRequestData syncRequestData = new SyncRequestData();
                syncRequestData.setSyncType("1");
                syncRequestData.setPersonId(personId);
                syncRequestData.setTeamMemberId(dbMemberRole.getLong("teammember.id"));
                syncRequestData.setTeamMemberRoleId(dbMemberRole.getLong("id"));
                syncRequestData.setTeamMemberRole(dbMemberRole);
                syncRequestDataList.add(syncRequestData);
            } else {
                log.info("effectJoinMemberRoleBill_row_no_role:{}", entryRow.getPkValue());
            }
            if (mainRoleRemoved) {
                log.info("effectJoinMemberRoleBill_row_main_role_maybe_removed:{}", entryRow.getPkValue());
            }
            DynamicObjectCollection otherRoleCols = entryRow.getDynamicObjectCollection("projectroleother");
            List otherRoleIds = otherRoleCols.stream().map(obj -> Triple.of((Object)personId, (Object)projectTeamId, (Object)obj.getLong("fbasedataid_id"))).collect(Collectors.toList());
            for (Triple otherRoleGroupKey : otherRoleIds) {
                DynamicObject dbOtherRole = memberRoleMap.get(otherRoleGroupKey);
                if (dbOtherRole == null) continue;
                String serviceStatus = dbOtherRole.getString("servicestate");
                if (HRObjectUtils.isEmpty((Object)dbOtherRole) || !"A".equals(serviceStatus)) continue;
                dbOtherRole.set("servicestate", (Object)"B");
                SyncRequestData syncRequestDataOther = new SyncRequestData();
                if (mainRoleRemoved && "1".equals(dbOtherRole.getString("isteammainrole"))) {
                    syncRequestDataOther.setSyncType("1");
                } else {
                    syncRequestDataOther.setSyncType("2");
                }
                syncRequestDataOther.setPersonId(personId);
                syncRequestDataOther.setTeamMemberId(dbOtherRole.getLong("teammember.id"));
                syncRequestDataOther.setTeamMemberRoleId(dbOtherRole.getLong("id"));
                syncRequestDataOther.setTeamMemberRole(dbOtherRole);
                syncRequestDataList.add(syncRequestDataOther);
            }
        }
        DynamicObject[] memberJoinRoles = (DynamicObject[])syncRequestDataList.stream().map(SyncRequestData::getTeamMemberRole).toArray(DynamicObject[]::new);
        this.teamMemberRoleRepository.update(memberJoinRoles);
        String adjustStatus = this.syncDataAndUpdateRowJoinStatus(syncRequestDataList);
        this.updateEntryRowAdjustStatus(adjustBill, "memberjoinentry", "joinstartdate", "adjuststatusjoin", adjustStatus);
    }

    private void updateEntryRowAdjustStatus(DynamicObject bill, String entryKey, String dateKey, String adjustStatusKey, String adjustStatus) {
        DynamicObjectCollection entry = bill.getDynamicObjectCollection(entryKey);
        for (DynamicObject row : entry) {
            String curRowStatus = row.getString(adjustStatusKey);
            if (curRowStatus.equals("B")) continue;
            Date rowDate = row.getDate(dateKey);
            if (rowDate.after(DateUtils.getNowDate())) {
                row.set(adjustStatusKey, (Object)"A");
                continue;
            }
            row.set(adjustStatusKey, (Object)adjustStatus);
        }
    }

    private void updateEntryRowAdjustQuitStatus(DynamicObject bill, String entryKey, String dateKey, String adjustStatusKey, String adjustStatus) {
        DynamicObjectCollection entry = bill.getDynamicObjectCollection(entryKey);
        for (DynamicObject row : entry) {
            String curRowStatus = row.getString(adjustStatusKey);
            if (curRowStatus.equals("B")) continue;
            Date rowDate = row.getDate(dateKey);
            if (DateUtils.getNowDate().after(rowDate)) {
                row.set(adjustStatusKey, (Object)adjustStatus);
                continue;
            }
            row.set(adjustStatusKey, (Object)"A");
        }
    }

    private void processRoleAdjust(DynamicObject adjustBill, DynamicObject[] teamMemberRoles) {
        log.info("effectAdjMemberRoleBill_billNo:{}", (Object)adjustBill.getString("billno"));
        Map<Triple<Long, Long, Long>, DynamicObject> roleUniqueKeyMap = Arrays.stream(teamMemberRoles).collect(Collectors.toMap(role -> Triple.of((Object)role.getLong("person.id"), (Object)role.getLong("projectteam.id"), (Object)role.getLong("projectrole.id")), role -> role, (v1, v2) -> v1));
        Map<Long, DynamicObject> roleIdMap = this.dyObjArrayToMap(teamMemberRoles, "id");
        log.info("roleUniqueKeyMap:{}", roleUniqueKeyMap.keySet());
        log.info("processRoleAdjust:{}", roleIdMap.keySet());
        List<SyncRequestData> syncRequestDataListJoin = this.processRoleJoin(adjustBill, roleUniqueKeyMap);
        List<SyncRequestData> syncRequestDataListAdjust = this.processRoleAdjust(adjustBill, roleUniqueKeyMap, roleIdMap);
        List<SyncRequestData> syncRequestDataListQuit = this.processRoleQuit(adjustBill, roleIdMap);
        List<DynamicObject> joinRoles = syncRequestDataListJoin.stream().map(SyncRequestData::getTeamMemberRole).collect(Collectors.toList());
        List adjustRoles = syncRequestDataListAdjust.stream().map(SyncRequestData::getTeamMemberRole).collect(Collectors.toList());
        List quitRoles = syncRequestDataListQuit.stream().map(SyncRequestData::getTeamMemberRole).collect(Collectors.toList());
        joinRoles.addAll(adjustRoles);
        joinRoles.addAll(quitRoles);
        this.teamMemberRoleRepository.update(joinRoles.toArray(new DynamicObject[0]));
        String roleAdjustJoinStatus = this.syncDataAndUpdateRowJoinStatus(syncRequestDataListJoin);
        this.updateEntryRowAdjustStatus(adjustBill, "memberadjjentry", "effectdateadja", "adjuststatusadja", roleAdjustJoinStatus);
        String roleAdjustStatus = this.syncDataAndUpdateRowAdjustStatus(syncRequestDataListAdjust);
        this.updateEntryRowAdjustStatus(adjustBill, "memberadjaentry", "effectdateadj", "adjuststatusadj", roleAdjustStatus);
        String roleAdjustQuitStatus = this.syncDataAndUpdateRowQuitStatus(syncRequestDataListQuit);
        this.updateEntryRowAdjustStatus(adjustBill, "memberadjqentry", "effectdateadjq", "adjuststatusadjq", roleAdjustQuitStatus);
    }

    private List<SyncRequestData> processRoleJoin(DynamicObject adjustBill, Map<Triple<Long, Long, Long>, DynamicObject> joinRolesMap) {
        DynamicObjectCollection entryRoleJoin = adjustBill.getDynamicObjectCollection("memberadjjentry");
        ArrayList syncRequestDataListJoin = Lists.newArrayList();
        for (DynamicObject entryRow : entryRoleJoin) {
            log.info("effectAdjMemberRoleBill_entry1_row_:{}", entryRow.getPkValue());
            String needEffectRow = this.needEffectRow(entryRow, "adjuststatusadja", "effectdateadja");
            if (!"1".equals(needEffectRow)) continue;
            long personId = entryRow.getLong("personbaseadja.person.id");
            long projectTeamId = entryRow.getLong("personbaseadja.projectteam.id");
            long projectRoleId = entryRow.getLong("projectroleadja.id");
            Triple curKey = Triple.of((Object)personId, (Object)projectTeamId, (Object)projectRoleId);
            DynamicObject curRole = joinRolesMap.get(curKey);
            log.info("processRoleJoin_personId:{}_role:{}", (Object)personId, (Object)curRole);
            if (HRObjectUtils.isEmpty((Object)curRole) || !"A".equals(curRole.getString("servicestate"))) continue;
            curRole.set("servicestate", (Object)"B");
            SyncRequestData syncRequestData = new SyncRequestData();
            syncRequestData.setSyncType("2");
            syncRequestData.setPersonId(personId);
            syncRequestData.setTeamMemberId(curRole.getLong("teammember.id"));
            syncRequestData.setTeamMemberRoleId(curRole.getLong("id"));
            syncRequestData.setTeamMemberRole(curRole);
            syncRequestDataListJoin.add(syncRequestData);
        }
        return syncRequestDataListJoin;
    }

    private List<SyncRequestData> processRoleAdjust(DynamicObject adjustBill, Map<Triple<Long, Long, Long>, DynamicObject> joinRolesMap, Map<Long, DynamicObject> quitRolesMap) {
        DynamicObjectCollection entryRoleAdjust = adjustBill.getDynamicObjectCollection("memberadjaentry");
        ArrayList syncRequestDataListAdjust = Lists.newArrayList();
        for (DynamicObject entryRow : entryRoleAdjust) {
            log.info("effectAdjMemberRoleBill_entry2_row_:{}", entryRow.getPkValue());
            String needEffectRow = this.needEffectRow(entryRow, "adjuststatusadj", "effectdateadj");
            if (!"1".equals(needEffectRow)) continue;
            long personId = entryRow.getLong("personbaseadj.person.id");
            long projectTeamId = entryRow.getLong("projectteamadjnew.id");
            long projectRoleId = entryRow.getLong("projectroleadjnew.id");
            Triple curKey = Triple.of((Object)personId, (Object)projectTeamId, (Object)projectRoleId);
            DynamicObject curRole = joinRolesMap.get(curKey);
            log.info("processRoleAdjust_after_personId:{}_roleId:{}", (Object)personId, (Object)curRole);
            if (!HRObjectUtils.isEmpty((Object)curRole) && "A".equals(curRole.getString("servicestate"))) {
                curRole.set("servicestate", (Object)"B");
                String syncJoinTypeByRole = this.getSyncJoinTypeByRole(curRole);
                SyncRequestData syncRequestData = new SyncRequestData();
                syncRequestData.setSyncType(syncJoinTypeByRole);
                syncRequestData.setPersonId(personId);
                syncRequestData.setTeamMemberId(curRole.getLong("teammember.id"));
                syncRequestData.setTeamMemberRoleId(curRole.getLong("id"));
                syncRequestData.setTeamMemberRole(curRole);
                syncRequestDataListAdjust.add(syncRequestData);
            }
            long quitRoleId = entryRow.getLong("personbaseadj.id");
            DynamicObject curRoleQuit = quitRolesMap.get(quitRoleId);
            log.info("processRoleAdjust_before_personId:{}_roleId:{}", (Object)personId, (Object)curRoleQuit);
            if (HRObjectUtils.isEmpty((Object)curRoleQuit) || "C".equals(curRoleQuit.getString("servicestate"))) continue;
            curRoleQuit.set("servicestate", (Object)"C");
            curRoleQuit.set("quitdate", entryRow.get("effectdateadj"));
            String syncQuitTypeByRole = this.getSyncQuitTypeByRole(curRoleQuit);
            SyncRequestData syncRequestData = new SyncRequestData();
            syncRequestData.setSyncType(syncQuitTypeByRole);
            syncRequestData.setPersonId(entryRow.getLong("personbaseadj.person.id"));
            syncRequestData.setTeamMemberId(entryRow.getLong("personbaseadj.teammember.id"));
            syncRequestData.setTeamMemberRoleId(quitRoleId);
            syncRequestData.setTeamMemberRole(curRoleQuit);
            syncRequestDataListAdjust.add(syncRequestData);
        }
        return syncRequestDataListAdjust;
    }

    private List<SyncRequestData> processRoleQuit(DynamicObject adjustBill, Map<Long, DynamicObject> quitRolesMap) {
        DynamicObjectCollection entryRoleQuit = adjustBill.getDynamicObjectCollection("memberadjqentry");
        ArrayList syncRequestDataListQuit = Lists.newArrayList();
        for (DynamicObject entryRow : entryRoleQuit) {
            log.info("effectAdjMemberRoleBill_entry3_row_:{}", entryRow.getPkValue());
            String needEffectRow = this.needEffectRow(entryRow, "adjuststatusadjq", "effectdateadjq");
            if (!"1".equals(needEffectRow)) continue;
            long quitRoleId = entryRow.getLong("personbaseadjq.id");
            DynamicObject curRole = quitRolesMap.get(quitRoleId);
            log.info("processRoleQuit_quitRoleId:{}_role:{}", (Object)quitRoleId, (Object)curRole);
            if (HRObjectUtils.isEmpty((Object)curRole) || "C".equals(curRole.getString("servicestate"))) continue;
            curRole.set("servicestate", (Object)"C");
            curRole.set("quitdate", (Object)entryRow.getDate("effectdateadjq"));
            SyncRequestData syncRequestData = new SyncRequestData();
            syncRequestData.setSyncType("4");
            syncRequestData.setPersonId(entryRow.getLong("personbaseadjq.person.id"));
            syncRequestData.setTeamMemberId(entryRow.getLong("personbaseadjq.teammember.id"));
            syncRequestData.setTeamMemberRoleId(quitRoleId);
            syncRequestData.setTeamMemberRole(curRole);
            syncRequestDataListQuit.add(syncRequestData);
        }
        return syncRequestDataListQuit;
    }

    private String getSyncJoinTypeByRole(DynamicObject curRoleQuit) {
        String teamMainRole = curRoleQuit.getString("isteammainrole");
        if ("1".equals(teamMainRole)) {
            return "1";
        }
        return "2";
    }

    private String getSyncQuitTypeByRole(DynamicObject curRoleQuit) {
        String teamMainRole = curRoleQuit.getString("isteammainrole");
        if ("1".equals(teamMainRole)) {
            return "3";
        }
        return "4";
    }

    private String needEffectRow(DynamicObject entryRow, String rowStatusKey, String dateKey) {
        String rowStatus = entryRow.getString(rowStatusKey);
        if ("B".equals(rowStatus)) {
            return "0";
        }
        Date joinDate = entryRow.getDate(dateKey);
        if (DateUtils.getNowDate().before(joinDate)) {
            return "2";
        }
        return "1";
    }

    private DynamicObject[] getTeamMemberObjs(List<Long> entryTeamMemberIds, DynamicObject[] teamMemberRoles) {
        List teamMemberByRoles = Arrays.stream(teamMemberRoles).map(obj -> obj.getLong(PropUtils.getIdDot((String)"teammember"))).collect(Collectors.toList());
        entryTeamMemberIds.addAll(teamMemberByRoles);
        return this.teamMemberRepository.listTeamMember(entryTeamMemberIds);
    }

    private DynamicObject[] getAdjustAfterMainRole(DynamicObjectCollection entryRoleAdjust) {
        ArrayList afterProjectTeamIds = Lists.newArrayList();
        ArrayList personIds = Lists.newArrayList();
        TeamMemberBillServiceImpl.getTeamAndPersonIds(entryRoleAdjust, afterProjectTeamIds, personIds);
        return this.teamMemberRoleRepository.getProjectTeamMainRole(afterProjectTeamIds, personIds);
    }

    private void execRoleJoinAndQuit(DynamicObject adjustBill, Map<ProjectMemberKey, DynamicObject> projectMemberMap, DynamicObject[] teamMemberRoles, Map<Long, DynamicObject> teamMemberMap, Map<AdjustEntryEnum, List<ProjectMemberEntryWrapper>> wrapperEntryRow, Map<Long, DynamicObject> dbProjectTeamMap, Map<Long, String> projectIdentifies) {
        String adjustBillNo = adjustBill.getString("billno");
        ArrayList syncRequestDataListJoin = Lists.newArrayList();
        ArrayList syncRequestDataListAdjust = Lists.newArrayList();
        ArrayList syncRequestDataListQuit = Lists.newArrayList();
        Map<Long, DynamicObject> teamMemberRoleMap = this.dyObjArrayToMap(teamMemberRoles, "id");
        List<ProjectMemberEntryWrapper> roleJoinWrapper = wrapperEntryRow.get(AdjustEntryEnum.ADJUST_JOIN);
        Pair<List<DynamicObject>, List<DynamicObject>> roleJoinResult = this.execRoleJoin(projectMemberMap, roleJoinWrapper, adjustBill, syncRequestDataListJoin, dbProjectTeamMap, projectIdentifies);
        List<ProjectMemberEntryWrapper> roleAdjustJoinWrapper = wrapperEntryRow.get(AdjustEntryEnum.ADJUST_ADJ_JOIN);
        Pair<List<DynamicObject>, List<DynamicObject>> roleAdjustJoinResult = this.execRoleJoin(projectMemberMap, roleAdjustJoinWrapper, adjustBill, syncRequestDataListAdjust, dbProjectTeamMap, projectIdentifies);
        ((List)roleJoinResult.getLeft()).addAll((Collection)roleAdjustJoinResult.getLeft());
        ((List)roleJoinResult.getRight()).addAll((Collection)roleAdjustJoinResult.getRight());
        List<ProjectMemberEntryWrapper> roleAdjustQuitWrapper = wrapperEntryRow.get(AdjustEntryEnum.ADJUST_ADJ_QUIT);
        this.execRoleQuit(teamMemberRoleMap, roleAdjustQuitWrapper, adjustBillNo, teamMemberMap, syncRequestDataListAdjust);
        List<ProjectMemberEntryWrapper> roleQuitWrapper = wrapperEntryRow.get(AdjustEntryEnum.ADJUST_QUIT);
        this.execRoleQuit(teamMemberRoleMap, roleQuitWrapper, adjustBillNo, teamMemberMap, syncRequestDataListQuit);
        this.projectMemberRepository.update(projectMemberMap.values().toArray(new DynamicObject[0]));
        List newTeamMemberObjs = (List)roleJoinResult.getLeft();
        newTeamMemberObjs.addAll(teamMemberMap.values());
        this.teamMemberRepository.update(newTeamMemberObjs.toArray(new DynamicObject[0]));
        List newTeamMemberRoleObjs = (List)roleJoinResult.getRight();
        ArrayList allUpdateRoles = Lists.newArrayListWithExpectedSize((int)(newTeamMemberRoleObjs.size() + teamMemberRoles.length));
        allUpdateRoles.addAll(newTeamMemberRoleObjs);
        allUpdateRoles.addAll(Arrays.asList(teamMemberRoles));
        this.teamMemberRoleRepository.update(allUpdateRoles.toArray(new DynamicObject[0]));
        this.refreshProjectMemberJoinDate(newTeamMemberRoleObjs, true);
        this.refreshProjectMemberStatusAndQuitDate(allUpdateRoles.toArray(new DynamicObject[0]));
        String roleAdjustJoinStatus = this.syncDataAndUpdateRowJoinStatus(syncRequestDataListJoin);
        this.updateEntryRowAdjustStatus(adjustBill, "memberadjjentry", "effectdateadja", "adjuststatusadja", roleAdjustJoinStatus);
        String roleAdjustStatus = this.syncDataAndUpdateRowAdjustStatus(syncRequestDataListAdjust);
        this.updateEntryRowAdjustStatus(adjustBill, "memberadjaentry", "effectdateadj", "adjuststatusadj", roleAdjustStatus);
        String roleAdjustQuitStatus = this.syncDataAndUpdateRowQuitStatus(syncRequestDataListQuit);
        this.updateEntryRowAdjustStatus(adjustBill, "memberadjqentry", "effectdateadjq", "adjuststatusadjq", roleAdjustQuitStatus);
    }

    private void entryMainIds(DynamicObjectCollection entry, List<Long> entryPersonIds, List<Long> entryTeamMemberIds, String entryKey) {
        if (entry.isEmpty()) {
            return;
        }
        Set joinPersonIds = entry.stream().map(obj -> obj.getLong(PropUtils.getIdDot((String)(entryKey + "." + "person")))).collect(Collectors.toSet());
        entryPersonIds.addAll(joinPersonIds);
        Set joinTeamMemberIds = entry.stream().map(obj -> obj.getLong(PropUtils.getIdDot((String)entryKey))).collect(Collectors.toSet());
        entryTeamMemberIds.addAll(joinTeamMemberIds);
    }

    private Map<AdjustEntryEnum, List<ProjectMemberEntryWrapper>> wrapperEntryRow(DynamicObject adjustBill) {
        HashMap entryWrapper = Maps.newHashMapWithExpectedSize((int)4);
        DynamicObjectCollection adjJoinEntry = adjustBill.getDynamicObjectCollection("memberadjjentry");
        DynamicObjectCollection adjChangeEntry = adjustBill.getDynamicObjectCollection("memberadjaentry");
        DynamicObjectCollection adjQuitEntry = adjustBill.getDynamicObjectCollection("memberadjqentry");
        ArrayList roleJoinEntityWrapper = Lists.newArrayList();
        ArrayList roleAdjustJoinEntityWrapper = Lists.newArrayList();
        ArrayList roleAdjustQuitEntityWrapper = Lists.newArrayList();
        ArrayList roleQuitEntityWrapper = Lists.newArrayList();
        for (DynamicObject entry : adjJoinEntry) {
            ProjectMemberEntryWrapper wrapper = ProjectMemberEntryWrapperFactory.getInstance((AdjustEntryEnum)AdjustEntryEnum.ADJUST_JOIN, (DynamicObject)entry, (DynamicObject)adjustBill);
            roleJoinEntityWrapper.add(wrapper);
        }
        for (DynamicObject entry : adjChangeEntry) {
            ProjectMemberEntryWrapper tempJoinEntityWrapper = ProjectMemberEntryWrapperFactory.getInstance((AdjustEntryEnum)AdjustEntryEnum.ADJUST_ADJ_JOIN, (DynamicObject)entry, (DynamicObject)adjustBill);
            roleAdjustJoinEntityWrapper.add(tempJoinEntityWrapper);
            ProjectMemberEntryWrapper tempAdjustEntityWrapper = ProjectMemberEntryWrapperFactory.getInstance((AdjustEntryEnum)AdjustEntryEnum.ADJUST_ADJ_QUIT, (DynamicObject)entry, (DynamicObject)adjustBill);
            roleAdjustQuitEntityWrapper.add(tempAdjustEntityWrapper);
        }
        for (DynamicObject entry : adjQuitEntry) {
            ProjectMemberEntryWrapper tempAdjustEntityWrapper = ProjectMemberEntryWrapperFactory.getInstance((AdjustEntryEnum)AdjustEntryEnum.ADJUST_QUIT, (DynamicObject)entry, (DynamicObject)adjustBill);
            roleQuitEntityWrapper.add(tempAdjustEntityWrapper);
        }
        entryWrapper.put(AdjustEntryEnum.ADJUST_JOIN, roleJoinEntityWrapper);
        entryWrapper.put(AdjustEntryEnum.ADJUST_ADJ_JOIN, roleAdjustJoinEntityWrapper);
        entryWrapper.put(AdjustEntryEnum.ADJUST_ADJ_QUIT, roleAdjustQuitEntityWrapper);
        entryWrapper.put(AdjustEntryEnum.ADJUST_QUIT, roleQuitEntityWrapper);
        return entryWrapper;
    }

    private Pair<List<DynamicObject>, List<DynamicObject>> execRoleJoin(Map<ProjectMemberKey, DynamicObject> projectMemberMap, List<ProjectMemberEntryWrapper> joinEntityWrapper, DynamicObject adjustBill, List<SyncRequestData> syncRequestDataList, Map<Long, DynamicObject> dbProjectTeamMap, Map<Long, String> projectIdentifies) {
        PluginProxy<IBillExPoint> billExPointPlugin = this.getBillExPointPluginProxy();
        String adjustBillNo = adjustBill.getString("billno");
        Map<Pair<Long, Long>, List<DynamicObject>> personMainTeamMap = this.getMainTeamRole(adjustBill);
        int mainRoleIdCount = (int)joinEntityWrapper.stream().filter(wrapper -> "1".equals(wrapper.getIsTeamMainRole())).count();
        int newMainTeamMemberIdIndex = 0;
        long[] newTeamMemberRoleIds = ORM.create().genLongIds("ptmm_teammember", mainRoleIdCount);
        int newRoleIdIndex = 0;
        long[] newRoleIds = ORM.create().genLongIds("ptmm_teammemberrole", joinEntityWrapper.size());
        LinkedList<DynamicObject> newTeamMemberObjs = new LinkedList<DynamicObject>();
        LinkedList<DynamicObject> newTeamMemberRoleObjs = new LinkedList<DynamicObject>();
        for (ProjectMemberEntryWrapper entryWrapper : joinEntityWrapper) {
            DynamicObject newRoleObj;
            boolean oneTeamOrAfterTeamNull;
            Long personId = entryWrapper.getPersonId();
            Date joinDate = entryWrapper.getJoinDate();
            Long teamMemberId = entryWrapper.getTeamMemberId();
            DynamicObject entryRow = entryWrapper.getEntryRow();
            long projectTeamId = entryRow.getLong(entryWrapper.getProjectTeamKey() + ".id");
            String projectIdentify = projectIdentifies.get(projectTeamId);
            ProjectMemberKey projectMemberKey = new ProjectMemberKey(projectIdentify, personId);
            DynamicObject dbAfterProjectMember = projectMemberMap.get(projectMemberKey);
            PtmmNPEExpUtil.throwExp((Object)projectIdentify, (String)"get adjust after project member by project team and person is null");
            if (!HRObjectUtils.isEmpty((Object)dbAfterProjectMember) && dbAfterProjectMember.getDate("joindate").after(joinDate)) {
                dbAfterProjectMember.set("joindate", (Object)joinDate);
            }
            long afterProjectTeamId = entryRow.getLong(entryWrapper.getProjectTeamKey() + ".id");
            Pair mainRoleKey = Pair.of((Object)personId, (Object)afterProjectTeamId);
            List<DynamicObject> mainTeamRoleList = personMainTeamMap.get(mainRoleKey);
            DynamicObject teamMainRole = this.getCurRowMainMemberRole(joinDate, mainTeamRoleList);
            SyncRequestData syncRequestData = new SyncRequestData();
            syncRequestData.setPersonId(entryWrapper.getPersonId());
            long beforeProjectTeamId = entryRow.getLong(PropUtils.getIdDot((String)entryWrapper.getBeforeProjectTeamKey()));
            boolean bl = oneTeamOrAfterTeamNull = HRObjectUtils.isEmpty((Object)teamMainRole) || beforeProjectTeamId == projectTeamId;
            if (oneTeamOrAfterTeamNull && "1".equals(entryWrapper.getIsTeamMainRole())) {
                long projectTeamMemberId = newTeamMemberRoleIds[newMainTeamMemberIdIndex++];
                this.createMainRoleTeamMember(adjustBillNo, newTeamMemberObjs, entryWrapper, entryRow, projectTeamMemberId, dbAfterProjectMember);
                DynamicObject newRoleObj2 = this.createTeamMemberRole(entryWrapper, projectTeamMemberId, adjustBillNo, "1", dbAfterProjectMember);
                newRoleObj2.set("id", (Object)newRoleIds[newRoleIdIndex++]);
                newTeamMemberRoleObjs.add(newRoleObj2);
                this.executeBillExPointPlugin(billExPointPlugin, this.packageArgs(adjustBill, entryRow, newRoleObj2));
                TeamMemberBillServiceImpl.assembleSyncJoinData(syncRequestDataList, entryWrapper, syncRequestData, projectTeamMemberId, newRoleObj2);
                continue;
            }
            if (beforeProjectTeamId != projectTeamId) {
                long mainTeamMemberId = 0L;
                if (teamMainRole != null && !HRObjectUtils.isEmpty((Object)teamMainRole)) {
                    mainTeamMemberId = teamMainRole.getLong("teammember.id");
                }
                newRoleObj = this.createTeamMemberRole(entryWrapper, mainTeamMemberId, adjustBillNo, "0", dbAfterProjectMember);
                this.executeBillExPointPlugin(billExPointPlugin, this.packageArgs(adjustBill, entryRow, newRoleObj));
                syncRequestData.setTeamMemberId(mainTeamMemberId);
            } else {
                newRoleObj = this.createTeamMemberRole(entryWrapper, teamMemberId, adjustBillNo, "0", dbAfterProjectMember);
                this.executeBillExPointPlugin(billExPointPlugin, this.packageArgs(adjustBill, entryRow, newRoleObj));
                syncRequestData.setTeamMemberId(teamMemberId);
            }
            newRoleObj.set("id", (Object)newRoleIds[newRoleIdIndex++]);
            newTeamMemberRoleObjs.add(newRoleObj);
            TeamMemberBillServiceImpl.assembleSyncQuitData(syncRequestDataList, entryWrapper, syncRequestData, newRoleObj);
        }
        return Pair.of(newTeamMemberObjs, newTeamMemberRoleObjs);
    }

    private DynamicObject getCurRowMainMemberRole(Date joinDate, List<DynamicObject> mainTeamRoleList) {
        DynamicObject teamMainRole = null;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(mainTeamRoleList)) {
            DynamicObject toBeEffectMainTeamRole;
            Date toBeEffectMainTeamRoleDate;
            teamMainRole = mainTeamRoleList.size() == 1 ? mainTeamRoleList.get(0) : (joinDate.compareTo(toBeEffectMainTeamRoleDate = (toBeEffectMainTeamRole = mainTeamRoleList.get(0)).getDate("joindate")) >= 0 ? toBeEffectMainTeamRole : mainTeamRoleList.get(1));
        }
        return teamMainRole;
    }

    private Map<Pair<Long, Long>, List<DynamicObject>> getMainTeamRole(DynamicObject adjustBill) {
        DynamicObjectCollection entryRoleAdjust = adjustBill.getDynamicObjectCollection("memberadjaentry");
        DynamicObject[] projectTeamMainRole = this.getAdjustAfterMainRole(entryRoleAdjust);
        return Arrays.stream(projectTeamMainRole).sorted((c1, c2) -> c2.getDate("createtime").compareTo(c1.getDate("createtime"))).collect(Collectors.groupingBy(obj -> Pair.of((Object)obj.getLong("person.id"), (Object)obj.getLong("projectteam_id"))));
    }

    private void createMainRoleTeamMember(String adjustBillNo, List<DynamicObject> newTeamMemberObjs, ProjectMemberEntryWrapper entryWrapper, DynamicObject entryRow, long projectTeamMemberId, DynamicObject dbAfterProjectMember) {
        DynamicObject newTeamMember = this.teamMemberRepository.generateEmptyDynamicObject();
        newTeamMember.set("id", (Object)projectTeamMemberId);
        this.setHisModelAttr(newTeamMember, DateUtils.getNowDate());
        newTeamMember.set("projectmember", (Object)dbAfterProjectMember.getLong("id"));
        newTeamMember.set("servicestate", (Object)this.getJoinServiceStatus(entryWrapper.getJoinDate()));
        newTeamMember.set("joindate", (Object)entryWrapper.getJoinDate());
        DynamicObject person = entryRow.getDynamicObject(entryWrapper.getPersonKey());
        newTeamMember.set("person", person.getPkValue());
        newTeamMember.set("name", person.get("name"));
        DynamicObject projectTeam = entryRow.getDynamicObject(entryWrapper.getProjectTeamKey());
        newTeamMember.set("number", (Object)projectTeam.getString("number"));
        newTeamMember.set("projectteam", (Object)projectTeam);
        newTeamMember.set("projectrole", entryRow.get(entryWrapper.getProjectroleKey()));
        newTeamMember.set("isprincipal", (Object)entryWrapper.getPrincipal());
        newTeamMember.set("joinbillno", (Object)adjustBillNo);
        newTeamMemberObjs.add(newTeamMember);
    }

    private void setHisModelAttr(DynamicObject projectTeamMember, Date value) {
        projectTeamMember.set("bsed", (Object)value);
        projectTeamMember.set("bsled", (Object)DateUtils.getHisMaxDate());
        projectTeamMember.set("iscurrentversion", (Object)"1");
        projectTeamMember.set("datastatus", (Object)"1");
        projectTeamMember.set("enable", (Object)"1");
        projectTeamMember.set("status", (Object)"C");
    }

    private void execRoleQuit(Map<Long, DynamicObject> dbTeamMemberRoleMap, List<ProjectMemberEntryWrapper> endRoleEntryWrapper, String adjustBillNo, Map<Long, DynamicObject> teamMemberMap, List<SyncRequestData> syncRequestDataList) {
        PluginProxy<IBillExPoint> billExPointPluginProxy = this.getBillExPointPluginProxy();
        for (ProjectMemberEntryWrapper endRoleWrapper : endRoleEntryWrapper) {
            Long teamMemberRoleId = endRoleWrapper.getTeamMemberRoleId();
            DynamicObject dbTeamMemberRole = dbTeamMemberRoleMap.get(teamMemberRoleId);
            dbTeamMemberRole.set("endbillno", (Object)adjustBillNo);
            dbTeamMemberRole.set("adjustreason", (Object)endRoleWrapper.getAdjustReason());
            dbTeamMemberRole.set("quitdate", (Object)endRoleWrapper.getQuitDate());
            String isTeamMainRole = endRoleWrapper.getIsTeamMainRole();
            long dbTeamMemberId = dbTeamMemberRole.getLong("teammember.id");
            DynamicObject dbTeamMember = teamMemberMap.get(dbTeamMemberId);
            SyncRequestData syncRequestData = new SyncRequestData();
            if (!HRObjectUtils.isEmpty((Object)dbTeamMember) && "1".equals(isTeamMainRole)) {
                dbTeamMember.set("endbillno", (Object)adjustBillNo);
                dbTeamMember.set("quitdate", (Object)endRoleWrapper.getQuitDate());
                syncRequestData.setSyncType("3");
            } else {
                syncRequestData.setSyncType("4");
            }
            if (DateUtils.getNowDate().getTime() >= endRoleWrapper.getQuitDate().getTime()) {
                dbTeamMemberRole.set("servicestate", (Object)"C");
                syncRequestData.setTeamMemberRoleId(dbTeamMemberRole.getLong("id"));
                syncRequestData.setTeamMemberRole(dbTeamMemberRole);
                if (!HRObjectUtils.isEmpty((Object)dbTeamMember)) {
                    syncRequestData.setTeamMemberId(dbTeamMember.getLong("id"));
                    if ("1".equals(isTeamMainRole)) {
                        dbTeamMember.set("servicestate", (Object)"C");
                    }
                } else {
                    syncRequestData.setTeamMemberId(0L);
                }
                syncRequestData.setPersonId(dbTeamMemberRole.getLong("person.id"));
                syncRequestDataList.add(syncRequestData);
            }
            DynamicObject bill = (DynamicObject)endRoleWrapper.getEntryRow().getParent();
            this.executeBillExPointPlugin(billExPointPluginProxy, this.packageArgs(bill, endRoleWrapper.getEntryRow(), dbTeamMemberRole));
        }
    }

    private DynamicObject createTeamMemberRole(ProjectMemberEntryWrapper wrapper, long teamMemberId, String adjustBillNo, String isTeamRole, DynamicObject dbAfterProjectMember) {
        DynamicObject entryRow = wrapper.getEntryRow();
        DynamicObject dynamicObject = this.teamMemberRoleRepository.generateEmptyDynamicObject();
        this.setHisModelAttr(dynamicObject, wrapper.getJoinDate());
        dynamicObject.set("projectname", (Object)wrapper.getProjectNameLocalString());
        dynamicObject.set("projectnumber", (Object)wrapper.getProjectNumber());
        dynamicObject.set("person", (Object)wrapper.getPersonId());
        dynamicObject.set("name", (Object)entryRow.getDynamicObject(wrapper.getPersonKey()).getString("name"));
        dynamicObject.set("projectmember", (Object)dbAfterProjectMember.getLong("id"));
        dynamicObject.set("teammember", (Object)teamMemberId);
        Date joinStartDate = wrapper.getJoinDate();
        dynamicObject.set("joindate", (Object)joinStartDate);
        dynamicObject.set("joinbillno", (Object)adjustBillNo);
        dynamicObject.set("servicestate", (Object)this.getJoinServiceStatus(joinStartDate));
        dynamicObject.set("adjustreason", (Object)wrapper.getAdjustReason());
        dynamicObject.set("isteammainrole", (Object)isTeamRole);
        dynamicObject.set("isprincipal", (Object)wrapper.getPrincipal());
        dynamicObject.set("projectteam", entryRow.get(wrapper.getProjectTeamKey()));
        dynamicObject.set("projectrole", entryRow.get(wrapper.getProjectroleKey()));
        dynamicObject.set("number", (Object)entryRow.getDynamicObject(wrapper.getProjectroleKey()).getString("number"));
        return dynamicObject;
    }

    public Map<ProjectMemberKey, DynamicObject> listProjectMemberMap(Collection<String> projectNames, List<Long> personIds) {
        DynamicObject[] projectMemberObjs = this.projectMemberRepository.listProjectMember(projectNames, personIds);
        return Arrays.stream(projectMemberObjs).collect(Collectors.toMap(obj -> new ProjectMemberKey(obj.getString("projectidentify"), Long.valueOf(obj.getLong("person.id"))), obj -> obj, (v1, v2) -> v1));
    }

    private Map<ProjectMemberKey, DynamicObject> createOrUpdateProjectMember(DynamicObjectCollection joinEntry, Map<ProjectMemberKey, DynamicObject> projectMemberMap, Map<Long, DynamicObject> projectIdentifies) {
        HashMap newProjectMemberMap = Maps.newHashMap();
        for (DynamicObject entryRow : joinEntry) {
            Date rowJoinDate = entryRow.getDate("joinstartdate");
            long projectTeamId = entryRow.getLong("projectteamadd.id");
            String rowProjectIdentify = projectIdentifies.get(projectTeamId).getString("projectidentify");
            Object rootProjectName = projectIdentifies.get(projectTeamId).get("projectname");
            Object rootProjectNumber = projectIdentifies.get(projectTeamId).get("projectnumber");
            long personId = entryRow.getLong("personfield.id");
            ProjectMemberKey projectMemberKey = new ProjectMemberKey(rowProjectIdentify, Long.valueOf(personId));
            DynamicObject projectMember = projectMemberMap.get(projectMemberKey);
            if (!HRObjectUtils.isEmpty((Object)projectMember)) {
                Date preJoinDate = projectMember.getDate("joindate");
                if (rowJoinDate.before(preJoinDate)) {
                    projectMember.set("joindate", (Object)rowJoinDate);
                }
                if (rowJoinDate.after(DateUtils.getNowDate())) continue;
                projectMember.set("servicestate", (Object)"B");
                continue;
            }
            projectMember = (DynamicObject)newProjectMemberMap.get(projectMemberKey);
            if (projectMember == null) {
                DynamicObject dynamicObject = this.projectMemberRepository.generateEmptyDynamicObject();
                this.setHisModelAttr(dynamicObject, rowJoinDate);
                dynamicObject.set("projectname", rootProjectName);
                dynamicObject.set("projectidentify", (Object)rowProjectIdentify);
                dynamicObject.set("projectnumber", rootProjectNumber);
                dynamicObject.set("person", (Object)personId);
                dynamicObject.set("joindate", (Object)rowJoinDate);
                dynamicObject.set("servicestate", (Object)this.getJoinServiceStatus(rowJoinDate));
                newProjectMemberMap.put(projectMemberKey, dynamicObject);
                continue;
            }
            this.updateProjectMemberJoinDateByRowDate(rowJoinDate, projectMember);
        }
        Collection newProjectMembers = newProjectMemberMap.values();
        long[] projectMemberIds = ORM.create().genLongIds("ptmm_projectmember", newProjectMembers.size());
        int i = 0;
        for (DynamicObject newProjectMember : newProjectMembers) {
            newProjectMember.set("id", (Object)projectMemberIds[i++]);
        }
        projectMemberMap.putAll(newProjectMemberMap);
        return projectMemberMap;
    }

    private void updateProjectMemberJoinDateByRowDate(Date rowJoinDate, DynamicObject projectMember) {
        Date preJoinDate = projectMember.getDate("joindate");
        if (rowJoinDate.before(preJoinDate)) {
            projectMember.set("joindate", (Object)rowJoinDate);
        }
    }

    private String syncDataAndUpdateRowJoinStatus(List<SyncRequestData> syncRequestDataList) {
        String adjustStatus = "B";
        try {
            this.syncMemberRoleHisJoin.accept(syncRequestDataList);
            PTMMServiceFactory.syncTeamMemberService.syncData(syncRequestDataList);
        }
        catch (Exception e) {
            log.error("sync_Role_Error_syncDataAndUpdateRowJoinStatus: ", (Throwable)e);
            List<DynamicObject> syncRole = syncRequestDataList.stream().map(SyncRequestData::getTeamMemberRole).collect(Collectors.toList());
            this.updateFailJoinRoleData(syncRole);
            adjustStatus = "C";
        }
        return adjustStatus;
    }

    private String syncDataAndUpdateRowAdjustStatus(List<SyncRequestData> syncRequestDataList) {
        String adjustStatus = "B";
        List syncMemberRoleDataJoin = syncRequestDataList.stream().filter(syncRequestData -> syncRequestData.getSyncType().equals("1") || syncRequestData.getSyncType().equals("2")).collect(Collectors.toList());
        List syncMemberRoleDataQuit = syncRequestDataList.stream().filter(syncRequestData -> syncRequestData.getSyncType().equals("3") || syncRequestData.getSyncType().equals("4")).collect(Collectors.toList());
        try {
            this.syncMemberRoleHisJoin.accept(syncMemberRoleDataJoin);
            this.syncMemberRoleHisQuit.accept(syncMemberRoleDataQuit);
            PTMMServiceFactory.syncTeamMemberService.syncData(syncRequestDataList);
        }
        catch (Exception e) {
            log.error("sync_Role_Error_syncDataAndUpdateRowAdjustStatus: ", (Throwable)e);
            List<DynamicObject> syncRoleJoin = syncMemberRoleDataJoin.stream().map(SyncRequestData::getTeamMemberRole).collect(Collectors.toList());
            this.updateFailJoinRoleData(syncRoleJoin);
            List<DynamicObject> syncRoleQuit = syncMemberRoleDataQuit.stream().map(SyncRequestData::getTeamMemberRole).collect(Collectors.toList());
            this.updateFailQuitRoleData(syncRoleQuit);
            adjustStatus = "C";
        }
        return adjustStatus;
    }

    private String syncDataAndUpdateRowQuitStatus(List<SyncRequestData> syncRequestDataList) {
        String adjustStatus = "B";
        try {
            this.syncMemberRoleHisQuit.accept(syncRequestDataList);
            PTMMServiceFactory.syncTeamMemberService.syncData(syncRequestDataList);
        }
        catch (Exception e) {
            log.error("sync_Role_Error_syncDataAndUpdateRowQuitStatus: ", (Throwable)e);
            List<DynamicObject> syncRoles = syncRequestDataList.stream().map(SyncRequestData::getTeamMemberRole).collect(Collectors.toList());
            this.updateFailQuitRoleData(syncRoles);
            adjustStatus = "C";
        }
        return adjustStatus;
    }

    private void updateFailJoinRoleData(List<DynamicObject> joinRoles) {
        List<Long> syncRoleIds = joinRoles.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
        Object[] dbJoinRoles = this.teamMemberRoleRepository.listTeamMemberRoleArr(syncRoleIds);
        Arrays.stream(dbJoinRoles).filter(role -> role.getString("servicestate").equals("B")).forEach(role -> role.set("servicestate", (Object)"A"));
        this.teamMemberRoleRepository.update((DynamicObject[])dbJoinRoles);
        this.refreshTeamMemberState(Lists.newArrayList((Object[])dbJoinRoles));
        this.refreshProjectMemberState(Lists.newArrayList((Object[])dbJoinRoles));
    }

    private void updateFailQuitRoleData(List<DynamicObject> quitRoles) {
        List<Long> syncRoleIds = quitRoles.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
        Object[] dbQuitRoles = this.teamMemberRoleRepository.listTeamMemberRoleArr(syncRoleIds);
        Arrays.stream(dbQuitRoles).filter(role -> role.getString("servicestate").equals("C")).forEach(role -> role.set("servicestate", (Object)"B"));
        this.teamMemberRoleRepository.update((DynamicObject[])dbQuitRoles);
        this.refreshTeamMemberState(Lists.newArrayList((Object[])dbQuitRoles));
        this.refreshProjectMemberStatusAndQuitDate((DynamicObject[])dbQuitRoles);
    }

    private Map<Pair<Long, Long>, Long> getPersonTeamBaseId(DynamicObject[] mergeProjectTeamMember) {
        return Arrays.stream(mergeProjectTeamMember).collect(Collectors.toMap(obj -> {
            Object personObj = obj.get("person");
            long personId = personObj instanceof Long ? ((Long)personObj).longValue() : obj.getLong("person.id");
            Object projectTeamObj = obj.get("projectteam");
            long projectTeamId = projectTeamObj instanceof Long ? ((Long)projectTeamObj).longValue() : obj.getLong(PropUtils.getIdDot((String)"projectteam"));
            return Pair.of((Object)personId, (Object)projectTeamId);
        }, obj -> obj.getLong("id"), (v1, v2) -> v1));
    }

    private Map<Long, DynamicObject> dyObjArrayToMap(DynamicObject[] dynamicObjects, String key) {
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(obj -> obj.getLong(key), obj -> obj, (v1, v2) -> v1));
    }

    private List<DynamicObject> createOrUpdateTeamMember(DynamicObjectCollection joinEntry, Map<ProjectMemberKey, DynamicObject> newPersonProject, String billNo, Map<Long, String> projectIdentifies) {
        ArrayList newTeamMembers = Lists.newArrayListWithExpectedSize((int)joinEntry.size());
        for (DynamicObject entryRow : joinEntry) {
            Long personId = entryRow.getLong("personfield.id");
            long projectTeamId = entryRow.getLong("projectteamadd.id");
            String rowProjectIdentify = projectIdentifies.get(projectTeamId);
            DynamicObject projectMember = newPersonProject.get(new ProjectMemberKey(rowProjectIdentify, personId));
            Long projectMemberId = projectMember.getLong("id");
            Date joinStartDate = entryRow.getDate("joinstartdate");
            DynamicObject dynamicObject = this.teamMemberRepository.generateEmptyDynamicObject();
            this.setHisModelAttr(dynamicObject, DateUtils.getNowDate());
            dynamicObject.set("projectteam", (Object)projectTeamId);
            dynamicObject.set("projectmember", (Object)projectMemberId);
            dynamicObject.set("person", (Object)personId);
            dynamicObject.set("servicestate", (Object)this.getJoinServiceStatus(joinStartDate));
            dynamicObject.set("joindate", (Object)joinStartDate);
            dynamicObject.set("name", (Object)entryRow.getString("personfield.name"));
            dynamicObject.set("number", (Object)entryRow.getString("projectteamadd.number"));
            dynamicObject.set("projectrole", entryRow.get("projectrole"));
            dynamicObject.set("isprincipal", entryRow.get("isprincipal"));
            dynamicObject.set("joinbillno", (Object)billNo);
            newTeamMembers.add(dynamicObject);
        }
        long[] projectTeamMemberIds = ORM.create().genLongIds("ptmm_teammember", newTeamMembers.size());
        for (int i = 0; i < projectTeamMemberIds.length; ++i) {
            ((DynamicObject)newTeamMembers.get(i)).set("id", (Object)projectTeamMemberIds[i]);
        }
        return newTeamMembers;
    }

    private List<DynamicObject> createOrUpdateTeamMemberRole(DynamicObject adjJoinBill, Map<ProjectMemberKey, DynamicObject> projectMemberMap, Map<Pair<Long, Long>, Long> newProjectTeamMemberId, List<SyncRequestData> syncRequestDataList, Map<Long, DynamicObject> projectIdentifies) {
        PluginProxy<IBillExPoint> pluginProxy = this.getBillExPointPluginProxy();
        DynamicObjectCollection joinEntry = adjJoinBill.getDynamicObjectCollection("memberjoinentry");
        int roleCount = joinEntry.stream().mapToInt(obj -> obj.getDynamicObjectCollection("projectroleother").size() + 1).sum();
        long[] projectMemberRoleIds = ORM.create().genLongIds("ptmm_teammemberrole", roleCount);
        int idIndex = 0;
        String billNo = adjJoinBill.getString("billno");
        ArrayList newTeamMemberRoles = Lists.newArrayListWithExpectedSize((int)joinEntry.size());
        for (DynamicObject entryRow : joinEntry) {
            long curRowId = projectMemberRoleIds[idIndex++];
            log.info("personOrg:{}", (Object)entryRow.getLong("personorg.id"));
            Long personId = entryRow.getLong("personfield.id");
            long projectTeamId = entryRow.getLong("projectteamadd.id");
            String rowProjectIdentify = projectIdentifies.get(projectTeamId).getString("projectidentify");
            Object rootProjectName = projectIdentifies.get(projectTeamId).get("projectname");
            Object rootProjectNumber = projectIdentifies.get(projectTeamId).get("projectnumber");
            DynamicObject projectMember = projectMemberMap.get(new ProjectMemberKey(rowProjectIdentify, personId));
            Long projectMemberId = projectMember.getLong("id");
            Pair projectTeamMemberKey = Pair.of((Object)personId, (Object)projectTeamId);
            Long projectTeamMemberId = newProjectTeamMemberId.get(projectTeamMemberKey);
            Date joinStartDate = entryRow.getDate("joinstartdate");
            Date nowDate = DateUtils.getNowDate();
            boolean syncDataFlag = false;
            DynamicObject dynamicObject = this.teamMemberRoleRepository.generateEmptyDynamicObject();
            if (joinStartDate.getTime() <= nowDate.getTime()) {
                SyncRequestData syncRequestData = new SyncRequestData();
                syncRequestData.setSyncType("1");
                syncRequestData.setPersonId(personId);
                syncRequestData.setTeamMemberId(projectTeamMemberId);
                syncRequestData.setTeamMemberRoleId(curRowId);
                syncRequestData.setTeamMemberRole(dynamicObject);
                syncRequestDataList.add(syncRequestData);
                syncDataFlag = true;
            }
            this.setHisModelAttr(dynamicObject, DateUtils.getNowDate());
            dynamicObject.set("id", (Object)curRowId);
            dynamicObject.set("projectname", rootProjectName);
            dynamicObject.set("projectnumber", rootProjectNumber);
            dynamicObject.set("person", (Object)personId);
            dynamicObject.set("name", entryRow.get("personfield.name"));
            dynamicObject.set("number", entryRow.get("projectrole.number"));
            dynamicObject.set("projectmember", (Object)projectMemberId);
            dynamicObject.set("projectteam", (Object)projectTeamId);
            dynamicObject.set("teammember", (Object)projectTeamMemberId);
            dynamicObject.set("servicestate", (Object)this.getJoinServiceStatus(joinStartDate));
            dynamicObject.set("joindate", (Object)joinStartDate);
            dynamicObject.set("projectrole", entryRow.get("projectrole"));
            dynamicObject.set("adjustreason", entryRow.get("adjustreason"));
            dynamicObject.set("isprincipal", entryRow.get("isprincipal"));
            dynamicObject.set("isteammainrole", (Object)"1");
            dynamicObject.set("joinbillno", (Object)billNo);
            this.executeBillExPointPlugin(pluginProxy, this.packageArgs(adjJoinBill, entryRow, dynamicObject));
            newTeamMemberRoles.add(dynamicObject);
            DynamicObjectCollection projectRoleOther = entryRow.getDynamicObjectCollection("projectroleother");
            for (DynamicObject object : projectRoleOther) {
                DynamicObject otherDynamicObject = this.teamMemberRoleRepository.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)otherDynamicObject, (Set)ImmutableSet.of((Object)"projectrole", (Object)"number", (Object)"isteammainrole", (Object)"isprincipal"));
                otherDynamicObject.set("id", (Object)projectMemberRoleIds[idIndex++]);
                otherDynamicObject.set("projectrole", object.get("fbasedataid"));
                otherDynamicObject.set("number", (Object)object.getDynamicObject("fbasedataid").getString("number"));
                otherDynamicObject.set("isteammainrole", (Object)"0");
                otherDynamicObject.set("isprincipal", (Object)"0");
                newTeamMemberRoles.add(otherDynamicObject);
                if (!syncDataFlag) continue;
                SyncRequestData syncRequestDataOther = new SyncRequestData();
                syncRequestDataOther.setSyncType("2");
                syncRequestDataOther.setPersonId(personId);
                syncRequestDataOther.setTeamMemberId(projectTeamMemberId);
                syncRequestDataOther.setTeamMemberRoleId(otherDynamicObject.getLong("id"));
                syncRequestDataOther.setTeamMemberRole(otherDynamicObject);
                syncRequestDataList.add(syncRequestDataOther);
            }
        }
        return newTeamMemberRoles;
    }

    private String getJoinServiceStatus(Date startDate) {
        if (startDate.after(DateUtils.getNowDate())) {
            return "A";
        }
        return "B";
    }

    private boolean allRowFinish(DynamicObject billObj, String entryKey, String statusKey) {
        DynamicObjectCollection entry = billObj.getDynamicObjectCollection(entryKey);
        return entry.stream().allMatch(row -> "B".equals(row.getString(statusKey)));
    }

    private boolean allRowWait(DynamicObject billObj, String entryKey, String statusKey) {
        DynamicObjectCollection entry = billObj.getDynamicObjectCollection(entryKey);
        return entry.stream().noneMatch(row -> "B".equals(row.getString(statusKey)));
    }

    private PluginProxy<IBillExPoint> getBillExPointPluginProxy() {
        PluginProxy iBillExPointPluginProxy = PluginProxy.create(null, IBillExPoint.class, (String)"kd.sdk.hr.hrmp.ptmm.expoint.IBillExPoint");
        List plugins = iBillExPointPluginProxy.getPlugins();
        if (plugins.size() == 0) {
            log.info("getBillExPointPlugin size is 0");
        }
        for (int i = 0; i < plugins.size(); ++i) {
            IBillExPoint plugin = (IBillExPoint)plugins.get(i);
            log.info("getBillExPointPlugin {}: {}", (Object)i, plugin != null ? plugin.getClass() : null);
        }
        return iBillExPointPluginProxy;
    }

    private void executeBillExPointPlugin(PluginProxy<IBillExPoint> pluginProxy, SetMemberRoleFromEntryArgs args) {
        boolean hasExtendPlugins;
        boolean bl = hasExtendPlugins = pluginProxy.getPlugins().size() != 0;
        if (hasExtendPlugins) {
            pluginProxy.callReplace(plugin -> {
                if (plugin != null) {
                    plugin.setMemberRoleFromEntry(args);
                }
                return null;
            });
        }
    }

    private SetMemberRoleFromEntryArgs packageArgs(DynamicObject bill, DynamicObject row, DynamicObject memberRole) {
        SetMemberRoleFromEntryArgs setMemberRoleFromEntryArgs = new SetMemberRoleFromEntryArgs();
        setMemberRoleFromEntryArgs.setBill(bill);
        setMemberRoleFromEntryArgs.setEntryRow(row);
        setMemberRoleFromEntryArgs.setTeamMemberRole(memberRole);
        setMemberRoleFromEntryArgs.setEntryKey(row.getDataEntityType().getName());
        return setMemberRoleFromEntryArgs;
    }
}

