/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.domain.service.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.common.api.EnumResponseCode;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.ptmm.business.domain.bo.TeamMemberRoleHisBO;
import kd.hr.ptmm.business.domain.repository.ProjectTeamRepository;
import kd.hr.ptmm.business.domain.repository.TeamMemberRoleHisRepository;
import kd.hr.ptmm.business.domain.service.ChangeMemberHisFunc;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.business.domain.service.TeamMemberRoleHisService;
import kd.hr.ptmm.business.domain.vid.UpdateVidDto;
import kd.hr.ptmm.common.constants.member.TeamMemberRoleHisConstants;
import kd.hr.ptmm.common.enums.PersonServiceStatusEnum;
import kd.hr.ptmm.common.enums.VidPropType;
import kd.hr.ptmm.common.util.PropUtils;
import kd.hr.ptmm.common.util.PtmmDateUtils;
import org.apache.http.util.Asserts;

public class TeamMemberRoleHisServiceImpl
implements TeamMemberRoleHisService,
TeamMemberRoleHisConstants {
    private static final TeamMemberRoleHisRepository REPOSITORY = new TeamMemberRoleHisRepository();
    private static final Log LOG = LogFactory.getLog(TeamMemberRoleHisServiceImpl.class);
    private static final Map<VidPropType, List<String>> PROP_TYPE_LIST_HASH_MAP = Maps.newHashMapWithExpectedSize((int)3);

    @Override
    public DynamicObject[] queryForChangeByProjectTeam(List<Long> projectTeamIdList, LocalDate bSed) {
        Asserts.check((!CollectionUtils.isEmpty(projectTeamIdList) ? 1 : 0) != 0, (String)"projectTeamIdList");
        this.logInfo("queryForChangeByProjectTeam", projectTeamIdList);
        QFilter isCurrentQFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter dataStatusQFilter = new QFilter("datastatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"1", "2"}));
        QFilter projectTeamQFilter = new QFilter("projectteamboid", "in", projectTeamIdList);
        DynamicObject[] dynamicObjects = REPOSITORY.loadDynamicObjectArray(new QFilter[]{projectTeamQFilter, dataStatusQFilter, isCurrentQFilter});
        return this.filterHisDO(bSed, dynamicObjects);
    }

    @Override
    public DynamicObject[] queryForChangeByProjectRole(List<Long> projectRoleIdList, LocalDate bSed) {
        Asserts.check((!CollectionUtils.isEmpty(projectRoleIdList) ? 1 : 0) != 0, (String)"projectRoleIdList");
        this.logInfo("queryForChangeByProjectRole", projectRoleIdList);
        QFilter currentQFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter dataStatusQFilter = new QFilter("datastatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"1", "2"}));
        QFilter projectRoleQFilter = new QFilter("projectroleboid", "in", projectRoleIdList);
        DynamicObject[] dynamicObjects = REPOSITORY.loadDynamicObjectArray(new QFilter[]{currentQFilter, projectRoleQFilter, dataStatusQFilter});
        return this.filterHisDO(bSed, dynamicObjects);
    }

    @Override
    public DynamicObject[] queryForChangeByTeamMemberRole(List<Long> teamMemberRoleIdList, LocalDate bSed) {
        Asserts.check((!CollectionUtils.isEmpty(teamMemberRoleIdList) ? 1 : 0) != 0, (String)"teamMemberRoleIdList");
        this.logInfo("queryForChangeByTeamMemberRole", teamMemberRoleIdList);
        QFilter scene_1QF = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0')).and(new QFilter("bsed", "<=", (Object)bSed).and(new QFilter("bsled", ">=", (Object)bSed)));
        QFilter scene_2QF = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1')).and(new QFilter("firstbsed", ">", (Object)bSed));
        QFilter qFilter = scene_1QF.or(scene_2QF);
        QFilter memberRoleQFilter = new QFilter("teammemberrole", "in", teamMemberRoleIdList);
        QFilter serviceQFilter = new QFilter("servicestate", "=", (Object)PersonServiceStatusEnum.SERVING.getCode());
        QFilter dataStatusQFilter = new QFilter("datastatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"1", "2"}));
        return REPOSITORY.loadDynamicObjectArray(new QFilter[]{qFilter, memberRoleQFilter, serviceQFilter, dataStatusQFilter});
    }

    @Override
    public void createRoleHisObj(List<TeamMemberRoleHisBO> teamMemberRoleHisBOList) {
        this.checkRoleHisBO(teamMemberRoleHisBOList);
        this.logInfo("createRoleHisObj.param", teamMemberRoleHisBOList);
        Object[] personIdArr = teamMemberRoleHisBOList.stream().map(TeamMemberRoleHisBO::getPersonId).toArray();
        Map personDOMap = BusinessDataServiceHelper.loadFromCache((Object[])personIdArr, (String)"hrpi_person");
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(teamMemberRoleHisBOList.size());
        long[] idArr = ORM.create().genLongIds(REPOSITORY.getEntityName(), teamMemberRoleHisBOList.size());
        for (int i = 0; i < teamMemberRoleHisBOList.size(); ++i) {
            TeamMemberRoleHisBO teamMemberRoleHisBO = teamMemberRoleHisBOList.get(i);
            DynamicObject dynamicObject = REPOSITORY.generateEmptyDynamicObject();
            dynamicObject.set("id", (Object)idArr[i]);
            dynamicObject.set("projectteam", (Object)teamMemberRoleHisBO.getProjectTeamId());
            dynamicObject.set("projectrole", (Object)teamMemberRoleHisBO.getProjectRoleId());
            dynamicObject.set("workrole", (Object)teamMemberRoleHisBO.getWorkRoleId());
            dynamicObject.set("projectmember", (Object)teamMemberRoleHisBO.getProjectMemberId());
            dynamicObject.set("teammember", (Object)teamMemberRoleHisBO.getTeamMemberId());
            dynamicObject.set("teammemberrole", (Object)teamMemberRoleHisBO.getTeamMemberRoleId());
            dynamicObject.set("isteammainrole", (Object)teamMemberRoleHisBO.getTeamMainRole());
            dynamicObject.set("startdate", (Object)teamMemberRoleHisBO.getStartDate());
            dynamicObject.set("enddate", (Object)teamMemberRoleHisBO.getEndDate());
            dynamicObject.set("servicestate", (Object)teamMemberRoleHisBO.getServiceState());
            dynamicObject.set("belongadminorg", (Object)teamMemberRoleHisBO.getBelongAdminOrgId());
            dynamicObject.set("isprincipal", (Object)teamMemberRoleHisBO.getPrincipal());
            dynamicObject.set("projectname", (Object)teamMemberRoleHisBO.getProjectName());
            dynamicObject.set("person", (Object)teamMemberRoleHisBO.getPersonId());
            dynamicObject.set("projectteamboid", (Object)teamMemberRoleHisBO.getProjectTeamBoId());
            dynamicObject.set("projectroleboid", (Object)teamMemberRoleHisBO.getProjectRoleBoId());
            dynamicObject.set("projectidentify", (Object)teamMemberRoleHisBO.getProjectIdentify());
            DynamicObject personDO = (DynamicObject)personDOMap.get(teamMemberRoleHisBO.getPersonId());
            if (Objects.nonNull(personDO)) {
                dynamicObject.set("name", (Object)personDO.getString("name"));
                dynamicObject.set("number", (Object)personDO.getString("number"));
            }
            dynamicObject.set("bsed", (Object)teamMemberRoleHisBO.getStartDate());
            dynamicObjectList.add(dynamicObject);
        }
        this.doUpdateVid(dynamicObjectList);
        this.updateBeforeSave(dynamicObjectList);
        this.invokeHisModelService(dynamicObjectList);
    }

    @Override
    public void changeRoleHisVersion(Date bSed, ChangeMemberHisFunc<DynamicObject[]> func) {
        Asserts.notNull(func, (String)"ChangeMemberHisFunc");
        Asserts.notNull((Object)bSed, (String)"business effect date");
        LocalDate bSedLocalDate = PtmmDateUtils.date2LocalDate((Date)bSed);
        long bSedTime = HRDateTimeUtils.localDate2Date((LocalDate)bSedLocalDate).getTime();
        DynamicObject[] teamMemberRoleHisDOArr = func.execute();
        if (Objects.isNull(teamMemberRoleHisDOArr) || teamMemberRoleHisDOArr.length == 0) {
            this.logWarn("changeRoleHisVersion_noData:{}", PtmmDateUtils.now());
            return;
        }
        LOG.info("changeRoleHisVersion bSed:{}, teamMemberRoleHis:{}", (Object)bSed, Arrays.stream(teamMemberRoleHisDOArr).map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        List<DynamicObject> dynamicObjectList = Arrays.stream(teamMemberRoleHisDOArr).map(dynamicObject -> {
            long originalBSedTime = dynamicObject.getDate("bsed").getTime();
            long originalBSledTime = dynamicObject.getDate("bsled").getTime();
            if (bSedTime >= originalBSedTime && bSedTime <= originalBSledTime) {
                dynamicObject.set("bsed", (Object)bSed);
            }
            this.updateBeforeSave((DynamicObject)dynamicObject);
            return this.getCloneDataForHisModel((DynamicObject)dynamicObject);
        }).collect(Collectors.toList());
        this.invokeHisModelService(dynamicObjectList);
    }

    @Override
    public void changeRoleHisVersion(List<ChangeMemberHisFunc<DynamicObject[]>> funcList) {
        Asserts.check((!CollectionUtils.isEmpty(funcList) ? 1 : 0) != 0, (String)"ChangeMemberHisFunc");
        List dynamicObjects = funcList.stream().map(func -> Arrays.asList((Object[])func.execute())).flatMap(Collection::stream).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dynamicObjects)) {
            this.logWarn("changeRoleHisVersion_noData:{}", PtmmDateUtils.now());
            return;
        }
        LOG.info("changeRoleHisVersion teamMemberRoleHis:{}", dynamicObjects.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        List<DynamicObject> dynamicObjectList = dynamicObjects.stream().map(dynamicObject -> {
            this.updateBeforeSave((DynamicObject)dynamicObject);
            return this.getCloneDataForHisModel((DynamicObject)dynamicObject);
        }).collect(Collectors.toList());
        this.invokeHisModelService(dynamicObjectList);
    }

    @Override
    public void updateBeforeSave(List<DynamicObject> dynamicObjects) {
        TeamMemberRoleHisService.super.updateBeforeSave(dynamicObjects);
        this.fillBelongAdminOrgInfo(dynamicObjects);
    }

    private void fillBelongAdminOrgInfo(List<DynamicObject> dynamicObjects) {
        List<Object> projectTeamList = dynamicObjects.stream().map(dy -> dy.get("projectteam")).collect(Collectors.toList());
        Map<Long, Long> belongAdminOrg = this.getBelongAdminOrg(projectTeamList);
        belongAdminOrg.forEach((projectTeam, adminOrg) -> {
            for (DynamicObject dynamicObject : dynamicObjects) {
                Object projectTeamObj = dynamicObject.get("projectteam");
                long projectTeamId = 0L;
                if (projectTeamObj instanceof DynamicObject) {
                    projectTeamId = ((DynamicObject)projectTeamObj).getLong("id");
                }
                if (projectTeamObj instanceof Long) {
                    projectTeamId = (Long)projectTeamObj;
                }
                if (projectTeamId != projectTeam) continue;
                dynamicObject.set("belongadminorg", adminOrg);
            }
        });
    }

    @Override
    public void updateBeforeSave(DynamicObject dynamicObject) {
        TeamMemberRoleHisService.super.updateBeforeSave(dynamicObject);
        if (Objects.isNull(dynamicObject)) {
            return;
        }
        dynamicObject.getDynamicObjectType().getProperties().stream().filter(prop -> prop instanceof BasedataProp).forEach(prop -> {
            Object value = prop.getValue((Object)dynamicObject);
            if (value instanceof Long) {
                DynamicObject temp = BusinessDataServiceHelper.newDynamicObject((String)((BasedataProp)prop).getBaseEntityId());
                temp.set("id", value);
                dynamicObject.set(prop.getName(), (Object)temp);
            }
        });
    }

    private Map<Long, Long> getBelongAdminOrg(List<Object> projectTeamObjList) {
        QFilter projectTeamQFilter = new QFilter("id", "in", projectTeamObjList.stream().map(obj -> {
            if (obj instanceof DynamicObject) {
                return ((DynamicObject)obj).getLong("id");
            }
            if (obj instanceof Long) {
                return (Long)obj;
            }
            return 0L;
        }).collect(Collectors.toList()));
        DynamicObject[] projectTeamDOList = ProjectTeamRepository.getInstance().query("belongadminorg", projectTeamQFilter.toArray());
        return Arrays.stream(projectTeamDOList).collect(Collectors.toMap(projectTeamDO -> projectTeamDO.getLong("id"), projectTeamDO -> projectTeamDO.getLong(PropUtils.getIdDot((String)"belongadminorg")), (V1, V2) -> V1));
    }

    private void invokeHisModelService(List<DynamicObject> dynamicObjectList) {
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setHisDyns(dynamicObjectList.toArray(new DynamicObject[0]));
        hisVersionParamBo.setEffImmediately(true);
        hisVersionParamBo.setAtomicTrans(true);
        hisVersionParamBo.setEntityNumber(REPOSITORY.getEntityName());
        hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
        hisVersionParamBo.setEventId(null);
        try (TXHandle txHandle = TX.required((String)"invokeHisModelService");){
            try {
                HisResponse response = HisModelController.getInstance().hisVersionChange(hisVersionParamBo);
                Objects.requireNonNull(response);
                if (!HRStringUtils.equals((String)response.getCode(), (String)EnumResponseCode.SUCCESS.getCode())) {
                    throw new KDBizException(String.format(Locale.ROOT, "invoke hisChangeService error\uff1a%s1", response.getErrorMessage()));
                }
            }
            catch (Exception exception) {
                txHandle.markRollback();
                this.logError("invokeHisModelService", exception);
                throw exception;
            }
        }
    }

    private DynamicObject[] filterHisDO(LocalDate bSed, DynamicObject[] dynamicObjects) {
        HashSet<DynamicObject> dynamicObjectSet = new HashSet<DynamicObject>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            LocalDate endLocalDate;
            LocalDate startLocalDate = PtmmDateUtils.date2LocalDate((Date)dynamicObject.getDate("startdate"));
            if (bSed.isBefore(startLocalDate)) {
                dynamicObjectSet.add(dynamicObject);
            }
            if (PtmmDateUtils.isEqualOrBefore((LocalDate)bSed, (LocalDate)(endLocalDate = Objects.isNull(dynamicObject.getDate("enddate")) ? PtmmDateUtils.date2LocalDate((Date)HRDateTimeUtils.getSysMaxDate()) : PtmmDateUtils.date2LocalDate((Date)dynamicObject.getDate("enddate")))) && PtmmDateUtils.isEqualOrBefore((LocalDate)startLocalDate, (LocalDate)bSed)) {
                LocalDate originBSed = PtmmDateUtils.date2LocalDate((Date)dynamicObject.getDate("bsed"));
                LocalDate originBSLed = PtmmDateUtils.date2LocalDate((Date)dynamicObject.getDate("bsled"));
                if (PtmmDateUtils.isEqualOrBefore((LocalDate)originBSed, (LocalDate)bSed) && PtmmDateUtils.isEqualOrBefore((LocalDate)bSed, (LocalDate)originBSLed)) {
                    dynamicObjectSet.add(dynamicObject);
                }
                if (bSed.isBefore(originBSed)) {
                    dynamicObjectSet.add(dynamicObject);
                }
                if (PtmmDateUtils.isEqualOrBefore((LocalDate)bSed, (LocalDate)originBSed) && HRStringUtils.equals((String)PersonServiceStatusEnum.EXITED.getCode(), (String)dynamicObject.getString("servicestate"))) {
                    dynamicObjectSet.add(dynamicObject);
                }
            }
            if (!PtmmDateUtils.isEqualOrBefore((LocalDate)endLocalDate, (LocalDate)bSed)) continue;
        }
        return dynamicObjectSet.toArray(new DynamicObject[0]);
    }

    private void checkRoleHisBO(List<TeamMemberRoleHisBO> teamMemberRoleHisBOList) {
        Asserts.check((!CollectionUtils.isEmpty(teamMemberRoleHisBOList) ? 1 : 0) != 0, (String)"teamMemberRoleHisBOList not empty");
        for (TeamMemberRoleHisBO teamMemberRoleHisBO : teamMemberRoleHisBOList) {
            Asserts.notNull((Object)teamMemberRoleHisBO.getProjectTeamId(), (String)"projectteam");
            Asserts.notNull((Object)teamMemberRoleHisBO.getWorkRoleId(), (String)"projectrole");
            Asserts.notNull((Object)teamMemberRoleHisBO.getProjectMemberId(), (String)"projectmember");
            Asserts.notNull((Object)teamMemberRoleHisBO.getTeamMemberRoleId(), (String)"teammemberrole");
            Asserts.notNull((Object)teamMemberRoleHisBO.getProjectName(), (String)"projectname");
            Asserts.notNull((Object)teamMemberRoleHisBO.getPersonId(), (String)"person");
        }
    }

    private void doUpdateVid(List<DynamicObject> teamMemberRoleHisDOList) {
        UpdateVidDto updateVidDto = new UpdateVidDto();
        updateVidDto.setDynamicObjectList(teamMemberRoleHisDOList).setPropMapping(PROP_TYPE_LIST_HASH_MAP).setObjValidDateMapping(teamMemberRoleHisDOList.stream().collect(Collectors.groupingBy(dy -> {
            Date date = dy.getDate("startdate");
            if (Objects.isNull(date)) {
                return LocalDate.now();
            }
            return PtmmDateUtils.date2LocalDate((Date)date);
        })));
        PTMMServiceFactory.updateVidService.updateHistoryVid(updateVidDto);
    }

    private DynamicObject getCloneDataForHisModel(DynamicObject dynamicObject) {
        String entityName = REPOSITORY.getEntityName();
        DynamicObject clone = REPOSITORY.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)clone, (boolean)true);
        clone.set("id", (Object)ORM.create().genLongId(entityName));
        return clone;
    }

    private void logInfo(String key, Object value) {
        String logKey = String.join((CharSequence)":", this.getClass().getSimpleName(), key, "{}");
        LOG.info(logKey, value);
    }

    private void logError(String key, Object value) {
        String logKey = String.join((CharSequence)":", this.getClass().getSimpleName(), key);
        LOG.error(logKey, value);
    }

    private void logWarn(String key, Object value) {
        String logKey = String.join((CharSequence)":", this.getClass().getSimpleName(), key);
        LOG.warn(logKey, value);
    }

    static {
        PROP_TYPE_LIST_HASH_MAP.put(VidPropType.PROJECT_TEAM, (List<String>)ImmutableList.of((Object)"projectteam"));
        PROP_TYPE_LIST_HASH_MAP.put(VidPropType.PROJECT_ROLE, (List<String>)ImmutableList.of((Object)"projectrole"));
        PROP_TYPE_LIST_HASH_MAP.put(VidPropType.WORK_ROLE, (List<String>)ImmutableList.of((Object)"workrole"));
    }
}

