/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.domain.service.impl;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.ptmm.business.domain.repository.TeamMemberRepository;
import kd.hr.ptmm.business.domain.repository.TeamMemberRoleRepository;
import kd.hr.ptmm.business.domain.service.ITeamMemberService;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class TeamMemberServiceImpl
implements ITeamMemberService {
    private static final Log LOGGER = LogFactory.getLog(TeamMemberServiceImpl.class);
    private static TeamMemberRepository teamMemberRepository = TeamMemberRepository.getInstance();
    private static TeamMemberRoleRepository teamMemberRoleRepository = TeamMemberRoleRepository.getInstance();

    @Override
    public List<Map<String, Object>> getProjectGroupMembersById(List<Long> groupIds) {
        ArrayList<Map<String, Object>> projectGroupMembersInfo = new ArrayList<Map<String, Object>>(groupIds.size());
        QFilter qFilterGroupIds = new QFilter("projectteam", "in", groupIds);
        QFilter qFilterGroupStatus = new QFilter("servicestate", "!=", (Object)"C");
        QFilter qFilterGroupCurrent = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{qFilterGroupIds, qFilterGroupStatus, qFilterGroupCurrent};
        DynamicObject[] groupMemberDOs = teamMemberRepository.query("person,projectteam,servicestate,iscurrentversion", qFilters);
        for (Long groupId : groupIds) {
            boolean haveMemberOrNot = this.checkHaveMemberOrNot(0, groupId, groupMemberDOs);
            HashMap<String, Constable> projectGroupMembers = new HashMap<String, Constable>();
            projectGroupMembers.put("projectGroupId", groupId);
            projectGroupMembers.put("isHaveMembers", Boolean.valueOf(haveMemberOrNot));
            projectGroupMembersInfo.add(projectGroupMembers);
            LOGGER.info("getProjectGroupMembersById projectGroupId is : [{}], isHaveMembers is :[{}]", (Object)groupId.toString(), (Object)haveMemberOrNot);
        }
        return projectGroupMembersInfo;
    }

    @Override
    public DynamicObject[] getProjectGroupMembers(List<Long> personIds, List<Long> groupIds) {
        QFilter qFilterPersonIds = new QFilter("person", "in", personIds);
        QFilter qFilterGroupIds = new QFilter("projectteam", "in", groupIds);
        QFilter qFilterGroupCurrent = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{qFilterPersonIds, qFilterGroupIds, qFilterGroupCurrent};
        DynamicObject[] groupMemberDOs = teamMemberRepository.query("person,projectteam,servicestate,iscurrentversion,joindate,quitdate,joinbillno,endbillno", qFilters);
        return groupMemberDOs;
    }

    @Override
    public List<Map<String, Object>> getProjectRoleMembersById(List<Long> roleIds) {
        LOGGER.info("getProjectRoleMembersById roleIds is : [{}]", roleIds);
        List<Long> workRoleIds = PTMMServiceFactory.workRoleHrService.convertProjectRole2WorkRole(roleIds);
        LOGGER.info("getProjectRoleMembersById workRoleIds is : [{}]", workRoleIds);
        ArrayList<Map<String, Object>> projectRoleMembersInfo = new ArrayList<Map<String, Object>>(workRoleIds.size());
        QFilter qFilterRoleIds = new QFilter("projectrole", "in", workRoleIds);
        QFilter qFilterRoleStatus = new QFilter("servicestate", "!=", (Object)"C");
        QFilter qFilterRoleCurrent = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{qFilterRoleIds, qFilterRoleStatus, qFilterRoleCurrent};
        DynamicObject[] roleMemberDOs = teamMemberRoleRepository.query("person,projectrole,servicestate,iscurrentversion", qFilters);
        for (Long roleId : roleIds) {
            boolean haveMemberOrNot = this.checkHaveMemberOrNot(1, roleId, roleMemberDOs);
            HashMap<String, Constable> projectGroupMembers = new HashMap<String, Constable>();
            projectGroupMembers.put("projectRoleId", roleId);
            projectGroupMembers.put("isHaveMembers", Boolean.valueOf(haveMemberOrNot));
            projectRoleMembersInfo.add(projectGroupMembers);
            LOGGER.info("getProjectRoleMembersById projectRoleId is : [{}], isHaveMembers is :[{}]", (Object)roleId.toString(), (Object)haveMemberOrNot);
        }
        return projectRoleMembersInfo;
    }

    @Override
    public DynamicObject[] getProjectRoleMembers(List<Long> personIds, List<Long> teamIds) {
        QFilter qFilterPersonIds = new QFilter("person", "in", personIds);
        QFilter qFilterTeamIds = new QFilter("projectteam", "in", teamIds);
        QFilter qFilterRoleCurrent = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{qFilterPersonIds, qFilterTeamIds, qFilterRoleCurrent};
        DynamicObject[] roleMemberDOs = teamMemberRoleRepository.query("person,projectteam,projectrole,servicestate,iscurrentversion,joindate,quitdate,joinbillno,endbillno,isprincipal", qFilters);
        return roleMemberDOs;
    }

    @Override
    public DynamicObject[] getProjectRoleMembersInPrj(List<Long> personIds, List<String> projectIdentifys) {
        QFilter qFilterPersonIds = new QFilter("person", "in", personIds);
        QFilter qFilterPrjNames = new QFilter("projectmember.projectidentify", "in", projectIdentifys);
        QFilter qFilterRoleCurrent = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{qFilterPersonIds, qFilterPrjNames, qFilterRoleCurrent};
        DynamicObject[] roleMemberDOs = teamMemberRoleRepository.query("person,projectname,projectmember,isprincipal,projectteam,projectrole,servicestate,iscurrentversion,joindate,quitdate", qFilters);
        return roleMemberDOs;
    }

    @Override
    public DynamicObject[] getAllProjectRoleMembers(List<String> projectIdentifys) {
        QFilter qFilterPrjNames = new QFilter("projectmember.projectidentify", "in", projectIdentifys);
        QFilter qFilterRoleCurrent = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter qFilterRoleStatus = new QFilter("servicestate", "=", (Object)"B");
        QFilter[] qFilters = new QFilter[]{qFilterPrjNames, qFilterRoleCurrent, qFilterRoleStatus};
        DynamicObject[] roleMemberDOs = teamMemberRoleRepository.query("person,projectname,projectmember,isprincipal,projectteam,projectrole,servicestate,iscurrentversion,joindate,quitdate", qFilters);
        return roleMemberDOs;
    }

    private boolean checkHaveMemberOrNot(int type, Long id, DynamicObject[] groupRoleMemberDOs) {
        boolean isHaveOrNot = false;
        for (DynamicObject groupMemberDO : groupRoleMemberDOs) {
            if (type == 0) {
                if (groupMemberDO.getLong("projectteam.id") != id.longValue()) continue;
                isHaveOrNot = true;
                continue;
            }
            if (groupMemberDO.getLong("projectrole.id") != id.longValue()) continue;
            isHaveOrNot = true;
        }
        return isHaveOrNot;
    }

    public DynamicObject getPprojectTeamById(long id) {
        DynamicObject projectTeamMember = teamMemberRepository.queryOne("projectteam.belongadminorg", new QFilter[]{new QFilter("id", "=", (Object)id)});
        return projectTeamMember.getDynamicObject("projectteam");
    }

    @Override
    public long getBelongAdminOrgIdByRole(long id) {
        DynamicObject projectTeamMemberRole = teamMemberRoleRepository.queryOne("projectteam.belongadminorg", new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (!HRObjectUtils.isEmpty((Object)projectTeamMemberRole)) {
            return projectTeamMemberRole.getLong("projectteam.belongadminorg.id");
        }
        return 0L;
    }

    @Override
    public long getBelongAdminOrgId(long id) {
        DynamicObject pprojectTeamById = this.getPprojectTeamById(id);
        if (!HRObjectUtils.isEmpty((Object)pprojectTeamById)) {
            return pprojectTeamById.getLong("belongadminorg.id");
        }
        return 0L;
    }

    @Override
    public DynamicObject[] listTeamMemberByPersonAndTeam(List<Pair<Long, Long>> teamKeys) {
        List<Long> personIds = teamKeys.stream().map(Pair::getLeft).collect(Collectors.toList());
        List<Long> teamIds = teamKeys.stream().map(Pair::getRight).collect(Collectors.toList());
        return teamMemberRepository.listTeamMember(teamIds, personIds);
    }

    @Override
    public DynamicObject[] listTeamMemberRoleTriple(List<Triple<Long, Long, Long>> uniqueKey) {
        return teamMemberRoleRepository.listTeamMemberRoleTriple(uniqueKey);
    }

    @Override
    public DynamicObject[] listOtherRole(Set<Long> teamMemberIds) {
        return teamMemberRoleRepository.listOtherRole(teamMemberIds);
    }

    @Override
    public Map<Long, List<DynamicObject>> listOtherRoleMap(Set<Long> teamMemberIds) {
        return Arrays.stream(this.listOtherRole(teamMemberIds)).collect(Collectors.groupingBy(role -> role.getLong("teammember.id")));
    }

    @Override
    public DynamicObject[] listTeamMemberRoleByProjectMemberIds(Object[] projectMemberIds) {
        QFilter qFilter = new QFilter("projectmember.id", "in", (Object)projectMemberIds);
        return teamMemberRoleRepository.query("projectmember,projectname,projectnumber", new QFilter[]{qFilter});
    }
}

