/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.domain.service.impl.common;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.business.domain.service.common.IHRPIService;
import kd.hr.ptmm.business.domain.service.invoke.InvokeHandler;
import kd.hr.ptmm.business.domain.service.invoke.InvokeParam;
import org.apache.commons.collections4.CollectionUtils;

public class HRPIServiceImpl
implements IHRPIService {
    private static final Log LOG = LogFactory.getLog(HRPIServiceImpl.class);

    @Override
    public List<Map<String, Object>> listBatchEmployeeByPerson(List<Long> personIds, QFilter qFilter, String attachEntityName) {
        InvokeParam invokeParam = new InvokeParam("hrmp", "hrpi", "IHRPIEmployeeService", "listBatchEmployeeByPerson");
        List listBatchEmployeeMap = (List)InvokeHandler.getInstance().invokeService(invokeParam, personIds, qFilter, attachEntityName);
        return listBatchEmployeeMap;
    }

    public List<Long> listBatchEmployeeByPerson(List<Long> personIds) {
        ArrayList personQuit = Lists.newArrayList();
        List<Map<String, Object>> employeeList = this.listBatchEmployeeByPerson(personIds, null, "hrpi_empentrel");
        if (CollectionUtils.isEmpty(employeeList)) {
            return new ArrayList<Long>();
        }
        for (Map<String, Object> employee : employeeList) {
            if (Long.parseLong(employee.get("labrelstatusprd_id").toString()) != 1020L) continue;
            personQuit.add((Long)employee.get("person_id"));
        }
        return personQuit;
    }

    @Override
    public List<Map<String, Object>> listEmpposorgrels(long personId) {
        InvokeParam invokeParam = new InvokeParam("hrmp", "hrpi", "IHRPIPersonService", "listEmpposorgrels");
        List empposorgrels = (List)InvokeHandler.getInstance().invokeService(invokeParam, personId);
        LOG.info("listEmpposorgrels personId:{}, result:{} ", (Object)personId, (Object)empposorgrels);
        return empposorgrels;
    }

    @Override
    public List<Map<String, Object>> listEmpposorgrels(String postType, List<Long> personIds) {
        InvokeParam invokeParam = new InvokeParam("hrmp", "hrpi", "IHRPIPersonService", "listEmpposorgrels");
        List empposorgrels = (List)InvokeHandler.getInstance().invokeService(invokeParam, postType, personIds);
        LOG.info("listEmpposorgrels postType:{}, personIds:{}, result:{} ", new Object[]{postType, personIds, empposorgrels});
        return empposorgrels;
    }

    @Override
    public Map<Long, Map<String, Object>> listEmployeePositionOrgRelationsMapByPersonId(List<Long> personIds) {
        List<Map<String, Object>> maps = this.listEmpposorgrels("1010_S", personIds);
        return maps.stream().collect(Collectors.toMap(map -> {
            Object personIdObj = map.get("person_id");
            if (personIdObj instanceof String) {
                return Long.parseLong(String.valueOf(personIdObj));
            }
            return (Long)personIdObj;
        }, mm -> mm, (v1, v2) -> v1));
    }

    @Override
    public Map<String, Object> saveBatch(Map<String, Object> paramMap) {
        InvokeParam invokeParam = new InvokeParam("hrmp", "hrpi", "IHRPIPersonGenericService", "saveBatch");
        Map saveResult = (Map)InvokeHandler.getInstance().invokeService(invokeParam, paramMap);
        return saveResult;
    }

    @Override
    public List<Map<String, Object>> listBatchPropPersonAttachs(List<Long> personIds, String selectProps, QFilter qFilter, String attachEntityName) {
        InvokeParam invokeParam = new InvokeParam("hrmp", "hrpi", "IHRPIPersonService", "listBatchPropPersonAttachs");
        List batchPropPersonAttachs = (List)InvokeHandler.getInstance().invokeService(invokeParam, personIds, selectProps, qFilter, attachEntityName);
        return batchPropPersonAttachs;
    }

    @Override
    public Map<String, Object> getPersonBaseInfo(long personId) {
        InvokeParam invokeParam = new InvokeParam("hrmp", "hrpi", "IHRPIPersonService", "getPersonBaseInfo");
        return (Map)InvokeHandler.getInstance().invokeService(invokeParam, personId);
    }

    @Override
    public Map<String, Object> getPrimaryEmpposorgrel(Long personId) {
        InvokeParam invokeParam = new InvokeParam("hrmp", "hrpi", "IHRPIPersonService", "getPrimaryEmpposorgrel");
        return (Map)InvokeHandler.getInstance().invokeService(invokeParam, personId);
    }

    @Override
    public List<Map<String, Object>> listPersonInfos(List<Long> personIds) {
        InvokeParam invokeParam = new InvokeParam("hrmp", "hrpi", "IHRPIPersonService", "listPersonInfos");
        return (List)InvokeHandler.getInstance().invokeService(invokeParam, personIds);
    }

    @Override
    public Map<String, Object> getEmpOrgrel(long depempId) {
        InvokeParam invokeParam = new InvokeParam("hrmp", "hrpi", "IHRPIDepempService", "getEmpOrgrel");
        return (Map)InvokeHandler.getInstance().invokeService(invokeParam, depempId);
    }

    @Override
    public DynamicObject[] listInfoById(List<Long> ids, String entityName) {
        InvokeParam invokeParam = new InvokeParam("hrmp", "hrpi", "IHRPIPersonSyncService", "listInfoById");
        return (DynamicObject[])InvokeHandler.getInstance().invokeService(invokeParam, ids, entityName);
    }

    @Override
    public DynamicObject[] listPersonByNumber(Collection<String> numbers) {
        QFilter qFilter = new QFilter("number", "in", numbers);
        HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hrpi_person");
        QFilter curVersion = new QFilter("iscurrentversion", "=", (Object)"1");
        return personHelper.queryOriginalArray("id,number,name", new QFilter[]{qFilter, curVersion});
    }

    @Override
    public Map<String, DynamicObject> personMapByNumber(Collection<String> numbers) {
        DynamicObject[] ermanFileInfoArr = PTMMServiceFactory.hspmService.listPrimaryErmanFilesByEmpnumber(new ArrayList<String>(numbers));
        Set personIds = Arrays.stream(ermanFileInfoArr).map(employeeInfo -> employeeInfo.getLong("person.id")).collect(Collectors.toSet());
        HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hrpi_person");
        QFilter qf = new QFilter("boid", "in", personIds);
        qf.and("iscurrentversion", "=", (Object)"1");
        qf.and("datastatus", "=", (Object)"1");
        qf.and("initstatus", "=", (Object)"2");
        DynamicObject[] personInfoArr = personHelper.loadDynamicObjectArray(new QFilter[]{qf});
        return Arrays.stream(personInfoArr).collect(Collectors.toMap(obj -> obj.getString("number"), Function.identity(), (v1, v2) -> v1));
    }

    @Override
    public DynamicObject[] listFieldsFilterInfo(String selectFields, QFilter custFilter, String entityName) {
        InvokeParam invokeParam = new InvokeParam("hrmp", "hrpi", "IHRPIPersonSyncService", "listFieldsFilterInfo");
        return (DynamicObject[])InvokeHandler.getInstance().invokeService(invokeParam, selectFields, custFilter, entityName);
    }
}

