/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.domain.service.impl.common;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hbp.common.model.AuthorizedOrgTeamResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.ptmm.business.domain.impt.bo.ImportDataValidateBO;
import kd.hr.ptmm.business.domain.service.common.IPTMMImportDoValidateService;
import kd.hr.ptmm.business.domain.status.dto.ValidateMsg;
import kd.hr.ptmm.common.KdPredicate;

public class PTMMImportDoValidateServiceImpl
implements IPTMMImportDoValidateService {
    @Override
    public void addCheck(AuthorizedOrgTeamResult permResult, Map<String, Long> teamNum2Ids, Map<String, String> teamNum2Pros, Map<String, DynamicObject> personMapByNumber, Map<String, DynamicObject> projectRoleMapByNumber, Map<String, DynamicObject> adjustReasonMapByNumber, ImportDataValidateBO param, JSONObject join) {
        ArrayList<ValidateMsg> checkMsgs = new ArrayList<ValidateMsg>();
        KdPredicate<JSONObject> perExistPredicate = this.getPerExistPredicate(personMapByNumber, join, checkMsgs, "personnumber", "personfield", "add_3");
        JSONObject team = join.getJSONObject("projectteamadd");
        KdPredicate<JSONObject> teamExistPredicate = this.getTeamExistPredicate(teamNum2Ids, team, checkMsgs, "add_4", 4L, ResManager.loadKDString((String)"\u9879\u76ee\u56e2\u961f\u4e0d\u5b58\u5728", (String)"PTMMImportValidateServiceImpl_0", (String)"hr-ptmm-business", (Object[])new Object[0]));
        KdPredicate<JSONObject> teamPermitPredicate = this.getTeamPermitPredicate(permResult, teamNum2Ids, checkMsgs, team, "add_5", 5L, ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u9650\u4e3a\u9879\u76ee\u56e2\u961f\u7ef4\u62a4\u6210\u5458", (String)"PTMMImportValidateServiceImpl_1", (String)"hr-ptmm-business", (Object[])new Object[0]));
        KdPredicate<JSONObject> teamProPredicate = this.getTeamProPredicate(teamNum2Pros, param, checkMsgs, team, "add_6", 6L, ResManager.loadKDString((String)"\u9879\u76ee\u56e2\u961f\u4e0d\u662f\u5355\u636e\u6240\u5c5e\u9879\u76ee\u8303\u56f4\u4e0b\u56e2\u961f", (String)"PTMMImportValidateServiceImpl_3", (String)"hr-ptmm-business", (Object[])new Object[0]));
        KdPredicate<JSONObject> roleExistPredicate = this.getRoleExistPredicate(teamNum2Ids, projectRoleMapByNumber, join, checkMsgs, team, "projectrole", "add_8", 8L, ResManager.loadKDString((String)"\u9879\u76ee\u89d2\u8272\u4e0d\u5b58\u5728", (String)"PTMMImportValidateServiceImpl_4", (String)"hr-ptmm-business", (Object[])new Object[0]));
        KdPredicate<JSONObject> otherRoleExistPredicate = this.getOtherRoleExistPredicate(teamNum2Ids, projectRoleMapByNumber, join, checkMsgs, team);
        KdPredicate<JSONObject> otherRoleRepeatPredicate = this.getOtherRoleRepeatPredicate(join, checkMsgs);
        KdPredicate<JSONObject> otherRoleRepeatLinePredicate = this.getOtherRoleRepeatLinePredicate(join, checkMsgs);
        KdPredicate<JSONObject> reasonExistPredicate = this.getReasonExistPredicate(adjustReasonMapByNumber, join, checkMsgs, "adjustreason", "1010", "add_13", 13L);
        KdPredicate<JSONObject> reasonEnablePredicate = this.getReasonEnablePredicate(adjustReasonMapByNumber, join, checkMsgs, "adjustreason", "add_14", 14L);
        KdPredicate teamRoleLink = teamExistPredicate.and(teamPermitPredicate).and(teamProPredicate).and(roleExistPredicate).and(otherRoleExistPredicate);
        KdPredicate reasonLink = reasonExistPredicate.and(reasonEnablePredicate);
        perExistPredicate.link((Predicate)teamRoleLink).link(otherRoleRepeatPredicate).link(otherRoleRepeatLinePredicate).link((Predicate)reasonLink).test((Object)join);
        param.setValidateMsgList(checkMsgs);
    }

    @Override
    public void exitCheck(AuthorizedOrgTeamResult permResult, Map<String, Long> teamNum2Ids, Map<String, String> teamNum2Pros, Map<String, DynamicObject> personMapByNumber, Map<String, DynamicObject> projectRoleMapByNumber, Map<String, DynamicObject> adjustReasonMapByNumber, ImportDataValidateBO param, JSONObject exit, Map<String, List<DynamicObject>> teamMemMapByTeamNum) {
        ArrayList<ValidateMsg> checkMsgs = new ArrayList<ValidateMsg>();
        KdPredicate<JSONObject> perExistPredicate = this.getPerExistPredicate(personMapByNumber, exit, checkMsgs, "numberq", "nameq", "exit_3");
        JSONObject team = exit.getJSONObject("projectteamq");
        KdPredicate<JSONObject> teamExistPredicate = this.getTeamExistPredicate(teamNum2Ids, team, checkMsgs, "exit_4", 4L, ResManager.loadKDString((String)"\u9879\u76ee\u56e2\u961f\u4e0d\u5b58\u5728", (String)"PTMMImportValidateServiceImpl_0", (String)"hr-ptmm-business", (Object[])new Object[0]));
        KdPredicate<JSONObject> teamPermitPredicate = this.getTeamPermitPredicate(permResult, teamNum2Ids, checkMsgs, team, "exit_5", 5L, ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u9650\u4e3a\u9879\u76ee\u56e2\u961f\u7ef4\u62a4\u6210\u5458", (String)"PTMMImportValidateServiceImpl_1", (String)"hr-ptmm-business", (Object[])new Object[0]));
        KdPredicate<JSONObject> teamProPredicate = this.getTeamProPredicate(teamNum2Pros, param, checkMsgs, team, "exit_6", 6L, ResManager.loadKDString((String)"\u9879\u76ee\u56e2\u961f\u4e0d\u662f\u5355\u636e\u6240\u5c5e\u9879\u76ee\u8303\u56f4\u4e0b\u56e2\u961f", (String)"PTMMImportValidateServiceImpl_3", (String)"hr-ptmm-business", (Object[])new Object[0]));
        KdPredicate<JSONObject> teamMemPredicate = this.getTeamMemPredicate(exit, teamMemMapByTeamNum, checkMsgs, team, "numberq", "nameq", "exit_7");
        KdPredicate<JSONObject> reasonExistPredicate = this.getReasonExistPredicate(adjustReasonMapByNumber, exit, checkMsgs, "adjustreasonq", "1030", "exit_13", 13L);
        KdPredicate<JSONObject> reasonEnablePredicate = this.getReasonEnablePredicate(adjustReasonMapByNumber, exit, checkMsgs, "adjustreasonq", "exit_14", 14L);
        KdPredicate teamMemLink = teamExistPredicate.and(teamPermitPredicate).and(teamProPredicate).and(teamMemPredicate);
        KdPredicate reasonLink = reasonExistPredicate.and(reasonEnablePredicate);
        perExistPredicate.link((Predicate)teamMemLink).link((Predicate)reasonLink).test((Object)exit);
        param.setValidateMsgList(checkMsgs);
    }

    @Override
    public void roleJoinCheck(AuthorizedOrgTeamResult permResult, Map<String, Long> teamNum2Ids, Map<String, String> teamNum2Pros, Map<String, DynamicObject> personMapByNumber, Map<String, DynamicObject> projectRoleMapByNumber, Map<String, DynamicObject> adjustReasonMapByNumber, ImportDataValidateBO param, JSONObject roleJoin, Map<String, List<DynamicObject>> teamMemMapByTeamNum) {
        ArrayList<ValidateMsg> checkMsgs = new ArrayList<ValidateMsg>();
        KdPredicate<JSONObject> perExistPredicate = this.getPerExistPredicate(personMapByNumber, roleJoin, checkMsgs, "numberadja", "personbaseadja", "roleJoin_3");
        JSONObject team = roleJoin.getJSONObject("projectteamadja");
        KdPredicate<JSONObject> teamExistPredicate = this.getTeamExistPredicate(teamNum2Ids, team, checkMsgs, "roleJoin_4", 4L, ResManager.loadKDString((String)"\u9879\u76ee\u56e2\u961f\u4e0d\u5b58\u5728", (String)"PTMMImportValidateServiceImpl_0", (String)"hr-ptmm-business", (Object[])new Object[0]));
        KdPredicate<JSONObject> teamPermitPredicate = this.getTeamPermitPredicate(permResult, teamNum2Ids, checkMsgs, team, "roleJoin_5", 5L, ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u9650\u4e3a\u9879\u76ee\u56e2\u961f\u7ef4\u62a4\u6210\u5458", (String)"PTMMImportValidateServiceImpl_1", (String)"hr-ptmm-business", (Object[])new Object[0]));
        KdPredicate<JSONObject> teamProPredicate = this.getTeamProPredicate(teamNum2Pros, param, checkMsgs, team, "roleJoin_6", 6L, ResManager.loadKDString((String)"\u9879\u76ee\u56e2\u961f\u4e0d\u662f\u5355\u636e\u6240\u5c5e\u9879\u76ee\u8303\u56f4\u4e0b\u56e2\u961f", (String)"PTMMImportValidateServiceImpl_3", (String)"hr-ptmm-business", (Object[])new Object[0]));
        KdPredicate<JSONObject> teamMemPredicate = this.getTeamMemPredicate(roleJoin, teamMemMapByTeamNum, checkMsgs, team, "numberadja", "personbaseadja", "roleJoin_7");
        KdPredicate<JSONObject> roleExistPredicate = this.getRoleExistPredicate(teamNum2Ids, projectRoleMapByNumber, roleJoin, checkMsgs, team, "projectroleadja", "add_8", 8L, ResManager.loadKDString((String)"\u9879\u76ee\u89d2\u8272\u4e0d\u5b58\u5728", (String)"PTMMImportValidateServiceImpl_4", (String)"hr-ptmm-business", (Object[])new Object[0]));
        KdPredicate<JSONObject> reasonExistPredicate = this.getReasonExistPredicate(adjustReasonMapByNumber, roleJoin, checkMsgs, "adjustreasonadja", "1020", "roleJoin_13", 13L);
        KdPredicate<JSONObject> reasonEnablePredicate = this.getReasonEnablePredicate(adjustReasonMapByNumber, roleJoin, checkMsgs, "adjustreasonadja", "roleJoin_14", 14L);
        KdPredicate teamMemRoleLink = teamExistPredicate.and(teamPermitPredicate).and(teamProPredicate).and(teamMemPredicate).and(roleExistPredicate);
        KdPredicate reasonLink = reasonExistPredicate.and(reasonEnablePredicate);
        perExistPredicate.link((Predicate)teamMemRoleLink).link((Predicate)reasonLink).test((Object)roleJoin);
        param.setValidateMsgList(checkMsgs);
    }

    @Override
    public void roleAdjustCheck(AuthorizedOrgTeamResult permResult, Map<String, Long> teamNum2Ids, Map<String, String> teamNum2Pros, Map<String, DynamicObject> personMapByNumber, Map<String, DynamicObject> projectRoleMapByNumber, Map<String, DynamicObject> adjustReasonMapByNumber, ImportDataValidateBO param, JSONObject roleAdjust, Map<String, List<DynamicObject>> teamRoleMapByTeamNum) {
        ArrayList<ValidateMsg> checkMsgs = new ArrayList<ValidateMsg>();
        KdPredicate<JSONObject> perExistPredicate = this.getPerExistPredicate(personMapByNumber, roleAdjust, checkMsgs, "numberadj", "personbaseadj", "roleAdjust_3");
        JSONObject teamBefore = roleAdjust.getJSONObject("projectteamadj");
        KdPredicate<JSONObject> teamExistPredicateBefore = this.getTeamExistPredicate(teamNum2Ids, teamBefore, checkMsgs, "roleAdjust_4", 4L, ResManager.loadKDString((String)"\u8c03\u6574\u524d\u9879\u76ee\u56e2\u961f\u4e0d\u5b58\u5728", (String)"PTMMImportValidateServiceImpl_13", (String)"hr-ptmm-business", (Object[])new Object[0]));
        KdPredicate<JSONObject> teamPermitPredicateBefore = this.getTeamPermitPredicate(permResult, teamNum2Ids, checkMsgs, teamBefore, "roleAdjust_5", 5L, ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u9650\u4e3a\u8c03\u6574\u524d\u9879\u76ee\u56e2\u961f\u7ef4\u62a4\u6210\u5458", (String)"PTMMImportValidateServiceImpl_17", (String)"hr-ptmm-business", (Object[])new Object[0]));
        KdPredicate<JSONObject> teamProPredicateBefore = this.getTeamProPredicate(teamNum2Pros, param, checkMsgs, teamBefore, "roleAdjust_6", 6L, ResManager.loadKDString((String)"\u8c03\u6574\u524d\u9879\u76ee\u56e2\u961f\u4e0d\u662f\u5355\u636e\u6240\u5c5e\u9879\u76ee\u8303\u56f4\u4e0b\u56e2\u961f", (String)"PTMMImportValidateServiceImpl_19", (String)"hr-ptmm-business", (Object[])new Object[0]));
        KdPredicate<JSONObject> teamMemRolePredicate = this.getTeamMemRolePredicate(projectRoleMapByNumber, roleAdjust, teamRoleMapByTeamNum, checkMsgs, teamBefore, "numberadj", "personbaseadj", "projectroleadj", "roleAdjust_9", ResManager.loadKDString((String)"\u6210\u5458\u65e0\u8be5\u8c03\u6574\u524d\u9879\u76ee\u89d2\u8272\u670d\u52a1\u4e2d\u4efb\u804c", (String)"PTMMImportValidateServiceImpl_11", (String)"hr-ptmm-business", (Object[])new Object[0]));
        JSONObject teamAfter = roleAdjust.getJSONObject("projectteamadjnew");
        KdPredicate<JSONObject> teamExistPredicateAfter = this.getTeamExistPredicate(teamNum2Ids, teamAfter, checkMsgs, "roleAdjust_13", 13L, ResManager.loadKDString((String)"\u8c03\u6574\u540e\u9879\u76ee\u56e2\u961f\u4e0d\u5b58\u5728", (String)"PTMMImportValidateServiceImpl_14", (String)"hr-ptmm-business", (Object[])new Object[0]));
        KdPredicate<JSONObject> teamPermitPredicateAfter = this.getTeamPermitPredicate(permResult, teamNum2Ids, checkMsgs, teamAfter, "roleAdjust_14", 14L, ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u9650\u4e3a\u8c03\u6574\u540e\u9879\u76ee\u56e2\u961f\u7ef4\u62a4\u6210\u5458", (String)"PTMMImportValidateServiceImpl_18", (String)"hr-ptmm-business", (Object[])new Object[0]));
        KdPredicate<JSONObject> teamProPredicateAfter = this.getTeamProPredicate(teamNum2Pros, param, checkMsgs, teamAfter, "roleAdjust_15", 15L, ResManager.loadKDString((String)"\u8c03\u6574\u540e\u9879\u76ee\u56e2\u961f\u4e0d\u662f\u5355\u636e\u6240\u5c5e\u9879\u76ee\u8303\u56f4\u4e0b\u56e2\u961f", (String)"PTMMImportValidateServiceImpl_20", (String)"hr-ptmm-business", (Object[])new Object[0]));
        KdPredicate<JSONObject> roleExistPredicateAfter = this.getRoleExistPredicate(teamNum2Ids, projectRoleMapByNumber, roleAdjust, checkMsgs, teamAfter, "projectroleadjnew", "add_16", 16L, ResManager.loadKDString((String)"\u8c03\u6574\u540e\u9879\u76ee\u89d2\u8272\u4e0d\u5b58\u5728", (String)"PTMMImportValidateServiceImpl_16", (String)"hr-ptmm-business", (Object[])new Object[0]));
        KdPredicate<JSONObject> reasonExistPredicate = this.getReasonExistPredicate(adjustReasonMapByNumber, roleAdjust, checkMsgs, "adjustreasonadj", "1020", "roleAdjust_13", 18L);
        KdPredicate<JSONObject> reasonEnablePredicate = this.getReasonEnablePredicate(adjustReasonMapByNumber, roleAdjust, checkMsgs, "adjustreasonadj", "roleAdjust_14", 19L);
        KdPredicate teamMemRoleLinkBefore = teamExistPredicateBefore.and(teamPermitPredicateBefore).and(teamProPredicateBefore).and(teamMemRolePredicate);
        KdPredicate teamMemRoleLinkAfter = teamExistPredicateAfter.and(teamPermitPredicateAfter).and(teamProPredicateAfter).and(roleExistPredicateAfter);
        KdPredicate reasonLink = reasonExistPredicate.and(reasonEnablePredicate);
        perExistPredicate.link((Predicate)teamMemRoleLinkBefore).link((Predicate)teamMemRoleLinkAfter).link((Predicate)reasonLink).test((Object)roleAdjust);
        param.setValidateMsgList(checkMsgs);
    }

    @Override
    public void roleQuitCheck(AuthorizedOrgTeamResult permResult, Map<String, Long> teamNum2Ids, Map<String, String> teamNum2Pros, Map<String, DynamicObject> personMapByNumber, Map<String, DynamicObject> projectRoleMapByNumber, Map<String, DynamicObject> adjustReasonMapByNumber, ImportDataValidateBO param, JSONObject roleQuit, Map<String, List<DynamicObject>> teamRoleMapByTeamNum) {
        ArrayList<ValidateMsg> checkMsgs = new ArrayList<ValidateMsg>();
        KdPredicate<JSONObject> perExistPredicate = this.getPerExistPredicate(personMapByNumber, roleQuit, checkMsgs, "numberadjq", "nameadjq", "roleQuit_3");
        JSONObject team = roleQuit.getJSONObject("projectteamadjq");
        KdPredicate<JSONObject> teamExistPredicate = this.getTeamExistPredicate(teamNum2Ids, team, checkMsgs, "roleQuit_4", 4L, ResManager.loadKDString((String)"\u9879\u76ee\u56e2\u961f\u4e0d\u5b58\u5728", (String)"PTMMImportValidateServiceImpl_0", (String)"hr-ptmm-business", (Object[])new Object[0]));
        KdPredicate<JSONObject> teamPermitPredicate = this.getTeamPermitPredicate(permResult, teamNum2Ids, checkMsgs, team, "roleQuit_5", 5L, ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u9650\u4e3a\u9879\u76ee\u56e2\u961f\u7ef4\u62a4\u6210\u5458", (String)"PTMMImportValidateServiceImpl_1", (String)"hr-ptmm-business", (Object[])new Object[0]));
        KdPredicate<JSONObject> teamProPredicate = this.getTeamProPredicate(teamNum2Pros, param, checkMsgs, team, "roleQuit_6", 6L, ResManager.loadKDString((String)"\u9879\u76ee\u56e2\u961f\u4e0d\u662f\u5355\u636e\u6240\u5c5e\u9879\u76ee\u8303\u56f4\u4e0b\u56e2\u961f", (String)"PTMMImportValidateServiceImpl_3", (String)"hr-ptmm-business", (Object[])new Object[0]));
        KdPredicate<JSONObject> roleExistPredicate = this.getRoleExistPredicate(teamNum2Ids, projectRoleMapByNumber, roleQuit, checkMsgs, team, "projectroleadjq", "add_8", 8L, ResManager.loadKDString((String)"\u9879\u76ee\u89d2\u8272\u4e0d\u5b58\u5728", (String)"PTMMImportValidateServiceImpl_4", (String)"hr-ptmm-business", (Object[])new Object[0]));
        KdPredicate<JSONObject> teamMemRolePredicate = this.getTeamMemRolePredicate(projectRoleMapByNumber, roleQuit, teamRoleMapByTeamNum, checkMsgs, team, "numberadjq", "nameadjq", "projectroleadjq", "roleQuit_9", ResManager.loadKDString((String)"\u6210\u5458\u65e0\u8be5\u9879\u76ee\u89d2\u8272\u670d\u52a1\u4e2d\u4efb\u804c", (String)"PTMMImportValidateServiceImpl_12", (String)"hr-ptmm-business", (Object[])new Object[0]));
        KdPredicate<JSONObject> reasonExistPredicate = this.getReasonExistPredicate(adjustReasonMapByNumber, roleQuit, checkMsgs, "adjustreasonadjq", "1020", "roleQuit_13", 13L);
        KdPredicate<JSONObject> reasonEnablePredicate = this.getReasonEnablePredicate(adjustReasonMapByNumber, roleQuit, checkMsgs, "adjustreasonadjq", "roleQuit_14", 14L);
        KdPredicate teamMemRoleLinkBefore = teamExistPredicate.and(teamPermitPredicate).and(teamProPredicate).and(roleExistPredicate).and(teamMemRolePredicate);
        KdPredicate reasonLink = reasonExistPredicate.and(reasonEnablePredicate);
        perExistPredicate.link((Predicate)teamMemRoleLinkBefore).link((Predicate)reasonLink).test((Object)roleQuit);
        param.setValidateMsgList(checkMsgs);
    }

    private KdPredicate<JSONObject> getTeamMemPredicate(JSONObject lineData, Map<String, List<DynamicObject>> teamMemMapByTeamNum, List<ValidateMsg> checkMsgs, JSONObject team, String perNumKey, String perNameKey, String msgCodeKey) {
        return temp -> {
            String teamNumber = team.getString("number");
            String perNum = lineData.getString(perNumKey);
            String perName = lineData.getString(perNameKey);
            if (teamMemMapByTeamNum.containsKey(teamNumber)) {
                List teamMems = (List)teamMemMapByTeamNum.get(teamNumber);
                for (DynamicObject teamMem : teamMems) {
                    DynamicObject per = teamMem.getDynamicObject("person");
                    if (!HRStringUtils.equals((String)perNum, (String)per.getString("number")) || !HRStringUtils.equals((String)perName, (String)per.getString("name"))) continue;
                    return true;
                }
            }
            ValidateMsg msg = new ValidateMsg();
            msg.setMsgCode(msgCodeKey);
            msg.setMsgIndex(7L);
            msg.setMsgInfo(ResManager.loadKDString((String)"\u6210\u5458\u65e0\u5f53\u524d\u56e2\u961f\u670d\u52a1\u4e2d\u4efb\u804c", (String)"PTMMImportValidateServiceImpl_10", (String)"hr-ptmm-business", (Object[])new Object[0]));
            checkMsgs.add(msg);
            return false;
        };
    }

    private KdPredicate<JSONObject> getOtherRoleRepeatLinePredicate(JSONObject lineData, List<ValidateMsg> checkMsgs) {
        KdPredicate otherRoleRepeatLinePredicate = temp -> {
            if (Objects.isNull(lineData.getJSONObject("projectroleother"))) {
                return true;
            }
            String otherRoleNums = lineData.getJSONObject("projectroleother").getString("number");
            if (HRStringUtils.isEmpty((String)otherRoleNums)) {
                return true;
            }
            String[] otherRoleNumArr = otherRoleNums.split(",");
            Set otherRoleNumSet = Arrays.stream(otherRoleNumArr).collect(Collectors.toSet());
            if (otherRoleNumSet.size() != otherRoleNumArr.length) {
                ValidateMsg msg = new ValidateMsg();
                msg.setMsgCode("add_11");
                msg.setMsgIndex(11L);
                msg.setMsgInfo(ResManager.loadKDString((String)"\u5176\u4ed6\u89d2\u8272\u4e0e\u672c\u884c\u5176\u4ed6\u89d2\u8272\u91cd\u590d", (String)"PTMMImportValidateServiceImpl_7", (String)"hr-ptmm-business", (Object[])new Object[0]));
                checkMsgs.add(msg);
                return false;
            }
            return true;
        };
        return otherRoleRepeatLinePredicate;
    }

    private KdPredicate<JSONObject> getOtherRoleRepeatPredicate(JSONObject lineData, List<ValidateMsg> checkMsgs) {
        KdPredicate otherRoleRepeatPredicate = temp -> {
            if (Objects.isNull(lineData.getJSONObject("projectrole"))) {
                return false;
            }
            String proRoleNumber = lineData.getJSONObject("projectrole").getString("number");
            if (Objects.isNull(lineData.getJSONObject("projectroleother"))) {
                return true;
            }
            String otherRoleNums = lineData.getJSONObject("projectroleother").getString("number");
            if (HRStringUtils.isEmpty((String)otherRoleNums)) {
                return true;
            }
            String[] otherRoleNumArr = otherRoleNums.split(",");
            for (int i = 0; i < otherRoleNumArr.length; ++i) {
                if (!HRStringUtils.equals((String)otherRoleNumArr[i], (String)proRoleNumber)) continue;
                ValidateMsg msg = new ValidateMsg();
                msg.setMsgCode("add_10");
                msg.setMsgIndex(10L);
                msg.setMsgInfo(ResManager.loadKDString((String)"\u5176\u4ed6\u89d2\u8272\u4e0e\u672c\u884c\u9879\u76ee\u89d2\u8272\u91cd\u590d", (String)"PTMMImportValidateServiceImpl_6", (String)"hr-ptmm-business", (Object[])new Object[0]));
                checkMsgs.add(msg);
                return false;
            }
            return true;
        };
        return otherRoleRepeatPredicate;
    }

    private KdPredicate<JSONObject> getOtherRoleExistPredicate(Map<String, Long> teamNum2Ids, Map<String, DynamicObject> projectRoleMapByNumber, JSONObject lineData, List<ValidateMsg> checkMsgs, JSONObject team) {
        KdPredicate otherRoleExistPredicate = temp -> {
            boolean isSucc = true;
            if (Objects.isNull(team)) {
                return false;
            }
            String teamNumber = team.getString("number");
            if (Objects.isNull(lineData.getJSONObject("projectroleother"))) {
                return true;
            }
            String otherRoleNums = lineData.getJSONObject("projectroleother").getString("number");
            if (HRStringUtils.isEmpty((String)otherRoleNums)) {
                return true;
            }
            String[] otherRoleNumArr = otherRoleNums.split(",");
            for (int i = 0; i < otherRoleNumArr.length; ++i) {
                boolean isOtherRoleExist;
                String otherRoleNum = otherRoleNumArr[i];
                boolean bl = isOtherRoleExist = !projectRoleMapByNumber.containsKey(otherRoleNum) || projectRoleMapByNumber.containsKey(otherRoleNum) && !HRStringUtils.equals((String)((DynamicObject)projectRoleMapByNumber.get(otherRoleNum)).getString("adminorg.id"), (String)((Long)teamNum2Ids.get(teamNumber)).toString());
                if (!isOtherRoleExist) continue;
                ValidateMsg msg = new ValidateMsg();
                msg.setMsgCode("add_9");
                msg.setMsgIndex(9L);
                msg.setMsgInfo(ResManager.loadKDString((String)"\u5176\u4ed6\u89d2\u8272\u4e0d\u5b58\u5728", (String)"PTMMImportValidateServiceImpl_5", (String)"hr-ptmm-business", (Object[])new Object[0]));
                checkMsgs.add(msg);
                isSucc = false;
                return isSucc;
            }
            return isSucc;
        };
        return otherRoleExistPredicate;
    }

    private KdPredicate<JSONObject> getRoleExistPredicate(Map<String, Long> teamNum2Ids, Map<String, DynamicObject> projectRoleMapByNumber, JSONObject lineData, List<ValidateMsg> checkMsgs, JSONObject team, String projectRoleKey, String msgCode, long msgIndex, String msgInfo) {
        return temp -> {
            boolean isRoleExist;
            String teamNumber = team.getString("number");
            if (Objects.isNull(lineData.getJSONObject(projectRoleKey))) {
                return false;
            }
            String proRoleNumber = lineData.getJSONObject(projectRoleKey).getString("number");
            boolean bl = isRoleExist = !projectRoleMapByNumber.containsKey(proRoleNumber) || projectRoleMapByNumber.containsKey(proRoleNumber) && !HRStringUtils.equals((String)((DynamicObject)projectRoleMapByNumber.get(proRoleNumber)).getString("adminorg.id"), (String)((Long)teamNum2Ids.get(teamNumber)).toString());
            if (isRoleExist) {
                ValidateMsg msg = new ValidateMsg();
                msg.setMsgCode(msgCode);
                msg.setMsgIndex(msgIndex);
                msg.setMsgInfo(msgInfo);
                checkMsgs.add(msg);
                return false;
            }
            return true;
        };
    }

    private KdPredicate<JSONObject> getTeamMemRolePredicate(Map<String, DynamicObject> projectRoleMapByNumber, JSONObject lineData, Map<String, List<DynamicObject>> teamRoleMapByTeamNum, List<ValidateMsg> checkMsgs, JSONObject team, String perNumKey, String perNameKey, String projectRoleKey, String msgCode, String msgInfo) {
        return temp -> {
            String teamNumber = team.getString("number");
            String perNum = lineData.getString(perNumKey);
            String perName = lineData.getString(perNameKey);
            String roleNumBefore = lineData.getJSONObject(projectRoleKey).getString("number");
            DynamicObject workRole = (DynamicObject)projectRoleMapByNumber.get(roleNumBefore);
            if (Objects.isNull(workRole)) {
                ValidateMsg msg = new ValidateMsg();
                msg.setMsgCode(msgCode);
                msg.setMsgIndex(9L);
                msg.setMsgInfo(msgInfo);
                checkMsgs.add(msg);
                return false;
            }
            if (teamRoleMapByTeamNum.containsKey(teamNumber)) {
                List teamRoles = (List)teamRoleMapByTeamNum.get(teamNumber);
                for (DynamicObject teamRole : teamRoles) {
                    DynamicObject per = teamRole.getDynamicObject("person");
                    DynamicObject role = teamRole.getDynamicObject("projectrole");
                    if (!HRStringUtils.equals((String)perNum, (String)per.getString("number")) || !HRStringUtils.equals((String)perName, (String)per.getString("name")) || !HRStringUtils.equals((String)workRole.getString("number"), (String)role.getString("number"))) continue;
                    return true;
                }
            }
            ValidateMsg msg = new ValidateMsg();
            msg.setMsgCode(msgCode);
            msg.setMsgIndex(9L);
            msg.setMsgInfo(msgInfo);
            checkMsgs.add(msg);
            return false;
        };
    }

    private KdPredicate<JSONObject> getPerExistPredicate(Map<String, DynamicObject> personMapByNumber, JSONObject lineData, List<ValidateMsg> checkMsgs, String personNumber, String personField, String msgCode) {
        return temp -> {
            boolean isPerExist;
            String perNum = lineData.getString(personNumber);
            String perName = lineData.getString(personField);
            if (HRStringUtils.isEmpty((String)perNum) || HRStringUtils.isEmpty((String)perName)) {
                return false;
            }
            boolean bl = isPerExist = !personMapByNumber.containsKey(perNum) || personMapByNumber.containsKey(perNum) && !HRStringUtils.equals((String)((DynamicObject)personMapByNumber.get(perNum)).getString("name"), (String)perName);
            if (isPerExist) {
                ValidateMsg msg = new ValidateMsg();
                msg.setMsgCode(msgCode);
                msg.setMsgIndex(3L);
                msg.setMsgInfo(ResManager.loadKDString((String)"\u4eba\u5458\u4e0d\u5b58\u5728", (String)"PTMMImportValidateServiceImpl_2", (String)"hr-ptmm-business", (Object[])new Object[0]));
                checkMsgs.add(msg);
                return false;
            }
            return true;
        };
    }

    private KdPredicate<JSONObject> getTeamExistPredicate(Map<String, Long> teamNum2Ids, JSONObject team, List<ValidateMsg> checkMsgs, String msgCode, long msgIndex, String msgInfo) {
        return temp -> {
            String teamNumber;
            if (Objects.isNull(team)) {
                return false;
            }
            if (Objects.nonNull(team) && !teamNum2Ids.containsKey(teamNumber = team.getString("number"))) {
                ValidateMsg msg = new ValidateMsg();
                msg.setMsgCode(msgCode);
                msg.setMsgIndex(msgIndex);
                msg.setMsgInfo(msgInfo);
                checkMsgs.add(msg);
                return false;
            }
            return true;
        };
    }

    private KdPredicate<JSONObject> getTeamPermitPredicate(AuthorizedOrgTeamResult permResult, Map<String, Long> teamNum2Ids, List<ValidateMsg> checkMsgs, JSONObject team, String msgCode, long msgIndex, String msgInfo) {
        return temp -> {
            String teamNumber = team.getString("number");
            if (!permResult.isHasAllOrgPerm() && permResult.getHasPermOrgTeamMap().values().stream().findFirst().isPresent() && !((List)permResult.getHasPermOrgTeamMap().values().stream().findFirst().get()).contains(teamNum2Ids.get(teamNumber))) {
                ValidateMsg msg = new ValidateMsg();
                msg.setMsgCode(msgCode);
                msg.setMsgIndex(msgIndex);
                msg.setMsgInfo(msgInfo);
                checkMsgs.add(msg);
                return false;
            }
            return true;
        };
    }

    private KdPredicate<JSONObject> getTeamProPredicate(Map<String, String> teamNum2Pros, ImportDataValidateBO param, List<ValidateMsg> checkMsgs, JSONObject team, String msgCode, long msgIndex, String msgInfo) {
        return temp -> {
            String teamNumber = team.getString("number");
            if (!HRStringUtils.equals((String)((String)teamNum2Pros.get(teamNumber)), (String)param.getProjectIdentify())) {
                ValidateMsg msg = new ValidateMsg();
                msg.setMsgCode(msgCode);
                msg.setMsgIndex(msgIndex);
                msg.setMsgInfo(msgInfo);
                checkMsgs.add(msg);
                return false;
            }
            return true;
        };
    }

    private KdPredicate<JSONObject> getReasonExistPredicate(Map<String, DynamicObject> adjustReasonMapByNumber, JSONObject lineData, List<ValidateMsg> checkMsgs, String adjustReasonKey, String group, String msgCode, long msgIndex) {
        return temp -> {
            if (Objects.isNull(lineData.getJSONObject(adjustReasonKey))) {
                return false;
            }
            String reasonNum = lineData.getJSONObject(adjustReasonKey).getString("number");
            if (HRStringUtils.isNotEmpty((String)reasonNum)) {
                boolean isAdjustResExist;
                boolean bl = isAdjustResExist = !adjustReasonMapByNumber.containsKey(reasonNum) || adjustReasonMapByNumber.containsKey(reasonNum) && !HRStringUtils.equals((String)((DynamicObject)adjustReasonMapByNumber.get(reasonNum)).getString("group"), (String)group);
                if (isAdjustResExist) {
                    ValidateMsg msg = new ValidateMsg();
                    msg.setMsgCode(msgCode);
                    msg.setMsgIndex(msgIndex);
                    msg.setMsgInfo(ResManager.loadKDString((String)"\u8c03\u6574\u539f\u56e0\u4e0d\u5b58\u5728", (String)"PTMMImportValidateServiceImpl_8", (String)"hr-ptmm-business", (Object[])new Object[0]));
                    checkMsgs.add(msg);
                    return false;
                }
            }
            return true;
        };
    }

    private KdPredicate<JSONObject> getReasonEnablePredicate(Map<String, DynamicObject> adjustReasonMapByNumber, JSONObject lineData, List<ValidateMsg> checkMsgs, String adjustReasonKey, String msgCode, long msgIndex) {
        return temp -> {
            String reasonNum = lineData.getJSONObject(adjustReasonKey).getString("number");
            if (HRStringUtils.isNotEmpty((String)reasonNum) && !HRStringUtils.equals((String)((DynamicObject)adjustReasonMapByNumber.get(reasonNum)).getString("enable"), (String)"1")) {
                ValidateMsg msg = new ValidateMsg();
                msg.setMsgCode(msgCode);
                msg.setMsgIndex(msgIndex);
                msg.setMsgInfo(ResManager.loadKDString((String)"\u8c03\u6574\u539f\u56e0\u5df2\u7981\u7528", (String)"PTMMImportValidateServiceImpl_9", (String)"hr-ptmm-business", (Object[])new Object[0]));
                checkMsgs.add(msg);
                return false;
            }
            return true;
        };
    }
}

