/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.domain.service.impl.common;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgTeamResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.ptmm.business.domain.impt.bo.ImportDataValidateBO;
import kd.hr.ptmm.business.domain.repository.TeamMemberRepository;
import kd.hr.ptmm.business.domain.repository.TeamMemberRoleRepository;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.business.domain.service.common.IPTMMImportValidateService;
import kd.hr.ptmm.business.domain.service.impl.common.PTMMImportDoValidateServiceImpl;
import kd.hr.ptmm.business.domain.service.impl.common.PTMMImportValidateServiceImplEx;
import kd.hr.ptmm.business.domain.service.impl.common.PtmmMultiSheetUtils;
import kd.hr.ptmm.business.domain.status.dto.ValidateMsg;
import kd.hr.ptmm.common.enums.AdjustTypeEnum;

public class PTMMImportValidateServiceImpl
implements IPTMMImportValidateService {
    private static final Log LOGGER = LogFactory.getLog(PTMMImportValidateServiceImpl.class);
    private PTMMImportDoValidateServiceImpl importDoValidateService = new PTMMImportDoValidateServiceImpl();
    private final TeamMemberRepository teamMemberRepository = TeamMemberRepository.getInstance();
    private final TeamMemberRoleRepository teamMemberRoleRepository = TeamMemberRoleRepository.getInstance();

    @Override
    public List<ImportDataValidateBO> projectMembersImportValidate(List<ImportDataValidateBO> validateParams, Map<String, DynamicObject> proRole2WorkRoles) {
        HashSet teamNumberSets = Sets.newHashSetWithExpectedSize((int)16);
        HashSet memTeamNumberSets = Sets.newHashSetWithExpectedSize((int)16);
        HashSet roleTeamNumberSets = Sets.newHashSetWithExpectedSize((int)16);
        HashSet perNumSets = Sets.newHashSetWithExpectedSize((int)16);
        this.collectDataForExcel(validateParams, teamNumberSets, memTeamNumberSets, roleTeamNumberSets, perNumSets);
        QFilter isCurrentVersQFilte = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObjectCollection projectTeams = QueryServiceHelper.query((String)"haos_projteambaseinfo", (String)"id,number,projectname", (QFilter[])new QFilter[]{isCurrentVersQFilte, new QFilter("number", "in", (Object)teamNumberSets)});
        HashMap teamNum2Ids = Maps.newHashMapWithExpectedSize((int)16);
        HashMap teamNum2Pros = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList teamIds = Lists.newArrayListWithExpectedSize((int)16);
        projectTeams.stream().forEach(projectTeam -> teamIds.add(projectTeam.getLong("id")));
        Map<Long, String> projectIdentify = PTMMServiceFactory.projectTeamService.listProjectTeamProjectIdentify(teamIds);
        projectTeams.stream().forEach(projectTeam -> {
            teamNum2Ids.put(projectTeam.getString("number"), projectTeam.getLong("id"));
            teamNum2Pros.put(projectTeam.getString("number"), projectIdentify.get(projectTeam.getLong("id")));
        });
        Map<String, DynamicObject> personMapByNumber = PTMMServiceFactory.hrpiService.personMapByNumber(perNumSets);
        QFilter qFilter = new QFilter("number", "is not null", null);
        HRBaseServiceHelper reasonHelper = new HRBaseServiceHelper("ptmm_adjustreason");
        DynamicObject[] reasonDynamicObjects = reasonHelper.queryOriginalArray("id,number,group,enable", new QFilter[]{qFilter});
        Map<String, DynamicObject> adjustReasonMapByNumber = Arrays.stream(reasonDynamicObjects).collect(Collectors.toMap(obj -> obj.getString("number"), Function.identity(), (v1, v2) -> v1));
        HashSet memTeamIds = Sets.newHashSetWithExpectedSize((int)16);
        memTeamNumberSets.stream().forEach(teamNum -> {
            if (teamNum2Ids.containsKey(teamNum)) {
                memTeamIds.add(teamNum2Ids.get(teamNum));
            }
        });
        DynamicObject[] teamMemList = this.teamMemberRepository.listByTeamIds(memTeamIds);
        Map<String, List<DynamicObject>> teamMemMapByTeamNum = Arrays.stream(teamMemList).collect(Collectors.groupingBy(obj -> obj.getString("projectteam.number")));
        HashSet roleTeamIds = Sets.newHashSetWithExpectedSize((int)16);
        roleTeamNumberSets.stream().forEach(teamNum -> {
            if (teamNum2Ids.containsKey(teamNum)) {
                roleTeamIds.add(teamNum2Ids.get(teamNum));
            }
        });
        DynamicObject[] memRoleList = this.teamMemberRoleRepository.listByTeamIds(roleTeamIds);
        Map<String, List<DynamicObject>> teamRoleMapByTeamNum = Arrays.stream(memRoleList).collect(Collectors.groupingBy(obj -> obj.getString("projectteam.number")));
        Long userId = RequestContext.get().getCurrUserId();
        String permItemId = "47150e89000000ac";
        String appId = "217WYC/L9U7E";
        AuthorizedOrgTeamResult permResult = (AuthorizedOrgTeamResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedOrgTeamsF7", (Object[])new Object[]{userId, appId, "ptmm_teammemberbill", permItemId, "projectteam"});
        this.executeValidateCheck(validateParams, proRole2WorkRoles, teamNum2Ids, teamNum2Pros, personMapByNumber, adjustReasonMapByNumber, teamMemMapByTeamNum, teamRoleMapByTeamNum, permResult);
        PTMMImportValidateServiceImplEx.excelRowAndEntryRowCheck(validateParams, proRole2WorkRoles);
        return validateParams;
    }

    private void executeValidateCheck(List<ImportDataValidateBO> validateParams, Map<String, DynamicObject> proRole2WorkRoles, Map<String, Long> teamNum2Ids, Map<String, String> teamNum2Pros, Map<String, DynamicObject> personMapByNumber, Map<String, DynamicObject> adjustReasonMapByNumber, Map<String, List<DynamicObject>> teamMemMapByTeamNum, Map<String, List<DynamicObject>> teamRoleMapByTeamNum, AuthorizedOrgTeamResult permResult) {
        for (ImportDataValidateBO param : validateParams) {
            JSONObject data = param.getImportBillData().getData().getJSONObject("data");
            HashMap<String, Consumer<String>> checkMap = new HashMap<String, Consumer<String>>(8);
            checkMap.put(AdjustTypeEnum.MEMBER_JOIN.getCode(), key -> this.importDoValidateService.addCheck(permResult, teamNum2Ids, teamNum2Pros, personMapByNumber, proRole2WorkRoles, adjustReasonMapByNumber, param, PtmmMultiSheetUtils.getMemberJoinJson(data)));
            checkMap.put(AdjustTypeEnum.ROLE_JOIN.getCode(), key -> this.importDoValidateService.roleJoinCheck(permResult, teamNum2Ids, teamNum2Pros, personMapByNumber, proRole2WorkRoles, adjustReasonMapByNumber, param, data.getJSONObject("ptmm_entryrolejoin"), teamMemMapByTeamNum));
            checkMap.put(AdjustTypeEnum.ROLE_ADJUST.getCode(), key -> this.importDoValidateService.roleAdjustCheck(permResult, teamNum2Ids, teamNum2Pros, personMapByNumber, proRole2WorkRoles, adjustReasonMapByNumber, param, data.getJSONObject("ptmm_entryroleadjust"), teamRoleMapByTeamNum));
            checkMap.put(AdjustTypeEnum.ROLE_QUIT.getCode(), key -> this.importDoValidateService.roleQuitCheck(permResult, teamNum2Ids, teamNum2Pros, personMapByNumber, proRole2WorkRoles, adjustReasonMapByNumber, param, data.getJSONObject("ptmm_entryrolequit"), teamRoleMapByTeamNum));
            checkMap.put(AdjustTypeEnum.MEMBER_QUIT.getCode(), key -> this.importDoValidateService.exitCheck(permResult, teamNum2Ids, teamNum2Pros, personMapByNumber, proRole2WorkRoles, adjustReasonMapByNumber, param, data.getJSONObject("ptmm_entrymemberquit"), teamMemMapByTeamNum));
            try {
                ((Consumer)checkMap.get(param.getAdjustEntryEnum().getCode())).accept("");
            }
            catch (Exception e) {
                LOGGER.error("PTMMImportValidateServiceImpl executeValidateCheck error: ", (Throwable)e);
                ValidateMsg checkMsg = new ValidateMsg();
                checkMsg.setMsgCode("codeError");
                checkMsg.setMsgInfo(e.toString());
                param.getValidateMsgList().add(checkMsg);
            }
        }
    }

    private void collectDataForExcel(List<ImportDataValidateBO> validateParams, Set<String> teamNumberSets, Set<String> memTeamNumberSets, Set<String> roleTeamNumberSets, Set<String> perNumSets) {
        for (ImportDataValidateBO param : validateParams) {
            JSONObject data = param.getImportBillData().getData().getJSONObject("data");
            String teamNumber = "";
            String perNum = "";
            switch (param.getAdjustEntryEnum()) {
                case MEMBER_JOIN: {
                    JSONObject join = PtmmMultiSheetUtils.getMemberJoinJson(data);
                    perNum = join.getString("personnumber");
                    if (!Objects.nonNull(join.getJSONObject("projectteamadd"))) break;
                    teamNumber = join.getJSONObject("projectteamadd").getString("number");
                    break;
                }
                case ROLE_JOIN: {
                    JSONObject roleJoin = data.getJSONObject("ptmm_entryrolejoin");
                    perNum = roleJoin.getString("numberadja");
                    if (!Objects.nonNull(roleJoin.getJSONObject("projectteamadja")) || !HRStringUtils.isNotEmpty((String)(teamNumber = roleJoin.getJSONObject("projectteamadja").getString("number")))) break;
                    memTeamNumberSets.add(teamNumber);
                    break;
                }
                case ROLE_ADJUST: {
                    String teamNumberAfter;
                    String teamNumberBefore;
                    JSONObject roleAdjust = data.getJSONObject("ptmm_entryroleadjust");
                    perNum = roleAdjust.getString("numberadj");
                    if (Objects.nonNull(roleAdjust.getJSONObject("projectteamadj")) && HRStringUtils.isNotEmpty((String)(teamNumberBefore = roleAdjust.getJSONObject("projectteamadj").getString("number")))) {
                        roleTeamNumberSets.add(teamNumberBefore);
                        teamNumberSets.add(teamNumberBefore);
                    }
                    if (!Objects.nonNull(roleAdjust.getJSONObject("projectteamadjnew")) || !HRStringUtils.isNotEmpty((String)(teamNumberAfter = roleAdjust.getJSONObject("projectteamadjnew").getString("number")))) break;
                    teamNumberSets.add(teamNumberAfter);
                    break;
                }
                case ROLE_QUIT: {
                    JSONObject roleQuit = data.getJSONObject("ptmm_entryrolequit");
                    perNum = roleQuit.getString("numberadjq");
                    if (!Objects.nonNull(roleQuit.getJSONObject("projectteamadjq")) || !HRStringUtils.isNotEmpty((String)(teamNumber = roleQuit.getJSONObject("projectteamadjq").getString("number")))) break;
                    roleTeamNumberSets.add(teamNumber);
                    break;
                }
                case MEMBER_QUIT: {
                    JSONObject exit = data.getJSONObject("ptmm_entrymemberquit");
                    perNum = exit.getString("numberq");
                    if (!Objects.nonNull(exit.getJSONObject("projectteamq")) || !HRStringUtils.isNotEmpty((String)(teamNumber = exit.getJSONObject("projectteamq").getString("number")))) break;
                    memTeamNumberSets.add(teamNumber);
                    break;
                }
            }
            if (HRStringUtils.isNotEmpty((String)teamNumber)) {
                teamNumberSets.add(teamNumber);
            }
            if (!HRStringUtils.isNotEmpty((String)perNum)) continue;
            perNumSets.add(perNum);
        }
    }
}

