/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.domain.service.impl.common;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.ptmm.business.domain.impt.bo.ImportDataValidateBO;
import kd.hr.ptmm.business.domain.service.impl.common.PtmmMultiSheetUtils;
import kd.hr.ptmm.business.domain.status.dto.ValidateMsg;
import kd.hr.ptmm.common.enums.AdjustTypeEnum;

public class PTMMImportValidateServiceImplEx {
    private static final Log LOGGER = LogFactory.getLog(PTMMImportValidateServiceImplEx.class);
    private static final String PERSON_NUMBER = "person.number";
    private static final String TEAM_NUMBER = "projectteam.number";
    private static final String ROLE_NUMBER = "projectrole.number";

    public static List<ImportDataValidateBO> excelRowAndEntryRowCheck(List<ImportDataValidateBO> validateParams, Map<String, DynamicObject> proRoleVWorkRoles) {
        for (ImportDataValidateBO param : validateParams) {
            JSONObject data = param.getImportBillData().getData().getJSONObject("data");
            int checkIndex = param.getImportBillData().getDataIndex();
            AdjustTypeEnum impType = param.getAdjustEntryEnum();
            try {
                switch (param.getAdjustEntryEnum().getCode()) {
                    case "1": {
                        DynamicObjectCollection memberjoinentryDC = PTMMImportValidateServiceImplEx.getBillEntryData(param, "memberjoinentry");
                        JSONObject join = PtmmMultiSheetUtils.getMemberJoinJson(data);
                        if (join.getJSONObject("projectteamadd") == null || !PTMMImportValidateServiceImplEx.checkExcelRowRepeat(impType, join, validateParams, checkIndex) && !PTMMImportValidateServiceImplEx.checkExcelAndEntryRowRepeat(impType, join, memberjoinentryDC, proRoleVWorkRoles)) break;
                        ValidateMsg checkMsg = new ValidateMsg();
                        checkMsg.setMsgCode("AddMember");
                        checkMsg.setMsgType("error");
                        checkMsg.setMsgIndex(30L);
                        checkMsg.setMsgInfo(ResManager.loadKDString((String)"\u6210\u5458\u65b0\u589e\u5df2\u5b58\u5728", (String)"PTMMImportValidateExcelEntryRowRepeat_1", (String)"hr-ptmm-business", (Object[])new Object[0]));
                        param.getValidateMsgList().add(checkMsg);
                        break;
                    }
                    case "2": {
                        DynamicObjectCollection memberadjjentryDC = PTMMImportValidateServiceImplEx.getBillEntryData(param, "memberadjjentry");
                        JSONObject roleJoin = data.getJSONObject("ptmm_entryrolejoin");
                        if (roleJoin.getJSONObject("projectteamadja") == null || roleJoin.getJSONObject("projectroleadja") == null || !PTMMImportValidateServiceImplEx.checkExcelRowRepeat(impType, roleJoin, validateParams, checkIndex) && !PTMMImportValidateServiceImplEx.checkExcelAndEntryRowRepeat(impType, roleJoin, memberadjjentryDC, proRoleVWorkRoles)) break;
                        ValidateMsg checkMsg = new ValidateMsg();
                        checkMsg.setMsgCode("AddRole");
                        checkMsg.setMsgType("error");
                        checkMsg.setMsgIndex(31L);
                        checkMsg.setMsgInfo(ResManager.loadKDString((String)"\u9879\u76ee\u4efb\u804c\u65b0\u589e\u5df2\u5b58\u5728", (String)"PTMMImportValidateExcelEntryRowRepeat_2", (String)"hr-ptmm-business", (Object[])new Object[0]));
                        param.getValidateMsgList().add(checkMsg);
                        break;
                    }
                    case "3": {
                        ValidateMsg checkMsg;
                        DynamicObjectCollection memberadjaentryDC = PTMMImportValidateServiceImplEx.getBillEntryData(param, "memberadjaentry");
                        JSONObject roleEdit = data.getJSONObject("ptmm_entryroleadjust");
                        if (roleEdit.getJSONObject("projectteamadj") == null || roleEdit.getJSONObject("projectroleadj") == null) break;
                        if (PTMMImportValidateServiceImplEx.checkExcelRowRepeat(impType, roleEdit, validateParams, checkIndex) || PTMMImportValidateServiceImplEx.checkExcelAndEntryRowRepeat(impType, roleEdit, memberadjaentryDC, proRoleVWorkRoles)) {
                            checkMsg = new ValidateMsg();
                            checkMsg.setMsgCode("RoleEditBefor");
                            checkMsg.setMsgType("error");
                            checkMsg.setMsgIndex(32L);
                            checkMsg.setMsgInfo(ResManager.loadKDString((String)"\u89d2\u8272\u8c03\u6574\u5df2\u5b58\u5728", (String)"PTMMImportValidateExcelEntryRowRepeat_3_1", (String)"hr-ptmm-business", (Object[])new Object[0]));
                            param.getValidateMsgList().add(checkMsg);
                        }
                        if (!PTMMImportValidateServiceImplEx.checkExcelAfterTeam(roleEdit, validateParams, checkIndex) && !PTMMImportValidateServiceImplEx.checkExcelAndEntryAfterTeam(roleEdit, memberadjaentryDC)) break;
                        checkMsg = new ValidateMsg();
                        checkMsg.setMsgCode("RoleEditAfter");
                        checkMsg.setMsgType("error");
                        checkMsg.setMsgIndex(33L);
                        checkMsg.setMsgInfo(ResManager.loadKDString((String)"\u6210\u5458\u8c03\u6574\u81f3\u9879\u76ee\u56e2\u961f\u6570\u636e\u5df2\u5b58\u5728", (String)"PTMMImportValidateExcelEntryRowRepeat_3_2", (String)"hr-ptmm-business", (Object[])new Object[0]));
                        param.getValidateMsgList().add(checkMsg);
                        break;
                    }
                    case "4": {
                        DynamicObjectCollection memberadjqentryDC = PTMMImportValidateServiceImplEx.getBillEntryData(param, "memberadjqentry");
                        JSONObject roleQuit = data.getJSONObject("ptmm_entryrolequit");
                        if (roleQuit.getJSONObject("projectteamadjq") == null || roleQuit.getJSONObject("projectroleadjq") == null || !PTMMImportValidateServiceImplEx.checkExcelRowRepeat(impType, roleQuit, validateParams, checkIndex) && !PTMMImportValidateServiceImplEx.checkExcelAndEntryRowRepeat(impType, roleQuit, memberadjqentryDC, proRoleVWorkRoles)) break;
                        ValidateMsg checkMsg = new ValidateMsg();
                        checkMsg.setMsgCode("RoleQuit");
                        checkMsg.setMsgType("error");
                        checkMsg.setMsgIndex(34L);
                        checkMsg.setMsgInfo(ResManager.loadKDString((String)"\u89d2\u8272\u4efb\u804c\u7ed3\u675f\u5df2\u5b58\u5728", (String)"PTMMImportValidateExcelEntryRowRepeat_4", (String)"hr-ptmm-business", (Object[])new Object[0]));
                        param.getValidateMsgList().add(checkMsg);
                        break;
                    }
                    case "5": {
                        DynamicObjectCollection memberquitentryDC = PTMMImportValidateServiceImplEx.getBillEntryData(param, "memberquitentry");
                        JSONObject memberQuit = data.getJSONObject("ptmm_entrymemberquit");
                        if (memberQuit.getJSONObject("projectteamq") == null || !PTMMImportValidateServiceImplEx.checkExcelRowRepeat(impType, memberQuit, validateParams, checkIndex) && !PTMMImportValidateServiceImplEx.checkExcelAndEntryRowRepeat(impType, memberQuit, memberquitentryDC, proRoleVWorkRoles)) break;
                        ValidateMsg checkMsg = new ValidateMsg();
                        checkMsg.setMsgCode("MemberQuit");
                        checkMsg.setMsgType("error");
                        checkMsg.setMsgIndex(35L);
                        checkMsg.setMsgInfo(ResManager.loadKDString((String)"\u6210\u5458\u9000\u51fa\u5df2\u5b58\u5728", (String)"PTMMImportValidateExcelEntryRowRepeat_5", (String)"hr-ptmm-business", (Object[])new Object[0]));
                        param.getValidateMsgList().add(checkMsg);
                        break;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("PTMMImportValidateServiceImplEx excelRowAndEntryRowCheck error: ", (Throwable)e);
                ValidateMsg checkMsg = new ValidateMsg();
                checkMsg.setMsgCode("codeError");
                checkMsg.setMsgInfo(e.toString());
                param.getValidateMsgList().add(checkMsg);
            }
        }
        return validateParams;
    }

    private static DynamicObjectCollection getBillEntryData(ImportDataValidateBO param, String entryName) {
        return param.getDataModel().getDataEntity(true).getDynamicObjectCollection(entryName);
    }

    public static boolean checkExcelRowRepeat(AdjustTypeEnum checkType, JSONObject checkJsonDate, List<ImportDataValidateBO> validateParams, int checkIndex) {
        boolean checkRes = false;
        for (ImportDataValidateBO param : validateParams) {
            JSONObject memberQuit;
            String projectTeamNumber;
            JSONObject roleQuit;
            String checkProjectTeamNumber;
            String personNumber;
            JSONObject roleAdjust;
            String checkRoleNumber;
            String checkProjectTeamNumber2;
            String roleNumber;
            JSONObject rolejoin;
            String checkPersonNumber;
            String personNumber2;
            String projectTeamNumber2;
            JSONObject join;
            AdjustTypeEnum impType = param.getAdjustEntryEnum();
            JSONObject data = param.getImportBillData().getData().getJSONObject("data");
            int dateIndex = param.getImportBillData().getDataIndex();
            if (impType != checkType || dateIndex == checkIndex) continue;
            if (checkType == AdjustTypeEnum.MEMBER_JOIN && (join = PtmmMultiSheetUtils.getMemberJoinJson(data)) != null) {
                projectTeamNumber2 = join.getJSONObject("projectteamadd").getString("number");
                personNumber2 = join.getString("personnumber");
                String checkProjectTeamNumber3 = checkJsonDate.getJSONObject("projectteamadd").getString("number");
                checkPersonNumber = checkJsonDate.getString("personnumber");
                if (HRStringUtils.isEmpty((String)checkProjectTeamNumber3) || HRStringUtils.isEmpty((String)checkPersonNumber) || HRStringUtils.isEmpty((String)projectTeamNumber2) || HRStringUtils.isEmpty((String)personNumber2)) continue;
                if (checkPersonNumber.equals(personNumber2) && checkProjectTeamNumber3.equals(projectTeamNumber2)) {
                    checkRes = true;
                }
            }
            if (checkType == AdjustTypeEnum.ROLE_JOIN && (rolejoin = data.getJSONObject("ptmm_entryrolejoin")) != null) {
                projectTeamNumber2 = rolejoin.getJSONObject("projectteamadja").getString("number");
                personNumber2 = rolejoin.getString("numberadja");
                roleNumber = rolejoin.getJSONObject("projectroleadja").getString("number");
                checkProjectTeamNumber2 = checkJsonDate.getJSONObject("projectteamadja").getString("number");
                String checkPersonNumber2 = checkJsonDate.getString("numberadja");
                checkRoleNumber = checkJsonDate.getJSONObject("projectroleadja").getString("number");
                if (HRStringUtils.isEmpty((String)projectTeamNumber2) || HRStringUtils.isEmpty((String)personNumber2) && HRStringUtils.isEmpty((String)roleNumber) || HRStringUtils.isEmpty((String)checkProjectTeamNumber2) && HRStringUtils.isEmpty((String)checkPersonNumber2) || HRStringUtils.isEmpty((String)checkRoleNumber)) continue;
                if (checkProjectTeamNumber2.equals(projectTeamNumber2) && checkPersonNumber2.equals(personNumber2) && checkRoleNumber.equals(roleNumber)) {
                    checkRes = true;
                }
            }
            if (checkType == AdjustTypeEnum.ROLE_ADJUST && (roleAdjust = data.getJSONObject("ptmm_entryroleadjust")) != null) {
                personNumber = roleAdjust.getString("numberadj");
                String beforeProjectTeamNumber = roleAdjust.getJSONObject("projectteamadj").getString("number");
                String beforeRoleNumber = roleAdjust.getJSONObject("projectroleadj").getString("number");
                checkPersonNumber = checkJsonDate.getString("numberadj");
                checkProjectTeamNumber = checkJsonDate.getJSONObject("projectteamadj").getString("number");
                checkRoleNumber = checkJsonDate.getJSONObject("projectroleadj").getString("number");
                if (HRStringUtils.isEmpty((String)personNumber) || HRStringUtils.isEmpty((String)beforeProjectTeamNumber) || HRStringUtils.isEmpty((String)beforeRoleNumber) || HRStringUtils.isEmpty((String)checkPersonNumber) || HRStringUtils.isEmpty((String)checkProjectTeamNumber) || HRStringUtils.isEmpty((String)checkRoleNumber)) continue;
                if (checkProjectTeamNumber.equals(beforeProjectTeamNumber) && checkPersonNumber.equals(personNumber) && checkRoleNumber.equals(beforeRoleNumber)) {
                    checkRes = true;
                }
            }
            if (checkType == AdjustTypeEnum.ROLE_QUIT && (roleQuit = data.getJSONObject("ptmm_entryrolequit")) != null) {
                personNumber = roleQuit.getString("numberadjq");
                projectTeamNumber = roleQuit.getJSONObject("projectteamadjq").getString("number");
                roleNumber = roleQuit.getJSONObject("projectroleadjq").getString("number");
                checkPersonNumber = checkJsonDate.getString("numberadjq");
                checkProjectTeamNumber = checkJsonDate.getJSONObject("projectteamadjq").getString("number");
                checkRoleNumber = checkJsonDate.getJSONObject("projectroleadjq").getString("number");
                if (HRStringUtils.isEmpty((String)personNumber) || HRStringUtils.isEmpty((String)projectTeamNumber) || HRStringUtils.isEmpty((String)roleNumber) || HRStringUtils.isEmpty((String)checkPersonNumber) || HRStringUtils.isEmpty((String)checkProjectTeamNumber) || HRStringUtils.isEmpty((String)checkRoleNumber)) continue;
                if (checkProjectTeamNumber.equals(projectTeamNumber) && checkPersonNumber.equals(personNumber) && checkRoleNumber.equals(roleNumber)) {
                    checkRes = true;
                }
            }
            if (checkType != AdjustTypeEnum.MEMBER_QUIT || (memberQuit = data.getJSONObject("ptmm_entrymemberquit")) == null) continue;
            personNumber = memberQuit.getString("numberq");
            projectTeamNumber = memberQuit.getJSONObject("projectteamq").getString("number");
            String checkPersonNumber3 = checkJsonDate.getString("numberq");
            checkProjectTeamNumber2 = checkJsonDate.getJSONObject("projectteamq").getString("number");
            if (HRStringUtils.isEmpty((String)personNumber) || HRStringUtils.isEmpty((String)projectTeamNumber) || HRStringUtils.isEmpty((String)checkPersonNumber3) || HRStringUtils.isEmpty((String)checkProjectTeamNumber2) || !checkProjectTeamNumber2.equals(projectTeamNumber) || !checkPersonNumber3.equals(personNumber)) continue;
            checkRes = true;
        }
        return checkRes;
    }

    public static boolean checkExcelAndEntryRowRepeat(AdjustTypeEnum checkType, JSONObject checkJsonDate, DynamicObjectCollection checkEntryDataDC, Map<String, DynamicObject> proRoleVWorkRoles) {
        boolean checkRes = false;
        for (DynamicObject checkDO : checkEntryDataDC) {
            DynamicObject projectTeamDO;
            String checkProjectTeamNumber;
            String checkPersonNumber;
            String personNumber;
            DynamicObject personDO;
            String checkWorkRoleNumber;
            String checkPrjRoleNumber;
            String workRoleNumber;
            String projectTeamNumber;
            DynamicObject workRoleDO;
            String projectTeamNumber2;
            String personNumber2;
            if (checkType == AdjustTypeEnum.MEMBER_JOIN) {
                String checkProjectTeamNumber2 = checkJsonDate.getJSONObject("projectteamadd").getString("number");
                String checkPersonNumber2 = checkJsonDate.getString("personnumber");
                personNumber2 = checkDO.getString("personnumber");
                DynamicObject projectTeamDO2 = checkDO.getDynamicObject("projectteamadd");
                if (projectTeamDO2 == null) continue;
                projectTeamNumber2 = projectTeamDO2.getString("number");
                if (HRStringUtils.isEmpty((String)checkProjectTeamNumber2) || HRStringUtils.isEmpty((String)checkPersonNumber2) || HRStringUtils.isEmpty((String)personNumber2) || HRStringUtils.isEmpty((String)projectTeamNumber2)) continue;
                if (checkProjectTeamNumber2.equals(projectTeamNumber2) && checkPersonNumber2.equals(personNumber2)) {
                    checkRes = true;
                }
            }
            if (checkType == AdjustTypeEnum.ROLE_JOIN) {
                DynamicObject projectTeamDO3 = checkDO.getDynamicObject("personbaseadja");
                DynamicObject personDO2 = checkDO.getDynamicObject("personbaseadja");
                workRoleDO = checkDO.getDynamicObject("projectroleadja");
                if (projectTeamDO3 == null || personDO2 == null || workRoleDO == null) continue;
                projectTeamNumber = projectTeamDO3.getString(TEAM_NUMBER);
                String personNumber3 = personDO2.getString(PERSON_NUMBER);
                workRoleNumber = workRoleDO.getString("number");
                String checkProjectTeamNumber3 = checkJsonDate.getJSONObject("projectteamadja").getString("number");
                String checkPersonNumber3 = checkJsonDate.getString("numberadja");
                checkPrjRoleNumber = checkJsonDate.getJSONObject("projectroleadja").getString("number");
                checkWorkRoleNumber = PTMMImportValidateServiceImplEx.getWorkRoleNumByPrjRoleNum(checkPrjRoleNumber, proRoleVWorkRoles);
                if (HRStringUtils.isEmpty((String)projectTeamNumber) || HRStringUtils.isEmpty((String)personNumber3) || HRStringUtils.isEmpty((String)workRoleNumber) || HRStringUtils.isEmpty((String)checkProjectTeamNumber3) || HRStringUtils.isEmpty((String)checkPersonNumber3) || HRStringUtils.isEmpty((String)checkPrjRoleNumber) || HRStringUtils.isEmpty((String)checkWorkRoleNumber)) continue;
                if (checkProjectTeamNumber3.equals(projectTeamNumber) && checkPersonNumber3.equals(personNumber3) && checkWorkRoleNumber.equals(workRoleNumber)) {
                    checkRes = true;
                }
            }
            if (checkType == AdjustTypeEnum.ROLE_ADJUST) {
                personDO = checkDO.getDynamicObject("personbaseadj");
                DynamicObject beforeProjectTeamDO = checkDO.getDynamicObject("personbaseadj");
                DynamicObject beforeWorkRoleDO = checkDO.getDynamicObject("personbaseadj");
                if (personDO == null || beforeProjectTeamDO == null || beforeWorkRoleDO == null) continue;
                personNumber = personDO.getString(PERSON_NUMBER);
                String beforeProjectTeamNumber = beforeProjectTeamDO.getString(TEAM_NUMBER);
                String beforeWorkRoleNumber = beforeWorkRoleDO.getString(ROLE_NUMBER);
                checkPersonNumber = checkJsonDate.getString("numberadj");
                checkProjectTeamNumber = checkJsonDate.getJSONObject("projectteamadj").getString("number");
                checkPrjRoleNumber = checkJsonDate.getJSONObject("projectroleadj").getString("number");
                checkWorkRoleNumber = PTMMImportValidateServiceImplEx.getWorkRoleNumByPrjRoleNum(checkPrjRoleNumber, proRoleVWorkRoles);
                if (HRStringUtils.isEmpty((String)personNumber) || HRStringUtils.isEmpty((String)beforeProjectTeamNumber) || HRStringUtils.isEmpty((String)beforeWorkRoleNumber) || HRStringUtils.isEmpty((String)checkPersonNumber) || HRStringUtils.isEmpty((String)checkProjectTeamNumber) || HRStringUtils.isEmpty((String)checkPrjRoleNumber) || HRStringUtils.isEmpty((String)checkWorkRoleNumber)) continue;
                if (checkProjectTeamNumber.equals(beforeProjectTeamNumber) && checkPersonNumber.equals(personNumber) && checkWorkRoleNumber.equals(beforeWorkRoleNumber)) {
                    checkRes = true;
                }
            }
            if (checkType == AdjustTypeEnum.ROLE_QUIT) {
                personDO = checkDO.getDynamicObject("personbaseadjq");
                projectTeamDO = checkDO.getDynamicObject("personbaseadjq");
                workRoleDO = checkDO.getDynamicObject("personbaseadjq");
                if (personDO == null || projectTeamDO == null || workRoleDO == null) continue;
                personNumber = personDO.getString(PERSON_NUMBER);
                projectTeamNumber2 = projectTeamDO.getString(TEAM_NUMBER);
                workRoleNumber = workRoleDO.getString(ROLE_NUMBER);
                checkPersonNumber = checkJsonDate.getString("numberadjq");
                checkProjectTeamNumber = checkJsonDate.getJSONObject("projectteamadjq").getString("number");
                checkPrjRoleNumber = checkJsonDate.getJSONObject("projectroleadjq").getString("number");
                checkWorkRoleNumber = PTMMImportValidateServiceImplEx.getWorkRoleNumByPrjRoleNum(checkPrjRoleNumber, proRoleVWorkRoles);
                if (HRStringUtils.isEmpty((String)personNumber) || HRStringUtils.isEmpty((String)projectTeamNumber2) || HRStringUtils.isEmpty((String)workRoleNumber) || HRStringUtils.isEmpty((String)checkPersonNumber) || HRStringUtils.isEmpty((String)checkProjectTeamNumber) || HRStringUtils.isEmpty((String)checkPrjRoleNumber) || HRStringUtils.isEmpty((String)checkWorkRoleNumber)) continue;
                if (checkProjectTeamNumber.equals(projectTeamNumber2) && checkPersonNumber.equals(personNumber) && checkWorkRoleNumber.equals(workRoleNumber)) {
                    checkRes = true;
                }
            }
            if (checkType != AdjustTypeEnum.MEMBER_QUIT) continue;
            personDO = checkDO.getDynamicObject("personbaseq");
            projectTeamDO = checkDO.getDynamicObject("personbaseq");
            if (personDO == null || projectTeamDO == null) continue;
            personNumber2 = personDO.getString(PERSON_NUMBER);
            projectTeamNumber = projectTeamDO.getString(TEAM_NUMBER);
            String checkPersonNumber4 = checkJsonDate.getString("numberq");
            String checkProjectTeamNumber4 = checkJsonDate.getJSONObject("projectteamq").getString("number");
            if (HRStringUtils.isEmpty((String)personNumber2) || HRStringUtils.isEmpty((String)projectTeamNumber) || HRStringUtils.isEmpty((String)checkPersonNumber4) || HRStringUtils.isEmpty((String)checkProjectTeamNumber4) || !checkProjectTeamNumber4.equals(projectTeamNumber) || !checkPersonNumber4.equals(personNumber2)) continue;
            checkRes = true;
        }
        return checkRes;
    }

    public static String getWorkRoleNumByPrjRoleNum(String prjRoleNum, Map<String, DynamicObject> proRoleVWorkRoles) {
        String workRoleNum = "";
        DynamicObject workRoleDO = proRoleVWorkRoles.get(prjRoleNum);
        if (workRoleDO != null) {
            workRoleNum = workRoleDO.getString("number");
        }
        return workRoleNum;
    }

    public static boolean checkExcelAfterTeam(JSONObject checkJsonDate, List<ImportDataValidateBO> validateParams, int checkIndex) {
        boolean checkRes = false;
        for (ImportDataValidateBO param : validateParams) {
            JSONObject roleAdjust;
            AdjustTypeEnum impType = param.getAdjustEntryEnum();
            JSONObject data = param.getImportBillData().getData().getJSONObject("data");
            int dateIndex = param.getImportBillData().getDataIndex();
            if (impType != AdjustTypeEnum.ROLE_ADJUST || dateIndex == checkIndex || (roleAdjust = data.getJSONObject("ptmm_entryroleadjust")) == null) continue;
            String personNumber = roleAdjust.getString("numberadj");
            String afterProjectTeamNumber = roleAdjust.getJSONObject("projectteamadjnew").getString("number");
            String checkPersonNumber = checkJsonDate.getString("numberadj");
            String checkAfterProjectTeamNumber = checkJsonDate.getJSONObject("projectteamadjnew").getString("number");
            if (HRStringUtils.isEmpty((String)personNumber) || HRStringUtils.isEmpty((String)afterProjectTeamNumber) || HRStringUtils.isEmpty((String)checkPersonNumber) || HRStringUtils.isEmpty((String)checkAfterProjectTeamNumber) || !checkPersonNumber.equals(personNumber) || !checkAfterProjectTeamNumber.equals(afterProjectTeamNumber)) continue;
            checkRes = true;
        }
        return checkRes;
    }

    public static boolean checkExcelAndEntryAfterTeam(JSONObject checkJsonDate, DynamicObjectCollection checkEntryDataDC) {
        boolean checkRes = false;
        for (DynamicObject checkDO : checkEntryDataDC) {
            DynamicObject personDO = checkDO.getDynamicObject("personbaseadj");
            DynamicObject afterProjectTeamDO = checkDO.getDynamicObject("projectteamadjnew");
            if (personDO == null || afterProjectTeamDO == null) continue;
            String personNumber = personDO.getString(PERSON_NUMBER);
            String afterProjectTeamNumber = afterProjectTeamDO.getString("number");
            String checkPersonNumber = checkJsonDate.getString("numberadj");
            String checkAfterProjectTeamNumber = checkJsonDate.getJSONObject("projectteamadjnew").getString("number");
            if (HRStringUtils.isEmpty((String)personNumber) || HRStringUtils.isEmpty((String)afterProjectTeamNumber) || HRStringUtils.isEmpty((String)checkPersonNumber) || HRStringUtils.isEmpty((String)checkAfterProjectTeamNumber) || !checkPersonNumber.equals(personNumber) || !checkAfterProjectTeamNumber.equals(afterProjectTeamNumber)) continue;
            checkRes = true;
        }
        return checkRes;
    }
}

