/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.domain.service.impl.common;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.business.domain.service.common.IPTMMValidateService;
import kd.hr.ptmm.business.domain.status.dto.ProjectTeamInfoDto;
import kd.hr.ptmm.business.domain.status.dto.ProjectTemaRoleInfoDto;
import kd.hr.ptmm.business.domain.status.dto.ValidateParamDto;
import kd.hr.ptmm.business.domain.status.dto.ValidateResDto;
import kd.hr.ptmm.business.domain.status.util.PTMMBuisinessCheckUtils;
import kd.hr.ptmm.business.domain.status.util.PersonChangeUtils;
import kd.hr.ptmm.common.enums.AdjustEntryEnum;
import org.apache.commons.lang3.StringUtils;

public class PTMMValidateServiceImpl
implements IPTMMValidateService {
    private static final Log LOGGER = LogFactory.getLog(PTMMValidateServiceImpl.class);
    private static final String HRPI_EMPENTREL = "hrpi_empentrel";
    private static final String DATA = "data";
    private static final String ACTION_ID = "actionId";
    private static final String QUIT_ACTION_ID = "1020";
    private static final String EFFECT_TIME = "effectTime";
    private static final String PERSON_ID = "person_id";

    @Override
    public List<ValidateResDto> projectMembersValidate(List<ValidateParamDto> validateParams) {
        validateParams = PTMMValidateServiceImpl.getPersonInAndQuitTime(validateParams);
        validateParams = PTMMValidateServiceImpl.getCrossValidateQuitBills(validateParams);
        validateParams = PTMMValidateServiceImpl.getProjectTeamInfo(validateParams);
        validateParams = PTMMValidateServiceImpl.getProjectTeamRoleInfo(validateParams);
        validateParams = PTMMValidateServiceImpl.getProjectTeamMembersInfo(validateParams);
        return PTMMBuisinessCheckUtils.businessCheck(validateParams);
    }

    @Override
    public List<ValidateResDto> addProjectMembersValidate(List<ValidateParamDto> validateParams) {
        validateParams = PTMMValidateServiceImpl.getPersonInAndQuitTime(validateParams);
        validateParams = PTMMValidateServiceImpl.getCrossValidateQuitBills(validateParams);
        validateParams = PTMMValidateServiceImpl.getProjectTeamInfo(validateParams);
        validateParams = PTMMValidateServiceImpl.getProjectTeamRoleInfo(validateParams);
        validateParams = PTMMValidateServiceImpl.getProjectTeamMembersInfo(validateParams);
        return PTMMBuisinessCheckUtils.addBusinessCheck(validateParams);
    }

    @Override
    public List<ValidateResDto> editProjectMemberRolesValidate(List<ValidateParamDto> validateParams) {
        validateParams = PTMMValidateServiceImpl.getPersonInAndQuitTime(validateParams);
        validateParams = PTMMValidateServiceImpl.getCrossValidateQuitBills(validateParams);
        validateParams = PTMMValidateServiceImpl.getProjectTeamInfo(validateParams);
        validateParams = PTMMValidateServiceImpl.getProjectTeamRoleInfo(validateParams);
        validateParams = PTMMValidateServiceImpl.getProjectTeamMembersInfo(validateParams);
        return PTMMBuisinessCheckUtils.editBusinessCheck(validateParams);
    }

    @Override
    public List<ValidateResDto> outPojectMembersValidate(List<ValidateParamDto> validateParams) {
        validateParams = PTMMValidateServiceImpl.getPersonInAndQuitTime(validateParams);
        validateParams = PTMMValidateServiceImpl.getCrossValidateQuitBills(validateParams);
        validateParams = PTMMValidateServiceImpl.getProjectTeamInfo(validateParams);
        validateParams = PTMMValidateServiceImpl.getProjectTeamMembersInfo(validateParams);
        return PTMMBuisinessCheckUtils.outBusinessCheck(validateParams);
    }

    private static List<ValidateParamDto> getPersonInAndQuitTime(List<ValidateParamDto> validateParams) {
        List<Long> personIds = PTMMValidateServiceImpl.getPersonIds(validateParams);
        try {
            List<Map<String, Object>> employeeInfos = PTMMServiceFactory.hrpiService.listBatchEmployeeByPerson(personIds, null, HRPI_EMPENTREL);
            for (ValidateParamDto param : validateParams) {
                for (Map<String, Object> employeeInfo : employeeInfos) {
                    Long employeeInfoPersonId = Long.parseLong(employeeInfo.get(PERSON_ID).toString());
                    if (!param.getPersonId().equals(employeeInfoPersonId)) continue;
                    Date startDate = HRDateTimeUtils.parseDate((String)employeeInfo.get("startdate").toString());
                    Date quitDate = HRDateTimeUtils.parseDate((String)employeeInfo.get("enddate").toString());
                    if (Long.parseLong(employeeInfo.get("labrelstatusprd_id").toString()) == 1020L) {
                        param.setQuitOrNot(true);
                    } else {
                        param.setQuitOrNot(false);
                    }
                    param.setInStartDate(startDate);
                    param.setQuitDate(quitDate);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("getPersonInAndQuitTime error: ", (Throwable)exception);
        }
        return validateParams;
    }

    private static List<ValidateParamDto> getCrossValidateQuitBills(List<ValidateParamDto> validateParams) {
        for (ValidateParamDto param : validateParams) {
            param.setHaveQuitBill(false);
            Map<String, Object> crossParam = PersonChangeUtils.getCheckParam(param);
            Map<String, Object> crossResult = PTMMServiceFactory.hpfsService.getCrossValidateBills(crossParam);
            if (!PersonChangeUtils.checkPerChgCrossValidateResult(crossResult)) {
                LOGGER.error("PTMM getCrossValidateQuitBills result is error , the personName is : [{}], the result is :[{}]", (Object)param.getPersonName(), crossResult);
            }
            if (crossResult == null) {
                return validateParams;
            }
            List crossList = (List)crossResult.get(DATA);
            if (Objects.isNull(crossList) || crossList.isEmpty()) continue;
            crossList.forEach(validateResult -> {
                if (validateResult.get(ACTION_ID).toString().equals(QUIT_ACTION_ID)) {
                    param.setHaveQuitBill(true);
                    param.setQuitEffectTime(Long.parseLong(validateResult.get(EFFECT_TIME).toString()));
                    LOGGER.info("getCrossValidateQuitBills EFFECT_TIME is :[{}]", (Object)validateResult.get(EFFECT_TIME).toString());
                }
            });
        }
        return validateParams;
    }

    private static List<ValidateParamDto> getProjectTeamInfo(List<ValidateParamDto> validateParams) {
        List<Map<String, Object>> projectTeamParams = PTMMValidateServiceImpl.getprojectTeamParams(validateParams);
        try {
            List<Map<String, Object>> projectTeamResult = PTMMServiceFactory.haosService.getProjectTeamInfos(projectTeamParams);
            LOGGER.info("getProjectTeamInfo projectTeamResult is : [{}]", (Object)JSONObject.toJSONString(projectTeamResult));
            for (ValidateParamDto param : validateParams) {
                for (Map<String, Object> projectTeam : projectTeamResult) {
                    Long projectGroupId = Long.parseLong(projectTeam.get("projectGroupId").toString());
                    String checkTime = projectTeam.get("checkTime").toString();
                    String projectTeamEnableStatus = projectTeam.get("projectEnableStatus").toString();
                    if (!checkTime.equals(param.getEffectTime().toString()) || !projectGroupId.equals(param.getTeamId()) || !projectTeamEnableStatus.equals("1")) continue;
                    ProjectTeamInfoDto projectTeamInfo = new ProjectTeamInfoDto();
                    projectTeamInfo.setProjectGroupId(projectGroupId);
                    projectTeamInfo.setProjectEnableStatus(projectTeam.get("projectEnableStatus").toString());
                    projectTeamInfo.setStartDate(HRDateTimeUtils.parseDate((String)projectTeam.get("startDate").toString()));
                    projectTeamInfo.setEndDate(HRDateTimeUtils.parseDate((String)projectTeam.get("endDate").toString()));
                    projectTeamInfo.setMsgCode(Integer.parseInt(projectTeam.get("msgCode").toString()));
                    projectTeamInfo.setMsgInfo(projectTeam.get("msgInfo").toString());
                    projectTeamInfo.setCheckTime(param.getEffectTime());
                    Date startDate = HRDateTimeUtils.parseDate((String)projectTeam.get("startDate").toString());
                    Date endDate = HRDateTimeUtils.parseDate((String)projectTeam.get("endDate").toString());
                    param.setTeamStartDate(startDate);
                    param.setTeamEndDate(endDate);
                    param.setProjectTeamInfo(projectTeamInfo);
                    String logInfo = String.format("PTMMValidateServiceImpl getProjectTeamInfo groupId is [%s]; teamStartTime is [%s];teamEndTime is[%s]", projectGroupId.toString(), PTMMBuisinessCheckUtils.getTimeStr(startDate), PTMMBuisinessCheckUtils.getTimeStr(endDate));
                    LOGGER.info(logInfo);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return validateParams;
    }

    private static List<ValidateParamDto> getProjectTeamRoleInfo(List<ValidateParamDto> validateParams) {
        List<Long> workRoleIds = PTMMValidateServiceImpl.getWorkRoleIds(validateParams);
        Map<Long, Long> workRoleIdVPrjRoleId = PTMMServiceFactory.workRoleHrService.getPositionByWorkRoleIds(workRoleIds);
        List<Map<String, Object>> projectTeamRoleParams = PTMMValidateServiceImpl.getProjectTeamRoleParams(validateParams, workRoleIdVPrjRoleId);
        LOGGER.info("getProjectTeamRoleInfo projectTeamRoleParam is : [{}]", (Object)JSONObject.toJSONString(projectTeamRoleParams));
        List<Map<String, Object>> projectTeamRoleResult = PTMMServiceFactory.haosService.getProjectTeamRoleInfos(projectTeamRoleParams);
        LOGGER.info("getProjectTeamRoleInfo projectTeamRoleResult is : [{}]", (Object)JSONObject.toJSONString(projectTeamRoleResult));
        for (ValidateParamDto param : validateParams) {
            for (Map<String, Object> projectTeamRole : projectTeamRoleResult) {
                Long projectRoleId = Long.parseLong(projectTeamRole.get("projectRoleId").toString());
                String checkTime = projectTeamRole.get("checkTime").toString();
                String projectTeamRoleEnableStatus = projectTeamRole.get("projectRoleEnableStatus").toString();
                if (checkTime.equals(param.getEffectTime().toString()) && projectRoleId.equals(workRoleIdVPrjRoleId.get(param.getRoleId())) && projectTeamRoleEnableStatus.equals("1")) {
                    ProjectTemaRoleInfoDto projectTemaRoleInfo = PTMMValidateServiceImpl.setProjectTemaRoleInfo(null, projectRoleId, projectTeamRole);
                    Date startDate = PTMMValidateServiceImpl.convertTimeDate(projectTeamRole.get("startDate").toString());
                    param.setRoleStartDate(startDate);
                    Date endDate = PTMMValidateServiceImpl.convertTimeDate(projectTeamRole.get("endDate").toString());
                    param.setRoleEndDate(endDate);
                    param.setProjectTemaRoleInfo(projectTemaRoleInfo);
                    String logInfo = String.format("PTMMValidateServiceImpl getProjectTeamRoleInfo roleId is [%s]; roleStartTime is [%s];roleEndTime is[%s]", projectRoleId.toString(), PTMMBuisinessCheckUtils.getTimeStr(startDate), PTMMBuisinessCheckUtils.getTimeStr(endDate));
                    LOGGER.info(logInfo);
                }
                PTMMValidateServiceImpl.setProjectTeamOtherRoleInfo(param, projectTeamRole, workRoleIdVPrjRoleId);
            }
        }
        return validateParams;
    }

    private static void setProjectTeamOtherRoleInfo(ValidateParamDto param, Map<String, Object> projectTeamRole, Map<Long, Long> workRoleIdVPrjRoleId) {
        LOGGER.info("setProjectTeamOtherRoleInfo  workRoleIdVPrjRoleId is : [{}]", (Object)JSONObject.toJSONString(workRoleIdVPrjRoleId));
        String checkTime = projectTeamRole.get("checkTime").toString();
        Long projectRoleId = Long.parseLong(projectTeamRole.get("projectRoleId").toString());
        for (ProjectTemaRoleInfoDto otherRole : param.getProjectTemaOtherRoleInfo()) {
            LOGGER.info("setProjectTeamOtherRoleInfo projectRoleId is : [{}]  workRoleId is : [{}]", (Object)projectRoleId, (Object)otherRole.getProjectRoleId());
            if (!checkTime.equals(param.getEffectTime().toString()) || !projectRoleId.equals(workRoleIdVPrjRoleId.get(otherRole.getProjectRoleId()))) continue;
            PTMMValidateServiceImpl.setProjectTemaRoleInfo(otherRole, projectRoleId, projectTeamRole);
        }
    }

    private static Date convertTimeDate(String time) {
        Date convertDate = new Date();
        try {
            if (StringUtils.isNotEmpty((CharSequence)time)) {
                convertDate = HRDateTimeUtils.parseDate((String)time);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return convertDate;
    }

    private static ProjectTemaRoleInfoDto setProjectTemaRoleInfo(ProjectTemaRoleInfoDto projectTemaRoleInfo, Long projectRoleId, Map<String, Object> projectTeamRole) {
        if (projectTemaRoleInfo == null) {
            projectTemaRoleInfo = new ProjectTemaRoleInfoDto();
        }
        projectTemaRoleInfo.setProjectRoleId(projectRoleId);
        projectTemaRoleInfo.setProjectRoleEnableStatus(projectTeamRole.get("projectRoleEnableStatus").toString());
        projectTemaRoleInfo.setStartDate(PTMMValidateServiceImpl.convertTimeDate(projectTeamRole.get("startDate").toString()));
        projectTemaRoleInfo.setEndDate(PTMMValidateServiceImpl.convertTimeDate(projectTeamRole.get("endDate").toString()));
        projectTemaRoleInfo.setMsgCode(Integer.parseInt(projectTeamRole.get("msgCode").toString()));
        projectTemaRoleInfo.setMsgInfo(projectTeamRole.get("msgInfo").toString());
        projectTemaRoleInfo.setCheckTime(PTMMValidateServiceImpl.convertTimeDate(projectTeamRole.get("checkTime").toString()));
        projectTemaRoleInfo.setHaveRoleInCheckTime(true);
        return projectTemaRoleInfo;
    }

    private static List<ValidateParamDto> getProjectTeamMembersInfo(List<ValidateParamDto> validateParams) {
        List<Long> personIds = PTMMValidateServiceImpl.getPersonIds(validateParams);
        List<Long> teamIds = PTMMValidateServiceImpl.getTeamIds(validateParams);
        List<String> projectIdentifys = PTMMValidateServiceImpl.getProjectIdentifys(validateParams);
        DynamicObject[] projectGroupMemberDOs = PTMMServiceFactory.teamMemberService.getProjectGroupMembers(personIds, teamIds);
        DynamicObject[] projectRoleMemberDOs = PTMMServiceFactory.teamMemberService.getProjectRoleMembers(personIds, teamIds);
        DynamicObject[] projectRoleMemberPrjDOs = PTMMServiceFactory.teamMemberService.getProjectRoleMembersInPrj(personIds, projectIdentifys);
        DynamicObject[] allProjectRoleMembers = PTMMServiceFactory.teamMemberService.getAllProjectRoleMembers(projectIdentifys);
        for (ValidateParamDto param : validateParams) {
            ArrayList<DynamicObject> personTeams = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> personBeforeTeams = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> personTeamRoles = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> personBeforeTeamRoles = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> personProjectRoles = new ArrayList<DynamicObject>();
            for (DynamicObject projectGroupMemberDO : projectGroupMemberDOs) {
                if (!param.getPersonId().equals(projectGroupMemberDO.getLong("person.id")) || !param.getTeamId().equals(projectGroupMemberDO.getLong("projectteam.id"))) continue;
                personTeams.add(projectGroupMemberDO);
            }
            for (DynamicObject projectGroupMemberDO : projectGroupMemberDOs) {
                if (param.getBeforeTeamId() == null || !param.getPersonId().equals(projectGroupMemberDO.getLong("person.id")) || !param.getBeforeTeamId().equals(projectGroupMemberDO.getLong("projectteam.id"))) continue;
                personBeforeTeams.add(projectGroupMemberDO);
            }
            for (DynamicObject projectRoleMemberDO : projectRoleMemberDOs) {
                if (!param.getPersonId().equals(projectRoleMemberDO.getLong("person.id")) || !param.getTeamId().equals(projectRoleMemberDO.getLong("projectteam.id"))) continue;
                personTeamRoles.add(projectRoleMemberDO);
            }
            for (DynamicObject projectRoleMemberDO : projectRoleMemberDOs) {
                if (param.getBeforeTeamId() == null || !param.getPersonId().equals(projectRoleMemberDO.getLong("person.id")) || !param.getBeforeTeamId().equals(projectRoleMemberDO.getLong("projectteam.id"))) continue;
                personBeforeTeamRoles.add(projectRoleMemberDO);
            }
            for (DynamicObject projectRoleMemberPrjDO : projectRoleMemberPrjDOs) {
                if (!param.getPersonId().equals(projectRoleMemberPrjDO.getLong("person.id")) || !param.getProjectName().equals(projectRoleMemberPrjDO.getString("projectname"))) continue;
                personProjectRoles.add(projectRoleMemberPrjDO);
            }
            param.setPersonTeamDOs(personTeams);
            param.setPersonBeforeTeamDOs(personBeforeTeams);
            param.setPersonTeamRoleDOs(personTeamRoles);
            param.setPersonBeforeTeamRoleDOs(personBeforeTeamRoles);
            param.setPersonProjectRoleDOs(personProjectRoles);
            boolean isOnlyPrjDutyper = PTMMValidateServiceImpl.checkPrjDutyper(param, allProjectRoleMembers);
            param.setOnlyPrjDutyper(isOnlyPrjDutyper);
        }
        return validateParams;
    }

    private static boolean checkPrjDutyper(ValidateParamDto param, DynamicObject[] allProjectRoleMembers) {
        boolean res = false;
        ArrayList<Long> dutyperPersonIds = new ArrayList<Long>(0);
        ArrayList prjTeamPersonIds = new ArrayList(0);
        ArrayList dutyperTeamPersonList = new ArrayList(0);
        for (DynamicObject projectRoleMembers : allProjectRoleMembers) {
            if (!param.getProjectName().equals(projectRoleMembers.getString("projectname"))) continue;
            boolean roleDu = projectRoleMembers.getBoolean("projectrole.mainpeoincharge");
            Long teamId = projectRoleMembers.getLong("projectteam.id");
            Long personId = projectRoleMembers.getLong("person.id");
            Long roleId = projectRoleMembers.getLong("projectrole.id");
            HashMap<Long, Long> teamPerson = new HashMap<Long, Long>();
            teamPerson.put(teamId, personId);
            if (param.getPersonId().equals(personId) && param.getTeamId().equals(teamId)) {
                if (param.getValidateType() == AdjustEntryEnum.ADJUST_QUIT && param.getRoleId().equals(roleId) && !roleDu) {
                    return false;
                }
                if (param.getValidateType() == AdjustEntryEnum.ADJUST_ADJ && param.getBeforeRoleId().equals(roleId) && !roleDu) {
                    return false;
                }
            }
            if (roleDu && param.getTeamId().equals(teamId)) {
                dutyperPersonIds.add(personId);
            }
            if (!dutyperTeamPersonList.contains(teamPerson)) {
                prjTeamPersonIds.add(teamPerson);
            }
            if (dutyperTeamPersonList.contains(teamPerson) || !roleDu) continue;
            dutyperTeamPersonList.add(teamPerson);
        }
        if (dutyperPersonIds.contains(param.getPersonId()) && dutyperTeamPersonList.size() == 1 && prjTeamPersonIds.size() > 1) {
            res = true;
        }
        return res;
    }

    private static List<Map<String, Object>> getprojectTeamParams(List<ValidateParamDto> validateParams) {
        ArrayList<Map<String, Object>> projectTeamParams = new ArrayList<Map<String, Object>>(validateParams.size());
        for (ValidateParamDto validateParam : validateParams) {
            HashMap<String, Comparable<Long>> projectTeamParam = new HashMap<String, Comparable<Long>>();
            projectTeamParam.put("projectGroupId", validateParam.getTeamId());
            projectTeamParam.put("checkTime", validateParam.getEffectTime());
            if (projectTeamParams.contains(projectTeamParam)) continue;
            projectTeamParams.add(projectTeamParam);
        }
        return projectTeamParams;
    }

    private static List<Map<String, Object>> getProjectTeamRoleParams(List<ValidateParamDto> validateParams, Map<Long, Long> workRoleIdVPrjRoleId) {
        ArrayList<Map<String, Object>> projectTeamRoleParams = new ArrayList<Map<String, Object>>(validateParams.size());
        for (ValidateParamDto validateParam : validateParams) {
            HashMap<String, Comparable<Long>> projectTeamRoleParam = new HashMap<String, Comparable<Long>>();
            projectTeamRoleParam.put("projectRoleId", workRoleIdVPrjRoleId.get(validateParam.getRoleId()));
            projectTeamRoleParam.put("checkTime", validateParam.getEffectTime());
            if (!projectTeamRoleParams.contains(projectTeamRoleParam)) {
                projectTeamRoleParams.add(projectTeamRoleParam);
            }
            if (validateParam.getOtherRoleIds() == null) continue;
            for (Long otherRole : validateParam.getOtherRoleIds()) {
                HashMap<String, Comparable<Long>> projectTeamOtherRoleParam = new HashMap<String, Comparable<Long>>();
                projectTeamOtherRoleParam.put("projectRoleId", workRoleIdVPrjRoleId.get(otherRole));
                projectTeamOtherRoleParam.put("checkTime", validateParam.getEffectTime());
                if (projectTeamRoleParams.contains(projectTeamOtherRoleParam)) continue;
                projectTeamRoleParams.add(projectTeamOtherRoleParam);
            }
        }
        return projectTeamRoleParams;
    }

    private static List<Long> getPersonIds(List<ValidateParamDto> validateParams) {
        ArrayList<Long> personIds = new ArrayList<Long>(validateParams.size());
        for (ValidateParamDto param : validateParams) {
            if (personIds.contains(param.getPersonId())) continue;
            personIds.add(param.getPersonId());
        }
        return personIds;
    }

    private static List<Long> getTeamIds(List<ValidateParamDto> validateParams) {
        ArrayList<Long> teamIds = new ArrayList<Long>(validateParams.size());
        for (ValidateParamDto param : validateParams) {
            if (!teamIds.contains(param.getTeamId())) {
                teamIds.add(param.getTeamId());
            }
            if (param.getValidateType() != AdjustEntryEnum.ADJUST_ADJ || teamIds.contains(param.getBeforeTeamId())) continue;
            teamIds.add(param.getBeforeTeamId());
        }
        return teamIds;
    }

    private static List<String> getProjectIdentifys(List<ValidateParamDto> validateParams) {
        ArrayList<String> projectIdentifys = new ArrayList<String>(validateParams.size());
        for (ValidateParamDto param : validateParams) {
            if (projectIdentifys.contains(param.getProjectIdentify())) continue;
            projectIdentifys.add(param.getProjectIdentify());
        }
        return projectIdentifys;
    }

    private static List<Long> getWorkRoleIds(List<ValidateParamDto> validateParams) {
        ArrayList<Long> workRoleIds = new ArrayList<Long>(validateParams.size());
        for (ValidateParamDto validateParam : validateParams) {
            if (!workRoleIds.contains(validateParam.getRoleId())) {
                workRoleIds.add(validateParam.getRoleId());
            }
            if (validateParam.getOtherRoleIds() == null) continue;
            for (Long otherRole : validateParam.getOtherRoleIds()) {
                if (workRoleIds.contains(otherRole)) continue;
                workRoleIds.add(otherRole);
            }
        }
        return workRoleIds;
    }
}

