/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.domain.service.impl.common;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.ptmm.business.domain.service.common.PersonAboutService;
import kd.hr.ptmm.common.constants.member.TeamMemberHeadConstants;
import org.apache.http.util.Asserts;

public class PersonAboutServiceImpl
implements PersonAboutService,
TeamMemberHeadConstants {
    private static final Log LOG = LogFactory.getLog(PersonAboutServiceImpl.class);

    @Override
    public DynamicObject invokeGetPrimaryFile(Object personId) {
        Asserts.notNull((Object)personId, (String)"personId");
        DynamicObject erManFileDt = (DynamicObject)HRMServiceHelper.invokeBizService((String)"hr", (String)"hspm", (String)"IHSPMService", (String)"getPrimaryErmanfFile", (Object[])new Object[]{personId});
        Asserts.notNull((Object)erManFileDt, (String)"primaryErmanFile");
        return erManFileDt;
    }

    @Override
    public List<Map<String, Object>> invokeCardFields(List<Long> erManFileIds) {
        Asserts.check((!CollectionUtils.isEmpty(erManFileIds) ? 1 : 0) != 0, (String)"erManFileIds");
        List maps = (List)HRMServiceHelper.invokeBizService((String)"hr", (String)"hspm", (String)"IHSPMService", (String)"getCardFields", (Object[])new Object[]{erManFileIds});
        if (CollectionUtils.isEmpty((Collection)maps)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5230\u4eba\u5458\u5361\u7247\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PersonAboutServiceImpl_0", (String)"hr-ptmm-business", (Object[])new Object[0]));
        }
        return maps;
    }

    @Override
    public Map<String, Object> getTeamMemberHeadParam(Long personId) {
        DynamicObject erManFileDO = this.invokeGetPrimaryFile(personId);
        List<Map<String, Object>> maps = this.invokeCardFields(Collections.singletonList(erManFileDO.getLong("id")));
        Map<String, Object> personInfo = maps.get(0);
        HashMap headParam = Maps.newHashMapWithExpectedSize((int)16);
        headParam.put("headsculpture", personInfo.get("headsculpture"));
        headParam.put("name", personInfo.get("name"));
        headParam.put("number", personInfo.get("number"));
        headParam.put("laborreltype", personInfo.get("laborreltype"));
        headParam.put("laborrelstatus", personInfo.get("laborrelstatus"));
        headParam.put("positiontype", personInfo.get("postype"));
        headParam.put("gender", personInfo.get("gender"));
        headParam.put("company", personInfo.get("company"));
        headParam.put("dept", personInfo.get("adminorg"));
        headParam.put("position", personInfo.get("position"));
        headParam.put("stdposition", personInfo.get("stdposition"));
        headParam.put("job", personInfo.get("job"));
        headParam.put("apositiontype", personInfo.get("apositiontype"));
        headParam.put("phone", personInfo.get("phone"));
        headParam.put("email", personInfo.get("peremail"));
        return headParam;
    }

    @Override
    public List<Map<String, Object>> invokePersonAttaches(Long personId, String attachEntityName) {
        Asserts.notNull((Object)personId, (String)"personId");
        Asserts.check((!HRStringUtils.isEmpty((String)attachEntityName) ? 1 : 0) != 0, (String)"attachEntityName");
        LOG.info("invokePersonAttaches: personId:{},attachEntityName:{} start", (Object)personId, (Object)attachEntityName);
        List maps = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"listPersonAttachs", (Object[])new Object[]{personId, attachEntityName});
        return maps;
    }

    @Override
    public List<Map<String, Object>> invokePersonAttaches(List<Long> personIds, QFilter qFilter, String attachEntityName) {
        Asserts.check((!CollectionUtils.isEmpty(personIds) ? 1 : 0) != 0, (String)"personIds");
        Asserts.check((!HRStringUtils.isEmpty((String)attachEntityName) ? 1 : 0) != 0, (String)"attachEntityName");
        List maps = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"listBatchPersonAttachs", (Object[])new Object[]{personIds, qFilter, attachEntityName});
        return maps;
    }

    @Override
    public List<Map<String, Object>> getPersonContactInfo(List<Long> personIds) {
        Asserts.check((!CollectionUtils.isEmpty(personIds) ? 1 : 0) != 0, (String)"personIds");
        return this.invokePersonAttaches(personIds.get(0), "hrpi_percontact");
    }

    @Override
    public List<Map<String, Object>> getPersonEmrgContactInfo(List<Long> personIds) {
        Asserts.check((!CollectionUtils.isEmpty(personIds) ? 1 : 0) != 0, (String)"personIds");
        return this.invokePersonAttaches(personIds.get(0), "hrpi_emrgcontact");
    }

    @Override
    public List<Map<String, Object>> getPersonBasicInfo(List<Long> personIds) {
        Asserts.check((!CollectionUtils.isEmpty(personIds) ? 1 : 0) != 0, (String)"personIds");
        return this.invokePersonAttaches(personIds, null, "hrpi_pernontsprop");
    }
}

