/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.domain.service.impl.common;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.ptmm.business.domain.repository.ProjectTeamRepository;
import kd.hr.ptmm.business.domain.service.common.IProjectTeamService;

public class ProjectTeamServiceImpl
implements IProjectTeamService {
    private static ProjectTeamRepository projectTeamRepository = ProjectTeamRepository.getInstance();

    @Override
    public DynamicObject getProjectTeamById(long id) {
        return projectTeamRepository.loadSingle(id);
    }

    @Override
    public DynamicObject[] listProjectTeamByNumber(Collection<String> numbers) {
        QFilter curVersion = new QFilter("iscurrentversion", "=", (Object)"1");
        return projectTeamRepository.queryOriginalArray("id,number,belongadminorg", new QFilter[]{new QFilter("number", "in", numbers), curVersion});
    }

    @Override
    public DynamicObject[] listProjectTeamByIds(Collection<Long> ids) {
        QFilter curVersion = new QFilter("iscurrentversion", "=", (Object)"1");
        return projectTeamRepository.query("id,number,belongadminorg,projectname,projectnumber,projectidentify,rootprojectteam,rootprojectteam,structnumber", new QFilter[]{new QFilter("id", "in", ids), curVersion});
    }

    @Override
    public Map<String, DynamicObject> projectTeamMapByNumber(Collection<String> numbers) {
        return Arrays.stream(this.listProjectTeamByNumber(numbers)).collect(Collectors.toMap(obj -> obj.getString("number"), Function.identity(), (v1, v2) -> v1));
    }

    @Override
    public Map<Long, DynamicObject> listProjectTeamMapById(Collection<Long> ids) {
        return Arrays.stream(this.listProjectTeamByIds(ids)).collect(Collectors.toMap(obj -> obj.getLong("id"), Function.identity(), (v1, v2) -> v1));
    }

    @Override
    public Map<Long, DynamicObject> listProjectTeamRootTeamMapById(Collection<Long> ids) {
        Map<Long, DynamicObject> projectTeamMap = this.listProjectTeamMapById(ids);
        List<Long> rootProjectTeamIds = projectTeamMap.values().stream().map(obj -> obj.getLong("rootprojectteam.id")).collect(Collectors.toList());
        Map<Long, DynamicObject> rootProjectTeamMap = this.listProjectTeamMapById(rootProjectTeamIds);
        HashMap projectTeamRootTeam = Maps.newHashMapWithExpectedSize((int)projectTeamMap.size());
        projectTeamMap.forEach((projectTeamId, childTeam) -> projectTeamRootTeam.put(projectTeamId, rootProjectTeamMap.get(childTeam.getLong("rootprojectteam.id"))));
        return projectTeamRootTeam;
    }

    @Override
    public Map<Long, String> listProjectTeamProjectIdentify(Collection<Long> ids) {
        Map<Long, DynamicObject> projectTeamRootTeam = this.listProjectTeamRootTeamMapById(ids);
        HashMap projectTeamProjectIdentify = Maps.newHashMapWithExpectedSize((int)projectTeamRootTeam.size());
        projectTeamRootTeam.forEach((projectTeamId, rootProjectTeam) -> projectTeamProjectIdentify.put(projectTeamId, rootProjectTeam.getString("projectidentify")));
        return projectTeamProjectIdentify;
    }
}

