/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.domain.service.impl.common;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.ptmm.business.domain.repository.ProjectRoleRepository;
import kd.hr.ptmm.business.domain.repository.TeamMemberRoleRepository;
import kd.hr.ptmm.business.domain.repository.WorkRoleHrRepository;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.business.domain.service.common.IWorkRoleHrService;
import org.apache.commons.lang3.tuple.Pair;

public class WorkRoleHrServiceImpl
implements IWorkRoleHrService {
    private static final WorkRoleHrRepository WORK_ROLE_HR_REPOSITORY = WorkRoleHrRepository.getInstance();
    private static final HRBaseServiceHelper DUTY_WORK_ROLE_REPOSITORY = new HRBaseServiceHelper("hbpm_dutyworkroles");

    @Override
    public DynamicObject getWorkRoleHrById(long id) {
        return WORK_ROLE_HR_REPOSITORY.queryOne("id,position,mainpeoincharge", new QFilter[]{new QFilter("id", "=", (Object)id)});
    }

    public DynamicObject[] getWorkRoleHrById(Collection<Long> ids) {
        return WORK_ROLE_HR_REPOSITORY.queryOriginalArray("id,position.id position_id,mainpeoincharge", new QFilter[]{new QFilter("id", "in", ids)});
    }

    @Override
    public DynamicObject[] getWorkRoleHrByPositionId(List<Long> positionIds) {
        QFilter qFilter = new QFilter("position", "in", positionIds);
        QFilter isCurrentQFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return WORK_ROLE_HR_REPOSITORY.query("id,position", new QFilter[]{qFilter, isCurrentQFilter});
    }

    @Override
    public DynamicObject[] getRoleSuperPerson(long workRoleHrId, long projectTeamId) {
        DynamicObject workRoleHrObj = this.getWorkRoleHrById(workRoleHrId);
        long positionId = workRoleHrObj.getLong("position_id");
        DynamicObject projectRole = PTMMServiceFactory.projectRoleServcie.getProjectRoleById(positionId);
        long superRoleId = projectRole.getLong("superroles.id");
        if (superRoleId == 0L) {
            return new DynamicObject[0];
        }
        QFilter teamQFilter = new QFilter("projectteam.id", "=", (Object)projectTeamId);
        QFilter roleQFilter = new QFilter("projectrole.id", "=", (Object)superRoleId);
        QFilter serviceStatusQFilter = new QFilter("servicestate", "=", (Object)"B");
        return TeamMemberRoleRepository.getInstance().query("person,person.id,person.name", new QFilter[]{roleQFilter, teamQFilter, serviceStatusQFilter});
    }

    @Override
    public Map<Pair<Long, Long>, List<DynamicObject>> getSuperiorByRoleAndTeam(Map<Long, Long> paramRoleTeamMap) {
        DynamicObject[] workRoleHrObj = this.getWorkRoleHrById(paramRoleTeamMap.keySet());
        List<Long> positionIds = Arrays.stream(workRoleHrObj).map(obj -> obj.getLong("position_id")).collect(Collectors.toList());
        DynamicObject[] projectRole = PTMMServiceFactory.projectRoleServcie.listProjectRoleById(positionIds);
        Map<Long, Long> superRoles = Arrays.stream(projectRole).collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj.getLong("superroles"), (v1, v2) -> v1));
        QFilter teamQFilter = new QFilter("projectteam.id", "in", paramRoleTeamMap.values());
        QFilter roleQFilter = new QFilter("projectrole.id", "in", superRoles.values());
        QFilter serviceStatusQFilter = new QFilter("servicestate", "=", (Object)"B");
        DynamicObject[] projectRoleObj = TeamMemberRoleRepository.getInstance().query("person,person.id,person.name,projectteam,projectrole", new QFilter[]{roleQFilter, teamQFilter, serviceStatusQFilter});
        Map<Pair, List<DynamicObject>> dbRoleTeamMap = Arrays.stream(projectRoleObj).collect(Collectors.groupingBy(obj -> Pair.of((Object)obj.getLong("projectrole.id"), (Object)obj.getLong("projectteam.id"))));
        HashMap result = Maps.newHashMapWithExpectedSize((int)paramRoleTeamMap.size());
        paramRoleTeamMap.forEach((roleId, teamId) -> {
            Long superRoleId = (Long)superRoles.get(roleId);
            Pair key = Pair.of((Object)superRoleId, (Object)teamId);
            result.put(Pair.of((Object)roleId, (Object)teamId), dbRoleTeamMap.get(key));
        });
        return result;
    }

    @Override
    public List<Long> getRoleSuperPersonIds(long workRoleHrId, long projectTeamId) {
        DynamicObject[] roleSuperPerson = this.getRoleSuperPerson(workRoleHrId, projectTeamId);
        return Arrays.stream(roleSuperPerson).map(obj -> obj.getLong("person.id")).collect(Collectors.toList());
    }

    @Override
    public Map<Long, Long> getProjectRoleByWorkRole(List<DynamicObject> workRoleDOs) {
        return this.getPositionByWorkRole(workRoleDOs);
    }

    @Override
    public Long getProjectRoleByWorkRole(DynamicObject workRoleDO) {
        Map<Long, Long> projectRoleByWorkRole = this.getProjectRoleByWorkRole(Collections.singletonList(workRoleDO));
        if (projectRoleByWorkRole == null || projectRoleByWorkRole.isEmpty()) {
            return 0L;
        }
        return projectRoleByWorkRole.get(workRoleDO.getLong("id"));
    }

    @Override
    public Map<Long, Long> getPositionByWorkRole(List<DynamicObject> workRoleDOs) {
        if (workRoleDOs.stream().allMatch(workRoleDO -> Objects.isNull(workRoleDO.getDynamicObjectType().getProperty("position")))) {
            List<Long> workRoleIdList = workRoleDOs.stream().map(workRole -> workRole.getLong("id")).collect(Collectors.toList());
            workRoleDOs = Arrays.asList(this.getWorkRoleHrDOs(workRoleIdList, "position"));
        }
        return workRoleDOs.stream().collect(Collectors.toMap(workRole -> workRole.getLong("id"), workRole -> workRole.getLong("position.id"), (v1, v2) -> v1));
    }

    private DynamicObject[] getWorkRoleHrDOs(List<Long> workRoleIdList, String selectProperties) {
        return WORK_ROLE_HR_REPOSITORY.query(selectProperties, new QFilter[]{new QFilter("id", "in", workRoleIdList)});
    }

    @Override
    public Map<Long, Long> getPositionByWorkRoleIds(List<Long> workRoleIdList) {
        List<DynamicObject> workRoleDOs = Arrays.asList(this.getWorkRoleHrDOs(workRoleIdList, "position"));
        return workRoleDOs.stream().collect(Collectors.toMap(workRole -> workRole.getLong("id"), workRole -> workRole.getLong("position.id"), (v1, v2) -> v1));
    }

    @Override
    public List<Long> getPositionListByWorkRoleIds(List<Long> workRoleIdList) {
        List<DynamicObject> workRoleDOs = Arrays.asList(this.getWorkRoleHrDOs(workRoleIdList, "position"));
        return workRoleDOs.stream().map(workRole -> workRole.getLong("position.id")).collect(Collectors.toList());
    }

    @Override
    public DynamicObject[] listWorkRoleByNumber(Collection<String> numbers) {
        QFilter curVersion = new QFilter("iscurrentversion", "=", (Object)"1");
        return WORK_ROLE_HR_REPOSITORY.queryOriginalArray("id,number,adminorg", new QFilter[]{new QFilter("number", "in", numbers), curVersion});
    }

    @Override
    public DynamicObject[] listWorkRoleById(Collection<Long> ids) {
        QFilter curVersion = new QFilter("iscurrentversion", "=", (Object)"1");
        return WORK_ROLE_HR_REPOSITORY.queryOriginalArray("id,number,adminorg,mainpeoincharge", new QFilter[]{new QFilter("id", "in", ids), curVersion});
    }

    @Override
    public Map<String, DynamicObject> projectRoleMapByNumber(Collection<String> numbers) {
        return Arrays.stream(this.listWorkRoleByNumber(numbers)).collect(Collectors.toMap(obj -> obj.getString("number"), Function.identity(), (v1, v2) -> v1));
    }

    @Override
    public Map<Long, DynamicObject> listProjectRoleMapById(Collection<Long> ids) {
        return Arrays.stream(this.listWorkRoleById(ids)).collect(Collectors.toMap(obj -> obj.getLong("id"), Function.identity(), (v1, v2) -> v1));
    }

    @Override
    public Map<String, DynamicObject> getWorkRoleByProjectRoleNum(List<String> projectRoleNumList) {
        if (CollectionUtils.isEmpty(projectRoleNumList)) {
            return Collections.emptyMap();
        }
        QFilter projectRoleQFilter = new QFilter("number", "in", projectRoleNumList);
        projectRoleQFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        DynamicObject[] projectRoleDOList = ProjectRoleRepository.getInstance().query("id", projectRoleQFilter.toArray());
        if (projectRoleDOList.length == 0) {
            return Collections.emptyMap();
        }
        QFilter workRoleQFilter = new QFilter("position", "in", (Object)Arrays.stream(projectRoleDOList).map(dynamicObject -> dynamicObject.get("id")).toArray());
        workRoleQFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        DynamicObject[] workRoleDOList = WORK_ROLE_HR_REPOSITORY.query("id,number,name,position.id,adminorg.id", workRoleQFilter.toArray());
        HashMap map = Maps.newHashMapWithExpectedSize((int)projectRoleNumList.size());
        for (DynamicObject workRoleDO : workRoleDOList) {
            long position = workRoleDO.getLong("position.id");
            Arrays.stream(projectRoleDOList).filter(projectRoleDOTemp -> projectRoleDOTemp.getLong("id") == position).findFirst().ifPresent(projectRoleDO -> map.put(projectRoleDO.getString("number"), workRoleDO));
        }
        return map;
    }

    @Override
    public List<Long> convertProjectRole2WorkRole(List<Long> projectRoleIdList) {
        return new ArrayList<Long>(this.getWorkRoleByProjectRole(projectRoleIdList).values());
    }

    @Override
    public Map<Long, Long> getWorkRoleByProjectRole(List<Long> projectRoleIdList) {
        if (CollectionUtils.isEmpty(projectRoleIdList)) {
            return Collections.emptyMap();
        }
        Object[] dutyWorkRoleIdArr = Arrays.stream(DUTY_WORK_ROLE_REPOSITORY.query(new QFilter("id", "in", projectRoleIdList).toArray())).map(dynamicObject -> dynamicObject.getLong("id")).toArray();
        QFilter workRoleQFilter = new QFilter("position", "in", (Object)dutyWorkRoleIdArr);
        QFilter isCurrentQFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return Arrays.stream(WORK_ROLE_HR_REPOSITORY.query("id,position", new QFilter[]{workRoleQFilter, isCurrentQFilter})).collect(Collectors.toMap(workRoleDO -> workRoleDO.getLong("position.id"), worRoleDO -> worRoleDO.getLong("id"), (d1, d2) -> d1));
    }
}

