/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.domain.status.util;

import com.alibaba.fastjson.JSONObject;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.ptmm.business.domain.status.dto.ProjectTemaRoleInfoDto;
import kd.hr.ptmm.business.domain.status.dto.ValidateMsg;
import kd.hr.ptmm.business.domain.status.dto.ValidateParamDto;
import kd.hr.ptmm.business.domain.status.dto.ValidateResDto;
import kd.hr.ptmm.business.test.BillExtPoint4TeamMemberRoleTest;
import kd.hr.ptmm.common.entity.TimePeriod;
import kd.hr.ptmm.common.enums.AdjustEntryEnum;
import kd.hr.ptmm.common.enums.AdjustTypeEnum;
import kd.hr.ptmm.common.enums.PTMMValidateTypeEnum;
import kd.hr.ptmm.common.util.ObjectUtils;
import kd.hr.ptmm.common.util.TimePeriodCalcUtils;
import kd.sdk.hr.ptmm.IBillExPoint;

public class PTMMBuisinessCheckUtils {
    private static final Log LOGGER = LogFactory.getLog(PTMMBuisinessCheckUtils.class);
    private static String MSGTYPE_ERROR = "error";
    private static String MSGTYPE_WARN = "warn";
    private static String FMT_DATE = "yyyy-MM-dd";

    public static List<ValidateResDto> businessCheck(List<ValidateParamDto> validateParams) {
        ArrayList<ValidateResDto> addValidateRes = new ArrayList<ValidateResDto>();
        for (ValidateParamDto param : validateParams) {
            ValidateResDto addCheckRes = PTMMBuisinessCheckUtils.newValidateResSetUtilsInfo(param);
            List<ValidateMsg> checkMsgs = new ArrayList<ValidateMsg>();
            List<ValidateMsg> inAndQuitTimeCheckMsg = PTMMBuisinessCheckUtils.personInAndQuitTimeCheck(param);
            checkMsgs.addAll(inAndQuitTimeCheckMsg);
            List<ValidateMsg> quitBillCheckMsg = PTMMBuisinessCheckUtils.personQuitBillCheck(param);
            checkMsgs.addAll(quitBillCheckMsg);
            List<ValidateMsg> projectTeamCheckMsg = PTMMBuisinessCheckUtils.projectTeamCheck(param);
            checkMsgs.addAll(projectTeamCheckMsg);
            List<ValidateMsg> projectRoleCheckMsg = PTMMBuisinessCheckUtils.projectRoleCheck(param);
            checkMsgs.addAll(projectRoleCheckMsg);
            List<ValidateMsg> billCheckMsg = PTMMBuisinessCheckUtils.billBusinessCheck(param, validateParams);
            LOGGER.info("PTMMBuisinessCheckUtils, billCheckMsg is : [{}]", (Object)JSONObject.toJSONString(billCheckMsg));
            checkMsgs = PTMMBuisinessCheckUtils.setCheckMsgs(checkMsgs, billCheckMsg);
            List<ValidateMsg> teamMemberBusinessCheck = PTMMBuisinessCheckUtils.teamMemberBusinessCheck(param);
            LOGGER.info("PTMMBuisinessCheckUtils, teamMemberBusinessCheck is : [{}]", (Object)JSONObject.toJSONString(teamMemberBusinessCheck));
            checkMsgs = PTMMBuisinessCheckUtils.setCheckMsgs(checkMsgs, teamMemberBusinessCheck);
            addCheckRes.setMsgs(checkMsgs);
            if (addCheckRes.getMsgs().size() == 0) continue;
            addValidateRes.add(addCheckRes);
        }
        LOGGER.info("PTMMBuisinessCheckUtils, businessCheck result is : [{}]", (Object)JSONObject.toJSONString(addValidateRes));
        return addValidateRes;
    }

    private static List<ValidateMsg> setCheckMsgs(List<ValidateMsg> checkMsgs, List<ValidateMsg> checkInfos) {
        for (ValidateMsg checkInfo : checkInfos) {
            boolean checkMsgCodeRepeat = PTMMBuisinessCheckUtils.checkValidateMsgRepeat(checkMsgs, checkInfo);
            boolean checkMainRoleInfoRepeat = PTMMBuisinessCheckUtils.checkValidateMainRoleMsg(checkMsgs, checkInfo);
            if (checkMsgCodeRepeat || checkMainRoleInfoRepeat) continue;
            checkMsgs.add(checkInfo);
        }
        return checkMsgs;
    }

    public static List<ValidateResDto> addBusinessCheck(List<ValidateParamDto> validateParams) {
        ArrayList<ValidateResDto> addValidateRes = new ArrayList<ValidateResDto>();
        for (ValidateParamDto param : validateParams) {
            ValidateResDto addCheckRes = PTMMBuisinessCheckUtils.newValidateResSetUtilsInfo(param);
            ArrayList<ValidateMsg> checkMsgs = new ArrayList<ValidateMsg>();
            List<ValidateMsg> inAndQuitTimeCheckMsg = PTMMBuisinessCheckUtils.personInAndQuitTimeCheck(param);
            checkMsgs.addAll(inAndQuitTimeCheckMsg);
            List<ValidateMsg> quitBillCheckMsg = PTMMBuisinessCheckUtils.personQuitBillCheck(param);
            checkMsgs.addAll(quitBillCheckMsg);
            List<ValidateMsg> projectTeamCheckMsg = PTMMBuisinessCheckUtils.projectTeamCheck(param);
            checkMsgs.addAll(projectTeamCheckMsg);
            List<ValidateMsg> projectRoleCheckMsg = PTMMBuisinessCheckUtils.projectRoleCheck(param);
            checkMsgs.addAll(projectRoleCheckMsg);
            List<ValidateMsg> billCheckMsg = PTMMBuisinessCheckUtils.billBusinessCheck(param, validateParams);
            checkMsgs.addAll(billCheckMsg);
            List<ValidateMsg> teamMemberBusinessCheck = PTMMBuisinessCheckUtils.teamMemberBusinessCheck(param);
            checkMsgs.addAll(teamMemberBusinessCheck);
            addCheckRes.setMsgs(checkMsgs);
            if (addCheckRes.getMsgs().size() == 0) continue;
            addValidateRes.add(addCheckRes);
        }
        return addValidateRes;
    }

    public static List<ValidateResDto> editBusinessCheck(List<ValidateParamDto> validateParams) {
        ArrayList<ValidateResDto> editValidateRes = new ArrayList<ValidateResDto>();
        for (ValidateParamDto param : validateParams) {
            ValidateResDto editCheckRes = PTMMBuisinessCheckUtils.newValidateResSetUtilsInfo(param);
            ArrayList<ValidateMsg> checkMsgs = new ArrayList<ValidateMsg>();
            List<ValidateMsg> inAndQuitTimeCheckMsg = PTMMBuisinessCheckUtils.personInAndQuitTimeCheck(param);
            checkMsgs.addAll(inAndQuitTimeCheckMsg);
            List<ValidateMsg> quitBillCheckMsg = PTMMBuisinessCheckUtils.personQuitBillCheck(param);
            checkMsgs.addAll(quitBillCheckMsg);
            List<ValidateMsg> projectTeamCheckMsg = PTMMBuisinessCheckUtils.projectTeamCheck(param);
            checkMsgs.addAll(projectTeamCheckMsg);
            List<ValidateMsg> projectRoleCheckMsg = PTMMBuisinessCheckUtils.projectRoleCheck(param);
            checkMsgs.addAll(projectRoleCheckMsg);
            List<ValidateMsg> billCheckMsg = PTMMBuisinessCheckUtils.billBusinessCheck(param, validateParams);
            checkMsgs.addAll(billCheckMsg);
            List<ValidateMsg> teamMemberBusinessCheck = PTMMBuisinessCheckUtils.teamMemberBusinessCheck(param);
            checkMsgs.addAll(teamMemberBusinessCheck);
            editCheckRes.setValidateIndex(param.getValidateIndex());
            editCheckRes.setMsgs(checkMsgs);
            if (editCheckRes.getMsgs().size() == 0) continue;
            editValidateRes.add(editCheckRes);
        }
        return editValidateRes;
    }

    public static List<ValidateResDto> outBusinessCheck(List<ValidateParamDto> validateParams) {
        ArrayList<ValidateResDto> outValidateRes = new ArrayList<ValidateResDto>();
        for (ValidateParamDto param : validateParams) {
            ValidateResDto outCheckRes = PTMMBuisinessCheckUtils.newValidateResSetUtilsInfo(param);
            ArrayList<ValidateMsg> checkMsgs = new ArrayList<ValidateMsg>();
            List<ValidateMsg> inAndQuitTimeCheckMsg = PTMMBuisinessCheckUtils.personInAndQuitTimeCheck(param);
            checkMsgs.addAll(inAndQuitTimeCheckMsg);
            List<ValidateMsg> quitBillCheckMsg = PTMMBuisinessCheckUtils.personQuitBillCheck(param);
            checkMsgs.addAll(quitBillCheckMsg);
            List<ValidateMsg> projectTeamCheckMsg = PTMMBuisinessCheckUtils.projectTeamCheck(param);
            checkMsgs.addAll(projectTeamCheckMsg);
            List<ValidateMsg> billCheckMsg = PTMMBuisinessCheckUtils.billBusinessCheck(param, validateParams);
            checkMsgs.addAll(billCheckMsg);
            List<ValidateMsg> teamMemberBusinessCheck = PTMMBuisinessCheckUtils.teamMemberBusinessCheck(param);
            checkMsgs.addAll(teamMemberBusinessCheck);
            outCheckRes.setMsgs(checkMsgs);
            if (outCheckRes.getMsgs().size() == 0) continue;
            outValidateRes.add(outCheckRes);
        }
        return outValidateRes;
    }

    private static ValidateResDto newValidateResSetUtilsInfo(ValidateParamDto param) {
        ValidateResDto checkRes = new ValidateResDto();
        checkRes.setValidateIndex(param.getValidateIndex());
        checkRes.setPersonId(param.getPersonId());
        checkRes.setPersonName(param.getPersonName());
        checkRes.setTeamId(param.getTeamId());
        checkRes.setRoleId(param.getRoleId());
        checkRes.setPersonNum(param.getPersonNum());
        checkRes.setTeamName(param.getTeamName());
        checkRes.setRoleName(param.getRoleName());
        checkRes.setAdjustType(AdjustTypeEnum.getEnumByType((AdjustEntryEnum)param.getValidateType()).getCode());
        return checkRes;
    }

    private static List<ValidateMsg> personInAndQuitTimeCheck(ValidateParamDto param) {
        ArrayList<ValidateMsg> msgs = new ArrayList<ValidateMsg>();
        Date inStartDate = param.getInStartDate();
        Date quitDate = param.getQuitDate();
        Date effectDate = param.getEffectTime();
        if (inStartDate == null || effectDate == null) {
            LOGGER.error("personInAndQuitTimeCheck HRPI person have no inStartDate and quitDate\uff0c personid is : [{}]", (Object)param.getPersonId().toString());
            return msgs;
        }
        boolean isQuiteBeforEffect = HRDateTimeUtils.dayBefore((Date)quitDate, (Date)effectDate);
        boolean isEffectBeforInDate = HRDateTimeUtils.dayBefore((Date)effectDate, (Date)inStartDate);
        String logInfo = String.format("personInAndQuitTimeCheck billId is : [%s]; personid is [%s];inStartDate is[%s];quitDate is [%s],effectDate is[%s]", param.getBillId().toString(), param.getPersonId().toString(), PTMMBuisinessCheckUtils.getTimeStr(inStartDate), PTMMBuisinessCheckUtils.getTimeStr(quitDate), PTMMBuisinessCheckUtils.getTimeStr(effectDate));
        LOGGER.info(logInfo);
        boolean isQuitOrNot = param.isQuitOrNot();
        if (param.getValidateType() == AdjustEntryEnum.JOIN) {
            ValidateMsg msg;
            if (isQuiteBeforEffect && isQuitOrNot) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Add_5", param, param.getRoleName(), inStartDate, quitDate);
                msgs.add(msg);
            } else if (!isQuiteBeforEffect && isQuitOrNot) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Add_4", param, param.getRoleName(), inStartDate, quitDate);
                msgs.add(msg);
            }
            if (isEffectBeforInDate) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Add_6", param, param.getRoleName(), inStartDate, quitDate);
                msgs.add(msg);
            }
        } else if (param.getValidateType() == AdjustEntryEnum.QUIT) {
            ValidateMsg msg;
            if (isQuiteBeforEffect && isQuitOrNot) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Out_6", param, param.getRoleName(), inStartDate, quitDate);
                msgs.add(msg);
            }
            if (isEffectBeforInDate) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Out_8", param, param.getRoleName(), inStartDate, quitDate);
                msgs.add(msg);
            }
        } else {
            ValidateMsg msg;
            if (isQuiteBeforEffect && isQuitOrNot) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Edit_7", param, param.getRoleName(), inStartDate, quitDate);
                msgs.add(msg);
            } else if (!isQuiteBeforEffect && isQuitOrNot) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Edit_6", param, param.getRoleName(), inStartDate, quitDate);
                msgs.add(msg);
            }
            if (isEffectBeforInDate) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Edit_1", param, param.getRoleName(), inStartDate, quitDate);
                msgs.add(msg);
            }
        }
        return msgs;
    }

    private static List<ValidateMsg> personQuitBillCheck(ValidateParamDto param) {
        ArrayList<ValidateMsg> msgs = new ArrayList<ValidateMsg>();
        if (!param.isHaveQuitBill()) {
            return msgs;
        }
        Date quitEffectDate = Date.from(Instant.ofEpochMilli(param.getQuitEffectTime()));
        LOGGER.info("personQuitBillCheck billId is : [{}] ; person :[{}] quitEffectDate : [{}]", new Object[]{param.getBillId().toString(), param.getPersonId().toString(), PTMMBuisinessCheckUtils.getTimeStr(quitEffectDate)});
        Date effectDate = param.getEffectTime();
        LOGGER.info("personQuitBillCheck billId is : [{}] ; person :[{}] effectDate : [{}]", new Object[]{param.getBillId().toString(), param.getPersonId().toString(), PTMMBuisinessCheckUtils.getTimeStr(effectDate)});
        boolean isEffectDatAfterQuitDate = HRDateTimeUtils.dayAfter((Date)effectDate, (Date)quitEffectDate);
        if (param.getValidateType() == AdjustEntryEnum.JOIN) {
            if (isEffectDatAfterQuitDate) {
                ValidateMsg msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Add_3", param, param.getRoleName(), quitEffectDate, quitEffectDate);
                msgs.add(msg);
            } else {
                ValidateMsg msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Add_2", param, param.getRoleName(), quitEffectDate, quitEffectDate);
                msgs.add(msg);
            }
        } else if (param.getValidateType() == AdjustEntryEnum.QUIT) {
            if (isEffectDatAfterQuitDate) {
                ValidateMsg msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Out_5", param, param.getRoleName(), quitEffectDate, quitEffectDate);
                msgs.add(msg);
            }
        } else if (isEffectDatAfterQuitDate) {
            ValidateMsg msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Edit_5", param, param.getRoleName(), quitEffectDate, quitEffectDate);
            msgs.add(msg);
        } else {
            ValidateMsg msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Edit_4", param, param.getRoleName(), quitEffectDate, quitEffectDate);
            msgs.add(msg);
        }
        return msgs;
    }

    private static List<ValidateMsg> projectTeamCheck(ValidateParamDto param) {
        ValidateMsg msg;
        boolean isHaveTeam;
        ArrayList<ValidateMsg> msgs = new ArrayList<ValidateMsg>();
        Date teamStartDate = param.getTeamStartDate();
        Date teamEndtDate = param.getTeamEndDate();
        Date effectDate = param.getEffectTime();
        boolean isEffectDatBeforeTeamStartDate = false;
        boolean isTeamEndtDateBeforeEffectDate = false;
        if (param.getProjectTeamInfo() == null) {
            isHaveTeam = false;
        } else {
            isHaveTeam = true;
            isEffectDatBeforeTeamStartDate = HRDateTimeUtils.dayBefore((Date)effectDate, (Date)teamStartDate);
            isTeamEndtDateBeforeEffectDate = HRDateTimeUtils.dayBefore((Date)teamEndtDate, (Date)effectDate);
            String logInfo = String.format("projectTeamCheck billId is : [%s]; personid is [%s];teamId is [%s];teamStartDate is[%s];teamEndtDate is [%s],effectDate is[%s]", param.getBillId().toString(), param.getPersonId().toString(), param.getTeamId().toString(), PTMMBuisinessCheckUtils.getTimeStr(teamStartDate), PTMMBuisinessCheckUtils.getTimeStr(teamEndtDate), PTMMBuisinessCheckUtils.getTimeStr(effectDate));
            LOGGER.info(logInfo);
        }
        if (param.getValidateType() == AdjustEntryEnum.JOIN) {
            if (!isHaveTeam || isEffectDatBeforeTeamStartDate || isTeamEndtDateBeforeEffectDate) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Add_1", param, param.getRoleName(), teamStartDate, teamEndtDate);
                msgs.add(msg);
            }
        } else if (param.getValidateType() == AdjustEntryEnum.QUIT) {
            if (!isHaveTeam || isEffectDatBeforeTeamStartDate || isTeamEndtDateBeforeEffectDate) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Out_4", param, param.getRoleName(), teamStartDate, teamEndtDate);
                msgs.add(msg);
            }
        } else if (!isHaveTeam || isEffectDatBeforeTeamStartDate || isTeamEndtDateBeforeEffectDate) {
            msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Edit_3", param, param.getRoleName(), teamStartDate, teamEndtDate);
            msgs.add(msg);
        }
        return msgs;
    }

    private static List<ValidateMsg> projectRoleCheck(ValidateParamDto param) {
        boolean isHaveRole;
        ArrayList<ValidateMsg> msgs = new ArrayList<ValidateMsg>();
        Date roleStartDate = param.getRoleStartDate();
        LOGGER.info("projectRoleCheck billId is : [{}] ; person :[{}] roleStartDate : [{}]", new Object[]{param.getBillId().toString(), param.getPersonId().toString(), PTMMBuisinessCheckUtils.getTimeStr(roleStartDate)});
        Date roleEndtDate = param.getRoleEndDate();
        LOGGER.info("projectRoleCheck billId is : [{}] ; person :[{}] roleEndtDate : [{}]", new Object[]{param.getBillId().toString(), param.getPersonId().toString(), PTMMBuisinessCheckUtils.getTimeStr(roleEndtDate)});
        Date effectDate = param.getEffectTime();
        LOGGER.info("projectRoleCheck billId is : [{}] ; person :[{}] effectDate : [{}]", new Object[]{param.getBillId().toString(), param.getPersonId().toString(), PTMMBuisinessCheckUtils.getTimeStr(effectDate)});
        boolean isEffectDatBeforeRoleStartDate = false;
        boolean isRoleEndtDateBeforeEffectDate = false;
        if (param.getProjectTemaRoleInfo() == null) {
            isHaveRole = false;
        } else {
            isHaveRole = true;
            isEffectDatBeforeRoleStartDate = HRDateTimeUtils.dayBefore((Date)effectDate, (Date)roleStartDate);
            isRoleEndtDateBeforeEffectDate = HRDateTimeUtils.dayBefore((Date)roleEndtDate, (Date)effectDate);
        }
        if (param.getValidateType() == AdjustEntryEnum.JOIN) {
            if (!isHaveRole || isEffectDatBeforeRoleStartDate || isRoleEndtDateBeforeEffectDate) {
                ValidateMsg msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Add_7", param, param.getRoleName(), roleStartDate, roleEndtDate);
                msgs.add(msg);
            }
            for (ProjectTemaRoleInfoDto otherRole : param.getProjectTemaOtherRoleInfo()) {
                if (!otherRole.isHaveRoleInCheckTime()) {
                    LOGGER.info("projectRoleCheck otherRoleCheck have no otherRole");
                    ValidateMsg msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Add_7", param, otherRole.getProjectRoleName(), null, null);
                    msgs.add(msg);
                    continue;
                }
                Date otherRoleStartDate = otherRole.getStartDate();
                Date otherRoleEndtDate = otherRole.getEndDate();
                LOGGER.info("projectRoleCheck otherRoleCheck billId is : [{}] ; otherRoleStartDate :[{}] otherRoleEndDate : [{}]", new Object[]{param.getBillId().toString(), PTMMBuisinessCheckUtils.getTimeStr(otherRoleStartDate), PTMMBuisinessCheckUtils.getTimeStr(otherRoleEndtDate)});
                boolean isEffectDatBeforeOtherRoleStartDate = HRDateTimeUtils.dayBefore((Date)effectDate, (Date)otherRoleStartDate);
                boolean isOtherRoleEndtDateBeforeEffectDate = HRDateTimeUtils.dayBefore((Date)otherRoleEndtDate, (Date)effectDate);
                if (!isEffectDatBeforeOtherRoleStartDate && !isOtherRoleEndtDateBeforeEffectDate) continue;
                ValidateMsg msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Add_7", param, otherRole.getProjectRoleName(), otherRoleStartDate, otherRoleEndtDate);
                msgs.add(msg);
            }
        } else if (param.getValidateType() != AdjustEntryEnum.QUIT && param.getValidateType() != AdjustEntryEnum.ADJUST_QUIT && (!isHaveRole || isEffectDatBeforeRoleStartDate || isRoleEndtDateBeforeEffectDate)) {
            ValidateMsg msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Edit_8", param, param.getRoleName(), roleStartDate, roleEndtDate);
            msgs.add(msg);
        }
        return msgs;
    }

    private static List<ValidateMsg> billBusinessCheck(ValidateParamDto checkParam, List<ValidateParamDto> validateParams) {
        ArrayList<ValidateMsg> msgs = new ArrayList<ValidateMsg>();
        for (ValidateParamDto otherParam : validateParams) {
            ValidateMsg msg;
            if (checkParam.getValidateType() == AdjustEntryEnum.JOIN) {
                if (checkParam.isIsprincipal() && checkParam.getPersonId().equals(otherParam.getPersonId()) && otherParam.isIsprincipal() && checkParam.getValidateIndex() != otherParam.getValidateIndex() && !PTMMBuisinessCheckUtils.checkValidateMsgRepeat(msgs, msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Add_10B", checkParam, checkParam.getRoleName(), null, null)) && !PTMMBuisinessCheckUtils.checkValidateMainRoleMsg(msgs, msg)) {
                    msgs.add(msg);
                }
                if (!PTMMBuisinessCheckUtils.checkAddandEditAtoB(checkParam, otherParam)) continue;
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("JOIN_ADJUST_ADJ_12", checkParam, checkParam.getRoleName(), null, null);
                msgs.add(msg);
                continue;
            }
            if (checkParam.getValidateType() == AdjustEntryEnum.QUIT) {
                if (PTMMBuisinessCheckUtils.checkQuitandEditAtoB(checkParam, otherParam)) {
                    msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("JOIN_ADJUST_ADJ_29", checkParam, checkParam.getRoleName(), null, null);
                    msgs.add(msg);
                }
                if (PTMMBuisinessCheckUtils.checkQuitandEditQuit(checkParam, otherParam)) {
                    msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("QUIT_ADJUST_QUIT_30", checkParam, checkParam.getRoleName(), null, null);
                    msgs.add(msg);
                }
                if (!PTMMBuisinessCheckUtils.checkEditAddRoleAndQuitBill(checkParam, otherParam) || PTMMBuisinessCheckUtils.checkValidateMsgRepeat(msgs, msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("ADJUST_JOIN_AND_QUIT_31", checkParam, checkParam.getRoleName(), otherParam.getEffectTime(), checkParam.getEffectTime()))) continue;
                msgs.add(msg);
                continue;
            }
            if (checkParam.getValidateType() == AdjustEntryEnum.ADJUST_JOIN) {
                if (checkParam.isIsprincipal() && checkParam.getPersonId().equals(otherParam.getPersonId()) && checkParam.getValidateIndex() != otherParam.getValidateIndex() && checkParam.getValidateType() != AdjustEntryEnum.ADJUST_QUIT && otherParam.isIsprincipal() && !PTMMBuisinessCheckUtils.checkValidateMsgRepeat(msgs, msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Edit_11B", checkParam, checkParam.getRoleName(), null, null)) && !PTMMBuisinessCheckUtils.checkValidateMainRoleMsg(msgs, msg)) {
                    msgs.add(msg);
                }
                if (otherParam.getValidateType() == AdjustEntryEnum.ADJUST_ADJ && checkParam.getPersonId().equals(otherParam.getPersonId()) && checkParam.getRoleId().equals(otherParam.getRoleId()) && !PTMMBuisinessCheckUtils.checkValidateMsgRepeat(msgs, msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Edit_15", checkParam, checkParam.getRoleName(), null, null))) {
                    msgs.add(msg);
                }
                if (!PTMMBuisinessCheckUtils.checkEditAddRoleAndQuitBill(checkParam, otherParam)) continue;
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("ADJUST_JOIN_AND_QUIT_31", checkParam, checkParam.getRoleName(), checkParam.getEffectTime(), otherParam.getEffectTime());
                msgs.add(msg);
                continue;
            }
            if (checkParam.getValidateType() == AdjustEntryEnum.ADJUST_ADJ) {
                if (checkParam.isIsprincipal() && checkParam.getPersonId().equals(otherParam.getPersonId()) && checkParam.getValidateIndex() != otherParam.getValidateIndex() && checkParam.getValidateType() != AdjustEntryEnum.ADJUST_QUIT && otherParam.isIsprincipal() && !PTMMBuisinessCheckUtils.checkValidateMsgRepeat(msgs, msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Edit_11B", checkParam, checkParam.getRoleName(), null, null)) && !PTMMBuisinessCheckUtils.checkValidateMainRoleMsg(msgs, msg)) {
                    msgs.add(msg);
                }
                if (PTMMBuisinessCheckUtils.checkAddandEditAtoB(checkParam, otherParam)) {
                    msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("JOIN_ADJUST_ADJ_12", checkParam, null, null, null);
                    msgs.add(msg);
                }
                if (PTMMBuisinessCheckUtils.checkQuitandEditAtoB(checkParam, otherParam)) {
                    msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("JOIN_ADJUST_ADJ_29", checkParam, checkParam.getRoleName(), null, null);
                    msgs.add(msg);
                }
                if (PTMMBuisinessCheckUtils.checkEditAddRoleAndQuitBill(checkParam, otherParam)) {
                    msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("ADJUST_JOIN_AND_QUIT_31", checkParam, checkParam.getRoleName(), checkParam.getEffectTime(), otherParam.getEffectTime());
                    msgs.add(msg);
                }
                if (otherParam.getValidateType() == AdjustEntryEnum.ADJUST_JOIN && checkParam.getPersonId().equals(otherParam.getPersonId()) && checkParam.getRoleId().equals(otherParam.getRoleId()) && !PTMMBuisinessCheckUtils.checkValidateMsgRepeat(msgs, msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Edit_15", checkParam, checkParam.getRoleName(), null, null))) {
                    msgs.add(msg);
                }
                if (otherParam.getValidateType() != AdjustEntryEnum.ADJUST_QUIT || !checkParam.getPersonId().equals(otherParam.getPersonId()) || !checkParam.getBeforeRoleId().equals(otherParam.getRoleId())) continue;
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Edit_16", checkParam, checkParam.getBeforeRoleName(), null, null);
                msgs.add(msg);
                continue;
            }
            if (checkParam.getValidateType() != AdjustEntryEnum.ADJUST_QUIT) continue;
            if (otherParam.getValidateType() == AdjustEntryEnum.ADJUST_ADJ && checkParam.getPersonId().equals(otherParam.getPersonId()) && checkParam.getRoleId().equals(otherParam.getBeforeRoleId())) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Edit_16", checkParam, checkParam.getRoleName(), null, null);
                msgs.add(msg);
            }
            if (!PTMMBuisinessCheckUtils.checkQuitandEditQuit(checkParam, otherParam)) continue;
            msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("QUIT_ADJUST_QUIT_30", checkParam, checkParam.getRoleName(), null, null);
            msgs.add(msg);
        }
        return msgs;
    }

    private static boolean checkValidateMsgRepeat(List<ValidateMsg> validateMsgs, ValidateMsg addMsg) {
        boolean checkRes = false;
        for (ValidateMsg validateMsg : validateMsgs) {
            if (!validateMsg.getPersonId().equals(addMsg.getPersonId()) || !validateMsg.getMsgCode().equals(addMsg.getMsgCode())) continue;
            checkRes = true;
        }
        return checkRes;
    }

    private static boolean checkValidateMainRoleMsg(List<ValidateMsg> validateMsgs, ValidateMsg addMsg) {
        boolean checkRes = false;
        LOGGER.info("PTMMBuisinessCheckUtils, checkValidateMainRoleMsg validateMsgs is : [{}]\u3000addMsg\u3000 is : [{}]", (Object)JSONObject.toJSONString(validateMsgs), (Object)JSONObject.toJSONString((Object)addMsg));
        if (!(addMsg.getMsgCode().equals("Edit_11D") || addMsg.getMsgCode().equals("Edit_11B") || addMsg.getMsgCode().equals("Add_10B") || addMsg.getMsgCode().equals("Add_10D"))) {
            return false;
        }
        for (ValidateMsg validateMsg : validateMsgs) {
            if (!validateMsg.getPersonId().equals(addMsg.getPersonId())) continue;
            LOGGER.info("PTMMBuisinessCheckUtils, checkValidateMainRoleMsg validateMsg.getMsgCode is : [{}]", (Object)validateMsg.getMsgCode());
            if (!validateMsg.getMsgCode().equals("Edit_11D") && !validateMsg.getMsgCode().equals("Edit_11B") && !validateMsg.getMsgCode().equals("Add_10B") && !validateMsg.getMsgCode().equals("Add_10D")) continue;
            checkRes = true;
        }
        return checkRes;
    }

    private static List<ValidateMsg> teamMemberBusinessCheck(ValidateParamDto param) {
        ArrayList<ValidateMsg> msgs = new ArrayList<ValidateMsg>();
        if (param.getValidateType() == AdjustEntryEnum.JOIN) {
            List<ValidateMsg> checkDissociateRoleMsg;
            List<ValidateMsg> checkTeamRoleOutTimeMsgs;
            ValidateMsg msg;
            if (PTMMBuisinessCheckUtils.checkTeamMemberByStatus("A", param)) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Add_8", param, param.getRoleName(), null, null);
                msgs.add(msg);
            }
            if (PTMMBuisinessCheckUtils.checkTeamMemberByStatus("B", param)) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Add_9", param, param.getRoleName(), null, null);
                msgs.add(msg);
            }
            if (PTMMBuisinessCheckUtils.checkProjectPrincipal(param) && !PTMMBuisinessCheckUtils.checkValidateMsgRepeat(msgs, msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Add_10D", param, param.getRoleName(), null, null)) && !PTMMBuisinessCheckUtils.checkValidateMainRoleMsg(msgs, msg)) {
                msgs.add(msg);
            }
            if ((checkTeamRoleOutTimeMsgs = PTMMBuisinessCheckUtils.checkTeamRoleOutTime(param)).size() > 0) {
                msgs.addAll(checkTeamRoleOutTimeMsgs);
            }
            if ((checkDissociateRoleMsg = PTMMBuisinessCheckUtils.checkDissociateRole(param)).size() > 0) {
                msgs.addAll(checkDissociateRoleMsg);
            }
        } else if (param.getValidateType() == AdjustEntryEnum.QUIT) {
            ValidateMsg msg;
            if (PTMMBuisinessCheckUtils.checkTeamMemberOutStatus(param, param.getPersonTeamDOs())) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Out_1", param, param.getRoleName(), null, null);
                msgs.add(msg);
            }
            if (PTMMBuisinessCheckUtils.checkTeamMemberWaitQuit(param)) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Out_2", param, param.getRoleName(), null, null);
                msgs.add(msg);
            }
            if (param.isOnlyPrjDutyper()) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Out_3", param, param.getRoleName(), null, null);
                msgs.add(msg);
            }
            if (PTMMBuisinessCheckUtils.checkRoleOutTime(param.getRoleId(), param)) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Out_7", param, param.getRoleName(), null, null);
                msgs.add(msg);
            }
            if (PTMMBuisinessCheckUtils.checkRoleQuitTime(param, param.getRoleId(), param.getPersonTeamRoleDOs())) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Out_10", param, param.getRoleName(), null, null);
                msgs.add(msg);
            }
            if (param.getOtherRoleIds() != null && param.getOtherRoleIds().size() > 0) {
                List<Long> otherRoles = PTMMBuisinessCheckUtils.getDistinctOtherRoleIds(param);
                for (Long otherRole : otherRoles) {
                    if (!PTMMBuisinessCheckUtils.checkRoleQuitTime(param, otherRole, param.getPersonTeamRoleDOs())) continue;
                    ValidateMsg msg2 = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Out_10", param, param.getRoleName(), null, null);
                    msgs.add(msg2);
                }
            }
            if (PTMMBuisinessCheckUtils.checkRoleQuitTimeAndRoleStartTime(param)) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Out_38", param, param.getRoleName(), null, null);
                msgs.add(msg);
            }
        } else if (param.getValidateType() == AdjustEntryEnum.ADJUST_ADJ) {
            ValidateMsg msg;
            if (PTMMBuisinessCheckUtils.checkRoleOutInfo(param.getBeforeRoleId(), param)) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Edit_2", param, param.getRoleName(), null, null);
                msgs.add(msg);
            }
            if (PTMMBuisinessCheckUtils.checkTeamMemberRoleByStatus("A", param)) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Edit_9", param, param.getRoleName(), null, null);
                msgs.add(msg);
            }
            if (PTMMBuisinessCheckUtils.checkTeamMemberRoleByStatus("B", param)) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Edit_10", param, param.getRoleName(), null, null);
                msgs.add(msg);
            }
            if (PTMMBuisinessCheckUtils.checkProjectPrincipal(param) && !PTMMBuisinessCheckUtils.checkValidateMsgRepeat(msgs, msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Edit_11D", param, param.getRoleName(), null, null)) && !PTMMBuisinessCheckUtils.checkValidateMainRoleMsg(msgs, msg)) {
                msgs.add(msg);
            }
            if (PTMMBuisinessCheckUtils.checkRoleOverTimeEditBeforeRole(param)) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Edit_12", param, param.getRoleName(), null, null);
                msgs.add(msg);
            }
            if (PTMMBuisinessCheckUtils.checkTeamRoleOutTime(param).size() > 0) {
                msgs.addAll(PTMMBuisinessCheckUtils.checkTeamRoleOutTime(param));
            }
            if (PTMMBuisinessCheckUtils.checkRoleQuitTime(param, param.getBeforeRoleId(), param.getPersonBeforeTeamRoleDOs())) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Edit_14", param, param.getRoleName(), null, null);
                msgs.add(msg);
            }
            if (param.isOnlyPrjDutyper()) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Edit_26", param, param.getBeforeRoleName(), null, null);
                msgs.add(msg);
            }
            if (PTMMBuisinessCheckUtils.checkEditAddRoleAndQuitDB(param)) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("ADJUST_JOIN_AND_QUIT_31DB", param, param.getRoleName(), param.getEffectTime(), param.getEffectTime());
                msgs.add(msg);
            }
            if (PTMMBuisinessCheckUtils.checkTeamMemberOutStatus(param, param.getPersonBeforeTeamDOs())) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Out_1", param, param.getBeforeRoleName(), null, null);
                msgs.add(msg);
            }
        } else if (param.getValidateType() == AdjustEntryEnum.ADJUST_JOIN) {
            ValidateMsg msg;
            if (PTMMBuisinessCheckUtils.checkProjectPrincipal(param) && !PTMMBuisinessCheckUtils.checkValidateMsgRepeat(msgs, msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Edit_11D", param, param.getRoleName(), null, null)) && !PTMMBuisinessCheckUtils.checkValidateMainRoleMsg(msgs, msg)) {
                msgs.add(msg);
            }
            if (PTMMBuisinessCheckUtils.checkTeamRoleOutTime(param).size() > 0) {
                msgs.addAll(PTMMBuisinessCheckUtils.checkTeamRoleOutTime(param));
            }
            if (PTMMBuisinessCheckUtils.checkTeamMemberRoleByStatus("A", param)) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Edit_9", param, param.getRoleName(), null, null);
                msgs.add(msg);
            }
            if (PTMMBuisinessCheckUtils.checkTeamMemberRoleByStatus("B", param)) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Edit_10", param, param.getRoleName(), null, null);
                msgs.add(msg);
            }
            if (PTMMBuisinessCheckUtils.checkEditAddRoleAndQuitDB(param)) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("ADJUST_JOIN_AND_QUIT_31DB", param, param.getRoleName(), param.getEffectTime(), param.getEffectTime());
                msgs.add(msg);
            }
            if (PTMMBuisinessCheckUtils.checkTeamMemberOutStatus(param, param.getPersonTeamDOs())) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Out_1", param, param.getRoleName(), null, null);
                msgs.add(msg);
            }
        } else if (param.getValidateType() == AdjustEntryEnum.ADJUST_QUIT) {
            ValidateMsg msg;
            if (PTMMBuisinessCheckUtils.checkRoleOverTimeEdit(param.getRoleId(), param)) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Edit_12", param, param.getRoleName(), null, null);
                msgs.add(msg);
            }
            if (PTMMBuisinessCheckUtils.checkRoleQuitTime(param, param.getRoleId(), param.getPersonTeamRoleDOs())) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Edit_14", param, param.getRoleName(), null, null);
                msgs.add(msg);
            }
            if (param.isOnlyPrjDutyper()) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Edit_26", param, param.getRoleName(), null, null);
                msgs.add(msg);
            }
            if (PTMMBuisinessCheckUtils.checkOverRoleStatus(param)) {
                msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Edit_2", param, param.getRoleName(), null, null);
                msgs.add(msg);
            }
        }
        return msgs;
    }

    private static boolean checkRoleQuitTimeAndRoleStartTime(ValidateParamDto param) {
        boolean checkRes = false;
        List<DynamicObject> personTeamRoleDOs = param.getPersonTeamRoleDOs();
        StringBuilder checkMsgBuilder = new StringBuilder();
        for (DynamicObject personTeamRoleDO : personTeamRoleDOs) {
            boolean checkTime;
            String personTeamRoleStatus = personTeamRoleDO.getString("servicestate");
            Date personTeamRoleStartDate = personTeamRoleDO.getDate("joindate");
            String personTeamRoleName = personTeamRoleDO.getString("projectrole.name");
            if (personTeamRoleStatus.equals("C") || !(checkTime = HRDateTimeUtils.dayBefore((Date)param.getEffectTime(), (Date)personTeamRoleStartDate))) continue;
            checkRes = true;
            String checkMsg = String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u3001", (String)"PTMMValidateOut_38_ROLETIEM", (String)"hr-ptmm-business", (Object[])new Object[0]), personTeamRoleName, PTMMBuisinessCheckUtils.getTimeStr(personTeamRoleStartDate));
            checkMsgBuilder.append(checkMsg);
        }
        param.setCheckMsg(HRStringUtils.substringBeforeLast((String)checkMsgBuilder.toString(), (String)"\u3001"));
        return checkRes;
    }

    private static boolean checkAddandEditAtoB(ValidateParamDto checkParam, ValidateParamDto otherParam) {
        boolean checRes = false;
        if (checkParam.getValidateType() == AdjustEntryEnum.JOIN && otherParam.getValidateType() == AdjustEntryEnum.ADJUST_ADJ) {
            checRes = PTMMBuisinessCheckUtils.checkPersonTeamRole(checkParam.getPersonId(), checkParam.getTeamId(), checkParam.getRoleId(), otherParam.getPersonId(), otherParam.getTeamId(), otherParam.getRoleId());
            if (checRes) {
                checkParam.setCheckMsg(checkParam.getRoleName());
                return true;
            }
            for (Long roleId : checkParam.getOtherRoleIds()) {
                checRes = PTMMBuisinessCheckUtils.checkPersonTeamRole(checkParam.getPersonId(), checkParam.getTeamId(), roleId, otherParam.getPersonId(), otherParam.getTeamId(), otherParam.getRoleId());
                if (!checRes) continue;
                checkParam.setCheckMsg(otherParam.getRoleName());
                return true;
            }
        }
        if (checkParam.getValidateType() == AdjustEntryEnum.ADJUST_ADJ && otherParam.getValidateType() == AdjustEntryEnum.JOIN) {
            checRes = PTMMBuisinessCheckUtils.checkPersonTeamRole(checkParam.getPersonId(), checkParam.getTeamId(), checkParam.getRoleId(), otherParam.getPersonId(), otherParam.getTeamId(), otherParam.getRoleId());
            if (checRes) {
                checkParam.setCheckMsg(checkParam.getRoleName());
                return true;
            }
            for (Long roleId : otherParam.getOtherRoleIds()) {
                checRes = PTMMBuisinessCheckUtils.checkPersonTeamRole(checkParam.getPersonId(), checkParam.getTeamId(), checkParam.getRoleId(), otherParam.getPersonId(), otherParam.getTeamId(), roleId);
                if (!checRes) continue;
                checkParam.setCheckMsg(checkParam.getRoleName());
                return true;
            }
        }
        return checRes;
    }

    private static boolean checkQuitandEditAtoB(ValidateParamDto checkParam, ValidateParamDto otherParam) {
        boolean checRes = false;
        if (checkParam.getValidateType() == AdjustEntryEnum.QUIT && otherParam.getValidateType() == AdjustEntryEnum.ADJUST_ADJ) {
            checRes = PTMMBuisinessCheckUtils.checkPersonTeam(checkParam.getPersonId(), checkParam.getTeamId(), otherParam.getPersonId(), otherParam.getBeforeTeamId());
        }
        if (checkParam.getValidateType() == AdjustEntryEnum.ADJUST_ADJ && otherParam.getValidateType() == AdjustEntryEnum.QUIT) {
            checRes = PTMMBuisinessCheckUtils.checkPersonTeam(checkParam.getPersonId(), checkParam.getBeforeTeamId(), otherParam.getPersonId(), otherParam.getTeamId());
        }
        return checRes;
    }

    private static boolean checkQuitandEditQuit(ValidateParamDto checkParam, ValidateParamDto otherParam) {
        boolean checRes = false;
        if (checkParam.getValidateType() == AdjustEntryEnum.QUIT && otherParam.getValidateType() == AdjustEntryEnum.ADJUST_QUIT) {
            checRes = PTMMBuisinessCheckUtils.checkPersonTeam(checkParam.getPersonId(), checkParam.getTeamId(), otherParam.getPersonId(), otherParam.getTeamId());
        }
        if (checkParam.getValidateType() == AdjustEntryEnum.ADJUST_QUIT && otherParam.getValidateType() == AdjustEntryEnum.QUIT) {
            checRes = PTMMBuisinessCheckUtils.checkPersonTeam(checkParam.getPersonId(), checkParam.getTeamId(), otherParam.getPersonId(), otherParam.getTeamId());
        }
        return checRes;
    }

    private static boolean checkEditAddRoleAndQuitBill(ValidateParamDto checkParam, ValidateParamDto otherParam) {
        boolean checRes = false;
        if (!checkParam.getTeamId().equals(otherParam.getTeamId()) || !checkParam.getPersonId().equals(otherParam.getPersonId())) {
            return false;
        }
        if (checkParam.getValidateType() == AdjustEntryEnum.ADJUST_JOIN && otherParam.getValidateType() == AdjustEntryEnum.QUIT) {
            checRes = HRDateTimeUtils.dayBefore((Date)otherParam.getEffectTime(), (Date)checkParam.getEffectTime());
        }
        if (checkParam.getValidateType() == AdjustEntryEnum.QUIT && otherParam.getValidateType() == AdjustEntryEnum.ADJUST_JOIN) {
            checRes = HRDateTimeUtils.dayBefore((Date)checkParam.getEffectTime(), (Date)otherParam.getEffectTime());
        }
        if (checkParam.getValidateType() == AdjustEntryEnum.ADJUST_ADJ && otherParam.getValidateType() == AdjustEntryEnum.QUIT) {
            checRes = HRDateTimeUtils.dayBefore((Date)otherParam.getEffectTime(), (Date)checkParam.getEffectTime());
        }
        if (checkParam.getValidateType() == AdjustEntryEnum.QUIT && otherParam.getValidateType() == AdjustEntryEnum.ADJUST_ADJ) {
            checRes = HRDateTimeUtils.dayBefore((Date)checkParam.getEffectTime(), (Date)otherParam.getEffectTime());
        }
        checkParam.setCheckMsgBillNo(checkParam.getBillNo());
        return checRes;
    }

    private static boolean checkEditAddRoleAndQuitDB(ValidateParamDto checkParam) {
        boolean checRes = false;
        if (checkParam.getValidateType() == AdjustEntryEnum.ADJUST_JOIN || checkParam.getValidateType() == AdjustEntryEnum.ADJUST_ADJ) {
            List<DynamicObject> personTeamDOs = checkParam.getPersonTeamDOs();
            for (DynamicObject personTeamDO : personTeamDOs) {
                String personTeamStatus = personTeamDO.getString("servicestate");
                String endbillno = personTeamDO.getString("endbillno");
                Long dbTeamId = personTeamDO.getLong("projectteam.id");
                Long dbPersonId = personTeamDO.getLong("person.id");
                if (HRStringUtils.isEmpty((String)endbillno) || !dbTeamId.equals(checkParam.getTeamId()) || !dbPersonId.equals(checkParam.getPersonId()) || !"B".equals(personTeamStatus)) continue;
                Date personTeamQuitDate = personTeamDO.getDate("quitdate");
                checRes = HRDateTimeUtils.dayBefore((Date)personTeamQuitDate, (Date)checkParam.getEffectTime());
                checkParam.setCheckMsgBillNo(endbillno);
                checkParam.setCheckMsg(PTMMBuisinessCheckUtils.getTimeStr(personTeamQuitDate));
            }
        }
        return checRes;
    }

    private static boolean checkPersonTeamRole(Long personIdA, Long teamIdA, Long roleIdA, Long personIdB, Long teamIdB, Long roleIdB) {
        boolean checkRes = false;
        if (personIdA.equals(personIdB) && teamIdA.equals(teamIdB) && roleIdA.equals(roleIdB)) {
            checkRes = true;
        }
        return checkRes;
    }

    private static boolean checkPersonTeam(Long personIdA, Long teamIdA, Long personIdB, Long teamIdB) {
        boolean checkRes = false;
        if (personIdA.equals(personIdB) && teamIdA.equals(teamIdB)) {
            checkRes = true;
        }
        return checkRes;
    }

    private static List<Long> getDistinctOtherRoleIds(ValidateParamDto param) {
        ArrayList<Long> disRoleIds = new ArrayList<Long>(param.getOtherRoleIds().size());
        for (Long roleId : param.getOtherRoleIds()) {
            if (disRoleIds.contains(roleId)) continue;
            disRoleIds.add(roleId);
        }
        return disRoleIds;
    }

    private static ValidateMsg getCheckMsgByMsgCode(String msgCode, ValidateParamDto param, String roleName, Date startDate, Date endDate) {
        ValidateMsg msg = new ValidateMsg();
        String checkDateStr = PTMMBuisinessCheckUtils.getTimeStr(param.getEffectTime());
        String startDateStr = PTMMBuisinessCheckUtils.getTimeStr(startDate);
        String endDateStr = PTMMBuisinessCheckUtils.getTimeStr(endDate);
        String personName = param.getPersonName();
        String personNum = param.getPersonNum();
        String teamName = param.getTeamName();
        switch (msgCode) {
            case "Add_1": {
                msg.setValidateType(PTMMValidateTypeEnum.PROJECT_TEAM);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u6240\u9009\u62e9\u52a0\u5165\u56e2\u961f\u65e5\u671f\uff08%3$s\uff09\u4e0d\u5728\u9879\u76ee\u56e2\u961f\u751f\u6548\u671f\u95f4\u3002", (String)"PTMMValidateAdd_1", (String)"hr-ptmm-business", (Object[])new Object[0]), param.getPersonName(), personNum, checkDateStr));
                break;
            }
            case "Add_2": {
                msg.setValidateType(PTMMValidateTypeEnum.PERSON_QUITBILL);
                msg.setMsgType(MSGTYPE_WARN);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5df2\u7533\u8bf7\u79bb\u804c\uff0c\u7533\u8bf7\u52b3\u52a8\u5173\u7cfb\u7ed3\u675f\u65e5\u671f\uff1a%3$s\u3002", (String)"PTMMValidateAdd_2", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, endDateStr));
                break;
            }
            case "Add_3": {
                msg.setValidateType(PTMMValidateTypeEnum.PERSON_QUITBILL);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5df2\u7533\u8bf7\u79bb\u804c\uff0c\u52a0\u5165\u56e2\u961f\u65e5\u671f\uff08%3$s\uff09\u665a\u4e8e\u7533\u8bf7\u52b3\u52a8\u5173\u7cfb\u7ed3\u675f\u65e5\u671f\uff08%4$s\uff09\u3002", (String)"PTMMValidateAdd_3", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, checkDateStr, endDateStr));
                break;
            }
            case "Add_4": {
                msg.setValidateType(PTMMValidateTypeEnum.PERSON_INANDQUITTIME);
                msg.setMsgType(MSGTYPE_WARN);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5df2\u79bb\u804c\uff0c\u79bb\u804c\u65e5\u671f\uff1a%3$s\u3002", (String)"PTMMValidateAdd_4", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, endDateStr));
                break;
            }
            case "Add_5": {
                msg.setValidateType(PTMMValidateTypeEnum.PERSON_INANDQUITTIME);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u52a0\u5165\u56e2\u961f\u65e5\u671f\uff08%3$s\uff09\u665a\u4e8e\u79bb\u804c\u65e5\u671f\uff08%4$s\uff09\u3002", (String)"PTMMValidateAdd_5", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, checkDateStr, endDateStr));
                break;
            }
            case "Add_6": {
                msg.setValidateType(PTMMValidateTypeEnum.PERSON_INANDQUITTIME);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5728\u6240\u9009\u62e9\u52a0\u5165\u56e2\u961f\u65e5\u671f\uff08%3$s\uff09\u65e0\u5728\u804c\u8bb0\u5f55\u3002", (String)"PTMMValidateAdd_6", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, checkDateStr));
                break;
            }
            case "Add_7": {
                msg.setValidateType(PTMMValidateTypeEnum.PROJECT_ROLE);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u6240\u9009\u62e9\u9879\u76ee\u89d2\u8272\uff08%3$s\uff09\u7684\u52a0\u5165\u65e5\u671f\uff08%4$s\uff09\u4e0d\u5728\u89d2\u8272\u751f\u6548\u671f\u95f4\u3002", (String)"PTMMValidateAdd_7", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, roleName, checkDateStr));
                break;
            }
            case "Add_8": {
                msg.setValidateType(PTMMValidateTypeEnum.TEAMMEMBER_BUSINESS);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5728\u9879\u76ee\u56e2\u961f\uff08%3$s\uff09\u5df2\u5b58\u5728\u5f85\u52a0\u5165\u6570\u636e\uff0c\u5355\u636e\u7f16\u53f7\uff1a%4$s\u3002", (String)"PTMMValidateAdd_8", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, teamName, param.getCheckMsgBillNo()));
                break;
            }
            case "Add_9": {
                msg.setValidateType(PTMMValidateTypeEnum.TEAMMEMBER_BUSINESS);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5728\u9879\u76ee\u56e2\u961f\uff08%3$s\uff09\u4e0b\u5df2\u5b58\u5728\u670d\u52a1\u4e2d\u6570\u636e\u3002", (String)"PTMMValidateAdd_9", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, teamName));
                break;
            }
            case "Add_10B": {
                msg.setValidateType(PTMMValidateTypeEnum.TEAMMEMBER_BILL);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5728\u9879\u76ee\uff08%3$s\uff09\u4e0b\u5b58\u5728\u591a\u4e2a\u4e3b\u8981\u89d2\u8272\u3002", (String)"PTMMValidateAdd_10", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, param.getProjectName()));
                break;
            }
            case "Add_10D": {
                msg.setValidateType(PTMMValidateTypeEnum.TEAMMEMBER_BUSINESS);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5728\u9879\u76ee\uff08%3$s\uff09\u4e0b\u5b58\u5728\u591a\u4e2a\u4e3b\u8981\u89d2\u8272\u3002", (String)"PTMMValidateAdd_10", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, param.getProjectName()));
                break;
            }
            case "Add_11": {
                msg.setValidateType(PTMMValidateTypeEnum.TEAMMEMBER_BUSINESS);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5728%3$s\u4e8e\u9879\u76ee\u56e2\u961f\uff08%4$s\uff09\u5df2\u5b58\u5728\u9879\u76ee\u89d2\u8272\uff08%5$s\uff09\u4efb\u804c\u3002", (String)"PTMMValidateAdd_11", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, checkDateStr, teamName, roleName));
                break;
            }
            case "Add_12": {
                msg.setValidateType(PTMMValidateTypeEnum.TEAMMEMBER_BUSINESS);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s\u5728%2$s\u4e2d\u5df2\u5b58\u5728\u9879\u76ee\u89d2\u8272%3$s\uff0c\u8bf7\u79fb\u9664\u8be5\u89d2\u8272\u540e\u518d\u8bd5\u3002", (String)"PTMMValidateAdd_12", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, teamName, roleName));
                break;
            }
            case "Edit_1": {
                msg.setValidateType(PTMMValidateTypeEnum.PERSON_INANDQUITTIME);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5728\u6240\u9009\u62e9\u8c03\u6574\u751f\u6548\u65e5\u671f\uff08%3$s\uff09\u65e0\u5728\u804c\u8bb0\u5f55\u3002", (String)"PTMMValidateEdit_1", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, checkDateStr));
                break;
            }
            case "Edit_2": {
                msg.setValidateType(PTMMValidateTypeEnum.TEAMMEMBER_BUSINESS);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u8c03\u6574\u751f\u6548\u65e5\u671f\uff08%3$s\uff09\u65e0\u56e2\u961f\u89d2\u8272\u4efb\u804c\u3002", (String)"PTMMValidateEdit_2", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, checkDateStr));
                break;
            }
            case "Edit_3": {
                msg.setValidateType(PTMMValidateTypeEnum.PROJECT_TEAM);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u6240\u9009\u62e9\u8c03\u6574\u751f\u6548\u65e5\u671f\uff08%3$s\uff09\u4e0d\u5728\u9879\u76ee\u56e2\u961f\u751f\u6548\u671f\u95f4\u3002", (String)"PTMMValidateEdit_3", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, checkDateStr));
                break;
            }
            case "Edit_4": {
                msg.setValidateType(PTMMValidateTypeEnum.PERSON_QUITBILL);
                msg.setMsgType(MSGTYPE_WARN);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5df2\u7533\u8bf7\u79bb\u804c\uff0c\u7533\u8bf7\u52b3\u52a8\u5173\u7cfb\u7ed3\u675f\u65e5\u671f\uff1a%3$s\u3002", (String)"PTMMValidateEdit_4", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, endDateStr));
                break;
            }
            case "Edit_5": {
                msg.setValidateType(PTMMValidateTypeEnum.PERSON_QUITBILL);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5df2\u7533\u8bf7\u79bb\u804c\uff0c\u8c03\u6574\u751f\u6548\u65e5\u671f\uff08%3$s\uff09\u665a\u4e8e\u7533\u8bf7\u52b3\u52a8\u5173\u7cfb\u7ed3\u675f\u65e5\u671f\uff08%4$s\uff09\u3002", (String)"PTMMValidateEdit_5", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, checkDateStr, endDateStr));
                break;
            }
            case "Edit_6": {
                msg.setValidateType(PTMMValidateTypeEnum.PERSON_INANDQUITTIME);
                msg.setMsgType(MSGTYPE_WARN);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5df2\u79bb\u804c\uff0c\u79bb\u804c\u65e5\u671f\uff1a%3$s\u3002", (String)"PTMMValidateEdit_6", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, endDateStr));
                break;
            }
            case "Edit_7": {
                msg.setValidateType(PTMMValidateTypeEnum.PERSON_INANDQUITTIME);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u8c03\u6574\u751f\u6548\u65e5\u671f\uff08%3$s\uff09\u665a\u4e8e\u79bb\u804c\u65e5\u671f\uff08%4$s\uff09\u3002", (String)"PTMMValidateEdit_7", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, checkDateStr, endDateStr));
                break;
            }
            case "Edit_8": {
                msg.setValidateType(PTMMValidateTypeEnum.PROJECT_ROLE);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u6240\u9009\u62e9\u9879\u76ee\u89d2\u8272\uff08%3$s\uff09\u7684\u8c03\u6574\u751f\u6548\u65e5\u671f\uff08%4$s\uff09\u4e0d\u5728\u89d2\u8272\u751f\u6548\u671f\u95f4\u3002", (String)"PTMMValidateEdit_8", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, roleName, checkDateStr));
                break;
            }
            case "Edit_9": {
                msg.setValidateType(PTMMValidateTypeEnum.TEAMMEMBER_BUSINESS);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5728\u9879\u76ee\u56e2\u961f\uff08%3$s\uff09\u5df2\u5b58\u5728\u9879\u76ee\u89d2\u8272\uff08%4$s\uff09\u5f85\u52a0\u5165\u6570\u636e\uff0c\u5355\u636e\u7f16\u53f7\uff1a%5$s\u3002", (String)"PTMMValidateEdit_9", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, teamName, roleName, param.getCheckMsgBillNo()));
                break;
            }
            case "Edit_10": {
                msg.setValidateType(PTMMValidateTypeEnum.TEAMMEMBER_BUSINESS);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5728\u9879\u76ee\u56e2\u961f\uff08%3$s\uff09\u5df2\u5b58\u5728\u9879\u76ee\u89d2\u8272\uff08%4$s\uff09\u670d\u52a1\u4e2d\u6570\u636e\u3002", (String)"PTMMValidateEdit_10", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, teamName, roleName));
                break;
            }
            case "Edit_11B": {
                msg.setValidateType(PTMMValidateTypeEnum.TEAMMEMBER_BILL);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5728\u9879\u76ee\uff08%3$s\uff09\u4e0b\u5b58\u5728\u591a\u4e2a\u4e3b\u8981\u89d2\u8272\u3002", (String)"PTMMValidateEdit_11", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, param.getProjectName()));
                break;
            }
            case "Edit_11D": {
                msg.setValidateType(PTMMValidateTypeEnum.TEAMMEMBER_BUSINESS);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5728\u9879\u76ee\uff08%3$s\uff09\u4e0b\u5b58\u5728\u591a\u4e2a\u4e3b\u8981\u89d2\u8272\u3002", (String)"PTMMValidateEdit_11", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, param.getProjectName()));
                break;
            }
            case "Edit_12": {
                msg.setValidateType(PTMMValidateTypeEnum.TEAMMEMBER_BUSINESS);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u89d2\u8272\u4efb\u804c\u7ed3\u675f\u65e5\u671f(%3$s)\u65e9\u4e8e\u89d2\u8272\u4efb\u804c\u5f00\u59cb\u65e5\u671f\uff08%4$s\uff09\u3002", (String)"PTMMValidateEdit_12", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, checkDateStr, param.getBusinessRoleJoinTime()));
                break;
            }
            case "Edit_13": {
                msg.setValidateType(PTMMValidateTypeEnum.TEAMMEMBER_BUSINESS);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5728%3$s\u4e8e\u9879\u76ee\u56e2\u961f\uff08%4$s\uff09\u5df2\u5b58\u5728\u9879\u76ee\u89d2\u8272\uff08%5$s\uff09\u4efb\u804c\u3002", (String)"PTMMValidateEdit_13", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, checkDateStr, teamName, roleName));
                break;
            }
            case "Edit_14": {
                if (param.getValidateType() == AdjustEntryEnum.ADJUST_ADJ) {
                    teamName = param.getBeforeTeamName();
                }
                msg.setValidateType(PTMMValidateTypeEnum.TEAMMEMBER_BUSINESS);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5728%3$s\u4e8e\u9879\u76ee\u56e2\u961f\uff08%4$s\uff09\u5df2\u5b58\u5728\u9879\u76ee\u89d2\u8272\uff08%5$s\uff09\u4efb\u804c\u3002", (String)"PTMMValidateEdit_14", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, checkDateStr, teamName, param.getCheckMsg()));
                break;
            }
            case "Edit_15": {
                msg.setValidateType(PTMMValidateTypeEnum.TEAMMEMBER_BILL);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5728\u9879\u76ee\u4efb\u804c\u65b0\u589e\u3001\u89d2\u8272\u8c03\u6574\u660e\u7ec6\u5b58\u5728\u91cd\u590d\u7684\u9879\u76ee\u56e2\u961f\uff08%3$s\uff09\u4e0b\u9879\u76ee\u89d2\u8272\uff08%4$s\uff09\u6570\u636e\u3002", (String)"PTMMValidateEdit_15", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, teamName, roleName));
                break;
            }
            case "Edit_16": {
                msg.setValidateType(PTMMValidateTypeEnum.TEAMMEMBER_BILL);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5728\u89d2\u8272\u8c03\u6574\u660e\u7ec6\u3001\u89d2\u8272\u4efb\u804c\u7ed3\u675f\u660e\u7ec6\u5b58\u5728\u91cd\u590d\u7684\u9879\u76ee\u56e2\u961f\uff08%3$s\uff09\u4e0b\u9879\u76ee\u89d2\u8272\uff08%4$s\uff09\u6570\u636e\u3002", (String)"PTMMValidateEdit_16", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, teamName, roleName));
                break;
            }
            case "Edit_26": {
                msg.setValidateType(PTMMValidateTypeEnum.TEAMMEMBER_BUSINESS);
                msg.setMsgType(MSGTYPE_WARN);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u89d2\u8272\u4efb\u804c\u7ed3\u675f\uff08%3$s\uff09\u540e\uff0c\u9879\u76ee\uff08%4$s\uff09\u5c06\u65e0\u4e3b\u8d1f\u8d23\u4eba\u3002", (String)"PTMMValidateEdit_26", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, roleName, param.getProjectName()));
                break;
            }
            case "Out_1": {
                msg.setValidateType(PTMMValidateTypeEnum.TEAMMEMBER_BUSINESS);
                msg.setMsgType(MSGTYPE_ERROR);
                String tmName = param.getValidateType() == AdjustEntryEnum.ADJUST_ADJ ? param.getBeforeTeamName() : teamName;
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5df2\u9000\u51fa\u9879\u76ee\u56e2\u961f\uff1a%3$s\uff0c\u9000\u51fa\u56e2\u961f\u65e5\u671f\uff1a%4$s \u3002", (String)"PTMMValidateOut_1", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, tmName, param.getBusinessRoleQuitTime()));
                break;
            }
            case "Out_2": {
                msg.setValidateType(PTMMValidateTypeEnum.TEAMMEMBER_BUSINESS);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5728\u9879\u76ee\u56e2\u961f\uff08%3$s\uff09\u5df2\u5b58\u5728\u5f85\u9000\u51fa\u6570\u636e\uff0c\u5355\u636e\u7f16\u53f7\uff1a%4$s\u3002", (String)"PTMMValidateOut_2", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, teamName, param.getCheckMsgBillNo()));
                break;
            }
            case "Out_3": {
                msg.setValidateType(PTMMValidateTypeEnum.TEAMMEMBER_BUSINESS);
                msg.setMsgType(MSGTYPE_WARN);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u9000\u51fa\u9879\u76ee\u56e2\u961f\uff08%3$s\uff09\u540e\uff0c\u9879\u76ee\uff08%4$s\uff09\u5c06\u65e0\u4e3b\u8d1f\u8d23\u4eba\u3002", (String)"PTMMValidateOut_3", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, teamName, param.getProjectName()));
                break;
            }
            case "Out_4": {
                msg.setValidateType(PTMMValidateTypeEnum.PROJECT_TEAM);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u9000\u51fa\u56e2\u961f\u65e5\u671f(%3$s\uff09\u4e0d\u5728\u9879\u76ee\u56e2\u961f\u751f\u6548\u671f\u95f4\u3002", (String)"PTMMValidateOut_4", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, checkDateStr));
                break;
            }
            case "Out_5": {
                msg.setValidateType(PTMMValidateTypeEnum.PERSON_QUITBILL);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5df2\u7533\u8bf7\u79bb\u804c\uff0c\u9000\u51fa\u56e2\u961f\u65e5\u671f\uff08%3$s\uff09\u665a\u4e8e\u7533\u8bf7\u52b3\u52a8\u5173\u7cfb\u7ed3\u675f\u65e5\u671f\uff08%4$s\uff09\u3002", (String)"PTMMValidateOut_5", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, checkDateStr, endDateStr));
                break;
            }
            case "Out_6": {
                msg.setValidateType(PTMMValidateTypeEnum.PERSON_INANDQUITTIME);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u9000\u51fa\u56e2\u961f\u65e5\u671f\uff08%3$s\uff09\u665a\u4e8e\u79bb\u804c\u65e5\u671f\uff08%4$s\uff09\u3002", (String)"PTMMValidateOut_6", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, checkDateStr, endDateStr));
                break;
            }
            case "Out_7": {
                msg.setValidateType(PTMMValidateTypeEnum.TEAMMEMBER_BUSINESS);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u9000\u51fa\u56e2\u961f\u65e5\u671f\uff08%3$s\uff09\u65e9\u4e8e\u52a0\u5165\u56e2\u961f\u65e5\u671f(%4$s)\u3002", (String)"PTMMValidateOut_7", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, checkDateStr, param.getBusinessRoleJoinTime()));
                break;
            }
            case "Out_8": {
                msg.setValidateType(PTMMValidateTypeEnum.PERSON_INANDQUITTIME);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5728\u6240\u9009\u62e9\u9000\u51fa\u56e2\u961f\u65e5\u671f\uff08%3$s\uff09\u65e0\u5728\u804c\u8bb0\u5f55\u3002", (String)"PTMMValidateOut_8", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, checkDateStr));
                break;
            }
            case "Out_10": {
                msg.setValidateType(PTMMValidateTypeEnum.TEAMMEMBER_BUSINESS);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5728%3$s\u4e8e\u9879\u76ee\u56e2\u961f\uff08%4$s\uff09\u5df2\u5b58\u5728\u9879\u76ee\u89d2\u8272\uff08%5$s\uff09\u4efb\u804c\u3002", (String)"PTMMValidateOut_10", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, checkDateStr, teamName, param.getCheckMsg()));
                break;
            }
            case "Out_38": {
                msg.setValidateType(PTMMValidateTypeEnum.TEAMMEMBER_BUSINESS);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u9000\u51fa\u56e2\u961f\u65e5\u671f\uff08%3$s\uff09\u65e9\u4e8e\u89d2\u8272\u4efb\u804c\u5f00\u59cb\u65e5\u671f\uff1a%4$s\u3002", (String)"PTMMValidateOut_38", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, checkDateStr, param.getCheckMsg()));
                break;
            }
            case "JOIN_ADJUST_ADJ_12": {
                msg.setValidateType(PTMMValidateTypeEnum.TEAMMEMBER_BILL);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5728\u6210\u5458\u65b0\u589e\u3001\u89d2\u8272\u8c03\u6574\u660e\u7ec6\u5b58\u5728\u91cd\u590d\u7684\u9879\u76ee\u56e2\u961f\uff08%3$s\uff09\u4e0b\u9879\u76ee\u89d2\u8272\uff08%4$s\uff09\u6570\u636e\u3002", (String)"PTMMValidate_JOIN_ADJUST_ADJ", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, teamName, param.getCheckMsg()));
                break;
            }
            case "JOIN_ADJUST_ADJ_29": {
                msg.setValidateType(PTMMValidateTypeEnum.TEAMMEMBER_BILL);
                msg.setMsgType(MSGTYPE_ERROR);
                String tmName = param.getValidateType() == AdjustEntryEnum.ADJUST_ADJ ? param.getBeforeTeamName() : teamName;
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5728\u89d2\u8272\u8c03\u6574\u660e\u7ec6\u3001\u6210\u5458\u9000\u51fa\u660e\u7ec6\u5b58\u5728\u91cd\u590d\u7684\u9000\u51fa\u9879\u76ee\u56e2\u961f\uff08%3$s\uff09\u6570\u636e\u3002", (String)"PTMMValidate_QUIT_ADJUST_ADJ", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, tmName));
                break;
            }
            case "QUIT_ADJUST_QUIT_30": {
                msg.setValidateType(PTMMValidateTypeEnum.TEAMMEMBER_BILL);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5728\u89d2\u8272\u4efb\u804c\u7ed3\u675f\u660e\u7ec6\u3001\u6210\u5458\u9000\u51fa\u660e\u7ec6\u5b58\u5728\u91cd\u590d\u7684\u9000\u51fa\u9879\u76ee\u56e2\u961f\uff08%3$s\uff09\u6570\u636e\u3002", (String)"PTMMValidate_QUIT_ADJUST_QUIT", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, teamName));
                break;
            }
            case "ADJUST_JOIN_AND_QUIT_31": {
                msg.setValidateType(PTMMValidateTypeEnum.TEAMMEMBER_BILL);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5728\u9879\u76ee\u56e2\u961f\uff08%3$s\uff09\u5df2\u5b58\u5728\u5f85\u9000\u51fa\u6570\u636e\uff0c\u4e14\u9000\u51fa\u56e2\u961f\u65e5\u671f\uff08%4$s\uff09\u65e9\u4e8e\u9879\u76ee\u4efb\u804c\u65b0\u589e\u65e5\u671f\uff08%5$s\uff09\uff0c\u5355\u636e\u7f16\u53f7\uff1a%6$s\u3002", (String)"PTMMValidate_ADJUST_JOIN_AND_QUIT", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, teamName, endDateStr, startDateStr, param.getCheckMsgBillNo()));
                break;
            }
            case "ADJUST_JOIN_AND_QUIT_31DB": {
                msg.setValidateType(PTMMValidateTypeEnum.TEAMMEMBER_BUSINESS);
                msg.setMsgType(MSGTYPE_ERROR);
                msg.setMsgInfo(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u5728\u9879\u76ee\u56e2\u961f\uff08%3$s\uff09\u5df2\u5b58\u5728\u5f85\u9000\u51fa\u6570\u636e\uff0c\u4e14\u9000\u51fa\u56e2\u961f\u65e5\u671f\uff08%4$s\uff09\u65e9\u4e8e\u9879\u76ee\u4efb\u804c\u65b0\u589e\u65e5\u671f\uff08%5$s\uff09\uff0c\u5355\u636e\u7f16\u53f7\uff1a%6$s\u3002", (String)"PTMMValidate_ADJUST_JOIN_AND_QUIT", (String)"hr-ptmm-business", (Object[])new Object[0]), personName, personNum, teamName, param.getCheckMsg(), startDateStr, param.getCheckMsgBillNo()));
                break;
            }
            default: {
                LOGGER.error("getCheckMsgByMsgCode Error, msgCode is : [{}]", (Object)msgCode);
            }
        }
        msg.setPersonId(param.getPersonId());
        msg.setMsgCode(msgCode);
        return msg;
    }

    public static String getTimeStr(Date time) {
        String timeStr = "";
        if (time != null) {
            timeStr = HRDateTimeUtils.format((Date)time, (String)FMT_DATE);
        }
        return timeStr;
    }

    private static boolean checkTeamMemberByStatus(String status, ValidateParamDto param) {
        boolean res = false;
        List<DynamicObject> personTeamDOs = param.getPersonTeamDOs();
        for (DynamicObject personTeamDO : personTeamDOs) {
            String personTeamStatus = personTeamDO.getString("servicestate");
            if (!personTeamStatus.equals(status)) continue;
            param.setCheckMsgBillNo(personTeamDO.getString("joinbillno"));
            res = true;
        }
        return res;
    }

    private static boolean checkTeamMemberOutStatus(ValidateParamDto param, List<DynamicObject> personTeamDOs) {
        boolean res = false;
        if (param.getValidateType() == AdjustEntryEnum.ADJUST_ADJ && param.getBeforeTeamDO() == null) {
            return false;
        }
        boolean isHaveTeamMemberActive = PTMMBuisinessCheckUtils.checkIsHaveTeamMemberActive(param, personTeamDOs);
        if (!isHaveTeamMemberActive) {
            res = true;
            param.setBusinessRoleQuitTime(PTMMBuisinessCheckUtils.getQuitDate(param, personTeamDOs));
        }
        Long teamMemberId = param.getValidateType() == AdjustEntryEnum.ADJUST_ADJ ? Long.valueOf(param.getBeforeTeamDO().getLong("id")) : Long.valueOf(param.getTeamDO().getLong("id"));
        for (DynamicObject personTeamDO : personTeamDOs) {
            String personTeamStatus = personTeamDO.getString("servicestate");
            if (!personTeamStatus.equals("C")) continue;
            Date personTeamStartDate = personTeamDO.getDate("joindate");
            Date personTeamEndDate = personTeamDO.getDate("quitdate");
            Long dbPersonId = personTeamDO.getLong("person.id");
            Long dbTeamMemberId = personTeamDO.getLong("id");
            if (!dbTeamMemberId.equals(teamMemberId) || !dbPersonId.equals(param.getPersonId()) || !PTMMBuisinessCheckUtils.checktiemIn(param.getEffectTime(), personTeamStartDate, personTeamEndDate)) continue;
            param.setCheckMsgBillNo(personTeamDO.getString("joinbillno"));
            param.setBusinessRoleQuitTime(PTMMBuisinessCheckUtils.getTimeStr(personTeamEndDate));
            res = true;
        }
        return res;
    }

    private static boolean checkIsHaveTeamMemberActive(ValidateParamDto param, List<DynamicObject> personTeamDOs) {
        boolean checkRes = false;
        Long personId = param.getPersonId();
        Long teamMemberId = param.getValidateType() == AdjustEntryEnum.ADJUST_ADJ ? Long.valueOf(param.getBeforeTeamDO().getLong("id")) : Long.valueOf(param.getTeamDO().getLong("id"));
        for (DynamicObject personTeamDO : personTeamDOs) {
            Long dbPersonId = personTeamDO.getLong("person.id");
            Long dbTeamMemberId = personTeamDO.getLong("id");
            String personTeamStatus = personTeamDO.getString("servicestate");
            if (!personId.equals(dbPersonId) || !teamMemberId.equals(dbTeamMemberId) || personTeamStatus.equals("C")) continue;
            checkRes = true;
        }
        return checkRes;
    }

    private static String getQuitDate(ValidateParamDto param, List<DynamicObject> personTeamDOs) {
        String quitDateStr = "";
        for (DynamicObject personTeamDO : personTeamDOs) {
            Date dbQuitDate = personTeamDO.getDate("quitdate");
            Long dbTeamMemberId = personTeamDO.getLong("id");
            String personTeamStatus = personTeamDO.getString("servicestate");
            Long dbPersonId = personTeamDO.getLong("person.id");
            Long checkTeamMember = param.getValidateType() == AdjustEntryEnum.ADJUST_ADJ ? Long.valueOf(param.getBeforeTeamDO().getLong("id")) : Long.valueOf(param.getTeamDO().getLong("id"));
            String logInfoTeam = String.format("PTMM getQuitDate -> dbTeamMemberId:[%s]; checkTeamMember :[%s];teamid:[%s];", dbTeamMemberId, checkTeamMember, param.getBeforeTeamId());
            LOGGER.info(logInfoTeam);
            String logInfoPerson = String.format("PTMM getQuitDate -> dbPersonId:[%s]; PersonId :[%s];personTeamStatus:[%s];", dbPersonId, param.getPersonId(), personTeamStatus);
            LOGGER.info(logInfoPerson);
            String logInfoQuitDate = String.format("PTMM getQuitDate -> dbQuitDate:[%s]; ", PTMMBuisinessCheckUtils.getTimeStr(dbQuitDate));
            LOGGER.info(logInfoQuitDate);
            if (!checkTeamMember.equals(dbTeamMemberId) || !param.getPersonId().equals(dbPersonId) || !personTeamStatus.equals("C")) continue;
            quitDateStr = PTMMBuisinessCheckUtils.getTimeStr(dbQuitDate);
        }
        return quitDateStr;
    }

    private static boolean checkTeamMemberWaitQuit(ValidateParamDto param) {
        boolean res = false;
        List<DynamicObject> personTeamDOs = param.getPersonTeamDOs();
        for (DynamicObject personTeamDO : personTeamDOs) {
            String personTeamStatus = personTeamDO.getString("servicestate");
            String endbillno = personTeamDO.getString("endbillno");
            Long dbTeamId = personTeamDO.getLong("projectteam.id");
            if (HRStringUtils.isEmpty((String)endbillno) || !dbTeamId.equals(param.getTeamId()) || !"B".equals(personTeamStatus)) continue;
            param.setCheckMsgBillNo(endbillno);
            res = true;
        }
        return res;
    }

    private static boolean checkProjectPrincipal(ValidateParamDto param) {
        boolean inHavePrincipal = false;
        if (param.isIsprincipal()) {
            for (DynamicObject personProjectRole : param.getPersonProjectRoleDOs()) {
                String personTeamRoleState = personProjectRole.getString("servicestate");
                String isprincipal = personProjectRole.getString("isprincipal");
                Long personProRoleId = personProjectRole.getLong("projectrole.id");
                if (param.getValidateType() == AdjustEntryEnum.ADJUST_ADJ) {
                    boolean checkBeforeRole = param.getBeforeRoleId().equals(personProRoleId);
                    if (checkBeforeRole || !isprincipal.equals("1") || personTeamRoleState.equals("C")) continue;
                    inHavePrincipal = true;
                    continue;
                }
                if (!isprincipal.equals("1") || personTeamRoleState.equals("C")) continue;
                inHavePrincipal = true;
            }
        }
        return inHavePrincipal;
    }

    private static List<ValidateMsg> checkTeamRoleOutTime(ValidateParamDto param) {
        ArrayList<ValidateMsg> msgs = new ArrayList<ValidateMsg>();
        List<DynamicObject> personTeamRoleDOs = param.getPersonTeamRoleDOs();
        for (DynamicObject personTeamRoleDO : personTeamRoleDOs) {
            String personTeamRoleState = personTeamRoleDO.getString("servicestate");
            if (!personTeamRoleState.equals("C")) continue;
            Long personTeamRoleId = personTeamRoleDO.getLong("projectrole.id");
            Date personTeamRoleStartDate = personTeamRoleDO.getDate("joindate");
            Date personTeamRoleEndDate = personTeamRoleDO.getDate("quitdate");
            if (param.getRoleId().equals(personTeamRoleId) && PTMMBuisinessCheckUtils.checktiemIn(param.getEffectTime(), personTeamRoleStartDate, personTeamRoleEndDate)) {
                ValidateMsg msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode(PTMMBuisinessCheckUtils.getCheckTeamRoleOutTimeMsgCode(param), param, param.getRoleName(), personTeamRoleStartDate, personTeamRoleEndDate);
                msgs.add(msg);
            }
            if (PTMMBuisinessCheckUtils.checkTeamOtherRoleOutTime(param, personTeamRoleDO).size() <= 0) continue;
            msgs.addAll(PTMMBuisinessCheckUtils.checkTeamOtherRoleOutTime(param, personTeamRoleDO));
        }
        return msgs;
    }

    private static List<ValidateMsg> checkDissociateRole(ValidateParamDto param) {
        HashSet<Long> rowRoleIdSet = new HashSet<Long>();
        rowRoleIdSet.add(param.getRoleId());
        rowRoleIdSet.addAll(param.getOtherRoleIds());
        ArrayList<ValidateMsg> result = new ArrayList<ValidateMsg>();
        List<DynamicObject> personTeamRoleDOs = param.getPersonTeamRoleDOs();
        Optional<DynamicObject> sameRole = personTeamRoleDOs.stream().filter(personTeamRoleDO -> {
            long projectRoleId = personTeamRoleDO.getLong("projectrole.id");
            String serviceStatus = personTeamRoleDO.getString("servicestate");
            boolean hasSameRole = rowRoleIdSet.contains(projectRoleId);
            Supplier<Boolean> servicingOrToBeEffectChecker = () -> HRStringUtils.equals((String)serviceStatus, (String)"B") || HRStringUtils.equals((String)serviceStatus, (String)"A");
            Supplier<Boolean> checkTimeChecker = () -> PTMMBuisinessCheckUtils.checktiemIn(param.getEffectTime(), personTeamRoleDO.getDate("joindate"), personTeamRoleDO.getDate("quitdate"));
            return hasSameRole && (servicingOrToBeEffectChecker.get() != false || checkTimeChecker.get() != false);
        }).findAny();
        if (sameRole.isPresent()) {
            ValidateMsg msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Add_12", param, sameRole.get().getString("projectrole.name"), null, null);
            result.add(msg);
        }
        return result;
    }

    private static String getCheckTeamRoleOutTimeMsgCode(ValidateParamDto param) {
        String msgCode = "";
        if (param.getValidateType() == AdjustEntryEnum.JOIN) {
            msgCode = "Add_11";
        } else if (param.getValidateType() == AdjustEntryEnum.ADJUST_ADJ || param.getValidateType() == AdjustEntryEnum.ADJUST_JOIN) {
            msgCode = "Edit_13";
        }
        return msgCode;
    }

    private static List<ValidateMsg> checkTeamOtherRoleOutTime(ValidateParamDto param, DynamicObject personTeamRoleDO) {
        ArrayList<ValidateMsg> msgs = new ArrayList<ValidateMsg>();
        Long personTeamRoleId = personTeamRoleDO.getLong("projectrole.id");
        List<Long> otherRoleIds = param.getOtherRoleIds();
        if (otherRoleIds == null || !otherRoleIds.contains(personTeamRoleId)) {
            return msgs;
        }
        for (Long otherRoleId : otherRoleIds) {
            String personTeamRoleName = personTeamRoleDO.getString("projectrole.name");
            Date personTeamRoleStartDate = personTeamRoleDO.getDate("joindate");
            Date personTeamRoleEndDate = personTeamRoleDO.getDate("quitdate");
            if (!otherRoleId.equals(personTeamRoleId) || !PTMMBuisinessCheckUtils.checktiemIn(param.getEffectTime(), personTeamRoleStartDate, personTeamRoleEndDate)) continue;
            ValidateMsg msg = PTMMBuisinessCheckUtils.getCheckMsgByMsgCode("Add_11", param, personTeamRoleName, personTeamRoleStartDate, personTeamRoleEndDate);
            msgs.add(msg);
        }
        return msgs;
    }

    private static boolean checktiemIn(Date checkDate, Date startDate, Date EndDate) {
        boolean res = false;
        if (checkDate.getTime() >= startDate.getTime() && checkDate.getTime() < EndDate.getTime()) {
            res = true;
        }
        return res;
    }

    private static boolean checkOverRoleStatus(ValidateParamDto param) {
        boolean res = false;
        Long teamMemberRoleId = param.getRoleDO().getLong("id");
        for (DynamicObject personTeamRole : param.getPersonTeamRoleDOs()) {
            String personTeamRoleServicestate = personTeamRole.getString("servicestate");
            Long personTeamRoleId = personTeamRole.getLong("id");
            String endbillno = personTeamRole.getString("endbillno");
            if (personTeamRoleServicestate.equals("B") && teamMemberRoleId.equals(personTeamRoleId) && !ObjectUtils.isEmpty((Object)endbillno)) {
                param.setCheckMsgBillNo(personTeamRole.getString("endbillno"));
                res = true;
            }
            if (!personTeamRoleServicestate.equals("C") || !teamMemberRoleId.equals(personTeamRoleId) || ObjectUtils.isEmpty((Object)endbillno)) continue;
            param.setCheckMsgBillNo(personTeamRole.getString("endbillno"));
            res = true;
        }
        return res;
    }

    private static boolean checkRoleOutInfo(Long roleId, ValidateParamDto param) {
        boolean res = false;
        Long beforeTeamMemberRoleId = param.getBeforeRoleDO().getLong("id");
        for (DynamicObject personTeamRole : param.getPersonBeforeTeamRoleDOs()) {
            String personTeamRoleServicestate = personTeamRole.getString("servicestate");
            Long personTeamRoleId = personTeamRole.getLong("projectrole.id");
            String endbillno = personTeamRole.getString("endbillno");
            Date personTeamRoleQuitDate = personTeamRole.getDate("quitdate");
            if (personTeamRoleServicestate.equals("B") && roleId.equals(personTeamRoleId) && !ObjectUtils.isEmpty((Object)endbillno)) {
                param.setCheckMsgBillNo(personTeamRole.getString("endbillno"));
                res = true;
                LOGGER.info("checkRoleOutInfo true, have quit bill");
            }
            Date personTeamRoleJoinDate = personTeamRole.getDate("joindate");
            boolean isOutBeforJoin = HRDateTimeUtils.dayBefore((Date)param.getEffectTime(), (Date)personTeamRoleJoinDate);
            if (beforeTeamMemberRoleId.equals(personTeamRole.getLong("id")) && isOutBeforJoin && !"A".equals(personTeamRoleServicestate)) {
                param.setBusinessRoleJoinTime(PTMMBuisinessCheckUtils.getTimeStr(personTeamRoleJoinDate));
                res = true;
                LOGGER.info("checkRoleOutInfo true, quittime before joindate");
            }
            if (personTeamRoleServicestate.equals("C") && beforeTeamMemberRoleId.equals(personTeamRole.getLong("id"))) {
                param.setBusinessRoleJoinTime(PTMMBuisinessCheckUtils.getTimeStr(personTeamRoleJoinDate));
                LOGGER.info("checkRoleOutInfo true, save and other bill end the role ,then this bill commit");
                res = true;
            }
            if (personTeamRoleServicestate.equals("C") && roleId.equals(personTeamRoleId)) {
                boolean isEffBeforQuit = HRDateTimeUtils.dayBefore((Date)param.getEffectTime(), (Date)personTeamRoleQuitDate);
                boolean isStartBeforEff = HRDateTimeUtils.dayBefore((Date)personTeamRoleJoinDate, (Date)param.getEffectTime());
                if (isEffBeforQuit && isStartBeforEff) {
                    param.setBusinessRoleJoinTime(PTMMBuisinessCheckUtils.getTimeStr(param.getEffectTime()));
                    res = true;
                    LOGGER.info("checkRoleOutInfo true, time between  other starttime and endtime");
                }
            }
            String logInfo = String.format("checkRoleOutInfo billId is : [%s]; personid is [%s];personTeamRoleServicestate is[%s];personTeamRoleId is [%s];roleId is[%s];endbillno is[%s]", param.getBillId().toString(), param.getPersonId().toString(), personTeamRoleServicestate, personTeamRoleId.toString(), roleId.toString(), endbillno);
            LOGGER.info(logInfo);
        }
        return res;
    }

    private static boolean checkRoleOutTime(Long roleId, ValidateParamDto param) {
        boolean res = false;
        for (DynamicObject personTeamRole : param.getPersonTeamRoleDOs()) {
            String personTeamRoleServicestate = personTeamRole.getString("servicestate");
            Long personTeamRoleId = personTeamRole.getLong("projectrole.id");
            Date personTeamRoleJoinDate = personTeamRole.getDate("joindate");
            boolean isOutBeforJoin = HRDateTimeUtils.dayBefore((Date)param.getEffectTime(), (Date)personTeamRoleJoinDate);
            if (!roleId.equals(personTeamRoleId) || !isOutBeforJoin || !"B".equals(personTeamRoleServicestate)) continue;
            param.setBusinessRoleJoinTime(PTMMBuisinessCheckUtils.getTimeStr(personTeamRoleJoinDate));
            res = true;
        }
        return res;
    }

    private static boolean checkRoleOverTimeEdit(Long roleId, ValidateParamDto param) {
        boolean res = false;
        for (DynamicObject personTeamRole : param.getPersonTeamRoleDOs()) {
            Long personTeamRoleId = personTeamRole.getLong("projectrole.id");
            if (!roleId.equals(personTeamRoleId)) continue;
            String personTeamRoleServicestate = personTeamRole.getString("servicestate");
            Date personTeamRoleJoinDate = personTeamRole.getDate("joindate");
            boolean isOutBeforJoin = HRDateTimeUtils.dayBefore((Date)param.getEffectTime(), (Date)personTeamRoleJoinDate);
            if (!isOutBeforJoin || !"B".equals(personTeamRoleServicestate)) continue;
            param.setBusinessRoleJoinTime(PTMMBuisinessCheckUtils.getTimeStr(personTeamRoleJoinDate));
            res = true;
        }
        return res;
    }

    private static boolean checkRoleOverTimeEditBeforeRole(ValidateParamDto param) {
        boolean res = false;
        Date personTeamRoleBeforeJoinDate = param.getBeforeRoleDO().getDate("joindate");
        boolean isRoleEndTimeBeforeJoinTime = HRDateTimeUtils.dayBefore((Date)param.getEffectTime(), (Date)personTeamRoleBeforeJoinDate);
        if (isRoleEndTimeBeforeJoinTime) {
            res = true;
            param.setBusinessRoleJoinTime(PTMMBuisinessCheckUtils.getTimeStr(personTeamRoleBeforeJoinDate));
        }
        return res;
    }

    private static boolean checkTeamMemberRoleByStatus(String status, ValidateParamDto param) {
        boolean res = false;
        List<DynamicObject> personTeamRoleDOs = param.getPersonTeamRoleDOs();
        PluginProxy pluginProxy = PluginProxy.create((Object)new BillExtPoint4TeamMemberRoleTest(), IBillExPoint.class, (String)"kd.sdk.hr.hrmp.ptmm.expoint.IBillExPoint");
        LOGGER.info("before callReplace checkTeamMemberRoleByStatus PluginProxy size:{}", (Object)pluginProxy.getPlugins().size());
        Map<String, Object> paramMap = param.convertToMap();
        for (DynamicObject personTeamRoleDO : personTeamRoleDOs) {
            String personTeamRoleStatus = personTeamRoleDO.getString("servicestate");
            Date personTeamRoleQuitDate = personTeamRoleDO.getDate("quitdate");
            Long personTeamRoleId = personTeamRoleDO.getLong("projectrole.id");
            AtomicBoolean validateResultForExt = new AtomicBoolean(true);
            pluginProxy.callReplace(plugin -> {
                validateResultForExt.set(plugin.memberRoleValidator(personTeamRoleDO, paramMap));
                return null;
            });
            if (!personTeamRoleStatus.equals(status) || !personTeamRoleId.equals(param.getRoleId()) || personTeamRoleDO.getBoolean("isprincipal") != param.isIsprincipal() || !validateResultForExt.get()) continue;
            param.setBusinessRoleQuitTime(PTMMBuisinessCheckUtils.getTimeStr(personTeamRoleQuitDate));
            param.setCheckMsgBillNo(personTeamRoleDO.getString("joinbillno"));
            res = true;
        }
        return res;
    }

    private static boolean checkRoleQuitTime(ValidateParamDto param, Long roleId, List<DynamicObject> personTeamRoleDOs) {
        boolean res = false;
        TimePeriod paramRoleTimePeriod = new TimePeriod();
        for (DynamicObject dynamicObject : personTeamRoleDOs) {
            String personTeamRoleStatus = dynamicObject.getString("servicestate");
            Long personTeamRoleId = dynamicObject.getLong("projectrole.id");
            Date personTeamRoleStartDate = dynamicObject.getDate("joindate");
            if (!"B".equals(personTeamRoleStatus) || !personTeamRoleId.equals(roleId)) continue;
            paramRoleTimePeriod.setStartTime(personTeamRoleStartDate);
            paramRoleTimePeriod.setEndTime(param.getEffectTime());
        }
        StringBuilder checkMsgBuilder = new StringBuilder();
        for (DynamicObject personTeamRoleDO : personTeamRoleDOs) {
            String personTeamRoleStatus = personTeamRoleDO.getString("servicestate");
            String personTeamRoleName = personTeamRoleDO.getString("projectrole.name");
            Long personTeamRoleId = personTeamRoleDO.getLong("projectrole.id");
            Date personTeamRoleStartDate = personTeamRoleDO.getDate("joindate");
            Date personTeamRoleQuitDate = personTeamRoleDO.getDate("quitdate");
            if (!"C".equals(personTeamRoleStatus) || !personTeamRoleId.equals(roleId)) continue;
            TimePeriod quitRoleTimePeriod = new TimePeriod();
            quitRoleTimePeriod.setStartTime(personTeamRoleStartDate);
            quitRoleTimePeriod.setEndTime(personTeamRoleQuitDate);
            boolean checkIsTimePeriodIntersection = TimePeriodCalcUtils.checkIsTimePeriodIntersection((TimePeriod)paramRoleTimePeriod, (TimePeriod)quitRoleTimePeriod);
            String logInfo = String.format("checkRoleQuitTime billId is : [%s]; paramRoleStart:[%s];paramRoleEnd:[%s];quitRoleStart:[%s];quitRoleEnd:[%s];checkRes:[%s]", param.getBillId().toString(), PTMMBuisinessCheckUtils.getTimeStr(paramRoleTimePeriod.getStartTime()), PTMMBuisinessCheckUtils.getTimeStr(paramRoleTimePeriod.getEndTime()), PTMMBuisinessCheckUtils.getTimeStr(quitRoleTimePeriod.getStartTime()), PTMMBuisinessCheckUtils.getTimeStr(quitRoleTimePeriod.getEndTime()), checkIsTimePeriodIntersection);
            LOGGER.info(logInfo);
            if (!checkIsTimePeriodIntersection) continue;
            res = true;
            checkMsgBuilder.append(personTeamRoleName);
            checkMsgBuilder.append('\u3001');
        }
        String string = checkMsgBuilder.toString();
        if (string.length() > 0) {
            param.setCheckMsg(string.substring(0, string.length() - 1));
        }
        return res;
    }
}

