/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.domain.sync.assemble;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.ptmm.business.domain.repository.DepEmpRepository;
import kd.hr.ptmm.business.domain.repository.HrpiProjectMemberRecordRepository;
import kd.hr.ptmm.business.domain.repository.HrpiProjectMemberRepository;
import kd.hr.ptmm.business.domain.repository.PersonRoleRepository;
import kd.hr.ptmm.business.domain.repository.TeamMemberRoleRepository;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.business.domain.sync.assemble.AssembleService;
import kd.hr.ptmm.business.domain.sync.dto.AssembleRequestData;
import kd.hr.ptmm.business.domain.sync.dto.AssembleResponseData;
import org.apache.http.util.Asserts;

public abstract class AbsAssembleServiceImpl
implements AssembleService {
    private static final Log LOG = LogFactory.getLog(AbsAssembleServiceImpl.class);

    @Override
    public List<AssembleResponseData> assembleData(List<AssembleRequestData> assembleRequestDataList) {
        Asserts.check((!CollectionUtils.isEmpty(assembleRequestDataList) ? 1 : 0) != 0, (String)"syncDtoList");
        return null;
    }

    protected DynamicObject generateDepEmpDO(DynamicObject teamMemberDO, DynamicObject employeeDO, DynamicObject cmpEmpDO) {
        DynamicObject depEmpDO = DepEmpRepository.getInstance().generateEmptyDynamicObject();
        depEmpDO.set("id", (Object)ORM.create().genLongId(DepEmpRepository.getInstance().getEntityName()));
        depEmpDO.set("bsed", (Object)teamMemberDO.getDate("joindate"));
        depEmpDO.set("person", teamMemberDO.get("person"));
        depEmpDO.set("startdate", (Object)teamMemberDO.getDate("joindate"));
        depEmpDO.set("businessstatus", (Object)"1");
        depEmpDO.set("employee", (Object)employeeDO);
        depEmpDO.set("cmpemp", (Object)cmpEmpDO);
        DynamicObject projectRoleDO = teamMemberDO.getDynamicObject("projectrole");
        Map<Long, Long> projectRoleByWorkRole = PTMMServiceFactory.workRoleHrService.getPositionByWorkRole(Collections.singletonList(projectRoleDO));
        depEmpDO.set("dutyworkroles", (Object)projectRoleByWorkRole.get(projectRoleDO.getLong("id")));
        depEmpDO.set("orgteam", (Object)teamMemberDO.getDynamicObject("projectteam").getLong("id"));
        depEmpDO.set("otclassify", (Object)1020L);
        depEmpDO.set("adminorg", teamMemberDO.getDynamicObject("projectteam").get("belongadminorg"));
        Date sysMaxDate = HRDateTimeUtils.getSysMaxDate();
        depEmpDO.set("enddate", (Object)sysMaxDate);
        depEmpDO.set("bsled", (Object)sysMaxDate);
        depEmpDO.set("initstatus", (Object)"2");
        return depEmpDO;
    }

    protected DynamicObject generateHrpiProjectMemberDO(DynamicObject teamMemberDO, DynamicObject employeeDO, DynamicObject cmpEmpDO, DynamicObject depEmpDO) {
        DynamicObject hrpiProjectMember = HrpiProjectMemberRepository.getInstance().generateEmptyDynamicObject();
        hrpiProjectMember.set("id", (Object)teamMemberDO.getLong("id"));
        hrpiProjectMember.set("bsed", (Object)teamMemberDO.getDate("joindate"));
        hrpiProjectMember.set("person", teamMemberDO.get("person"));
        hrpiProjectMember.set("projectteam", teamMemberDO.get("projectteam"));
        DynamicObject projectRoleDO = teamMemberDO.getDynamicObject("projectrole");
        hrpiProjectMember.set("projectrole", (Object)PTMMServiceFactory.workRoleHrService.getProjectRoleByWorkRole(projectRoleDO));
        hrpiProjectMember.set("businessstatus", (Object)"1");
        hrpiProjectMember.set("startdate", teamMemberDO.get("joindate"));
        hrpiProjectMember.set("employee", (Object)employeeDO);
        hrpiProjectMember.set("cmpemp", (Object)cmpEmpDO);
        hrpiProjectMember.set("depemp", (Object)depEmpDO);
        Date sysMaxDate = HRDateTimeUtils.getSysMaxDate();
        hrpiProjectMember.set("enddate", (Object)sysMaxDate);
        hrpiProjectMember.set("bsled", (Object)sysMaxDate);
        DynamicObject[] teamMemberRolesFromDB = TeamMemberRoleRepository.getInstance().getOtherRoleByTeamMember(teamMemberDO.getLong("id"));
        String otherRoleNames = this.getOtherTeamMemberRoleNames(teamMemberRolesFromDB);
        hrpiProjectMember.set("otherprojectrole", (Object)otherRoleNames);
        hrpiProjectMember.set("initstatus", (Object)"2");
        return hrpiProjectMember;
    }

    protected DynamicObject generatePersonRoleDO(DynamicObject teamMemberRoleDO, DynamicObject depEmpDO, DynamicObject employee, DynamicObject cmpEmp) {
        DynamicObject personRoleDO = PersonRoleRepository.getInstance().generateEmptyDynamicObject();
        personRoleDO.set("id", (Object)ORM.create().genLongId(PersonRoleRepository.getInstance().getEntityName()));
        personRoleDO.set("bsed", teamMemberRoleDO.get("joindate"));
        personRoleDO.set("person", teamMemberRoleDO.get("person"));
        personRoleDO.set("depemp", (Object)depEmpDO);
        personRoleDO.set("startdate", teamMemberRoleDO.get("joindate"));
        personRoleDO.set("iseffective", (Object)"1");
        personRoleDO.set("businessstatus", (Object)"1");
        personRoleDO.set("employee", (Object)employee);
        personRoleDO.set("cmpemp", (Object)cmpEmp);
        personRoleDO.set("role", teamMemberRoleDO.get("projectrole"));
        DynamicObject projectTeamDO = teamMemberRoleDO.getDynamicObject("projectteam");
        personRoleDO.set("adminorg", (Object)projectTeamDO);
        Date sysMaxDate = HRDateTimeUtils.getSysMaxDate();
        personRoleDO.set("enddate", (Object)sysMaxDate);
        personRoleDO.set("bsled", (Object)sysMaxDate);
        personRoleDO.set("initstatus", (Object)"2");
        return personRoleDO;
    }

    protected DynamicObject generateProjectMemberRecord(DynamicObject teamMemberRoleDO, DynamicObject employee) {
        DynamicObject dynamicObject = HrpiProjectMemberRecordRepository.getInstance().generateEmptyDynamicObject();
        dynamicObject.set("id", (Object)teamMemberRoleDO.getLong("id"));
        dynamicObject.set("projectteam", teamMemberRoleDO.get("projectteam"));
        DynamicObject projectRoleDO = teamMemberRoleDO.getDynamicObject("projectrole");
        dynamicObject.set("projectrole", (Object)PTMMServiceFactory.workRoleHrService.getProjectRoleByWorkRole(projectRoleDO));
        dynamicObject.set("startdate", teamMemberRoleDO.get("joindate"));
        dynamicObject.set("person", teamMemberRoleDO.get("person"));
        dynamicObject.set("enddate", (Object)HRDateTimeUtils.getSysMaxDate());
        dynamicObject.set("employee", (Object)employee);
        dynamicObject.set("isprimary", teamMemberRoleDO.get("isteammainrole"));
        dynamicObject.set("initstatus", (Object)"2");
        return dynamicObject;
    }

    protected DynamicObject[] queryDepEmpDOs(List<Long> depEmpIds) {
        return PTMMServiceFactory.hrpiService.listInfoById(depEmpIds, DepEmpRepository.getInstance().getEntityName());
    }

    protected DynamicObject[] queryPersonRoleRels(List<Long> personRoleRelIds) {
        return PTMMServiceFactory.hrpiService.listInfoById(personRoleRelIds, PersonRoleRepository.getInstance().getEntityName());
    }

    protected DynamicObject[] getProjectMemberDOs(List<AssembleRequestData> requestDataList) {
        List<Long> projectMemberIdList = requestDataList.stream().filter(requestData -> Objects.nonNull(requestData.getTeamMemberDO())).map(requestData -> {
            DynamicObject teamMemberDO = requestData.getTeamMemberDO();
            return teamMemberDO.getLong("id");
        }).collect(Collectors.toList());
        return this.queryProjectMembers(projectMemberIdList);
    }

    protected DynamicObject[] queryProjectMembers(List<Long> idList) {
        return PTMMServiceFactory.hrpiService.listInfoById(idList, HrpiProjectMemberRepository.getInstance().getEntityName());
    }

    protected DynamicObject[] queryProjectMemberRecords(List<Long> idList) {
        return PTMMServiceFactory.hrpiService.listInfoById(idList, HrpiProjectMemberRecordRepository.getInstance().getEntityName());
    }

    protected DynamicObject invalidDepEmpDO(DynamicObject depEmpDO, DynamicObject teamMemberDO) {
        depEmpDO.set("bsed", (Object)teamMemberDO.getDate("quitdate"));
        depEmpDO.set("businessstatus", (Object)"2");
        depEmpDO.set("enddate", (Object)teamMemberDO.getDate("quitdate"));
        return this.getCloneDataForHisModel(depEmpDO);
    }

    protected DynamicObject invalidPersonRoleRelDO(DynamicObject dynamicObject, DynamicObject teamMemberRoleDO) {
        dynamicObject.set("bsed", (Object)teamMemberRoleDO.getDate("quitdate"));
        dynamicObject.set("businessstatus", (Object)"2");
        dynamicObject.set("enddate", (Object)teamMemberRoleDO.getDate("quitdate"));
        return this.getCloneDataForHisModel(dynamicObject);
    }

    protected DynamicObject invalidProjectMemberDO(DynamicObject projectMemberDO, DynamicObject teamMemberDO) {
        projectMemberDO.set("bsed", (Object)teamMemberDO.getDate("quitdate"));
        projectMemberDO.set("businessstatus", (Object)"2");
        projectMemberDO.set("enddate", (Object)teamMemberDO.getDate("quitdate"));
        return this.getCloneDataForHisModel(projectMemberDO);
    }

    protected DynamicObject invalidProjectMemberRecordDO(DynamicObject dynamicObject, DynamicObject teamMemberRoleDO) {
        dynamicObject.set("enddate", teamMemberRoleDO.get("quitdate"));
        return this.getCloneDataForHisModel(dynamicObject);
    }

    protected DynamicObject updateProjectMemberOthRole(DynamicObject projectMemberDO, DynamicObject teamMemberDO) {
        DynamicObject[] otherRoles = TeamMemberRoleRepository.getInstance().getOtherRoleByTeamMember(teamMemberDO.getLong("id"));
        String otherTeamMemberRoleNames = this.getOtherTeamMemberRoleNames(otherRoles);
        projectMemberDO.set("otherprojectrole", (Object)otherTeamMemberRoleNames);
        return this.getCloneDataForHisModel(projectMemberDO);
    }

    protected DynamicObject filterProjectMemberRecord(DynamicObject[] projectMemberRecords, DynamicObject teamMemberRole) {
        long id = teamMemberRole.getLong("id");
        return Arrays.stream(projectMemberRecords).filter(projectMemberRecord -> projectMemberRecord.getLong("id") == id).findFirst().orElseThrow(() -> new RuntimeException("not find projectmemberrecord"));
    }

    protected DynamicObject filterProjectMember(DynamicObject[] projectMembers, DynamicObject teamMember) {
        if (projectMembers == null || projectMembers.length == 0 || Objects.isNull(teamMember)) {
            return null;
        }
        long id = teamMember.getLong("id");
        return Arrays.stream(projectMembers).filter(projectMember -> projectMember.getLong("id") == id).findFirst().orElse(null);
    }

    protected DynamicObject filterPersonRoleRel(DynamicObject[] personRoleRelDOs, DynamicObject teamMemberRole) {
        long personRoleRelId = teamMemberRole.getLong("personrolerel.id");
        return Arrays.stream(personRoleRelDOs).filter(personRoleRelDO -> personRoleRelId == personRoleRelDO.getLong("id")).findFirst().orElse(null);
    }

    protected DynamicObject filterDepEmp(DynamicObject[] depEmpDOs, DynamicObject teamMember) {
        long depEmpId = teamMember.getDynamicObject("depemp").getLong("id");
        return Arrays.stream(depEmpDOs).filter(depEmp -> depEmp.getLong("id") == depEmpId).findFirst().orElseThrow(() -> new RuntimeException("not find depemp"));
    }

    private DynamicObject getCloneDataForHisModel(DynamicObject dynamicObject) {
        String entityName = dynamicObject.getDataEntityType().getName();
        DynamicObject clone = new HRBaseServiceHelper(entityName).generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)clone, (boolean)true);
        clone.set("sourcevid", null);
        clone.set("id", (Object)ORM.create().genLongId(entityName));
        return clone;
    }

    private String getOtherTeamMemberRoleNames(DynamicObject[] otherTeamMemberRoles) {
        List otherRoleNames = Arrays.stream(otherTeamMemberRoles).map(otherTeamMemberRole -> otherTeamMemberRole.getDynamicObject("projectrole").getString("name")).collect(Collectors.toList());
        return Joiner.on((char)',').skipNulls().join(otherRoleNames);
    }
}

