/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.domain.sync.assemble;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.ptmm.business.domain.sync.assemble.AbsAssembleServiceImpl;
import kd.hr.ptmm.business.domain.sync.dto.AssembleRequestData;
import kd.hr.ptmm.business.domain.sync.dto.AssembleResponseData;
import org.apache.http.util.Asserts;

public class QuitMainRoleServiceImpl
extends AbsAssembleServiceImpl {
    @Override
    public List<AssembleResponseData> assembleData(List<AssembleRequestData> requestDataList) {
        super.assembleData(requestDataList);
        ArrayList<AssembleResponseData> responseDataList = new ArrayList<AssembleResponseData>(requestDataList.size());
        DynamicObject[] depEmpDOs = this.getDepEmpDOs(requestDataList);
        DynamicObject[] projectMemberDOs = this.getProjectMemberDOs(requestDataList);
        ArrayList<Long> personRoleRelIds = new ArrayList<Long>();
        ArrayList<Long> teamMemberRoleIds = new ArrayList<Long>();
        requestDataList.forEach(requestData -> {
            List<DynamicObject> teamMemberRoleDOList = requestData.getTeamMemberRoleDOList();
            personRoleRelIds.addAll(teamMemberRoleDOList.stream().map(memberRoleDO -> memberRoleDO.getDynamicObject("personrolerel").getLong("id")).collect(Collectors.toList()));
            teamMemberRoleIds.addAll(teamMemberRoleDOList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        });
        DynamicObject[] personRoleRelDOs = this.queryPersonRoleRels(personRoleRelIds);
        DynamicObject[] projectMemberRecordDOs = this.queryProjectMemberRecords(teamMemberRoleIds);
        requestDataList.forEach(requestData -> {
            AssembleResponseData responseData = new AssembleResponseData();
            DynamicObject teamMemberDO = requestData.getTeamMemberDO();
            DynamicObject depEmpDO = this.filterDepEmp(depEmpDOs, teamMemberDO);
            List<DynamicObject> teamMemberRoleDOList = requestData.getTeamMemberRoleDOList();
            DynamicObject newDepEmpDO = this.invalidDepEmpDO(depEmpDO, teamMemberDO);
            responseData.setDepEmpDO(newDepEmpDO);
            DynamicObject projectMemberDO = this.filterProjectMember(projectMemberDOs, teamMemberDO);
            Asserts.notNull((Object)projectMemberDO, (String)"projectMemberDO");
            DynamicObject newProjectMemberDO = this.invalidProjectMemberDO(projectMemberDO, teamMemberDO);
            responseData.setProjectMemberDO(newProjectMemberDO);
            ArrayList<DynamicObject> personRoleRelDOList = new ArrayList<DynamicObject>(teamMemberRoleDOList.size());
            ArrayList<DynamicObject> projectMemberRecordList = new ArrayList<DynamicObject>(teamMemberRoleDOList.size());
            teamMemberRoleDOList.forEach(teamMemberRoleDO -> {
                DynamicObject personRoleRelDO = this.filterPersonRoleRel(personRoleRelDOs, (DynamicObject)teamMemberRoleDO);
                personRoleRelDOList.add(this.invalidPersonRoleRelDO(personRoleRelDO, (DynamicObject)teamMemberRoleDO));
                DynamicObject projectMemberRecord = this.filterProjectMemberRecord(projectMemberRecordDOs, (DynamicObject)teamMemberRoleDO);
                projectMemberRecordList.add(this.invalidProjectMemberRecordDO(projectMemberRecord, (DynamicObject)teamMemberRoleDO));
            });
            responseData.setPersonRoleDOList(personRoleRelDOList);
            responseData.setProjectMemberRecordDOList(projectMemberRecordList);
            responseDataList.add(responseData);
        });
        return responseDataList;
    }

    private DynamicObject[] getDepEmpDOs(List<AssembleRequestData> requestDataList) {
        List<Long> depEmpIdList = requestDataList.stream().map(requestData -> {
            DynamicObject teamMemberDO = requestData.getTeamMemberDO();
            DynamicObject depEmpDO = teamMemberDO.getDynamicObject("depemp");
            Asserts.notNull((Object)depEmpDO, (String)"depEmpDO");
            return depEmpDO.getLong("id");
        }).collect(Collectors.toList());
        return this.queryDepEmpDOs(depEmpIdList);
    }
}

