/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.domain.sync.assemble;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.ptmm.business.domain.sync.assemble.AbsAssembleServiceImpl;
import kd.hr.ptmm.business.domain.sync.dto.AssembleRequestData;
import kd.hr.ptmm.business.domain.sync.dto.AssembleResponseData;

public class QuitOtherRoleServiceImpl
extends AbsAssembleServiceImpl {
    @Override
    public List<AssembleResponseData> assembleData(List<AssembleRequestData> requestDataList) {
        super.assembleData(requestDataList);
        ArrayList<AssembleResponseData> responseDataList = new ArrayList<AssembleResponseData>(requestDataList.size());
        ArrayList<Long> personRoleRelIds = new ArrayList<Long>();
        ArrayList<Long> teamMemberRoleIds = new ArrayList<Long>();
        requestDataList.forEach(requestData -> {
            List<DynamicObject> teamMemberRoleDOList = requestData.getTeamMemberRoleDOList();
            personRoleRelIds.addAll(teamMemberRoleDOList.stream().map(memberRoleDO -> memberRoleDO.getLong("personrolerel.id")).collect(Collectors.toList()));
            teamMemberRoleIds.addAll(teamMemberRoleDOList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        });
        DynamicObject[] personRoleRelDOs = this.queryPersonRoleRels(personRoleRelIds);
        DynamicObject[] projectMemberRecordDOs = this.queryProjectMemberRecords(teamMemberRoleIds);
        requestDataList.forEach(requestData -> {
            AssembleResponseData responseData = new AssembleResponseData();
            List<DynamicObject> teamMemberRoleDOList = requestData.getTeamMemberRoleDOList();
            ArrayList<DynamicObject> personRoleRelDOList = new ArrayList<DynamicObject>(teamMemberRoleDOList.size());
            ArrayList<DynamicObject> projectMemberRecordList = new ArrayList<DynamicObject>(teamMemberRoleDOList.size());
            teamMemberRoleDOList.forEach(teamMemberRoleDO -> {
                DynamicObject newPersonRoleRelDO = this.filterPersonRoleRel(personRoleRelDOs, (DynamicObject)teamMemberRoleDO);
                if (Objects.nonNull(newPersonRoleRelDO)) {
                    personRoleRelDOList.add(this.invalidPersonRoleRelDO(newPersonRoleRelDO, (DynamicObject)teamMemberRoleDO));
                }
                DynamicObject newProjectMemberRecordDO = this.filterProjectMemberRecord(projectMemberRecordDOs, (DynamicObject)teamMemberRoleDO);
                projectMemberRecordList.add(this.invalidProjectMemberRecordDO(newProjectMemberRecordDO, (DynamicObject)teamMemberRoleDO));
            });
            responseData.setPersonRoleDOList(personRoleRelDOList);
            responseData.setProjectMemberRecordDOList(projectMemberRecordList);
            responseDataList.add(responseData);
        });
        return responseDataList;
    }
}

