/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.domain.sync.impl;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.ptmm.business.domain.repository.TeamMemberRepository;
import kd.hr.ptmm.business.domain.repository.TeamMemberRoleRepository;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.business.domain.sync.SyncRequestData;
import kd.hr.ptmm.business.domain.sync.SyncTeamMemberService;
import kd.hr.ptmm.business.domain.sync.assemble.AssembleService;
import kd.hr.ptmm.business.domain.sync.dto.AssembleRequestData;
import kd.hr.ptmm.business.domain.sync.dto.AssembleResponseData;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.util.Asserts;

public class SyncTeamMemberServiceImpl
implements SyncTeamMemberService {
    private static final Log LOG = LogFactory.getLog(SyncTeamMemberServiceImpl.class);

    @Override
    public void syncDataJoin(List<Long> teamMemberRoleIdList) {
        LOG.info("SyncTeamMemberService syncDataJoin roleList: {}", teamMemberRoleIdList);
        if (CollectionUtils.isEmpty(teamMemberRoleIdList)) {
            return;
        }
        try {
            List<AssembleRequestData> responseDataList = this.assembleJoinRequestData(teamMemberRoleIdList);
            this.invokeSave(responseDataList);
        }
        catch (Exception exception) {
            LOG.error("SyncTeamMemberService-syncDataJoin error: ", (Throwable)exception);
            throw new KDBizException((Throwable)exception, new ErrorCode("SyncTeamMemberServiceImpl.doSyncData", ResManager.loadKDString((String)"\u540c\u6b65\u6570\u636e\u5230\u4eba\u5458\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"SyncTeamMemberServiceImpl_0", (String)"hr-ptmm-business", (Object[])new Object[0])), new Object[0]);
        }
    }

    @Override
    public void syncDataQuit(List<Long> teamMemberRoleIdList) {
        LOG.info("SyncTeamMemberService syncDataQuit roleList: {}", teamMemberRoleIdList);
        if (CollectionUtils.isEmpty(teamMemberRoleIdList)) {
            return;
        }
        try {
            List<AssembleRequestData> requestData = this.assembleQuitRequestData(teamMemberRoleIdList);
            this.invokeSave(requestData);
        }
        catch (Exception exception) {
            LOG.error("SyncTeamMemberService-syncDataQuit error: ", (Throwable)exception);
            throw new KDBizException((Throwable)exception, new ErrorCode("SyncTeamMemberServiceImpl.doSyncData", ResManager.loadKDString((String)"\u540c\u6b65\u6570\u636e\u5230\u4eba\u5458\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"SyncTeamMemberServiceImpl_0", (String)"hr-ptmm-business", (Object[])new Object[0])), new Object[0]);
        }
    }

    @Override
    public void syncData(List<SyncRequestData> syncRequestDataListAll) {
        List<SyncRequestData> syncRequestDataList;
        List<Long> personIds = syncRequestDataListAll.stream().map(SyncRequestData::getPersonId).collect(Collectors.toList());
        List<Long> departurePersonIds = PTMMServiceFactory.hrpiService.listBatchEmployeeByPerson(personIds);
        if (!CollectionUtils.isEmpty(departurePersonIds)) {
            LOG.info("SyncTeamMemberService.syncData quitPerson:{}", departurePersonIds);
        }
        if (CollectionUtils.isEmpty(syncRequestDataList = syncRequestDataListAll.stream().filter(syncRequestData -> !departurePersonIds.contains(syncRequestData.getPersonId())).collect(Collectors.toList()))) {
            return;
        }
        LOG.info("SyncTeamMemberService.syncData request: {}", syncRequestDataList);
        DynamicObject[] teamMemberRoleDOs = TeamMemberRoleRepository.getInstance().loadDynamicObjectArray(syncRequestDataList.stream().map(SyncRequestData::getTeamMemberRoleId).toArray());
        DynamicObject[] employeeDOs = this.getEmployees(teamMemberRoleDOs);
        DynamicObject[] cmpEmpDOs = this.getCmpEmps(teamMemberRoleDOs);
        DynamicObject[] teamMemberDOs = TeamMemberRepository.getInstance().loadDynamicObjectArray(syncRequestDataList.stream().map(SyncRequestData::getTeamMemberId).toArray());
        ArrayList<AssembleRequestData> assembleRequestDataList = new ArrayList<AssembleRequestData>(syncRequestDataList.size());
        this.supplyDissociateRole(syncRequestDataList, teamMemberRoleDOs, employeeDOs, cmpEmpDOs, assembleRequestDataList);
        syncRequestDataList.stream().filter(syncRequestData -> syncRequestData.getTeamMemberId() != null && syncRequestData.getTeamMemberId() != 0L).collect(Collectors.groupingBy(SyncRequestData::getTeamMemberId)).forEach((teamMemberId, syncRequestDataTempList) -> {
            LOG.info("SyncTeamMember.group: teamMemberId-{},data-{}", teamMemberId, syncRequestDataTempList);
            Long personId = ((SyncRequestData)syncRequestDataTempList.get(0)).getPersonId();
            List operateMainRoleDatas = syncRequestDataTempList.stream().filter(temp -> this.isOperateMainRole(temp.getSyncType())).collect(Collectors.toList());
            if (operateMainRoleDatas.size() > 1) {
                throw new KDBizException("can not operate mainrole more than once,teamMemberId: " + teamMemberId);
            }
            if (!CollectionUtils.isEmpty(operateMainRoleDatas)) {
                SyncRequestData syncRequestData2 = (SyncRequestData)operateMainRoleDatas.get(0);
                AssembleRequestData requestData = new AssembleRequestData();
                requestData.setAssembleType(syncRequestData2.getSyncType());
                requestData.setTeamMemberDO(this.filterTeamMember(teamMemberDOs, (long)teamMemberId));
                requestData.setCmpEmpDO(this.filterCmpemp(cmpEmpDOs, personId));
                requestData.setEmployeeDO(this.filterEmployee(employeeDOs, personId));
                ArrayList<DynamicObject> tempTeamMemberRoleDOList = new ArrayList<DynamicObject>(syncRequestDataTempList.size());
                syncRequestDataTempList.stream().map(SyncRequestData::getTeamMemberRoleId).forEach(teamMemberRoleId -> tempTeamMemberRoleDOList.add(this.filterTeamMemberRole(teamMemberRoleDOs, (long)teamMemberRoleId)));
                requestData.setTeamMemberRoleDOList(tempTeamMemberRoleDOList);
                assembleRequestDataList.add(requestData);
            } else {
                if (syncRequestDataTempList.stream().map(SyncRequestData::getSyncType).anyMatch(type -> HRStringUtils.equals((String)type, (String)"2") || HRStringUtils.equals((String)type, (String)"4"))) {
                    AssembleRequestData requestData = new AssembleRequestData();
                    assembleRequestDataList.add(requestData);
                    requestData.setAssembleType("5");
                    requestData.setTeamMemberDO(this.filterTeamMember(teamMemberDOs, (long)teamMemberId));
                }
                syncRequestDataTempList.forEach(syncRequestData -> {
                    AssembleRequestData requestData = new AssembleRequestData();
                    requestData.setAssembleType(syncRequestData.getSyncType());
                    requestData.setTeamMemberDO(this.filterTeamMember(teamMemberDOs, syncRequestData.getTeamMemberId()));
                    requestData.setTeamMemberRoleDOList(Collections.singletonList(this.filterTeamMemberRole(teamMemberRoleDOs, syncRequestData.getTeamMemberRoleId())));
                    requestData.setEmployeeDO(this.filterEmployee(employeeDOs, syncRequestData.getPersonId()));
                    requestData.setCmpEmpDO(this.filterCmpemp(cmpEmpDOs, syncRequestData.getPersonId()));
                    assembleRequestDataList.add(requestData);
                });
            }
        });
        this.invokeSave(assembleRequestDataList);
    }

    private void supplyDissociateRole(List<SyncRequestData> syncRequestDataList, DynamicObject[] teamMemberRoleDOs, DynamicObject[] employeeDOs, DynamicObject[] cmpEmpDOs, List<AssembleRequestData> assembleRequestDataList) {
        syncRequestDataList.stream().filter(syncRequestData -> syncRequestData.getTeamMemberId() == null || syncRequestData.getTeamMemberId() == 0L).forEach(syncRequestData -> {
            AssembleRequestData requestData = new AssembleRequestData();
            requestData.setCmpEmpDO(this.filterCmpemp(cmpEmpDOs, syncRequestData.getPersonId()));
            requestData.setEmployeeDO(this.filterEmployee(employeeDOs, syncRequestData.getPersonId()));
            requestData.setTeamMemberDO(null);
            requestData.setTeamMemberRoleDOList(Collections.singletonList(this.filterTeamMemberRole(teamMemberRoleDOs, syncRequestData.getTeamMemberRoleId())));
            requestData.setAssembleType(syncRequestData.getSyncType());
            assembleRequestDataList.add(requestData);
        });
    }

    private List<AssembleRequestData> assembleJoinRequestData(List<Long> teamMemberRoleIdList) {
        DynamicObject[] teamMemberRoleDOs = TeamMemberRoleRepository.getInstance().loadDynamicObjectArray(teamMemberRoleIdList.toArray());
        DynamicObject[] employeeDOs = this.getEmployees(teamMemberRoleDOs);
        DynamicObject[] cmpEmpDOs = this.getCmpEmps(teamMemberRoleDOs);
        ArrayList<AssembleRequestData> requestDataList = new ArrayList<AssembleRequestData>(teamMemberRoleIdList.size());
        Arrays.stream(teamMemberRoleDOs).filter(dynamicObject -> dynamicObject.get("teammember") == null).forEach(dynamicObject -> {
            long personId = dynamicObject.getDynamicObject("person").getLong("id");
            DynamicObject cmpEmpDO = this.filterCmpemp(cmpEmpDOs, personId);
            DynamicObject employeeDO = this.filterEmployee(employeeDOs, personId);
            AssembleRequestData requestData = new AssembleRequestData();
            requestDataList.add(requestData);
            requestData.setTeamMemberRoleDOList(Collections.singletonList(dynamicObject));
            requestData.setCmpEmpDO(cmpEmpDO);
            requestData.setEmployeeDO(employeeDO);
            requestData.setAssembleType("2");
        });
        Arrays.stream(teamMemberRoleDOs).filter(dynamicObject -> dynamicObject.get("teammember") != null).collect(Collectors.groupingBy(dy -> dy.getDynamicObject("teammember").getLong("id"))).forEach((teamMemberId, teamMemberRoleDOList) -> {
            DynamicObject[] teamMemberDOs = this.getTeamMemberDOs(teamMemberRoleDOList.toArray(new DynamicObject[0]));
            DynamicObject teamMember = this.filterTeamMember(teamMemberDOs, (long)teamMemberId);
            assert (teamMember != null);
            long personId = teamMember.getLong("person.id");
            AssembleRequestData requestData = new AssembleRequestData();
            requestDataList.add(requestData);
            requestData.setTeamMemberDO(teamMember);
            requestData.setTeamMemberRoleDOList((List<DynamicObject>)teamMemberRoleDOList);
            requestData.setEmployeeDO(this.filterEmployee(employeeDOs, personId));
            requestData.setCmpEmpDO(this.filterCmpemp(cmpEmpDOs, personId));
            if (teamMemberRoleDOList.stream().anyMatch(dynamicObject -> dynamicObject.getBoolean("isteammainrole"))) {
                requestData.setAssembleType("1");
            } else {
                requestData.setAssembleType("2");
            }
        });
        return requestDataList;
    }

    private List<AssembleRequestData> assembleQuitRequestData(List<Long> teamMemberRoleIdList) {
        DynamicObject[] teamMemberRoleDOs = TeamMemberRoleRepository.getInstance().loadDynamicObjectArray(teamMemberRoleIdList.toArray());
        DynamicObject[] employeeDOs = this.getEmployees(teamMemberRoleDOs);
        DynamicObject[] cmpEmpDOs = this.getCmpEmps(teamMemberRoleDOs);
        ArrayList<AssembleRequestData> requestDataList = new ArrayList<AssembleRequestData>(teamMemberRoleIdList.size() << 2);
        Arrays.stream(teamMemberRoleDOs).filter(dynamicObject -> dynamicObject.get("teammember") == null).forEach(dynamicObject -> {
            long personId = dynamicObject.getDynamicObject("person").getLong("id");
            DynamicObject cmpEmpDO = this.filterCmpemp(cmpEmpDOs, personId);
            DynamicObject employeeDO = this.filterEmployee(employeeDOs, personId);
            AssembleRequestData requestData = new AssembleRequestData();
            requestDataList.add(requestData);
            requestData.setTeamMemberRoleDOList(Collections.singletonList(dynamicObject));
            requestData.setCmpEmpDO(cmpEmpDO);
            requestData.setEmployeeDO(employeeDO);
            requestData.setAssembleType("4");
        });
        Arrays.stream(teamMemberRoleDOs).filter(dynamicObject -> dynamicObject.get("teammember") != null).collect(Collectors.groupingBy(dy -> dy.getDynamicObject("teammember").getLong("id"))).forEach((teamMemberId, teamMemberRoleDOList) -> {
            DynamicObject[] teamMemberDOs = this.getTeamMemberDOs(teamMemberRoleDOList.toArray(new DynamicObject[0]));
            DynamicObject teamMember = this.filterTeamMember(teamMemberDOs, (long)teamMemberId);
            assert (teamMember != null);
            long personId = teamMember.getLong("person.id");
            AssembleRequestData requestData = new AssembleRequestData();
            requestDataList.add(requestData);
            requestData.setTeamMemberDO(teamMember);
            requestData.setTeamMemberRoleDOList((List<DynamicObject>)teamMemberRoleDOList);
            requestData.setEmployeeDO(this.filterEmployee(employeeDOs, personId));
            requestData.setCmpEmpDO(this.filterCmpemp(cmpEmpDOs, personId));
            if (teamMemberRoleDOList.stream().anyMatch(dynamicObject -> dynamicObject.getBoolean("isteammainrole"))) {
                requestData.setAssembleType("3");
            } else {
                requestData.setAssembleType("4");
            }
        });
        return requestDataList;
    }

    private void invokeSave(List<AssembleRequestData> requestDataList) {
        if (CollectionUtils.isEmpty(requestDataList)) {
            return;
        }
        LOG.info("SyncTeamMember.assembleRequestData:{}", requestDataList);
        ArrayList<AssembleResponseData> responseDataList = new ArrayList<AssembleResponseData>();
        requestDataList.stream().collect(Collectors.groupingBy(AssembleRequestData::getAssembleType)).forEach((assembleType, requestList) -> {
            AssembleService instance = AssembleService.getInstance(assembleType);
            if (Objects.isNull(instance)) {
                return;
            }
            responseDataList.addAll(instance.assembleData((List<AssembleRequestData>)requestList));
        });
        LOG.info("SyncTeamMember.assembleResponseData:{}", responseDataList);
        Map<String, Object> param = this.formatResponseData(responseDataList);
        LOG.info("SyncTeamMemberService.saveBatch param: {}", param);
        Map<String, Object> map = PTMMServiceFactory.hrpiService.saveBatch(param);
        LOG.info("SyncTeamMemberService.saveBatch result: {}", map);
        if (!((Boolean)map.get("success")).booleanValue()) {
            List resultData = (List)map.get("data");
            if (!CollectionUtils.isEmpty((Collection)resultData) && HRStringUtils.equals((String)String.valueOf(((Map)resultData.get(0)).get("code")), (String)"501")) {
                LOG.info("SyncTeamMemberService hasBeenSaved");
                return;
            }
            throw new KDBizException("syncService error: " + map);
        }
        this.handleResponseData(responseDataList);
    }

    private void handleResponseData(List<AssembleResponseData> responseDataList) {
        try (TXHandle txHandle = TX.required((String)"SyncTeamMember");){
            try {
                ArrayList teamMemberDOList = new ArrayList();
                ArrayList teamMemberRoleDOList = new ArrayList();
                responseDataList.forEach(responseData -> {
                    Map<DynamicObject, DynamicObject> memberRole2PersonRoleMap;
                    Pair<DynamicObject, DynamicObject> member2DepEmpMapping = responseData.getMember2DepEmpMapping();
                    if (Objects.nonNull(member2DepEmpMapping)) {
                        DynamicObject teamMemberDO = (DynamicObject)member2DepEmpMapping.getLeft();
                        teamMemberDO.set("depemp", member2DepEmpMapping.getRight());
                        teamMemberDOList.add(teamMemberDO);
                    }
                    if (Objects.nonNull(memberRole2PersonRoleMap = responseData.getMemberRole2PersonRoleMap())) {
                        memberRole2PersonRoleMap.forEach((memberRole, personRole) -> {
                            memberRole.set("personrolerel", personRole);
                            teamMemberRoleDOList.add(memberRole);
                        });
                    }
                });
                if (!teamMemberDOList.isEmpty()) {
                    TeamMemberRepository.getInstance().save(teamMemberDOList.toArray(teamMemberDOList.toArray(new DynamicObject[0])));
                }
                if (!teamMemberRoleDOList.isEmpty()) {
                    TeamMemberRoleRepository.getInstance().save(teamMemberRoleDOList.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception exception) {
                LOG.error("SyncTeamMemberService.updateOurTable error: ", (Throwable)exception);
                txHandle.markRollback();
            }
        }
    }

    private Map<String, Object> formatResponseData(List<AssembleResponseData> responseDataList) {
        ArrayList<Map<String, Object>> hisDynParam = new ArrayList<Map<String, Object>>(4);
        DynamicObjectCollection depEmpCollection = new DynamicObjectCollection();
        DynamicObjectCollection personRoleCollection = new DynamicObjectCollection();
        DynamicObjectCollection projectMemberCollection = new DynamicObjectCollection();
        DynamicObjectCollection projectMemberRecordCollection = new DynamicObjectCollection();
        responseDataList.forEach(responseData -> {
            if (Objects.nonNull(responseData.getDepEmpDO())) {
                depEmpCollection.add((Object)responseData.getDepEmpDO());
            }
            if (!CollectionUtils.isEmpty(responseData.getPersonRoleDOList())) {
                personRoleCollection.addAll(responseData.getPersonRoleDOList());
            }
            if (Objects.nonNull(responseData.getProjectMemberDO())) {
                projectMemberCollection.add((Object)responseData.getProjectMemberDO());
            }
            if (!CollectionUtils.isEmpty(responseData.getProjectMemberRecordDOList())) {
                projectMemberRecordCollection.addAll(responseData.getProjectMemberRecordDOList());
            }
        });
        if (!CollectionUtils.isEmpty((Collection)depEmpCollection)) {
            hisDynParam.add(this.formHisDynData(depEmpCollection));
        }
        if (!CollectionUtils.isEmpty((Collection)personRoleCollection)) {
            hisDynParam.add(this.formHisDynData(personRoleCollection));
        }
        if (!CollectionUtils.isEmpty((Collection)projectMemberCollection)) {
            hisDynParam.add(this.formHisDynData(projectMemberCollection));
        }
        if (!CollectionUtils.isEmpty((Collection)projectMemberRecordCollection)) {
            hisDynParam.add(this.formHisDynData(projectMemberRecordCollection));
        }
        Asserts.notNull(hisDynParam, (String)"data");
        HashMap param = Maps.newHashMapWithExpectedSize((int)4);
        param.put("caller", "hfps");
        param.put("mustAllSuccess", Boolean.TRUE);
        param.put("eventId", ID.genLongId());
        param.put("data", hisDynParam);
        return param;
    }

    private Map<String, Object> formHisDynData(DynamicObjectCollection data) {
        if (CollectionUtils.isEmpty((Collection)data)) {
            return null;
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)1);
        map.put("hisDyns", data);
        return map;
    }

    private DynamicObject filterTeamMemberRole(DynamicObject[] teamMemberRoleDOs, long memberRoleId) {
        return Arrays.stream(teamMemberRoleDOs).filter(dynamicObject -> memberRoleId == dynamicObject.getLong("id")).findFirst().orElseThrow(() -> new RuntimeException("not find teamMemberRole, memberRoleId: " + memberRoleId));
    }

    private DynamicObject filterTeamMember(DynamicObject[] teamMemberDOs, long teamMemberId) {
        if (teamMemberId == 0L) {
            return null;
        }
        return Arrays.stream(teamMemberDOs).filter(teamMemberDO -> teamMemberId == teamMemberDO.getLong("id")).findFirst().orElseThrow(() -> new RuntimeException("not find teamMember, teamMemberId: " + teamMemberId));
    }

    private DynamicObject filterEmployee(DynamicObject[] employees, long personId) {
        return Arrays.stream(employees).filter(employee -> employee.getDynamicObject("person").getLong("id") == personId).findFirst().orElseThrow(() -> new RuntimeException("no find employee, personId: " + personId));
    }

    private DynamicObject filterCmpemp(DynamicObject[] cmpemps, long personId) {
        return Arrays.stream(cmpemps).filter(cmpemp -> cmpemp.getDynamicObject("person").getLong("id") == personId).findFirst().orElseThrow(() -> new RuntimeException("no find cmpemp, personId: " + personId));
    }

    private DynamicObject[] getCmpEmps(DynamicObject[] teamMemberRoleDOList) {
        List<Map<String, Object>> workExperiences = this.getWorkExperiences(teamMemberRoleDOList);
        List cmpempIds = workExperiences.stream().map(we -> Long.parseLong(we.get("cmpemp_id").toString())).collect(Collectors.toList());
        HRBaseServiceHelper cmpempHelper = new HRBaseServiceHelper("hrpi_cmpemp");
        return cmpempHelper.query("person", new QFilter("id", "in", cmpempIds).toArray());
    }

    private DynamicObject[] getEmployees(DynamicObject[] teamMemberRoleDOList) {
        List<Map<String, Object>> workExperiences = this.getWorkExperiences(teamMemberRoleDOList);
        List employeeIds = workExperiences.stream().map(we -> Long.parseLong(we.get("employee_id").toString())).collect(Collectors.toList());
        HRBaseServiceHelper employeeHelper = new HRBaseServiceHelper("hrpi_employee");
        return employeeHelper.query("person", new QFilter("id", "in", employeeIds).toArray());
    }

    private List<Map<String, Object>> getWorkExperiences(DynamicObject[] teamMemberRoleDOList) {
        return Arrays.stream(teamMemberRoleDOList).map(teamMemberDO -> this.getLongFromDO((DynamicObject)teamMemberDO, "person")).map(PTMMServiceFactory.hrpiService::listEmpposorgrels).filter(Objects::nonNull).map(resultList -> {
            Optional<Map> isprimary = resultList.stream().filter(Objects::nonNull).filter(resultMap -> {
                Object isPrimary = resultMap.get("isprimary");
                return isPrimary != null && isPrimary.toString().equals("1");
            }).findAny();
            return isprimary.orElseGet(HashMap::new);
        }).collect(Collectors.toList());
    }

    private DynamicObject[] getTeamMemberDOs(DynamicObject[] teamMemberRoleDOList) {
        return TeamMemberRepository.getInstance().loadDynamicObjectArray(Arrays.stream(teamMemberRoleDOList).map(teamMemberRoleDO -> this.getLongFromDO((DynamicObject)teamMemberRoleDO, "teammember")).toArray());
    }

    private long getLongFromDO(DynamicObject dynamicObject, String property) {
        Object obj = dynamicObject.get(property);
        if (obj instanceof DynamicObject) {
            return ((DynamicObject)obj).getLong("id");
        }
        return Long.parseLong(String.valueOf(obj));
    }
}

