/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.domain.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ValidateContext {
    private static final Log logger = LogFactory.getLog(ValidateContext.class);
    private Map<String, String> validateResult = new LinkedHashMap<String, String>();
    private Map<String, Boolean> validateIsStrong = new HashMap<String, Boolean>(16);

    public void setResult(String field, String errorMsg) {
        this.setValidResult(field, errorMsg);
    }

    public void setResult(String field, String errorMsg, Boolean isStrong) {
        this.setValidResult(field, errorMsg, isStrong);
    }

    private synchronized void setValidResult(String field, String errorMsg) {
        try {
            this.validateResult.put(field, errorMsg);
            this.validateIsStrong.put(field, true);
        }
        catch (Exception e) {
            logger.error("Setting valide error type exception: [{}]", (Object)e.getMessage());
        }
    }

    private void setValidResult(String field, String errorMsg, Boolean isStrong) {
        try {
            this.validateResult.put(field, errorMsg);
            this.validateIsStrong.put(field, isStrong);
        }
        catch (Exception e) {
            logger.error("Setting valide error type exception: [{}]", (Object)e.getMessage());
        }
    }

    public Map<String, String> getValidateResult() {
        return this.validateResult;
    }

    public List<String> getStrongValidKeys() {
        ArrayList<String> keys = new ArrayList<String>(this.validateIsStrong.size());
        this.validateIsStrong.forEach((key, value) -> {
            if (value.booleanValue()) {
                keys.add((String)key);
            }
        });
        return keys;
    }

    public List<String> getNotStrongValidKeys() {
        ArrayList<String> keys = new ArrayList<String>(this.validateIsStrong.size());
        this.validateIsStrong.forEach((key, value) -> {
            if (!value.booleanValue()) {
                keys.add((String)key);
            }
        });
        return keys;
    }

    public List<String> getValidateResultStrByKey(List<String> keys) {
        ArrayList<String> resultStrs = new ArrayList<String>(keys.size());
        this.validateResult.forEach((key, value) -> {
            if (keys.contains(key)) {
                resultStrs.add((String)value);
            }
        });
        return resultStrs;
    }

    public String getValidateResultStr() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!Objects.isNull(this.validateResult) && !this.validateResult.isEmpty()) {
            this.validateResult.forEach((key, value) -> stringBuilder.append((String)value));
            return stringBuilder.toString();
        }
        return "";
    }

    public String getFirValidateResultStr() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!Objects.isNull(this.validateResult) && !this.validateResult.isEmpty()) {
            this.validateResult.values().stream().findFirst().ifPresent(stringBuilder::append);
            return stringBuilder.toString();
        }
        return "";
    }
}

