/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.mq.consumer;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.ptmm.business.domain.bo.ProjectTeamChangeBO;
import kd.hr.ptmm.business.domain.service.ChangeMemberHisFunc;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.common.util.PtmmDateUtils;

public class ProjectTeamChangeMsgConsumeService {
    private static final Log logger = LogFactory.getLog(ProjectTeamChangeMsgConsumeService.class);

    public static void childTeamInfoChange(ProjectTeamChangeBO prjTeamChange, List<Long> prjTeamBoidIds) {
        PTMMServiceFactory.memberRoleHisService.changeRoleHisVersion(prjTeamChange.getChangeTime(), ChangeMemberHisFunc.changeByProjectTeam(prjTeamBoidIds, PtmmDateUtils.date2LocalDate((Date)prjTeamChange.getChangeTime()), teamMemberRoleHisDOArr -> {
            for (DynamicObject teamMemberRoleHisDO : teamMemberRoleHisDOArr) {
                if (!prjTeamChange.isTeamProjectNameChange()) continue;
                teamMemberRoleHisDO.set("projectname", prjTeamChange.getAfterProjectName());
            }
        }));
        if (prjTeamChange.isTeamProjectNameChange()) {
            for (Long prjTeamChildBoidId : prjTeamBoidIds) {
                PTMMServiceFactory.teamMemberBillService.updateChangeProjectName(prjTeamChildBoidId, prjTeamChange);
            }
        }
    }

    public static void teamInfoChange(ProjectTeamChangeBO prjTeamChange, List prjTeamBoidIds) {
        PTMMServiceFactory.memberRoleHisService.changeRoleHisVersion(prjTeamChange.getChangeTime(), ChangeMemberHisFunc.changeByProjectTeam(prjTeamBoidIds, PtmmDateUtils.date2LocalDate((Date)prjTeamChange.getChangeTime()), teamMemberRoleHisDOArr -> {
            for (DynamicObject teamMemberRoleHisDO : teamMemberRoleHisDOArr) {
                if (prjTeamChange.isTeamNameChange()) {
                    HRBaseServiceHelper teamServiceHelper = new HRBaseServiceHelper("haos_projectteamhr");
                    DynamicObject teamDO = teamServiceHelper.generateEmptyDynamicObject();
                    teamDO.set("id", (Object)prjTeamChange.getAfterTeamFid());
                    teamMemberRoleHisDO.set("projectteam", (Object)teamDO);
                }
                if (prjTeamChange.isTeamOrgChange()) {
                    HRBaseServiceHelper orgServiceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
                    DynamicObject orgDO = orgServiceHelper.generateEmptyDynamicObject();
                    orgDO.set("id", (Object)prjTeamChange.getAfterOrgId());
                    teamMemberRoleHisDO.set("belongadminorg", (Object)orgDO);
                }
                if (!prjTeamChange.isTeamProjectNameChange()) continue;
                teamMemberRoleHisDO.set("projectname", prjTeamChange.getAfterProjectName());
            }
        }));
        if (prjTeamChange.isTeamProjectNameChange()) {
            PTMMServiceFactory.teamMemberBillService.updateChangeProjectName(prjTeamChange.getTeamBoId(), prjTeamChange);
        }
    }

    public static void teamProjectChange(ProjectTeamChangeBO prjTeamChange) {
        String lockKey = "kd.hr.ptmm.business.domain.service.impl.ProAdjustServiceImpl.updateRelation.afterProjectId:" + prjTeamChange.getAfterProjectId();
        DLock dLock = DLock.create((String)lockKey);
        if (!dLock.tryLock(10000L)) {
            logger.error("ProjectTeamChangeMsgConsumeService teamProjectChange updateRelation tryLock overtime :{}  LockInfo:{}", (Object)JSON.toJSONString((Object)prjTeamChange), (Object)DLock.getLockInfo((String)lockKey));
            DLock.forceUnlock((String[])new String[]{lockKey});
            throw new KDBizException("ProjectTeamChangeMsgConsumeService teamProjectChange updateRelation tryLock overtime");
        }
        try {
            PTMMServiceFactory.proAdjustService.updateRelation(prjTeamChange);
            dLock.unlock();
        }
        catch (Exception exception) {
            try {
                logger.error("ProjectTeamChangeMsgConsumeService teamProjectChange exception", (Throwable)exception);
                throw exception;
            }
            catch (Throwable throwable) {
                DLock.forceUnlock((String[])new String[]{lockKey});
                throw throwable;
            }
        }
        DLock.forceUnlock((String[])new String[]{lockKey});
    }
}

