/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.schedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.ptmm.business.domain.repository.TeamMemberBillRepository;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.common.util.PtmmDateUtils;

public class TeamMemberAdjustTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(TeamMemberAdjustTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DynamicObject[] dynamicObjects = TeamMemberBillRepository.getInstance().queryAlrSubmitBill();
        if (dynamicObjects.length == 0) {
            LOG.debug("TeamMemberAdjustTask noExecute data: {}", (Object)PtmmDateUtils.now());
            return;
        }
        List idList = Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        LOG.info("TeamMemberAdjustTask start-id:{}\uff1btime:{}", idList, (Object)PtmmDateUtils.now());
        int failNum = 0;
        ArrayList<Long> failObjList = new ArrayList<Long>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String traceId = RequestContext.get().getTraceId();
            String billNo = dynamicObject.getString("billno");
            LOG.info("effectAdjustBillByTask_traceId:{}_billNo:{}", (Object)traceId, (Object)billNo);
            try (TXHandle txHandle = TX.required((String)((Object)((Object)this)).getClass().getName());){
                try {
                    PTMMServiceFactory.teamMemberBillService.effectAdjustBillByTask(dynamicObject);
                }
                catch (Exception exception) {
                    txHandle.markRollback();
                    failObjList.add(dynamicObject.getLong("id"));
                    ++failNum;
                    LOG.error("TeamMemberAdjustTask obj:{}, error:", (Object)dynamicObject.getLong("id"), (Object)exception);
                }
            }
        }
        LOG.info("TeamMemberAdjustTask end-time:{}", (Object)PtmmDateUtils.now());
        if (failNum != 0) {
            throw new KDException(new ErrorCode("", "bill fail num: %s,obj: %s"), new Object[]{failNum, failObjList});
        }
    }
}

