/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.business.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.ptmm.business.domain.validator.DyObjValidateContext;
import kd.hr.ptmm.common.enums.AdjustStatusEnum;

public class PtmmExcelUtils {
    private static final String FIELD_ISLEGAL = "islegal";
    private static final String FIELD_REASON = "reason";

    private PtmmExcelUtils() {
    }

    public static List<HRExportHeadObject> initMemAdjustConfirmExcelHead(String keyword) {
        ArrayList<HRExportHeadObject> headObjectList = new ArrayList<HRExportHeadObject>();
        headObjectList.add(new HRExportHeadObject("billno", ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"PtmmExcelUtils_0", (String)"hr-ptmm-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("adjuststatus", ResManager.loadKDString((String)"\u8c03\u6574\u72b6\u6001", (String)"PtmmExcelUtils_1", (String)"hr-ptmm-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("projectteam", ResManager.loadKDString((String)"\u9879\u76ee\u56e2\u961f", (String)"PtmmExcelUtils_2", (String)"hr-ptmm-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("adjustnum", ResManager.loadKDString((String)"\u8c03\u6574\u4eba\u6570", (String)"PtmmExcelUtils_3", (String)"hr-ptmm-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject(FIELD_ISLEGAL, String.format(ResManager.loadKDString((String)"\u662f\u5426\u53ef%s", (String)"PtmmExcelUtils_5", (String)"hr-ptmm-business", (Object[])new Object[0]), keyword)));
        headObjectList.add(new HRExportHeadObject(FIELD_REASON, String.format(ResManager.loadKDString((String)"\u4e0d\u53ef%s\u539f\u56e0", (String)"PtmmExcelUtils_6", (String)"hr-ptmm-business", (Object[])new Object[0]), keyword)));
        return headObjectList;
    }

    public static List<Map<String, Object>> initMemAdjustConfirmExportData(List<DyObjValidateContext> dyObjValidateContexts) {
        ArrayList exportDataList = Lists.newArrayListWithExpectedSize((int)(1 << dyObjValidateContexts.size()));
        for (int index = 0; index < dyObjValidateContexts.size(); ++index) {
            DynamicObject bill = dyObjValidateContexts.get(index).getDynamicObject();
            HashMap exportData = Maps.newHashMapWithExpectedSize((int)16);
            exportData.put("id", bill.getLong("id"));
            exportData.put("billno", bill.getString("billno"));
            exportData.put("adjuststatus", AdjustStatusEnum.getName((String)bill.getString("adjuststatus")));
            exportData.put("projectteam", bill.getDynamicObject("projectteam").getLocaleString("name").toString());
            int num = bill.getInt("adjustnum") + bill.getInt("adjustnumadd") + bill.getInt("adjustnumadj") + bill.getInt("adjustnumend") + bill.getInt("adjustnumquit");
            exportData.put("adjustnum", num);
            if (dyObjValidateContexts.get(index).getValidatorContext().getValidateResult().size() > 0) {
                exportData.put(FIELD_ISLEGAL, ResManager.loadKDString((String)"\u5426", (String)"PtmmExcelUtils_7", (String)"hr-ptmm-business", (Object[])new Object[0]));
                exportData.put(FIELD_REASON, dyObjValidateContexts.get(index).getValidatorContext().getValidateResultStr());
            } else {
                exportData.put(FIELD_ISLEGAL, ResManager.loadKDString((String)"\u662f", (String)"PtmmExcelUtils_8", (String)"hr-ptmm-business", (Object[])new Object[0]));
            }
            exportDataList.add(exportData);
        }
        return exportDataList;
    }
}

