/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.mservice;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.message.IHRMsgTplService;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.ptmm.business.domain.repository.ProjectMemberRepository;
import kd.hr.ptmm.business.domain.repository.TeamMemberRepository;
import kd.hr.ptmm.business.domain.repository.TeamMemberRoleRepository;
import kd.hr.ptmm.common.constants.member.TeamMemberConstants;
import kd.hr.ptmm.mservice.ProjectMemberOutRollbackMsgService;
import kd.hr.ptmm.mservice.api.IProjectMemberOutMsgService;
import kd.hr.ptmm.mservice.api.IProjectMemberOutRollbackMsgService;

public abstract class AbstractMemberOutService
implements IHRMsgTplService,
IProjectMemberOutMsgService,
IProjectMemberOutRollbackMsgService,
TeamMemberConstants {
    protected static final Log LOG = LogFactory.getLog(ProjectMemberOutRollbackMsgService.class);
    private final ProjectMemberRepository projectMemberRepository = ProjectMemberRepository.getInstance();
    private final TeamMemberRepository teamMemberRepository = TeamMemberRepository.getInstance();
    private final TeamMemberRoleRepository teamMemberRoleRepository = TeamMemberRoleRepository.getInstance();
    protected Map<String, Object> chgInfoDetailMap = Maps.newHashMapWithExpectedSize((int)16);
    protected Map<String, Object> personInfoMap = Maps.newHashMapWithExpectedSize((int)16);

    public HRMServiceResult consumerSaveMsg(DynamicObject dynamicObject) {
        String content = dynamicObject.getString("msgcontent");
        Map contentMap = (Map)SerializationUtils.deSerializeFromBase64((String)content);
        LOG.info("AbstractMemberOutService consumerSaveMsg contentMap:{}", (Object)JSON.toJSONString((Object)contentMap));
        Object recordId = contentMap.get("recordId");
        this.chgInfoDetailMap = this.getChgInfoDetailByRecordId(recordId);
        if (CollectionUtils.isEmpty(this.chgInfoDetailMap) || this.chgInfoDetailMap.get("data") == null) {
            return HRMServiceResult.fail((String)"can not get chg info detail by recordId!");
        }
        this.personInfoMap = this.getPersonInfoMap(this.chgInfoDetailMap);
        if (CollectionUtils.isEmpty(this.personInfoMap)) {
            return HRMServiceResult.fail((String)"can not get person info!");
        }
        return HRMServiceResult.success();
    }

    private Map<String, Object> getChgInfoDetailByRecordId(Object recordId) {
        Map result = (Map)HRMServiceHelper.invokeHRService((String)"hpfs", (String)"IHPFSPersonChgService", (String)"getChgInfoDetailByRecordId", (Object[])new Object[]{recordId});
        LOG.info("ProjectMemberOutMsgService consumerSaveMsg result:{}", (Object)JSON.toJSONString((Object)result));
        return result;
    }

    private Map<String, Object> getPersonInfoMap(Map<String, Object> chgInfoDetailMap) {
        Map data = (Map)chgInfoDetailMap.get("data");
        List entityDataList = (List)data.get("data");
        if (CollectionUtils.isEmpty((Collection)entityDataList)) {
            return null;
        }
        Map personInfoMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map entityData : entityDataList) {
            if (!"hrpi_person".equals(entityData.get("entity"))) continue;
            personInfoMap = entityData;
        }
        return personInfoMap;
    }

    protected HRMServiceResult updateMemberServiceStatusByPersonId(Long personId, Date effectTime, boolean isQuit) {
        DynamicObject[] teamMemRoles;
        DynamicObject[] teamMemberInfoArr;
        LOG.info("updateMemberServiceStatusByPersonId personId:{}, effectTime:{}", (Object)personId, (Object)effectTime);
        DynamicObject[] projectMemberInfoArr = this.projectMemberRepository.loadMemberHisByPersonIds(Collections.singleton(personId), isQuit);
        LOG.info("updateMemberServiceStatusByPersonId projectMemberInfoArr length:{}", (Object)projectMemberInfoArr.length);
        HashSet projectMemberIds = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject projectMemberInfo : projectMemberInfoArr) {
            this.setMemberStatus(projectMemberInfo, effectTime);
            projectMemberIds.add(projectMemberInfo.getLong("id"));
        }
        this.projectMemberRepository.save(projectMemberInfoArr);
        for (DynamicObject teamMemberInfo : teamMemberInfoArr = this.teamMemberRepository.listTeamMemberByProjectMemberId((Set)projectMemberIds, isQuit)) {
            this.setMemberStatus(teamMemberInfo, effectTime);
        }
        this.teamMemberRepository.save(teamMemberInfoArr);
        for (DynamicObject teamMemRole : teamMemRoles = this.teamMemberRoleRepository.loadTeamMemberRoleByTeamMemberId((Set)projectMemberIds, isQuit)) {
            this.setMemberStatus(teamMemRole, effectTime);
        }
        this.teamMemberRoleRepository.save(teamMemRoles);
        return HRMServiceResult.success();
    }

    protected abstract void setMemberStatus(DynamicObject var1, Date var2);
}

