/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.mservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.ptmm.business.domain.repository.TeamMemberRepository;
import kd.hr.ptmm.business.domain.repository.TeamMemberRoleHisRepository;
import kd.hr.ptmm.business.domain.repository.TeamMemberRoleRepository;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.common.enums.PersonServiceStatusEnum;
import kd.hr.ptmm.common.util.PtmmDateUtils;
import kd.hr.ptmm.mservice.api.IPTMMQueryMemberService;

public class PTMMQueryMemberService
implements IPTMMQueryMemberService {
    private static final Log LOG = LogFactory.getLog(PTMMQueryMemberService.class);

    public List<Map<String, Object>> getProjectGroupMembersById(List<Long> projectGroupIds) {
        return PTMMServiceFactory.teamMemberService.getProjectGroupMembersById(projectGroupIds);
    }

    public List<Map<String, Object>> getProjectRoleMembersById(List<Long> projectRoleIds) {
        return PTMMServiceFactory.teamMemberService.getProjectRoleMembersById(projectRoleIds);
    }

    public List<Map<String, Object>> getMemberHis(List<Long> projectTeamIdList, Date date) {
        LOG.info("getMemberHis projectTeamIdList:{} date:{}", projectTeamIdList, (Object)date);
        if (CollectionUtils.isEmpty(projectTeamIdList)) {
            return Collections.emptyList();
        }
        if (Objects.isNull(date)) {
            date = PtmmDateUtils.now();
        }
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        QFilter bSedQFilter = new QFilter("bsed", "<=", (Object)localDate).and(new QFilter("bsled", ">=", (Object)localDate));
        QFilter projectTeamQFilter = new QFilter("projectteamboid", "in", projectTeamIdList);
        QFilter serviceStateQFilter = new QFilter("servicestate", "=", (Object)PersonServiceStatusEnum.SERVING.getCode());
        QFilter isTeamMainRoleQFilter = new QFilter("isteammainrole", "=", (Object)"1");
        QFilter isCurrentVerQFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter dataStatusQFilter = new QFilter("datastatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"1", "2"}));
        String selectProperties = String.join((CharSequence)",", "projectrole", "projectteamboid", "person", "projectroleboid", "isprincipal", "servicestate");
        DynamicObject[] teamMemberRoleHisDOArr = TeamMemberRoleHisRepository.getInstance().query(selectProperties, new QFilter[]{bSedQFilter, projectTeamQFilter, serviceStateQFilter, isTeamMainRoleQFilter, isCurrentVerQFilter, dataStatusQFilter});
        if ((long)teamMemberRoleHisDOArr.length == 0L) {
            LOG.warn("getMemberHis no suitable teamMemberRoleHis");
            return Collections.emptyList();
        }
        LOG.info("getMemberHis teamMemberRoleHis:{}", Arrays.stream(teamMemberRoleHisDOArr).map(d -> d.getLong("id")).collect(Collectors.toList()));
        return this.convertToResultMap(teamMemberRoleHisDOArr);
    }

    public Map<String, Object> listTeamMemberRole(Map<String, Object> inParam) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        LOG.info(String.format("listTeamMemberRole_start with inParam:%s", inParam));
        List<Long> employeeidList = inParam.getOrDefault("employeeidList", Collections.emptyList());
        employeeidList = employeeidList == null ? Collections.emptyList() : employeeidList;
        try {
            Object data = new ArrayList();
            if (employeeidList.size() != 0) {
                ListTeamMemberRoleData listTeamMemberRoleData = this.queryData(employeeidList);
                data = this.packageTeamMemberRoleData(listTeamMemberRoleData);
            }
            result.put("success", "true");
            result.put("data", data);
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            result.put("success", "false");
            result.put("message", ex.getMessage());
        }
        LOG.info("listTeamMemberRole_end");
        return result;
    }

    private ListTeamMemberRoleData queryData(List<Long> employeeList) {
        Map<Long, Long> depempIdVsEmployeeId = this.convertDepempIdVsEmployeeId(employeeList);
        if (depempIdVsEmployeeId.size() == 0) {
            return new ListTeamMemberRoleData();
        }
        DynamicObject[] teamMembers = TeamMemberRepository.getInstance().queryOriginalByDepemp("id, depemp.id", depempIdVsEmployeeId.keySet());
        Set teamMemberIdList = Arrays.stream(teamMembers).map(teamMember -> teamMember.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] teamMemberRoles = TeamMemberRoleRepository.getInstance().queryOriginalByTeamMember("id, projectnumber, projectname, projectteam.number, projectteam.name, projectteam.simplename, projectrole.name, isteammainrole, isprincipal, joindate, quitdate, servicestate, teammember.id, projectrole.mainpeoincharge", teamMemberIdList);
        Map<Long, Long> teamMemberIdVsDepempId = Arrays.stream(teamMembers).collect(Collectors.toMap(teamMember -> teamMember.getLong("id"), teamMember -> teamMember.getLong("depemp.id")));
        Map<Long, Long> teamMemberRoleIdVsEmployeeId = Arrays.stream(teamMemberRoles).collect(Collectors.toMap(teamMemberRole -> teamMemberRole.getLong("id"), teamMemberRole -> {
            long teamMemberId = teamMemberRole.getLong("teammember.id");
            Long depempId = teamMemberIdVsDepempId.getOrDefault(teamMemberId, 0L);
            return depempIdVsEmployeeId.getOrDefault(depempId, 0L);
        }));
        ListTeamMemberRoleData listTeamMemberRoleData = new ListTeamMemberRoleData();
        listTeamMemberRoleData.teamMemberRoleList = Arrays.asList(teamMemberRoles);
        listTeamMemberRoleData.teamMemberRoleIdVsEmployeeId = teamMemberRoleIdVsEmployeeId;
        return listTeamMemberRoleData;
    }

    private Map<Long, Long> convertDepempIdVsEmployeeId(List<Long> employeeList) {
        QFilter employeeFilter = new QFilter("employee", "in", employeeList);
        DynamicObject[] depemps = PTMMServiceFactory.hrpiService.listFieldsFilterInfo("employee,id", employeeFilter, "hrpi_depemp");
        if (depemps.length != 0) {
            return Arrays.stream(depemps).collect(Collectors.toMap(depemp -> depemp.getLong("id"), depemp -> depemp.getLong("employee.id")));
        }
        return Collections.emptyMap();
    }

    private Object packageTeamMemberRoleData(ListTeamMemberRoleData listTeamMemberRoleData) {
        List<DynamicObject> teamMemberRoleList = listTeamMemberRoleData.teamMemberRoleList;
        Map<Long, Long> teamMemberRoleIdVsEmployeeId = listTeamMemberRoleData.teamMemberRoleIdVsEmployeeId;
        return teamMemberRoleList.stream().map(teamMemberRole -> {
            HashMap<String, Object> result = new HashMap<String, Object>();
            long teamMemberRoleId = teamMemberRole.getLong("id");
            result.put("id", teamMemberRoleId);
            result.put("projectname", teamMemberRole.getString("projectname"));
            result.put("projectteamNumber", teamMemberRole.getString("projectteam.number"));
            result.put("projectteamName", teamMemberRole.getString("projectteam.name"));
            result.put("projectteamSimplename", teamMemberRole.getString("projectteam.simplename"));
            result.put("projectroleName", teamMemberRole.getString("projectrole.name"));
            result.put("projectroleMainpeoincharge", teamMemberRole.getString("projectrole.mainpeoincharge"));
            result.put("isprincipal", teamMemberRole.getString("isprincipal"));
            result.put("joindate", teamMemberRole.getString("joindate"));
            result.put("quitdate", teamMemberRole.getString("quitdate"));
            result.put("servicestate", teamMemberRole.getString("servicestate"));
            Long employeeId = teamMemberRoleIdVsEmployeeId.getOrDefault(teamMemberRoleId, 0L);
            result.put("employeeId", employeeId);
            return result;
        }).collect(Collectors.toList());
    }

    private List<Map<String, Object>> convertToResultMap(DynamicObject[] teamMemberRoleHisDOArr) {
        Map<Long, List<DynamicObject>> map = Arrays.stream(teamMemberRoleHisDOArr).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong("projectteamboid")));
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(map.size());
        map.forEach((projectTeamId, hisDOList) -> {
            int subordinateNum = hisDOList.size();
            ArrayList<DynamicObject> chargePeople = new ArrayList<DynamicObject>(hisDOList.size());
            for (DynamicObject dynamicObject : hisDOList) {
                DynamicObject projectRole = dynamicObject.getDynamicObject("projectrole");
                Objects.requireNonNull(projectRole);
                if (!projectRole.getBoolean("isdutypers")) continue;
                chargePeople.add(dynamicObject);
            }
            if (CollectionUtils.isEmpty(chargePeople)) {
                HashMap result = Maps.newHashMapWithExpectedSize((int)8);
                resultList.add(result);
                result.put("projectTeamId", projectTeamId);
                result.put("name", " ");
                result.put("headPicutre", " ");
                result.put("projectRoleId", 0L);
                result.put("isprincipal", " ");
                result.put("serviceState", " ");
                result.put("subordinateNum", subordinateNum);
            } else {
                for (DynamicObject chargePerson : chargePeople) {
                    HashMap result = Maps.newHashMapWithExpectedSize((int)8);
                    resultList.add(result);
                    result.put("projectTeamId", projectTeamId);
                    result.put("name", chargePerson.getDynamicObject("person").getString("name"));
                    result.put("headPicutre", chargePerson.getDynamicObject("person").getString("headsculpture"));
                    result.put("projectRoleId", chargePerson.getLong("projectroleboid"));
                    result.put("isprincipal", chargePerson.getBoolean("isprincipal"));
                    result.put("serviceState", chargePerson.getString("servicestate"));
                    result.put("subordinateNum", subordinateNum);
                }
            }
        });
        LOG.info("getMemberHis result:{}", resultList);
        return resultList;
    }

    static class ListTeamMemberRoleData {
        List<DynamicObject> teamMemberRoleList = Collections.emptyList();
        Map<Long, Long> teamMemberRoleIdVsEmployeeId = Collections.emptyMap();

        ListTeamMemberRoleData() {
        }
    }
}

