/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.mservice;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.message.IHRMsgTplService;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.ptmm.business.domain.bo.ProjectRoleChangeBO;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.business.mq.consumer.ProjectRoleChangeMsgConsumeService;
import kd.hr.ptmm.common.util.MapUtils;
import kd.hr.ptmm.mservice.PTMMQueryMemberService;
import kd.hr.ptmm.mservice.api.IProjectRoleChangeMsgService;

public class ProjectRoleChangeMsgService
implements IProjectRoleChangeMsgService,
IHRMsgTplService {
    private static final Log LOG = LogFactory.getLog(PTMMQueryMemberService.class);
    private static final String MSGCONTENT = "msgcontent";
    private static final String BEFORE = "before";
    private static final String AFTER = "after";
    private static final String BSED = "bsed";
    private static final String WORK_ROLE_VID = "workRoleVid";
    private static final String IS_DUTY_PER = "isDutyPer";

    public HRMServiceResult consumerSaveMsg(DynamicObject dynamicObject) {
        String content = dynamicObject.getString(MSGCONTENT);
        Map contentMap = (Map)SerializationUtils.deSerializeFromBase64((String)content);
        LOG.info("ProjectRoleChangeMsgService consumerSaveMsg contentMap:{}", (Object)JSON.toJSONString((Object)contentMap));
        Map curProRoleMap = (Map)contentMap.get("curProRole");
        Map oldProRoleMap = (Map)contentMap.get("oldProRole");
        Long roleCurFidAfter = (Long)curProRoleMap.get("vid");
        Long roleCurBoid = (Long)curProRoleMap.get("boId");
        HrApiResponse roleMaps = PTMMServiceFactory.haosService.getRoleChangeInfos(roleCurFidAfter, null);
        LOG.info("ProjectRoleChangeMsgService consumerSaveMsg getRoleChangeInfos:{}", (Object)JSON.toJSONString((Object)roleMaps));
        Map roleInfos = (Map)roleMaps.getData();
        Map roleInfoBeforeAndAfter = (Map)roleInfos.get(roleCurBoid);
        LOG.info("ProjectRoleChangeMsgService consumerSaveMsg roleInfoBeforeAndAfter:{}", (Object)JSON.toJSONString((Object)roleInfoBeforeAndAfter));
        String checkRes = this.checkApiData(roleInfoBeforeAndAfter);
        if (checkRes.length() != 0) {
            LOG.error("ProjectRoleChangeMsgService consumerSaveMsg error:", (Object)checkRes);
            return HRMServiceResult.fail((String)checkRes);
        }
        List<ProjectRoleChangeBO> prjRoleChanges = this.getChangeInfoBo(roleCurBoid, roleInfoBeforeAndAfter);
        LOG.info("ProjectRoleChangeMsgService prjRoleChanges BO is :{}", (Object)JSON.toJSONString(prjRoleChanges));
        try {
            ArrayList<Long> roleBoids = new ArrayList<Long>(1);
            roleBoids.add(roleCurBoid);
            if (prjRoleChanges.size() > 0) {
                LOG.info("ProjectRoleChangeMsgService roleInfoChange  star roleBoids is :{} prjRoleChanges is:{}", (Object)JSON.toJSONString(roleBoids), (Object)JSON.toJSONString(prjRoleChanges));
                ProjectRoleChangeMsgConsumeService.roleInfoChange(roleBoids, prjRoleChanges);
                LOG.info("ProjectRoleChangeMsgService roleInfoChange  end");
            }
        }
        catch (Exception exception) {
            LOG.error("ProjectRoleChangeMsgService excude teamInfoChange error", (Throwable)exception);
            return HRMServiceResult.fail((String)exception.getMessage());
        }
        return HRMServiceResult.success();
    }

    private String checkApiData(Map<String, Object> roleInfoBeforeAndAfter) {
        StringBuilder msgSb = new StringBuilder(8);
        try {
            if (roleInfoBeforeAndAfter.get(BEFORE) == null || roleInfoBeforeAndAfter.get(AFTER) == null) {
                msgSb.append("teamInfoBeforeAndAfter date error :");
                return msgSb.toString();
            }
        }
        catch (Exception exception) {
            LOG.error("ProjectRoleChangeMsgService checkApiData error", (Throwable)exception);
        }
        return msgSb.toString();
    }

    private List<ProjectRoleChangeBO> getChangeInfoBo(Long roleBoId, Map<String, Object> roleInfoBeforeAndAfter) {
        ArrayList<ProjectRoleChangeBO> prjRoleChanges = new ArrayList<ProjectRoleChangeBO>(1);
        try {
            Map apiDataBeforeRole = (Map)roleInfoBeforeAndAfter.get(BEFORE);
            Map apiDataAfterRole = (Map)roleInfoBeforeAndAfter.get(AFTER);
            Long roleFidBefore = (Long)apiDataBeforeRole.get("id");
            Long roleFidAfter = (Long)apiDataAfterRole.get("id");
            Long workRoleFidBefore = (Long)apiDataBeforeRole.get(WORK_ROLE_VID);
            Long workRoleFidAfter = (Long)apiDataAfterRole.get(WORK_ROLE_VID);
            Map beforeRoleName = (Map)apiDataBeforeRole.get("name");
            Map afterRoleName = (Map)apiDataAfterRole.get("name");
            Boolean isDutyPerBefore = (Boolean)apiDataBeforeRole.get(IS_DUTY_PER);
            Boolean isDutyPerAfter = (Boolean)apiDataAfterRole.get(IS_DUTY_PER);
            ProjectRoleChangeBO prjRoleChange = new ProjectRoleChangeBO();
            Date changeTime = (Date)apiDataAfterRole.get(BSED);
            prjRoleChange.setRoleBoId(roleBoId);
            prjRoleChange.setChangeTime(changeTime);
            prjRoleChange.setBeforePrjRoleFid(roleFidBefore);
            prjRoleChange.setAfterPrjRoleFid(roleFidAfter);
            prjRoleChange.setBeforeWorkRoleFid(workRoleFidBefore);
            prjRoleChange.setAfterWorkRoleFid(workRoleFidAfter);
            if (!MapUtils.mapCompare((Map)beforeRoleName, (Map)afterRoleName).booleanValue()) {
                prjRoleChange.setRoleNameChange(true);
                prjRoleChange.setBeforePrjRoleName(beforeRoleName);
                prjRoleChange.setAfterPrjRoleName(afterRoleName);
            }
            if (!isDutyPerBefore.equals(isDutyPerAfter)) {
                prjRoleChange.setMainRoleChange(true);
                if (isDutyPerAfter.booleanValue()) {
                    prjRoleChange.setAfterIsMainRole("1");
                } else {
                    prjRoleChange.setBeforeIsMainRole("0");
                }
            }
            if (prjRoleChange.isRoleNameChange() || prjRoleChange.isMainRoleChange()) {
                prjRoleChanges.add(prjRoleChange);
            }
        }
        catch (Exception exception) {
            LOG.error("ProjectRoleChangeMsgService  getChangeInfoBo error", (Throwable)exception);
        }
        return prjRoleChanges;
    }
}

