/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.mservice;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.message.IHRMsgTplService;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.ptmm.business.domain.bo.ProjectTeamChangeBO;
import kd.hr.ptmm.business.domain.service.PTMMServiceFactory;
import kd.hr.ptmm.business.mq.consumer.ProjectTeamChangeMsgConsumeService;
import kd.hr.ptmm.common.util.MapUtils;
import kd.hr.ptmm.mservice.PTMMQueryMemberService;
import kd.hr.ptmm.mservice.api.IProjectTeamChangeMsgService;

public class ProjectTeamChangeMsgService
implements IProjectTeamChangeMsgService,
IHRMsgTplService {
    private static final Log LOG = LogFactory.getLog(PTMMQueryMemberService.class);
    private static final String MSGCONTENT = "msgcontent";
    private static final String BOID = "boId";
    private static final String BEFORE = "before";
    private static final String AFTER = "after";
    private static final String BSED = "bsed";
    private static final String BELONG_ADMIN_ORG_NUMBER = "belongAdminOrgNumber";
    private static final String BELONG_ADMINORG_BOID = "belongAdminOrgBoId";
    private static final String PROJECT_NAME = "projectName";
    private static final String PROJECT_ID_ENTIFY = "projectIdentify";

    public HRMServiceResult consumerSaveMsg(DynamicObject dynamicObject) {
        String content = dynamicObject.getString(MSGCONTENT);
        Map contentMap = (Map)SerializationUtils.deSerializeFromBase64((String)content);
        LOG.info("ProjectTeamChangeMsgService consumerSaveMsg contentMap:{}", (Object)JSON.toJSONString((Object)contentMap));
        List dataList = (List)contentMap.get("dataList");
        List teamFids = dataList.stream().map(data -> data.get("id")).filter(Objects::nonNull).map(data -> Long.parseLong(data.toString())).collect(Collectors.toList());
        Long teamBoId = (Long)contentMap.get(BOID);
        ArrayList<ProjectTeamChangeBO> changeBOList = new ArrayList<ProjectTeamChangeBO>(teamFids.size());
        for (Long teamFidAfter : teamFids) {
            HrApiResponse teamMaps = PTMMServiceFactory.haosService.getTeamChangeInfos(Collections.singletonList(teamFidAfter));
            LOG.info("ProjectTeamChangeMsgService consumerSaveMsg getTeamChangeInfos:{}", (Object)JSON.toJSONString((Object)teamMaps));
            Map teamInfos = (Map)teamMaps.getData();
            Map teamInfoBeforeAndAfter = (Map)teamInfos.get(teamBoId);
            LOG.info("ProjectTeamChangeMsgService consumerSaveMsg teamInfoBeforeAndAfter:{}", (Object)JSON.toJSONString((Object)teamInfoBeforeAndAfter));
            String checkRes = this.checkApiData(teamInfoBeforeAndAfter, teamFidAfter);
            if (checkRes.length() != 0) {
                LOG.error("ProjectTeamChangeMsgService consumerSaveMsg error:", (Object)checkRes);
                return HRMServiceResult.fail((String)checkRes);
            }
            ProjectTeamChangeBO prjTeamChange = this.getChangeInfoBo(teamBoId, teamFidAfter, teamInfoBeforeAndAfter);
            LOG.info("ProjectTeamChangeMsgService teamInfoChange object is : {}", (Object)JSON.toJSONString((Object)prjTeamChange));
            changeBOList.add(prjTeamChange);
        }
        for (ProjectTeamChangeBO prjTeamChange : changeBOList.stream().sorted(Comparator.comparing(ProjectTeamChangeBO::getChangeTime)).collect(Collectors.toList())) {
            if (prjTeamChange.isTeamProjectChange()) {
                try {
                    LOG.info("ProjectTeamChangeMsgService excude teamProjectChange start prjTeamChange is : {}", (Object)JSON.toJSONString((Object)prjTeamChange));
                    ProjectTeamChangeMsgConsumeService.teamProjectChange((ProjectTeamChangeBO)prjTeamChange);
                    LOG.info("ProjectTeamChangeMsgService excude teamProjectChange end");
                    continue;
                }
                catch (Exception exception) {
                    LOG.error("ProjectTeamChangeMsgService excude teamProjectChange error \uff1a {}", (Object)exception.getMessage());
                    return HRMServiceResult.fail((String)exception.getMessage());
                }
            }
            if (!prjTeamChange.isTeamNameChange() && !prjTeamChange.isTeamOrgChange() && !prjTeamChange.isTeamProjectNameChange()) continue;
            try {
                LOG.info("ProjectTeamChangeMsgService excude teamInfoChange start prjTeamChange is : {}", (Object)JSON.toJSONString((Object)prjTeamChange));
                ArrayList<Long> prjTeamBoidIds = new ArrayList<Long>(8);
                prjTeamBoidIds.add(prjTeamChange.getTeamBoId());
                ProjectTeamChangeMsgConsumeService.teamInfoChange((ProjectTeamChangeBO)prjTeamChange, prjTeamBoidIds);
                LOG.info("ProjectTeamChangeMsgService excude teamInfoChange end");
                List childTeamBoids = PTMMServiceFactory.adminOrgStructureService.listProjectTeamChildIdsById(prjTeamChange.getTeamBoId().longValue());
                LOG.info("ProjectTeamChangeMsgService childTeamBoids\uff1a {}", (Object)childTeamBoids);
                if (childTeamBoids.size() <= 0 || !prjTeamChange.isTeamProjectNameChange()) continue;
                LOG.info("ProjectTeamChangeMsgService excude childTeamInfoChange start");
                ProjectTeamChangeMsgConsumeService.childTeamInfoChange((ProjectTeamChangeBO)prjTeamChange, (List)childTeamBoids);
                LOG.info("ProjectTeamChangeMsgService excude childTeamInfoChange end");
            }
            catch (Exception exception) {
                LOG.error("ProjectTeamChangeMsgService excude teamInfoChange error", (Throwable)exception);
                return HRMServiceResult.fail((String)exception.getMessage());
            }
        }
        return HRMServiceResult.success();
    }

    private Map<String, Object> getTeamDateByType(String dataType, Long afterTeamFid, List<Map<String, Object>> apiData) {
        Map<String, Object> teamDate = new HashMap<String, Object>(1);
        for (Map<String, Object> data : apiData) {
            if (data.get("id") == null) continue;
            Long fid = (Long)data.get("id");
            if (fid.equals(afterTeamFid) && dataType.equals(AFTER)) {
                teamDate = data;
            }
            if (fid.equals(afterTeamFid) || !dataType.equals(BEFORE)) continue;
            teamDate = data;
        }
        return teamDate;
    }

    private String checkApiData(Map<String, Object> teamInfoBeforeAndAfter, Long teamFidAfter) {
        StringBuilder msgSb = new StringBuilder(8);
        try {
            if (teamInfoBeforeAndAfter == null) {
                msgSb.append("teamInfoBeforeAndAfter is null;");
                return msgSb.toString();
            }
            if (teamInfoBeforeAndAfter.get(BEFORE) == null || teamInfoBeforeAndAfter.get(AFTER) == null) {
                msgSb.append("teamInfoBeforeAndAfter date error;");
                return msgSb.toString();
            }
            Map apiDataBeforeTeam = (Map)teamInfoBeforeAndAfter.get(BEFORE);
            Map apiDataAfterTeam = (Map)teamInfoBeforeAndAfter.get(AFTER);
            if (apiDataAfterTeam.get(BSED) == null) {
                msgSb.append("bsed is null;");
            }
            if (apiDataBeforeTeam.get("id") == null) {
                msgSb.append("before fid is null;");
            }
            if (apiDataBeforeTeam.get("name") == null) {
                msgSb.append("before team name is null;");
            }
            if (apiDataAfterTeam.get("name") == null) {
                msgSb.append("after team name is null;");
            }
            if (apiDataBeforeTeam.get(PROJECT_NAME) == null) {
                msgSb.append("before project name is null;");
            }
            if (apiDataAfterTeam.get(PROJECT_NAME) == null) {
                msgSb.append("after project name is null;");
            }
            if (apiDataBeforeTeam.get(PROJECT_ID_ENTIFY) == null) {
                msgSb.append("before project id is null;");
            }
            if (apiDataAfterTeam.get(PROJECT_ID_ENTIFY) == null) {
                msgSb.append("after project id is null;");
            }
        }
        catch (Exception exception) {
            LOG.error("ProjectTeamChangeMsgService checkApiData error", (Throwable)exception);
        }
        return msgSb.toString();
    }

    private ProjectTeamChangeBO getChangeInfoBo(Long teamBoId, Long teamFidAfter, Map<String, Object> teamInfoBeforeAndAfter) {
        ProjectTeamChangeBO prjTeamChange = new ProjectTeamChangeBO();
        try {
            Map apiDataBeforeTeam = (Map)teamInfoBeforeAndAfter.get(BEFORE);
            Map apiDataAfterTeam = (Map)teamInfoBeforeAndAfter.get(AFTER);
            Date changeTime = (Date)apiDataAfterTeam.get(BSED);
            Long teamFidBefore = (Long)apiDataBeforeTeam.get("id");
            Map beforeTeamName = (Map)apiDataBeforeTeam.get("name");
            Map afterTeamName = (Map)apiDataAfterTeam.get("name");
            LOG.info("ProjectTeamChangeMsgService getChangeInfoBo beforeTeamName \uff1a {},afterTeamName: {}", (Object)JSON.toJSONString((Object)beforeTeamName), (Object)JSON.toJSONString((Object)afterTeamName));
            Map beforePrjName = (Map)apiDataBeforeTeam.get(PROJECT_NAME);
            Map afterPrjName = (Map)apiDataAfterTeam.get(PROJECT_NAME);
            LOG.info("ProjectTeamChangeMsgService getChangeInfoBo beforePrjName \uff1a {},afterPrjName: {}", (Object)JSON.toJSONString((Object)beforePrjName), (Object)JSON.toJSONString((Object)afterPrjName));
            String projectIdentifyBefore = (String)apiDataBeforeTeam.get(PROJECT_ID_ENTIFY);
            String projectIdentifyAfter = (String)apiDataAfterTeam.get(PROJECT_ID_ENTIFY);
            Long beforeBelongAdminOrgNumber = 0L;
            Long afterBelongAdminOrgNumber = 0L;
            if (apiDataBeforeTeam.get(BELONG_ADMINORG_BOID) != null) {
                beforeBelongAdminOrgNumber = (Long)apiDataBeforeTeam.get(BELONG_ADMINORG_BOID);
            }
            if (apiDataAfterTeam.get(BELONG_ADMINORG_BOID) != null) {
                afterBelongAdminOrgNumber = (Long)apiDataAfterTeam.get(BELONG_ADMINORG_BOID);
            }
            prjTeamChange.setTeamBoId(teamBoId);
            prjTeamChange.setChangeTime(changeTime);
            prjTeamChange.setBeforeTeamFid(teamFidBefore);
            prjTeamChange.setAfterTeamFid(teamFidAfter);
            if (!MapUtils.mapCompare((Map)beforeTeamName, (Map)afterTeamName).booleanValue()) {
                prjTeamChange.setTeamNameChange(true);
            }
            prjTeamChange.setBeforeTeamName(beforeTeamName);
            prjTeamChange.setAfterTeamName(afterTeamName);
            if (!beforeBelongAdminOrgNumber.equals(afterBelongAdminOrgNumber)) {
                prjTeamChange.setTeamOrgChange(true);
            }
            prjTeamChange.setBeforeOrgId(beforeBelongAdminOrgNumber);
            prjTeamChange.setAfterOrgId(afterBelongAdminOrgNumber);
            if (!MapUtils.mapCompare((Map)beforePrjName, (Map)afterPrjName).booleanValue() && projectIdentifyBefore.equals(projectIdentifyAfter)) {
                prjTeamChange.setTeamProjectNameChange(true);
            }
            prjTeamChange.setBeforeProjectName(beforePrjName);
            prjTeamChange.setAfterProjectName(afterPrjName);
            if (!projectIdentifyBefore.equals(projectIdentifyAfter)) {
                prjTeamChange.setTeamProjectChange(true);
            }
            prjTeamChange.setBeforeProjectName(beforePrjName);
            prjTeamChange.setAfterProjectName(afterPrjName);
            prjTeamChange.setBeforeProjectId(projectIdentifyBefore);
            prjTeamChange.setAfterProjectId(projectIdentifyAfter);
        }
        catch (Exception exception) {
            LOG.error("ProjectTeamChangeMsgService  getChangeInfoBo error", (Throwable)exception);
        }
        return prjTeamChange;
    }
}

