/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.common.entity;

import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.ptmm.common.entity.ProjectMemberEntryWrapper;
import kd.hr.ptmm.common.enums.AdjustEntryEnum;
import kd.hr.ptmm.common.util.DateUtils;

public class ProjectMemberEntryWrapperFactory {
    private ProjectMemberEntryWrapperFactory() {
    }

    public static ProjectMemberEntryWrapper getInstance(AdjustEntryEnum type, DynamicObject entryRow, DynamicObject obj) {
        ProjectMemberEntryWrapper wrapper = new ProjectMemberEntryWrapper();
        wrapper.setProjectName(obj.getString("projectname"));
        wrapper.setProjectNameLocalString(obj.getLocaleString("projectname"));
        wrapper.setProjectNumber(obj.getString("projectnumber"));
        wrapper.setEntryRow(entryRow);
        wrapper.setAdjustEntryEnum(type);
        switch (type) {
            case ADJUST_JOIN: {
                ProjectMemberEntryWrapperFactory.entry1Wrapper(entryRow, wrapper);
                break;
            }
            case ADJUST_ADJ_JOIN: {
                ProjectMemberEntryWrapperFactory.entry2Wrapper(entryRow, wrapper);
                break;
            }
            case ADJUST_ADJ_QUIT: {
                ProjectMemberEntryWrapperFactory.entry2QWrapper(entryRow, wrapper);
                break;
            }
            case ADJUST_QUIT: {
                ProjectMemberEntryWrapperFactory.entry3Wrapper(entryRow, wrapper);
                break;
            }
        }
        return wrapper;
    }

    private static void entry3Wrapper(DynamicObject entryRow, ProjectMemberEntryWrapper wrapper) {
        wrapper.setAdjustEntryEnum(AdjustEntryEnum.ADJUST_QUIT);
        wrapper.setPersonId(entryRow.getLong("personbaseadjq.person.id"));
        wrapper.setTeamMemberId(entryRow.getLong("personbaseadjq.teammember.id"));
        wrapper.setProjectMemberId(entryRow.getLong("personbaseadjq.projectmember.id"));
        wrapper.setTeamMemberRoleId(entryRow.getLong("personbaseadjq.id"));
        wrapper.setIsTeamMainRole(entryRow.getString("personbaseadjq.isteammainrole"));
        wrapper.setQuitDate(DateUtils.getNoTimeDate(entryRow.getDate("effectdateadjq")));
        wrapper.setAdjustReason(entryRow.getLong("adjustreasonadjq.id"));
        wrapper.setPrincipal(entryRow.getString("personbaseadjq.isprincipal"));
        wrapper.setAdjustReasonKey("adjustreasonadjq");
        wrapper.setProjectTeamKey("personbaseadjq.projectteam");
        wrapper.setProjectroleKey("personbaseadjq.projectrole");
        wrapper.setPersonKey("personbaseadjq.person");
    }

    private static void entry2QWrapper(DynamicObject entryRow, ProjectMemberEntryWrapper wrapper) {
        wrapper.setAdjustEntryEnum(AdjustEntryEnum.ADJUST_ADJ_QUIT);
        wrapper.setPersonId(entryRow.getLong("personbaseadj.person.id"));
        wrapper.setProjectMemberId(entryRow.getLong("personbaseadj.projectmember.id"));
        wrapper.setTeamMemberId(entryRow.getLong("personbaseadj.teammember.id"));
        wrapper.setTeamMemberRoleId(entryRow.getLong("personbaseadj.id"));
        wrapper.setQuitDate(DateUtils.getNoTimeDate(entryRow.getDate("effectdateadj")));
        wrapper.setAdjustReason(entryRow.getLong("adjustreasonadj.id"));
        wrapper.setPrincipal(entryRow.getString("personbaseadj.isprincipal"));
        wrapper.setIsTeamMainRole(entryRow.getString("personbaseadj.isteammainrole"));
        wrapper.setAdjustReasonKey("adjustreasonadj");
        wrapper.setProjectTeamKey("personbaseadj.projectteam");
        wrapper.setProjectroleKey("personbaseadj.projectrole");
        wrapper.setBeforeProjectTeamKey("personbaseadj.projectteam");
        wrapper.setPersonKey("personbaseadj.person");
    }

    private static void entry2Wrapper(DynamicObject entryRow, ProjectMemberEntryWrapper wrapper) {
        wrapper.setAdjustEntryEnum(AdjustEntryEnum.ADJUST_ADJ_JOIN);
        wrapper.setPersonId(entryRow.getLong("personbaseadj.person.id"));
        wrapper.setTeamMemberId(entryRow.getLong("personbaseadj.teammember.id"));
        wrapper.setProjectMemberId(entryRow.getLong("personbaseadj.projectmember.id"));
        wrapper.setTeamMemberRoleId(entryRow.getLong("personbaseadj.id"));
        wrapper.setJoinDate(DateUtils.getNoTimeDate(entryRow.getDate("effectdateadj")));
        wrapper.setAdjustReason(entryRow.getLong("adjustreasonadj.id"));
        wrapper.setPrincipal(entryRow.getString("isprincipaladjnew"));
        wrapper.setIsTeamMainRole(entryRow.getString("personbaseadj.isteammainrole"));
        wrapper.setAdjustReasonKey("adjustreasonadj");
        wrapper.setProjectTeamKey("projectteamadjnew");
        wrapper.setProjectroleKey("projectroleadjnew");
        wrapper.setBeforeProjectTeamKey("personbaseadj.projectteam");
        wrapper.setPersonKey("personbaseadj.person");
    }

    private static void entry1Wrapper(DynamicObject entryRow, ProjectMemberEntryWrapper wrapper) {
        wrapper.setAdjustEntryEnum(AdjustEntryEnum.ADJUST_JOIN);
        wrapper.setPersonId(entryRow.getLong("personbaseadja.person.id"));
        wrapper.setTeamMemberId(entryRow.getLong("personbaseadja.id"));
        wrapper.setTeamMemberRoleId(-1L);
        wrapper.setProjectMemberId(entryRow.getLong("personbaseadja.projectmember.id"));
        wrapper.setJoinDate(DateUtils.getNoTimeDate(entryRow.getDate("effectdateadja")));
        wrapper.setAdjustReason(entryRow.getLong("adjustreasonadja.id"));
        wrapper.setPrincipal(entryRow.getString("isprincipaladja"));
        wrapper.setIsTeamMainRole("0");
        wrapper.setAdjustReasonKey("adjustreasonadja");
        wrapper.setProjectTeamKey("personbaseadja.projectteam");
        wrapper.setProjectroleKey("projectroleadja");
        wrapper.setPersonKey("personbaseadja.person");
        wrapper.setBeforeProjectTeamKey("personbaseadja.projectteam");
    }
}

