/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.common.util;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.interaction.InteractionConfirmResult;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.interaction.KDInteractionException;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class OpConfirmHelper {
    public static boolean showConfirmMessage(OperateOption option, String opKey, String message) {
        String confirmResultString = option.getVariableValue("interactionconfirmresult", "");
        InteractionConfirmResult intConfirmResult = InteractionConfirmResult.fromJsonString((String)confirmResultString);
        if (intConfirmResult.getResults().containsKey(opKey)) {
            String result = (String)intConfirmResult.getResults().get(opKey);
            return "Yes".equals(result);
        }
        InteractionContext interactionContext = new InteractionContext();
        OperateErrorInfo errorInfo = new OperateErrorInfo();
        errorInfo.setMessage(message);
        errorInfo.setLevel(ErrorLevel.Warning);
        interactionContext.addOperateInfo(errorInfo);
        throw new KDInteractionException(opKey, interactionContext);
    }

    public static void checkPermissionAndThrowKDBizException(String entityName, String operationKey, String appId) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        Map operateMeta = EntityMetadataCache.getDataEntityOperate((String)entityName, (String)operationKey);
        long userId = RequestContext.get().getCurrUserId();
        String operateName = (String)((Map)operateMeta.get("name")).get(RequestContext.get().getLang().name());
        String permItemId = (String)operateMeta.get("permission");
        boolean hasPermission = PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)entityName, (String)permItemId);
        if (!hasPermission) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OpConfirmHelper_0", (String)"hr-ptmm-common", (Object[])new Object[0]), dataEntityType.getDisplayName().getLocaleValue(), operateName));
        }
    }
}

