/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.common.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Objects;

public class PtmmDateUtils {
    public static Date now() {
        LocalDateTime localDateTime = LocalDateTime.now();
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return Date.from(instant);
    }

    public static boolean isBeforeOrEqualNow(Date date) {
        if (Objects.isNull(date)) {
            return false;
        }
        LocalDate now = LocalDate.now();
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return localDate.isBefore(now) || localDate.isEqual(now);
    }

    public static boolean isBeforeNow(Date date) {
        if (Objects.isNull(date)) {
            return false;
        }
        LocalDate now = LocalDate.now();
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return localDate.isBefore(now);
    }

    public static LocalDate date2LocalDate(Date date) {
        if (Objects.isNull(date)) {
            return LocalDate.MIN;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static boolean isEqualOrBefore(LocalDate localDate1, LocalDate localDate2) {
        Objects.requireNonNull(localDate1);
        Objects.requireNonNull(localDate2);
        return localDate1.isBefore(localDate2) || localDate1.isEqual(localDate2);
    }
}

