/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.common.util;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class PtmmJSONUtils {
    private static final Log logger = LogFactory.getLog(PtmmJSONUtils.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static <T> T map2Bean(Map<String, Object> map, Class<T> clazz) {
        if (map == null) {
            return null;
        }
        Object bean = null;
        try {
            bean = JSON.parseObject((String)JSON.toJSONString(map), clazz);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return (T)bean;
    }

    public static String serialize(Object obj) {
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            logger.error((Throwable)e);
            throw new KDBizException("obj to json string err, please contact admin!");
        }
    }

    public static <T> T deserialize(String jsonStr, TypeReference<T> typeReference) {
        try {
            return (T)objectMapper.readValue(jsonStr, typeReference);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

