/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ptmm.common.util;

import java.util.Date;
import java.util.List;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.ptmm.common.entity.TimePeriod;

public class TimePeriodCalcUtils {
    public static boolean checkIsTimePeriodIntersection(TimePeriod timePeriodsA, TimePeriod timePeriodsB) {
        boolean checkResult = false;
        boolean checkA = TimePeriodCalcUtils.checkTimePeriod(timePeriodsA);
        boolean checkB = TimePeriodCalcUtils.checkTimePeriod(timePeriodsB);
        if (!checkA || !checkB) {
            return false;
        }
        Date aStartDate = timePeriodsA.getStartTime();
        Date aEndDate = timePeriodsA.getEndTime();
        Date bStartDate = timePeriodsB.getStartTime();
        Date bEndDate = HRDateTimeUtils.getBeforeDay((Date)timePeriodsB.getEndTime());
        if (aStartDate.compareTo(bStartDate) == 0 && aEndDate.compareTo(bEndDate) == 0) {
            checkResult = true;
        }
        if (aStartDate.compareTo(bStartDate) > 0 && aStartDate.compareTo(bEndDate) <= 0) {
            checkResult = true;
        }
        if (bStartDate.compareTo(aStartDate) > 0 && bStartDate.compareTo(aEndDate) <= 0) {
            checkResult = true;
        }
        if (aStartDate.compareTo(bStartDate) < 0 && aEndDate.compareTo(bEndDate) >= 0) {
            checkResult = true;
        }
        if (bStartDate.compareTo(aStartDate) <= 0 && bEndDate.compareTo(aEndDate) >= 0) {
            checkResult = true;
        }
        return checkResult;
    }

    public static boolean checkIsTimePeriodInTimeList(TimePeriod timePeriodsA, List<TimePeriod> timePeriods) {
        boolean checkResult = false;
        for (int i = 0; i < timePeriods.size(); ++i) {
            if (!TimePeriodCalcUtils.checkIsTimePeriodIntersection(timePeriodsA, timePeriods.get(i))) continue;
            checkResult = true;
        }
        return checkResult;
    }

    public static boolean checkTimePeriod(TimePeriod timePeriods) {
        boolean checkResult = false;
        if (timePeriods == null) {
            return checkResult;
        }
        if (timePeriods.getStartTime() == null || timePeriods.getEndTime() == null) {
            return checkResult;
        }
        if (timePeriods.getEndTime().compareTo(timePeriods.getStartTime()) >= 0) {
            checkResult = true;
        }
        return checkResult;
    }
}

