/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.common.enums;

import java.util.Arrays;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.hr.hbp.common.util.HRStringUtils;

public enum EvalMsgOpEnum {
    BEGIN("begin", 3010L, new MultiLangEnumBridge("\u542f\u52a8", "EvalMsgOpEnum_0", "hrmp-bes-common")),
    SUSPEND("suspend", 3020L, new MultiLangEnumBridge("\u6682\u505c", "EvalMsgOpEnum_1", "hrmp-bes-common")),
    URGING("urging", 3030L, new MultiLangEnumBridge("\u50ac\u529e", "EvalMsgOpEnum_2", "hrmp-bes-common")),
    RETURN("return", 3040L, new MultiLangEnumBridge("\u9000\u56de", "EvalMsgOpEnum_3", "hrmp-bes-common"));

    private final Long useSceneId;
    private final String code;
    private final MultiLangEnumBridge bridge;

    private EvalMsgOpEnum(String code, Long useSceneId, MultiLangEnumBridge bridge) {
        this.code = code;
        this.bridge = bridge;
        this.useSceneId = useSceneId;
    }

    public String getCode() {
        return this.code;
    }

    public Long getUseSceneId() {
        return this.useSceneId;
    }

    public static String getName(String code) {
        if (code == null) {
            return null;
        }
        for (EvalMsgOpEnum se : EvalMsgOpEnum.values()) {
            if (!code.equals(se.getCode())) continue;
            return se.getName();
        }
        return null;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public static EvalMsgOpEnum getEnumByCode(String code) {
        return Arrays.stream(EvalMsgOpEnum.values()).filter(msgOpEnum -> HRStringUtils.equals((String)code, (String)msgOpEnum.getCode())).findFirst().orElse(null);
    }

    public static EvalMsgOpEnum getEnumByUseSceneId(Long useSceneId) {
        return Arrays.stream(EvalMsgOpEnum.values()).filter(msgOpEnum -> msgOpEnum.getUseSceneId().compareTo(useSceneId) == 0).findFirst().orElse(null);
    }
}

