/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.common.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;

public class DynamicObjectIdUtils {
    public static List<Long> getIds(DynamicObject[] objs) {
        return DynamicObjectIdUtils.getIds(objs, "id");
    }

    public static List<Long> getIds(DynamicObject[] objs, String key) {
        return Arrays.stream(objs).map(obj -> obj.getLong(key)).collect(Collectors.toList());
    }

    public static List<Long> getIds(Collection<DynamicObject> objs) {
        return DynamicObjectIdUtils.getIds(objs, "id");
    }

    public static List<Long> getIds(Collection<DynamicObject> objs, String key) {
        return objs.stream().map(obj -> obj.getLong(key)).collect(Collectors.toList());
    }

    public static List<String> getStrProp(Collection<DynamicObject> objs, String key) {
        return objs.stream().map(obj -> obj.getString(key)).collect(Collectors.toList());
    }

    public static long getBaseDataId(DynamicObject obj, String key) {
        Object baseObj = obj.get(key);
        if (baseObj instanceof DynamicObject) {
            return obj.getLong(key + "_id");
        }
        return obj.getLong(key);
    }
}

