/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.common.utils;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.util.HRStringUtils;

public class NumberNameConvertUtils {
    public static Map<Long, String> getNumberNameMap(DynamicObject[] objs) {
        return NumberNameConvertUtils.getIdBllNoNameMap(objs, "evaluatorsource", "evaloroutname", "evaloroutnumber", "evalorouttel");
    }

    public static Map<Long, String> getNumberNameMapEvalObj(DynamicObject[] objs) {
        return NumberNameConvertUtils.getIdBllNoNameMap(objs, "perdatasource", "pername", "pernumber", "telephone");
    }

    public static Map<Long, String> getEvaluatorNumber(DynamicObject[] objs) {
        return NumberNameConvertUtils.getIdNumberMap(objs);
    }

    public static <T> Map<T, String> getIdBllNoNameMap(DynamicObject[] objs, String sourceKey, String nameKey, String numberKey, String outTelKey) {
        Map<String, Integer> nameIdMap = Arrays.stream(objs).collect(Collectors.groupingBy(obj -> obj.getString(nameKey), Collectors.collectingAndThen(Collectors.toSet(), Set::size)));
        return Arrays.stream(objs).collect(Collectors.toMap(obj -> obj.get("id"), obj -> {
            String fullSource = obj.getString(sourceKey);
            String fullName = obj.getString(nameKey);
            String fullNumber = obj.getString(numberKey);
            String fullTel = obj.getString(outTelKey);
            Integer idCount = (Integer)nameIdMap.get(fullName);
            if (idCount != null && idCount > 1) {
                if (HRStringUtils.equals((String)fullSource, (String)"1")) {
                    return fullName + "\uff08" + fullNumber + "\uff09";
                }
                return fullName + "\uff08" + fullTel + "\uff09";
            }
            return fullName;
        }, (k1, k2) -> k1));
    }

    public static Map<Long, String> getIdNumberMap(DynamicObject[] objs) {
        Map<Long, String> idNumberMap = Arrays.stream(objs).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("evaluatornumber")));
        return idNumberMap;
    }
}

