/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.mservice;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hrmp.bes.business.domain.evaltask.EvalTaskDomainServiceImpl;
import kd.hrmp.bes.mservice.ResultUtils;
import kd.hrmp.bes.mservice.api.IEvalTaskService;

public class EvalTaskService
implements IEvalTaskService {
    private static final Log log = LogFactory.getLog(EvalTaskService.class);
    private final EvalTaskDomainServiceImpl evalTaskDomainService = new EvalTaskDomainServiceImpl();

    public Map<String, Object> createEvalTaskPerRealName(Map<String, Object> evalParam) {
        Map result = this.evalTaskDomainService.createEvalTaskPerRealName(evalParam);
        return result;
    }

    public Map<String, Object> createEvalTaskPerAnonymous(Map<String, Object> evalParam) {
        Map result = this.evalTaskDomainService.createEvalTaskPerAnonymous(evalParam);
        return result;
    }

    public Map<String, Object> startUpEvalTask(List<Long> ids) {
        log.info("EvalTaskService.startUpEvalTask ids: {}", ids);
        try {
            this.evalTaskDomainService.startUpEvalTask(ids);
            return ResultUtils.getSucResult();
        }
        catch (Exception e) {
            log.error("EvalTaskService.startUpEvalTask error ", (Throwable)e);
            return ResultUtils.getResult(Boolean.FALSE, e.getMessage());
        }
    }

    public Map<String, Object> deleteEvalTask(List<Long> ids) {
        log.info("EvalTaskService.deleteEvalTask ids: {}", ids);
        this.evalTaskDomainService.deleteEvalTaskById(ids);
        return ResultUtils.getSucResult();
    }

    public Map<String, Object> terminateEvalTask(Map<Long, Object> param) {
        log.info("EvalTaskService.terminateEvalTask param: {}", param);
        OperationResult operationResult = this.evalTaskDomainService.terminateEvalTask(param);
        log.info("EvalTaskService.completeEvalTask terminateEvalTask: {}", (Object)operationResult);
        return ResultUtils.getResult(operationResult);
    }

    public Map<String, Object> completeEvalTask(List<Long> ids) {
        log.info("EvalTaskService.completeEvalTask ids: {}", ids);
        OperationResult operationResult = this.evalTaskDomainService.completedEvalTaskByOp(ids);
        log.info("EvalTaskService.completeEvalTask operationResult: {}", (Object)operationResult);
        return ResultUtils.getResult(operationResult);
    }

    public Map<String, Object> adjustTaskEndDate(Map<Long, Date> param) {
        OperationResult operationResult;
        log.info("EvalTaskService.adjustTaskEndDate ids: {}", param);
        try {
            operationResult = this.evalTaskDomainService.adjustTaskEndDate(param);
        }
        catch (Exception e) {
            log.error("EvalTaskService.adjustTaskEndDate", (Throwable)e);
            return ResultUtils.getResult(Boolean.FALSE, "sys error");
        }
        log.info("EvalTaskService.adjustTaskEndDate operationResult: {}", (Object)operationResult);
        return ResultUtils.getResult(operationResult);
    }

    public Map<Long, List<String>> getIncompleteEvaluator(List<Long> ids) {
        log.info("EvalTaskService.getIncompleteEvaluator ids: {}", ids);
        return this.evalTaskDomainService.getIncompleteEvaluator(ids);
    }
}

