/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.opplugin.body;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;
import kd.hrmp.bes.business.domain.evaltask.EvalTaskDomainServiceImpl;

public class EvalBodyQuoteCannotDeleteOp
extends HRCoreBaseBillOp {
    private static final EvalTaskDomainServiceImpl EVALTASKDOMAINSERVICE = new EvalTaskDomainServiceImpl();
    private static final Log LOG = LogFactory.getLog(EvalBodyQuoteCannotDeleteOp.class);

    public void onAddValidators(AddValidatorsEventArgs evt) {
        super.onAddValidators(evt);
        evt.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] selectedData = this.getDataEntities();
                ArrayList<Long> evalBodyIdList = new ArrayList<Long>(selectedData.length);
                for (ExtendedDataEntity selectedDatum : selectedData) {
                    evalBodyIdList.add(selectedDatum.getDataEntity().getLong("id"));
                }
                LOG.info("EvalIndicatorsDeleteOp.onAddValidators.validate indicatorsIdList is {}", evalBodyIdList);
                DynamicObject[] taskDyList = EVALTASKDOMAINSERVICE.queryTaskDynamicObjByBodyIds(evalBodyIdList);
                Map<Long, List<DynamicObject>> evalBodyIdAndTaskDys = Arrays.stream(taskDyList).collect(Collectors.groupingBy(obj -> obj.getLong("contententryentity.evaluatorrealsubentry.evalbody")));
                for (ExtendedDataEntity selectedDatum : selectedData) {
                    if (!Objects.nonNull(evalBodyIdAndTaskDys.get(selectedDatum.getDataEntity().getLong("id"))) || evalBodyIdAndTaskDys.get(selectedDatum.getDataEntity().getLong("id")).size() <= 0) continue;
                    String referencedTaskName = EvalBodyQuoteCannotDeleteOp.this.referencedTplNameList(evalBodyIdAndTaskDys.get(selectedDatum.getDataEntity().getLong("id")));
                    this.addFatalErrorMessage(selectedDatum, ResManager.loadKDString((String)"\u5f53\u524d\u8bc4\u4ef7\u4e3b\u4f53\u5df2\u88ab\u6d4b\u8bc4\u4efb\u52a1\uff1a%s\u5f15\u7528\uff0c \u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"EvalBoyQuoteCannotDeleteOp_0", (String)"hrmp-bes-opplugin", (Object[])new Object[]{referencedTaskName}));
                }
            }
        });
    }

    private String referencedTplNameList(List<DynamicObject> referencedTaskList) {
        StringJoiner referencedNameList = new StringJoiner("\u3001");
        for (DynamicObject dynamicObject : referencedTaskList) {
            referencedNameList.add(dynamicObject.getString("name"));
        }
        return referencedNameList.toString();
    }
}

