/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.opplugin.evaltask;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hrmp.bes.business.domain.application.task.EvalTaskMenuDomainServiceImpl;
import kd.hrmp.bes.business.domain.evaltask.EvalTaskDomainServiceImpl;
import kd.hrmp.bes.common.enums.EvalTaskStatusEnum;

public class EvalTaskDochangeDeadLineOp
extends HRDataBaseOp {
    private static final EvalTaskDomainServiceImpl EVALTASKDOMAINSERVICE = new EvalTaskDomainServiceImpl();
    private static final EvalTaskMenuDomainServiceImpl EVALTASKMENUDOMAINSERVICE = new EvalTaskMenuDomainServiceImpl();
    private static final Log LOG = LogFactory.getLog(EvalTaskDochangeDeadLineOp.class);
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        super.onPreparePropertys(evt);
        evt.getFieldKeys().add("startdate");
        evt.getFieldKeys().add("evaltaskstatus");
        evt.getFieldKeys().add("planenddate");
    }

    public void onAddValidators(AddValidatorsEventArgs evt) {
        super.onAddValidators(evt);
        evt.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] selectedData = this.getDataEntities();
                ArrayList<Long> tasksIdList = new ArrayList<Long>(selectedData.length);
                for (ExtendedDataEntity selectedDatum : selectedData) {
                    tasksIdList.add(selectedDatum.getDataEntity().getLong("id"));
                }
                LOG.info("EvalTaskDochangeDeadLineOp.onAddValidators.validate indicatorsIdList is {}", tasksIdList);
                Map idsAndStatusMap = EVALTASKDOMAINSERVICE.queryByIds(tasksIdList);
                for (ExtendedDataEntity selectedDatum : selectedData) {
                    DynamicObject dataEntity = selectedDatum.getDataEntity();
                    String evalTaskStatus = (String)idsAndStatusMap.get(dataEntity.getLong("id"));
                    if (HRStringUtils.equals((String)evalTaskStatus, (String)EvalTaskStatusEnum.IN_PROGRESS.getCode()) || HRStringUtils.equals((String)evalTaskStatus, (String)EvalTaskStatusEnum.PAUSED.getCode())) continue;
                    this.addErrorMessage(selectedDatum, ResManager.loadKDString((String)"\u53ea\u6709\u201c\u8fdb\u884c\u4e2d\u201d\u6216\u201c\u6682\u505c\u4e2d\u201d\u7684\u6d4b\u8bc4\u4efb\u52a1\u5141\u8bb8\u8c03\u6574\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u3002", (String)"EvalTaskDochangeDeadLineOp_0", (String)"hrmp-bes-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] batchSetDateEntry = e.getDataEntities();
        String json = this.getOption().getVariableValue("setidanddateinfo");
        Map taskIdDateMap = (Map)SerializationUtils.fromJsonString((String)json, Map.class);
        this.operationResultHandler(batchSetDateEntry, taskIdDateMap);
    }

    private void operationResultHandler(DynamicObject[] operationResult, Map<String, String> restoredMap) {
        if (operationResult.length == 0) {
            return;
        }
        for (DynamicObject dynamicObject : operationResult) {
            try {
                Date date = SIMPLE_DATE_FORMAT.parse(restoredMap.get(dynamicObject.getString("id")));
                dynamicObject.set("planenddate", (Object)date);
            }
            catch (ParseException e) {
                LOG.info("Date Format Error:" + e.getMessage());
            }
        }
        EVALTASKMENUDOMAINSERVICE.updateBatchSetTimeResult(operationResult);
    }
}

