/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.opplugin.track.button;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hrmp.bes.business.domain.entityservice.evalsubtask.EvalSubTaskEntityService;
import kd.hrmp.bes.business.domain.entityservice.evalsubtask.EvalTaskEntityService;
import kd.hrmp.bes.business.domain.entityservice.evalsubtask.track.TrackEvaluatorAnonEntityService;
import kd.hrmp.bes.business.domain.entityservice.evalsubtask.track.TrackEvaluatorRealEntityService;
import kd.hrmp.bes.business.domain.evaltask.EvalTaskDomainServiceImpl;
import kd.hrmp.bes.common.enums.EvalSubTaskStatusEnum;

public class EvalTrackReturnOp
extends HRDataBaseOp {
    private static final Log log = LogFactory.getLog(EvalTrackReturnOp.class);
    private static final TrackEvaluatorRealEntityService trackEvaluatorRealEntityService = new TrackEvaluatorRealEntityService();
    private static final TrackEvaluatorAnonEntityService trackEvaluatorAnonEntityService = new TrackEvaluatorAnonEntityService();
    private static final EvalSubTaskEntityService evalSubTaskEntityService = new EvalSubTaskEntityService();
    private static EvalTaskDomainServiceImpl evalTaskDomainService = new EvalTaskDomainServiceImpl();
    private static final EvalTaskEntityService taskEntityService = new EvalTaskEntityService();

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        super.onPreparePropertys(evt);
        evt.getFieldKeys().add("evalstatus");
        evt.getFieldKeys().add("returnuser");
        evt.getFieldKeys().add("returntime");
        evt.getFieldKeys().add("evaltask");
        evt.getFieldKeys().add("taskcontentid");
    }

    public void onAddValidators(AddValidatorsEventArgs evt) {
        super.onAddValidators(evt);
        evt.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] proxyRecordData;
                for (ExtendedDataEntity proxyRecordDatum : proxyRecordData = this.getDataEntities()) {
                    if (HRStringUtils.equals((String)proxyRecordDatum.getValue("evalstatus").toString(), (String)"B")) continue;
                    this.addErrorMessage(proxyRecordDatum, ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5df2\u5b8c\u6210\u201d\u7684\u6570\u636e\u5141\u8bb8\u9000\u56de\u3002", (String)"EvalTrackReturnOp_0", (String)"hrmp-bes-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs evt) {
        String realOrAnon;
        super.beginOperationTransaction(evt);
        DynamicObject[] needUpdateData = evt.getDataEntities();
        Long taskId = needUpdateData[0].getLong("evaltask.id");
        DynamicObject taskDy = taskEntityService.queryOneById(taskId);
        for (DynamicObject needUpdateDatum : needUpdateData) {
            needUpdateDatum.set("returnuser", (Object)UserServiceHelper.getCurrentUserId());
            needUpdateDatum.set("returntime", (Object)new Date());
        }
        switch (realOrAnon = taskDy.getString("realorcryptonym")) {
            case "1": {
                trackEvaluatorRealEntityService.save(needUpdateData);
                break;
            }
            case "2": {
                trackEvaluatorAnonEntityService.save(needUpdateData);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs evt) {
        super.afterExecuteOperationTransaction(evt);
        DynamicObject[] successData = evt.getDataEntities();
        Long taskId = successData[0].getLong("evaltask.id");
        Long contentId = successData[0].getLong("taskcontentid");
        List<Object> successIdList = Arrays.stream(successData).map(obj -> obj.get("id")).collect(Collectors.toList());
        this.updateReturn(taskId, contentId, successIdList);
    }

    private void updateReturn(Object taskId, Object contentId, List<Object> successPkIds) {
        DynamicObject taskDy = taskEntityService.queryOneById((Long)taskId);
        DynamicObject[] realOrAnon = taskDy.getString("realorcryptonym");
        DynamicObject[] needUpdateData = null;
        switch (realOrAnon) {
            case "1": {
                needUpdateData = this.getRealNeedUpdateData(taskId, contentId, successPkIds);
                break;
            }
            case "2": {
                needUpdateData = this.getAnonNeedUpdateData(taskId, contentId, successPkIds);
            }
        }
        log.info("EvalTrackReturnOp.afterExecuteOperationTransaction.updateReturn needUpdateData:{}", needUpdateData);
        if (Objects.nonNull(needUpdateData)) {
            for (DynamicObject needUpdateDatum : needUpdateData) {
                needUpdateDatum.set("taskstatus", (Object)EvalSubTaskStatusEnum.UN_EVALUATE.getCode());
                needUpdateDatum.set("endtime", null);
            }
            evalSubTaskEntityService.save(needUpdateData);
            ArrayList<Long> evalTaskIdList = new ArrayList<Long>(1);
            evalTaskIdList.add((Long)taskId);
            evalTaskDomainService.refreshEvalResult(evalTaskIdList);
        }
    }

    private DynamicObject[] getRealNeedUpdateData(Object taskId, Object contentId, List<Object> successPkIds) {
        DynamicObject[] evaluatorRealDy = trackEvaluatorRealEntityService.queryByPkIds(successPkIds);
        List evaluatorRealIds = Arrays.stream(evaluatorRealDy).filter(obj -> obj.getLong("evalinternalper.id") != 0L).map(obj -> obj.getLong("evalinternalper.id")).collect(Collectors.toList());
        evaluatorRealIds.addAll(Arrays.stream(evaluatorRealDy).filter(obj -> obj.getLong("evaloutsiderentryid") != 0L).map(obj -> obj.getLong("evaloutsiderentryid")).collect(Collectors.toList()));
        log.info("EvalTrackReturnOp.afterExecuteOperationTransaction.updateReturn.getRealNeedUpdateData taskId:{}, contentId:{}, evaluatorRealIds:{}", new Object[]{taskId, contentId, evaluatorRealIds});
        return evalSubTaskEntityService.querySubTaskByObj(taskId, contentId, evaluatorRealIds, null, "1");
    }

    private DynamicObject[] getAnonNeedUpdateData(Object taskId, Object contentId, List<Object> successPkIds) {
        DynamicObject[] evaluatorAnonDys = trackEvaluatorAnonEntityService.queryByPkIds(successPkIds);
        LinkedList<String> userAccounts = new LinkedList<String>();
        for (DynamicObject evaluatorAnonDy : evaluatorAnonDys) {
            userAccounts.add(evaluatorAnonDy.getString("accountanon"));
        }
        log.info("EvalTrackReturnOp.afterExecuteOperationTransaction.updateReturn.getAnonNeedUpdateData taskId:{}, contentId:{}, evaluatorRealIds:{}", new Object[]{taskId, contentId, userAccounts});
        return evalSubTaskEntityService.querySubTaskByObj(taskId, contentId, null, userAccounts, "2");
    }
}

