/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.opplugin.track.button;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hrmp.bes.business.domain.entityservice.evalsubtask.track.TrackEvaluatorRealEntityService;

public class EvalTrackUrgeOp
extends HRDataBaseOp {
    TrackEvaluatorRealEntityService trackEvaluatorRealEntityService = new TrackEvaluatorRealEntityService();

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        super.onPreparePropertys(evt);
        evt.getFieldKeys().add("evalstatus");
        evt.getFieldKeys().add("reminder");
        evt.getFieldKeys().add("remindertime");
    }

    public void onAddValidators(AddValidatorsEventArgs evt) {
        super.onAddValidators(evt);
        evt.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] proxyRecordData;
                for (ExtendedDataEntity proxyRecordDatum : proxyRecordData = this.getDataEntities()) {
                    if (!HRStringUtils.equals((String)proxyRecordDatum.getValue("evalstatus").toString(), (String)"A")) {
                        this.addErrorMessage(proxyRecordDatum, ResManager.loadKDString((String)"\u53ea\u6709\u201c\u8fdb\u884c\u4e2d\u201d\u7684\u6570\u636e\u5141\u8bb8\u50ac\u529e\u3002", (String)"EvalTrackUrgeOp_0", (String)"hrmp-bes-opplugin", (Object[])new Object[0]));
                    }
                    if (!Objects.nonNull(proxyRecordDatum.getValue("remindertime"))) continue;
                    String returnTime = proxyRecordDatum.getValue("remindertime").toString();
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Date newReturn = new Date();
                    try {
                        Date tempReturnTime = dateFormat.parse(returnTime);
                        newReturn = new Date(tempReturnTime.getTime() + 300000L);
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                    if (newReturn.compareTo(new Date()) <= 0) continue;
                    this.addErrorMessage(proxyRecordDatum, ResManager.loadKDString((String)"\u64cd\u4f5c\u592a\u9891\u7e41\uff0c\u8bf7\u4e94\u5206\u949f\u540e\u518d\u8bd5\u3002", (String)"EvalTrackUrgeOp_1", (String)"hrmp-bes-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs evt) {
        DynamicObject[] needUpdateData;
        super.beginOperationTransaction(evt);
        for (DynamicObject needUpdateDatum : needUpdateData = evt.getDataEntities()) {
            needUpdateDatum.set("reminder", (Object)UserServiceHelper.getCurrentUserId());
            needUpdateDatum.set("remindertime", (Object)new Date());
        }
        this.trackEvaluatorRealEntityService.save(needUpdateData);
    }
}

