/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.opplugin.validator.indicators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hrmp.bes.business.domain.evaltpl.EvalTplDomainServiceImpl;

public class EvalIndicatorsDeleteOp
extends HRDataBaseOp {
    private static final EvalTplDomainServiceImpl TPLDOMAINSERVICE = new EvalTplDomainServiceImpl();
    private static final Log LOG = LogFactory.getLog(EvalIndicatorsDeleteOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] selectedData = this.getDataEntities();
                ArrayList<Long> indicatorsIdList = new ArrayList<Long>(selectedData.length);
                for (ExtendedDataEntity selectedDatum : selectedData) {
                    indicatorsIdList.add(selectedDatum.getDataEntity().getLong("id"));
                }
                LOG.info("EvalIndicatorsDeleteOp.onAddValidators.validate indicatorsIdList is {}", indicatorsIdList);
                DynamicObject[] tplDyList = TPLDOMAINSERVICE.queryTplDynamicObjByIndicatorIds(indicatorsIdList);
                Map<Long, List<DynamicObject>> indicatorIdAndTplDys = Arrays.stream(tplDyList).collect(Collectors.groupingBy(obj -> obj.getLong("indicatorentryentity.indicatorbase")));
                for (ExtendedDataEntity selectedDatum : selectedData) {
                    if (!Objects.nonNull(indicatorIdAndTplDys.get(selectedDatum.getDataEntity().getLong("id"))) || indicatorIdAndTplDys.get(selectedDatum.getDataEntity().getLong("id")).size() <= 0) continue;
                    String referencedTplName = EvalIndicatorsDeleteOp.this.referencedTplNameList(indicatorIdAndTplDys.get(selectedDatum.getDataEntity().getLong("id")));
                    this.addFatalErrorMessage(selectedDatum, ResManager.loadKDString((String)"\u5f53\u524d\u6d4b\u8bc4\u6307\u6807\u5df2\u88ab\u6d4b\u8bc4\u6a21\u677f\uff1a%s\u5f15\u7528\uff0c \u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"EvalIndicatorsDeleteOp_0", (String)"hrmp-bes-opplugin", (Object[])new Object[]{referencedTplName}));
                }
            }
        });
    }

    private String referencedTplNameList(List<DynamicObject> referencedTplList) {
        StringJoiner referencedNameList = new StringJoiner("\u3001");
        for (DynamicObject dynamicObject : referencedTplList) {
            referencedNameList.add(dynamicObject.getString("name"));
        }
        return referencedNameList.toString();
    }
}

