/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.opplugin.validator.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.bes.business.domain.BesServiceFactory;
import kd.hrmp.bes.business.domain.entityservice.evalsubtask.track.TrackEvalObjOrgEntityService;
import kd.hrmp.bes.business.domain.entityservice.evalsubtask.track.TrackEvalObjPerEntityService;
import kd.hrmp.bes.common.enums.EvalTaskStatusEnum;
import kd.hrmp.bes.common.utils.NumberNameConvertUtils;
import kd.hrmp.bes.opplugin.validator.task.TaskSourceCheckValidator;
import org.apache.commons.collections4.CollectionUtils;

public class EvalTaskCompleteValidator
extends HRDataBaseValidator {
    private final TrackEvalObjPerEntityService evalObjPerEntityService = (TrackEvalObjPerEntityService)BesServiceFactory.getService(TrackEvalObjPerEntityService.class);
    private final TrackEvalObjOrgEntityService evalObjOrgEntityService = (TrackEvalObjOrgEntityService)BesServiceFactory.getService(TrackEvalObjOrgEntityService.class);

    public void validate() {
        List evalTaskIdList = Arrays.stream(this.getDataEntities()).map(ExtendedDataEntity::getDataEntity).filter(dataEntity -> EvalTaskStatusEnum.IN_PROGRESS.getCode().equals(dataEntity.getString("evaltaskstatus"))).map(dataEntity -> dataEntity.getLong("id")).collect(Collectors.toList());
        QFilter evalTaskFilter = new QFilter("evaltask.id", "in", evalTaskIdList);
        QFilter evalNumFilter = new QFilter("completeevalnum", "=", (Object)0);
        QFilter[] filters = new QFilter[]{evalTaskFilter, evalNumFilter};
        List evalObjPer = this.evalObjPerEntityService.queryOriginalList("id,evaltask,perdatasource,pername,pernumber,telephone", filters);
        Map<Long, List<DynamicObject>> evalObjPerGroup = evalObjPer.stream().collect(Collectors.groupingBy(obj -> obj.getLong("evaltask")));
        List evalObjOrg = this.evalObjOrgEntityService.queryOriginalList("id,evaltask,orgname", filters);
        Map<Long, List<DynamicObject>> evalObjOrgGroup = evalObjOrg.stream().collect(Collectors.groupingBy(obj -> obj.getLong("evaltask")));
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            List<DynamicObject> evalObjOrgNoEvalList;
            Boolean isEvalTask;
            DynamicObject dataEntity2 = extendedDataEntity.getDataEntity();
            String taskStatus = dataEntity2.getString("evaltaskstatus");
            boolean skipTaskSourceValidate = this.getOption().containsVariable("skip_task_source_validate");
            if (!skipTaskSourceValidate && !(isEvalTask = TaskSourceCheckValidator.checkTaskSource(dataEntity2)).booleanValue()) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u6d4b\u8bc4\u4efb\u52a1\u6765\u6e90\u4e3a\u201c\u6d4b\u8bc4\u7ba1\u7406\u201d\u7684\u6d4b\u8bc4\u4efb\u52a1\u5141\u8bb8\u64cd\u4f5c\u5b8c\u6210\u3002", (String)"EvalTaskCompleteValidator_1", (String)"hrmp-bes-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (!EvalTaskStatusEnum.IN_PROGRESS.getCode().equals(taskStatus)) continue;
            ArrayList tipEvalObj = Lists.newArrayList();
            long evalTaskId = dataEntity2.getLong("id");
            List<DynamicObject> evalObjPerNoEvalList = evalObjPerGroup.get(evalTaskId);
            if (CollectionUtils.isNotEmpty(evalObjPerNoEvalList)) {
                Map evaluatorNumber = NumberNameConvertUtils.getNumberNameMapEvalObj((DynamicObject[])evalObjPerNoEvalList.toArray(new DynamicObject[0]));
                tipEvalObj.addAll(evaluatorNumber.values());
            }
            if (CollectionUtils.isNotEmpty(evalObjOrgNoEvalList = evalObjOrgGroup.get(evalTaskId))) {
                List orgNameList = evalObjOrgNoEvalList.stream().map(obj -> obj.getString("orgname")).collect(Collectors.toList());
                tipEvalObj.addAll(orgNameList);
            }
            if (!CollectionUtils.isNotEmpty((Collection)tipEvalObj)) continue;
            String tipStr = tipEvalObj.stream().map(nameStr -> "\u201c" + nameStr + "\u201d").collect(Collectors.joining("\u3001"));
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u88ab\u6d4b\u8bc4\u5bf9\u8c61%s\u672a\u88ab\u8bc4\u4ef7\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u5b8c\u6210\u3002", (String)"EvalTaskCompleteValidator_0", (String)"hrmp-bes-formplugin", (Object[])new Object[]{tipStr}));
        }
    }
}

