/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.opplugin.validator.task;

import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.bes.business.domain.checkservice.EvalTaskAnonymousReviewerCheckHelper;
import kd.hrmp.bes.business.domain.checkservice.EvalTaskContCheckHelper;
import kd.hrmp.bes.business.domain.checkservice.EvalTaskEvaluatorRealCheckHelper;
import kd.hrmp.bes.business.domain.evalsubtask.EvalTaskBasicInfoHelper;
import kd.hrmp.bes.business.domain.evalsubtask.EvalTaskSetObHelper;
import kd.hrmp.bes.common.dto.CheckValidateMsg;

public class EvalTaskNextStepValidator
extends HRDataBaseValidator {
    private static final Log LOG = LogFactory.getLog(EvalTaskNextStepValidator.class);

    public void validate() {
        super.validate();
        String focusGuideNode = this.getFocusGuideNode();
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            CheckValidateMsg checkValidateMsg = null;
            switch (focusGuideNode) {
                case "tab_baseinfo": {
                    checkValidateMsg = EvalTaskBasicInfoHelper.judgingDate((DynamicObject)dataEntity);
                    break;
                }
                case "tab_certassessment": {
                    checkValidateMsg = EvalTaskContCheckHelper.scoreIndicatorSetSaveCheck((DynamicObject)dataEntity);
                    break;
                }
                case "tab_setassessper": {
                    checkValidateMsg = EvalTaskSetObHelper.setObInfoIsEmpty((DynamicObject)dataEntity);
                    break;
                }
                case "tab_setevalper": {
                    String anonymousFlag = dataEntity.getString("realorcryptonym");
                    if (HRStringUtils.equals((String)anonymousFlag, (String)"1") && (checkValidateMsg = EvalTaskEvaluatorRealCheckHelper.evaluatorSaveCheck((DynamicObject)dataEntity)).getPass().booleanValue()) {
                        checkValidateMsg = EvalTaskEvaluatorRealCheckHelper.outEvaluatorSaveValid((DynamicObject)dataEntity);
                    }
                    if (!HRStringUtils.equals((String)anonymousFlag, (String)"2")) break;
                    checkValidateMsg = EvalTaskAnonymousReviewerCheckHelper.setAnonymousReviewerSaveCheck((DynamicObject)dataEntity);
                    break;
                }
            }
            this.handleResult(extendedDataEntity, checkValidateMsg);
        }
    }

    private void handleResult(ExtendedDataEntity extendedDataEntity, CheckValidateMsg checkValidateMsg) {
        if (checkValidateMsg == null) {
            return;
        }
        if (!checkValidateMsg.getPass().booleanValue()) {
            int noteType = checkValidateMsg.getNoteType();
            if (noteType == 0) {
                this.addErrorMessage(extendedDataEntity, (String)checkValidateMsg.getMsgList().get(0));
            }
            if (noteType == 1) {
                for (String errorMsg : checkValidateMsg.getMsgList()) {
                    this.addFatalErrorMessage(extendedDataEntity, errorMsg);
                }
            }
        }
    }

    private String getFocusGuideNode() {
        OperateOption option = this.getOption();
        return option.getVariableValue("guidenode", "");
    }
}

