/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.application.external;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;

public class BesHRPIPersonService {
    private static final Log log = LogFactory.getLog(BesHRPIPersonService.class);

    public List<Map<String, Object>> listEmpposorgrels(String postType, List<Long> personIds) {
        log.info("listPersonByNameAndNumber params postType: {}, personIds: {}", (Object)postType, personIds);
        return (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"listEmpposorgrels", (Object[])new Object[]{postType, personIds});
    }

    public List<Map<String, Object>> listEmpposorgrels(List<Long> personIds) {
        return this.listEmpposorgrels("1", personIds);
    }

    public Map<Long, Map<String, Object>> listPrimaryEmpposorgrels(List<Long> personIds) {
        List<Map<String, Object>> empposorgrelsList = this.listEmpposorgrels(personIds);
        return empposorgrelsList.stream().collect(Collectors.groupingBy(obj -> Long.parseLong(String.valueOf(obj.get("employee_id"))), Collectors.collectingAndThen(Collectors.toList(), groupEmpposorgrelsByEmployee -> {
            Optional<Map> primaryEmpposorgrelsOption = groupEmpposorgrelsByEmployee.stream().filter(obj -> Boolean.TRUE.equals(obj.get("isprimary"))).findAny();
            return primaryEmpposorgrelsOption.orElseGet(() -> groupEmpposorgrelsByEmployee.stream().max(Comparator.comparing(empposorgrel -> {
                Object startDate = empposorgrel.get("startdate");
                if (startDate == null) {
                    return new Date(0L);
                }
                return (Date)startDate;
            })).orElseGet(HashMap::new));
        })));
    }

    public DynamicObject[] listFieldsFilterInfo(List<Long> personIds) {
        QFilter perFilter = new QFilter("person.id", "in", personIds);
        return (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonSyncService", (String)"listFieldsFilterInfo", (Object[])new Object[]{"person,phone,peremail,busemail", perFilter, "hrpi_percontact"});
    }

    public List<Map<String, Object>> listEmployees(List<Long> employeeIds) {
        return (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listEmployees", (Object[])new Object[]{employeeIds});
    }

    public Map<String, Object> getUserIdByEmployeeIds(List<Long> employeeIds) {
        HashMap idMaps = Maps.newHashMapWithExpectedSize((int)1);
        idMaps.put("employee", employeeIds);
        return this.getUserIdByPersonInfo(idMaps);
    }

    public Map<String, Object> getUserIdByPersonIds(List<Long> personIds) {
        HashMap idMaps = Maps.newHashMapWithExpectedSize((int)1);
        idMaps.put("person", personIds);
        return this.getUserIdByPersonInfo(idMaps);
    }

    public Map<String, Object> getUserIdByPersonInfo(Map<String, List<Long>> idMaps) {
        log.info("SihcIHRPIPersonService.getUserIdByPersonInfo idMaps: {}", idMaps);
        Map res = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getUserIdByPersonInfo", (Object[])new Object[]{idMaps});
        log.info("SihcIHRPIPersonService.getUserIdByPersonInfo res: {}", (Object)res);
        return res;
    }

    public Map<String, Object> getPersonModelId() {
        Map res = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonModelId", (Object[])new Object[0]);
        log.info("SihcIHRPIPersonService.getPersonModelId res: {}", (Object)res);
        return res;
    }

    public List<Map<String, Object>> getEmpposorgrelsByDepId(List<Long> depempIds) {
        return (List)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIDepempService", (String)"listEmpOrgrels", (Object[])new Object[]{depempIds});
    }
}

