/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.checkservice;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hrmp.bes.business.domain.checkservice.EvaluatorValHelper;
import kd.hrmp.bes.common.dto.CheckValidateMsg;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class EvalTaskAnonymousReviewerCheckHelper {
    private static final Log LOG = LogFactory.getLog(EvalTaskAnonymousReviewerCheckHelper.class);

    public static CheckValidateMsg setAnonymousReviewerSaveCheck(DynamicObject entity) {
        CheckValidateMsg msg = new CheckValidateMsg();
        String realAnonymous = entity.getString("realorcryptonym");
        if (!"2".equals(realAnonymous)) {
            return msg;
        }
        try {
            EvalTaskAnonymousReviewerCheckHelper.checkEvalTaskContentAnonymousReviewer(entity, msg);
            return msg;
        }
        catch (Exception exception) {
            LOG.error("scoreIndicatorSetSaveCheck error: ", (Throwable)exception);
            msg.setPass(Boolean.FALSE);
            return msg;
        }
    }

    private static void checkEvalTaskContentAnonymousReviewer(DynamicObject entity, CheckValidateMsg msg) {
        if (!msg.getPass().booleanValue()) {
            return;
        }
        DynamicObjectCollection contentEntity = entity.getDynamicObjectCollection("contententryentity");
        ArrayList<String> messageList = new ArrayList<String>(10);
        if (contentEntity != null && contentEntity.size() > 0) {
            DynamicObject contentEntryObj;
            boolean validateSuc;
            Iterator iterator = contentEntity.iterator();
            while (iterator.hasNext() && (validateSuc = EvalTaskAnonymousReviewerCheckHelper.checkAnonymousReviewer(contentEntryObj = (DynamicObject)iterator.next(), messageList))) {
            }
        }
        if (messageList.size() > 0) {
            msg.setPass(Boolean.FALSE);
            msg.getMsgList().addAll(messageList);
            msg.setNoteType(messageList.size() > 1 ? 1 : 0);
        }
    }

    private static boolean checkAnonymousReviewer(DynamicObject contentEntryObj, List<String> messageList) {
        EvalTaskAnonymousReviewerCheckHelper.validateFieldMustInput(contentEntryObj, messageList);
        if (messageList.size() == 0) {
            EvaluatorValHelper.validOuterEntry(contentEntryObj, messageList);
        }
        if (messageList.size() == 0) {
            EvaluatorValHelper.validEvaluatorScope(contentEntryObj, messageList);
        }
        if (messageList.size() == 0) {
            EvalTaskAnonymousReviewerCheckHelper.validateAccountInformation(contentEntryObj, messageList);
        }
        return messageList.size() == 0;
    }

    private static void validateAccountInformation(DynamicObject contentEntryObj, List<String> messageList) {
        String specificEvaluator = contentEntryObj.getString("specificevaluator");
        String evalMainBody = contentEntryObj.getString("evalmainbody");
        String anonMode = contentEntryObj.getString("anonmode");
        if ("10".equals(specificEvaluator)) {
            DynamicObjectCollection evalAnonColl = contentEntryObj.getDynamicObjectCollection("evaluatoranonsubentry");
            if ("20".equals(anonMode) && "10".equals(evalMainBody) && CollectionUtils.isEmpty((Collection)evalAnonColl)) {
                EvalTaskAnonymousReviewerCheckHelper.addEvalMainBodyMsg(messageList);
            }
            if ("10".equals(anonMode) && "20".equals(evalMainBody)) {
                if (CollectionUtils.isEmpty((Collection)evalAnonColl)) {
                    EvalTaskAnonymousReviewerCheckHelper.addAccountInfo(messageList);
                } else {
                    int evaluatorNumMax = contentEntryObj.getInt("evaluatornummax");
                    if (evaluatorNumMax != evalAnonColl.size()) {
                        messageList.add(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u7684\u8d26\u53f7\u603b\u6570\u4e0e\u8bc4\u4ef7\u8005\u4eba\u6570\u4e0a\u9650\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8d26\u53f7\u6216\u8c03\u6574\u8bc4\u4ef7\u8005\u4eba\u6570\u4e0a\u9650\u3002", (String)"EvalTaskAnonymousReviewerCheckHelper_3", (String)"hrmp-bes-business", (Object[])new Object[0]));
                    }
                }
            }
            if ("10".equals(anonMode) && "10".equals(evalMainBody) && CollectionUtils.isEmpty((Collection)evalAnonColl)) {
                EvalTaskAnonymousReviewerCheckHelper.addEvalMainBodyMsg(messageList);
            }
            EvalTaskAnonymousReviewerCheckHelper.accountPasswordValidate(contentEntryObj, messageList, anonMode, evalAnonColl);
        }
    }

    private static void accountPasswordValidate(DynamicObject contentEntryObj, List<String> messageList, String anonMode, DynamicObjectCollection evalAnonColl) {
        if (messageList.size() != 0) {
            return;
        }
        if ("10".equals(anonMode) && CollectionUtils.isNotEmpty((Collection)evalAnonColl)) {
            boolean accountMatch = EvalTaskAnonymousReviewerCheckHelper.validateAccount(contentEntryObj, evalAnonColl);
            boolean pwdMatch = EvalTaskAnonymousReviewerCheckHelper.validatePassword(contentEntryObj, evalAnonColl);
            if (!accountMatch || !pwdMatch) {
                messageList.add(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u7684\u8d26\u53f7(\u5bc6\u7801)\u4e0e\u8d26\u53f7(\u5bc6\u7801)\u751f\u6210\u65b9\u5f0f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8d26\u53f7\u6216\u8c03\u6574\u8d26\u53f7(\u5bc6\u7801)\u751f\u6210\u65b9\u5f0f\u3002", (String)"EvalTaskAnonymousReviewerCheckHelper_6", (String)"hrmp-bes-business", (Object[])new Object[0]));
            }
        }
    }

    private static boolean validateAccount(DynamicObject contentEntryObj, DynamicObjectCollection evalAnonColl) {
        String accountAnon = ((DynamicObject)evalAnonColl.get(0)).getString("accountanon");
        String accountLetter = contentEntryObj.getString("accountletter");
        int accountNumDigit = contentEntryObj.getInt("accountnumdigit");
        String regex = accountLetter + "\\d{" + accountNumDigit + "}";
        return EvalTaskAnonymousReviewerCheckHelper.isMatch(accountAnon, regex);
    }

    private static boolean validatePassword(DynamicObject contentEntryObj, DynamicObjectCollection evalAnonColl) {
        String passwordAnon = ((DynamicObject)evalAnonColl.get(0)).getString("passwordanon");
        String pwdLetter = contentEntryObj.getString("pwdletter");
        String pwdSpecialSymbol = contentEntryObj.getString("pwdspecialsymbol");
        if (StringUtils.isNotBlank((CharSequence)pwdSpecialSymbol)) {
            pwdSpecialSymbol = "\\" + pwdSpecialSymbol;
        }
        int pwdNumDigit = contentEntryObj.getInt("pwdnumdigit");
        String regex = pwdLetter + pwdSpecialSymbol + "\\d{" + pwdNumDigit + "}";
        return EvalTaskAnonymousReviewerCheckHelper.isMatch(passwordAnon, regex);
    }

    private static boolean isMatch(String matchVal, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(matchVal);
        return matcher.matches();
    }

    private static void addEvalMainBodyMsg(List<String> messageList) {
        messageList.add(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u8bc4\u4ef7\u4e3b\u4f53\u3002", (String)"EvalTaskAnonymousReviewerCheckHelper_1", (String)"hrmp-bes-business", (Object[])new Object[0]));
    }

    private static void addAccountInfo(List<String> messageList) {
        messageList.add(ResManager.loadKDString((String)"\u8bf7\u751f\u6210\u8d26\u53f7\u4fe1\u606f\u3002", (String)"EvalTaskAnonymousReviewerCheckHelper_2", (String)"hrmp-bes-business", (Object[])new Object[0]));
    }

    private static void validateFieldMustInput(DynamicObject contentEntryObj, List<String> messageList) {
        int evaluatorNumMax;
        ArrayList fields = Lists.newArrayList();
        String specificEval = contentEntryObj.getString("specificevaluator");
        String evalMainBody = contentEntryObj.getString("evalmainbody");
        if ("10".equals(specificEval) && "20".equals(evalMainBody) && (evaluatorNumMax = contentEntryObj.getInt("evaluatornummax")) == 0) {
            fields.add(ResManager.loadKDString((String)"\u8bc4\u4ef7\u8005\u4eba\u6570\u4e0a\u9650", (String)"EvalTaskAnonymousReviewerCheckHelper_5", (String)"hrmp-bes-business", (Object[])new Object[0]));
        }
        if (CollectionUtils.isNotEmpty((Collection)fields)) {
            String res = EvalTaskAnonymousReviewerCheckHelper.getSplicingResults(fields);
            messageList.add(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199%s\u3002", (String)"EvalTaskAnonymousReviewerCheckHelper_0", (String)"hrmp-bes-business", (Object[])new Object[0]), res));
        }
    }

    public static String getSplicingResults(List<String> strList) {
        return strList.stream().map(str -> "\u201c" + str + "\u201d").collect(Collectors.joining("\u3001"));
    }
}

