/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.checkservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.bes.common.dto.CheckValidateMsg;
import org.apache.commons.collections4.CollectionUtils;

public class EvalTaskEvaluatorRealCheckHelper {
    private static final String EVALEDOBJTYPE_PER = "10";
    private static final String EVALEDOBJTYPE_ORG = "20";
    private static final String SPECIFICEVALUATOR_YES = "10";

    public static CheckValidateMsg evaluatorSaveCheck(DynamicObject entity) {
        CheckValidateMsg checkValidateMsg = new CheckValidateMsg();
        checkValidateMsg.setPass(Boolean.valueOf(true));
        DynamicObjectCollection contentEntry = entity.getDynamicObjectCollection("contententryentity");
        ArrayList<String> msgList = new ArrayList<String>(10);
        for (DynamicObject content : contentEntry) {
            ArrayList<String> fields = new ArrayList<String>(10);
            if (HRStringUtils.equals((String)"10", (String)content.getString("specificevaluator"))) {
                DynamicObjectCollection objInfoSubEntry = new DynamicObjectCollection();
                String nameId = "";
                String evaledObjType = content.getString("evaledobjtype");
                if (HRStringUtils.equals((String)evaledObjType, (String)"10")) {
                    objInfoSubEntry = content.getDynamicObjectCollection("objinfopersubentry");
                    nameId = "pername";
                } else if (HRStringUtils.equals((String)evaledObjType, (String)EVALEDOBJTYPE_ORG)) {
                    objInfoSubEntry = content.getDynamicObjectCollection("objinfoorgsubentry");
                    nameId = "orgname";
                }
                Map evaledObjMap = objInfoSubEntry.stream().collect(Collectors.toMap(obj -> obj.getLong("id"), Function.identity()));
                DynamicObjectCollection evaluatorRealSubEntry = content.getDynamicObjectCollection("evaluatorrealsubentry");
                String finalNameId = nameId;
                evaluatorRealSubEntry.forEach(evaluator -> {
                    if (CollectionUtils.isEmpty((Collection)evaluator.getDynamicObjectCollection("inevaluator")) && HRStringUtils.isEmpty((String)evaluator.getString("outevaluator_tag"))) {
                        DynamicObject evaledObj = (DynamicObject)evaledObjMap.get(evaluator.getLong("evaledobj"));
                        if (Objects.nonNull(evaluator.get("evalbody"))) {
                            fields.add(evaledObj.getString(finalNameId) + "_" + evaluator.getString("evalbody.name"));
                        } else {
                            fields.add(evaledObj.getString(finalNameId));
                        }
                    }
                });
            }
            if (!CollectionUtils.isNotEmpty(fields)) continue;
            String res = EvalTaskEvaluatorRealCheckHelper.getSplicingResults(fields);
            msgList.add(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u8bf7\u4e3a%2$s\u8bbe\u7f6e\u8bc4\u4ef7\u8005\u6570\u636e\u3002", (String)"AdjustEvalRelationCheckHelper_0", (String)"hrmp-bes-business", (Object[])new Object[0]), content.getString("contentname"), res));
        }
        if (CollectionUtils.isNotEmpty(msgList)) {
            checkValidateMsg.setPass(Boolean.valueOf(false));
            checkValidateMsg.setNoteType(msgList.size() == 1 ? 0 : 1);
            checkValidateMsg.setMsgList(msgList);
        }
        return checkValidateMsg;
    }

    private static String getSplicingResults(List<String> strList) {
        return strList.stream().map(str -> "\u201c" + str + "\u201d").collect(Collectors.joining("\u3001"));
    }

    public static CheckValidateMsg outEvaluatorSaveValid(DynamicObject dataEntity) {
        CheckValidateMsg checkValidateMsg = new CheckValidateMsg();
        checkValidateMsg.setPass(Boolean.valueOf(true));
        DynamicObjectCollection contentEntry = dataEntity.getDynamicObjectCollection("contententryentity");
        ArrayList<String> msgList = new ArrayList<String>(10);
        for (DynamicObject content : contentEntry) {
            if (!HRStringUtils.equals((String)"10", (String)content.getString("specificevaluator")) || !HRStringUtils.equals((String)"10", (String)content.getString("setouterevaluator")) || !content.getDynamicObjectCollection("realoutsidersubentry").isEmpty()) continue;
            msgList.add(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u8bf7\u8bbe\u7f6e\u5916\u90e8\u8bc4\u4ef7\u8005\uff0c\u6216\u5207\u6362\u5916\u90e8\u8bc4\u4ef7\u8005\u4e3a\u4e0d\u9700\u8981\u3002", (String)"AdjustEvalRelationCheckHelper_1", (String)"hrmp-bes-business", (Object[])new Object[0]), content.getString("contentname")));
        }
        if (CollectionUtils.isNotEmpty(msgList)) {
            checkValidateMsg.setPass(Boolean.valueOf(false));
            checkValidateMsg.setNoteType(msgList.size() == 1 ? 0 : 1);
            checkValidateMsg.setMsgList(msgList);
        }
        return checkValidateMsg;
    }
}

