/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.checkservice;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class EvaluatorValHelper {
    private static Log LOG = LogFactory.getLog(EvaluatorValHelper.class);
    private static final HRBaseServiceHelper HRPI_PERCONTACT = HRBaseServiceHelper.create((String)"hrpi_percontact");
    private static final HRBaseServiceHelper HBSS_LABRELSTATUSCLS = HRBaseServiceHelper.create((String)"hbss_labrelstatuscls");
    private static final HRBaseServiceHelper HRPI_EMPENTREL = HRBaseServiceHelper.create((String)"hrpi_empentrel");
    private static final List<String> TELEPHONE_LIST = new ArrayList<String>();
    private static final List<String> EMAILL_LIST = new ArrayList<String>();
    private static final String SPECIFICEVALUATOR_YES = "10";

    public static void validEvaluatorScope(DynamicObject entity, List<String> messageList) {
        String specificEval = entity.getString("specificevaluator");
        String setOutEval = entity.getString("setouterevaluator");
        if (HRStringUtils.equals((String)SPECIFICEVALUATOR_YES, (String)specificEval)) {
            String evalMain = entity.getString("evalmainbody");
            DynamicObjectCollection innerEvaluatorCol = entity.getDynamicObjectCollection("evaluatorscope");
            int anonOutColSize = entity.getDynamicObjectCollection("anonoutsidersubentry").size();
            if (innerEvaluatorCol.size() + anonOutColSize == 0) {
                return;
            }
            int sum = 0;
            if (HRStringUtils.equals((String)"20", (String)evalMain)) {
                int number = entity.getInt("evaluatornummax");
                if (HRStringUtils.equals((String)setOutEval, (String)SPECIFICEVALUATOR_YES)) {
                    sum += entity.getDynamicObjectCollection("anonoutsidersubentry").size();
                }
                if (!innerEvaluatorCol.isEmpty()) {
                    sum += innerEvaluatorCol.size();
                }
                if (sum != number) {
                    messageList.add(ResManager.loadKDString((String)"\u8bc4\u4ef7\u8005\u8303\u56f4\u603b\u6570\u4e0e\u4eba\u6570\u4e0a\u9650\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8c03\u6574\u8bc4\u4ef7\u8005\u8303\u56f4\u6216\u4eba\u6570\u4e0a\u9650\u3002", (String)"EvaluatorValHelper_10", (String)"hrmp-bes-business", (Object[])new Object[0]));
                    return;
                }
            }
            if (HRStringUtils.equals((String)SPECIFICEVALUATOR_YES, (String)evalMain)) {
                if (HRStringUtils.equals((String)setOutEval, (String)SPECIFICEVALUATOR_YES)) {
                    sum += entity.getDynamicObjectCollection("anonoutsidersubentry").size();
                }
                if (!innerEvaluatorCol.isEmpty()) {
                    sum += innerEvaluatorCol.size();
                }
                DynamicObjectCollection anonObjectCol = entity.getDynamicObjectCollection("evaluatoranonsubentry");
                int anonObjectCount = 0;
                if (!anonObjectCol.isEmpty()) {
                    HashMap evalBodyMaps = Maps.newHashMapWithExpectedSize((int)10);
                    for (DynamicObject anonObject : anonObjectCol) {
                        evalBodyMaps.put(anonObject.getString("evalbodynameanon"), anonObject.getInt("participantnumber"));
                    }
                    for (Map.Entry evalBodyMap : evalBodyMaps.entrySet()) {
                        int anonObjectInt = (Integer)evalBodyMap.getValue();
                        anonObjectCount += anonObjectInt;
                    }
                }
                if (sum != anonObjectCount) {
                    messageList.add(ResManager.loadKDString((String)"\u8bc4\u4ef7\u8005\u8303\u56f4\u603b\u6570\u4e0e\u5404\u8bc4\u4ef7\u4e3b\u4f53\u53c2\u4e0e\u4eba\u6570\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8c03\u6574\u8bc4\u4ef7\u8005\u8303\u56f4\u6216\u5404\u8bc4\u4ef7\u4e3b\u4f53\u53c2\u4e0e\u4eba\u6570\u3002", (String)"EvaluatorValHelper_9", (String)"hrmp-bes-business", (Object[])new Object[0]));
                    return;
                }
            }
        }
    }

    public static void validOuterEntry(DynamicObject entity, List<String> messageList) {
        String specificEval = entity.getString("specificevaluator");
        String setOutEval = entity.getString("setouterevaluator");
        if (HRStringUtils.equals((String)SPECIFICEVALUATOR_YES, (String)specificEval) && HRStringUtils.equals((String)setOutEval, (String)SPECIFICEVALUATOR_YES)) {
            DynamicObjectCollection outerEntry = entity.getDynamicObjectCollection("anonoutsidersubentry");
            if (CollectionUtils.isEmpty((Collection)outerEntry)) {
                messageList.add(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5916\u90e8\u8bc4\u4ef7\u8005\u8303\u56f4\u3002", (String)"EvaluatorValHelper_0", (String)"hrmp-bes-business", (Object[])new Object[0]));
                return;
            }
            if (!EvaluatorValHelper.validInfoIsEmpty(outerEntry, messageList).booleanValue()) {
                return;
            }
            EvaluatorValHelper.validTeleAndEmail(outerEntry, messageList);
        }
    }

    private static Boolean validInfoIsEmpty(DynamicObjectCollection outerEntry, List<String> messageList) {
        HashSet errorInfo = Sets.newHashSetWithExpectedSize((int)10);
        for (DynamicObject outerDy : outerEntry) {
            if (HRStringUtils.isEmpty((String)outerDy.getString("evaloroutnameanon"))) {
                errorInfo.add(ResManager.loadKDString((String)"\u201c\u59d3\u540d\u201d", (String)"EvaluatorValHelper_1", (String)"hrmp-bes-business", (Object[])new Object[0]));
            }
            if (HRStringUtils.isEmpty((String)outerDy.getString("evalorouttelanon"))) {
                errorInfo.add(ResManager.loadKDString((String)"\u201d\u624b\u673a\u53f7\u7801\u201c", (String)"EvaluatorValHelper_2", (String)"hrmp-bes-business", (Object[])new Object[0]));
            }
            if (!HRStringUtils.isEmpty((String)outerDy.getString("evaloroutcompanyanon"))) continue;
            errorInfo.add(ResManager.loadKDString((String)"\u201c\u516c\u53f8\u201d", (String)"EvaluatorValHelper_3", (String)"hrmp-bes-business", (Object[])new Object[0]));
        }
        if (!errorInfo.isEmpty()) {
            String errorMsg = String.join((CharSequence)"\u3001", errorInfo.toArray(new String[0]));
            messageList.add(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199%s\u3002", (String)"EvaluatorValHelper_4", (String)"hrmp-bes-business", (Object[])new Object[0]), errorMsg));
            LOG.info("EvaluatorValHelper validOuterEntry validInfoIsEmpty :{}", (Object)((Object)errorInfo).toString());
            return false;
        }
        return true;
    }

    public static void validTeleAndEmail(DynamicObjectCollection outerEntry, List<String> messageList) {
        HashSet<String> outPerTele = new HashSet<String>(10);
        HashSet<String> outPerEmail = new HashSet<String>(10);
        StringJoiner stringJoiner = new StringJoiner("\r\n");
        for (DynamicObject outPerson : outerEntry) {
            boolean isExistEmail;
            String email;
            boolean isExistTele;
            Long initEmpentrelId = 0L;
            String telephone = outPerson.getString("evalorouttelanon");
            if (!telephone.isEmpty() && (initEmpentrelId = EvaluatorValHelper.existInnerPerson(telephone, initEmpentrelId)) != 0L) {
                String message = ResManager.loadKDString((String)"\u624b\u673a\u53f7%s\u5728\u5185\u90e8\u4eba\u5458\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u3002", (String)"EvaluatorValHelper_5", (String)"hrmp-bes-business", (Object[])new Object[]{telephone});
                EvaluatorValHelper.handleTip(stringJoiner, message);
            }
            if (!(isExistTele = outPerTele.add(telephone))) {
                String message = ResManager.loadKDString((String)"\u624b\u673a\u53f7%s\u5728\u5916\u90e8\u8bc4\u4ef7\u8005\u4e2d\u5df2\u5b58\u5728\u3002", (String)"EvaluatorValHelper_8", (String)"hrmp-bes-business", (Object[])new Object[]{telephone});
                EvaluatorValHelper.handleTip(stringJoiner, message);
            }
            if ((email = outPerson.getString("evaloroutemailanon")).isEmpty() || (isExistEmail = outPerEmail.add(email))) continue;
            String message = ResManager.loadKDString((String)"\u90ae\u7bb1%s\u5728\u5916\u90e8\u8bc4\u4ef7\u8005\u4e2d\u5df2\u5b58\u5728\u3002", (String)"EvaluatorValHelper_7", (String)"hrmp-bes-business", (Object[])new Object[]{email});
            EvaluatorValHelper.handleTip(stringJoiner, message);
        }
        if (!stringJoiner.toString().isEmpty()) {
            String[] tipMessages = stringJoiner.toString().split("\r\n");
            if (tipMessages.length == 1) {
                messageList.add(stringJoiner.toString());
                return;
            }
            for (String tipMessage : tipMessages) {
                messageList.add(tipMessage);
            }
            return;
        }
        TELEPHONE_LIST.clear();
        EMAILL_LIST.clear();
    }

    private static void validatorEmailEqual(String email, DynamicObject outPerson, StringJoiner stringJoiner, DynamicObjectCollection realOutSiderSubentry) {
        if (email.isEmpty()) {
            return;
        }
        for (DynamicObject dynamicObject : realOutSiderSubentry) {
            if (!dynamicObject.getString("evaloroutemailanon").equals(email) || outPerson.getString("evaloroutnameanon").equals(dynamicObject.getString("evaloroutnameanon")) && outPerson.getString("evaloroutcompanyanon").equals(dynamicObject.getString("evaloroutcompanyanon")) && outPerson.getString("evalorouttelanon").equals(dynamicObject.getString("evalorouttelanon")) && outPerson.getString("evaloroutadminorganon").equals(dynamicObject.getString("evaloroutadminorganon")) && outPerson.getString("evaloroutposanon").equals(dynamicObject.getString("evaloroutposanon")) && outPerson.getString("evaloroutstdposanon").equals(dynamicObject.getString("evaloroutstdposanon")) && outPerson.getString("evaloroutjobanon").equals(dynamicObject.getString("evaloroutjobanon"))) continue;
            if (EMAILL_LIST.contains(email)) {
                return;
            }
            EMAILL_LIST.add(email);
            String message = ResManager.loadKDString((String)"\u90ae\u7bb1%s\u5728\u5916\u90e8\u8bc4\u4ef7\u8005\u4e2d\u5df2\u5b58\u5728\u3002", (String)"EvaluatorValHelper_7", (String)"hrmp-bes-business", (Object[])new Object[]{email});
            stringJoiner.add(message);
        }
    }

    private static void validatorTeleEqual(String telephone, DynamicObject outPerson, StringJoiner stringJoiner, DynamicObjectCollection realOutSiderSubentry) {
        for (DynamicObject dynamicObject : realOutSiderSubentry) {
            if (!dynamicObject.getString("evalorouttelanon").equals(telephone) || outPerson.getString("evaloroutnameanon").equals(dynamicObject.getString("evaloroutnameanon")) && outPerson.getString("evaloroutcompanyanon").equals(dynamicObject.getString("evaloroutcompanyanon")) && outPerson.getString("evaloroutemailanon").equals(dynamicObject.getString("evaloroutemailanon")) && outPerson.getString("evaloroutadminorganon").equals(dynamicObject.getString("evaloroutadminorganon")) && outPerson.getString("evaloroutposanon").equals(dynamicObject.getString("evaloroutposanon")) && outPerson.getString("evaloroutstdposanon").equals(dynamicObject.getString("evaloroutstdposanon")) && outPerson.getString("evaloroutjobanon").equals(dynamicObject.getString("evaloroutjobanon"))) continue;
            if (TELEPHONE_LIST.contains(telephone)) {
                return;
            }
            TELEPHONE_LIST.add(telephone);
            String message = ResManager.loadKDString((String)"\u624b\u673a\u53f7%s\u5728\u5916\u90e8\u8bc4\u4ef7\u8005\u4e2d\u5df2\u5b58\u5728\u3002", (String)"EvaluatorValHelper_8", (String)"hrmp-bes-business", (Object[])new Object[]{telephone});
            stringJoiner.add(message);
        }
    }

    public static Long existInnerPerson(String phone, Long flag) {
        ImmutableMap maps = ImmutableMap.of((Object)"phone", (Object)phone, (Object)"fuzzyFlag", (Object)false);
        try {
            HashMap empentrelMap;
            Object labrelstatuscls;
            DynamicObject labrelStatuScls;
            Long labStatusPrd;
            List list;
            Map hrpiEmpentrel;
            Map data = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonInfoFuzzy", (Object[])new Object[]{maps});
            if (!data.isEmpty() && ((Boolean)data.get("success")).booleanValue() && (hrpiEmpentrel = (list = (List)data.get("data")).stream().filter(rs -> rs.containsKey("hrpi_empentrel")).findFirst().orElseGet(() -> Maps.newHashMapWithExpectedSize((int)8))).containsKey("hrpi_empentrel") && (labStatusPrd = Long.valueOf((labrelStatuScls = HBSS_LABRELSTATUSCLS.queryOne("labrelstatusprd.id", new QFilter("id", "=", labrelstatuscls = (empentrelMap = (HashMap)hrpiEmpentrel.get("hrpi_empentrel")).get("laborrelstatus_labrelstatuscls_id")))).getLong("labrelstatusprd.id"))).equals(1010L)) {
                flag = (Long)empentrelMap.get("id");
            }
        }
        catch (Exception exception) {
            LOG.error("EvaluatorValHelper validTeleAndEmail existInnerPerson error: ", (Throwable)exception);
        }
        return flag;
    }

    private static void handleTip(StringJoiner stringJoiner, String message) {
        String[] tipMessageSet = stringJoiner.toString().trim().split("\r\n");
        List<String> tipMessageList = Arrays.asList(tipMessageSet);
        if (!tipMessageList.contains(message)) {
            stringJoiner.add(message);
        }
    }

    public static boolean existEmailPerson(String email, Long initEmpentrelId) {
        boolean flag = false;
        try {
            DynamicObject empentrelDy;
            QFilter personQFilter;
            DynamicObject percontact;
            if (initEmpentrelId != 0L && HRStringUtils.equals((String)(percontact = HRPI_PERCONTACT.queryOriginalOne("peremail,busemail", (personQFilter = new QFilter("person", "=", (Object)(empentrelDy = HRPI_EMPENTREL.queryOriginalOne("person", new QFilter("id", "=", (Object)initEmpentrelId))).getLong("person"))).toArray())).getString("busemail"), (String)email)) {
                flag = true;
            }
        }
        catch (Exception exception) {
            LOG.error("EvaluatorValHelper validTeleAndEmail existEmailPerson error: ", (Throwable)exception);
        }
        return flag;
    }
}

