/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.checkservice;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.bes.common.dto.CheckValidateMsg;
import kd.hrmp.bes.common.fun.KdBiFunction;

public class IndicatorCheckHelper {
    private static Log LOG = LogFactory.getLog(IndicatorCheckHelper.class);

    private static String getFieldWeight() {
        return ResManager.loadKDString((String)"\u201c\u6307\u6807\u6743\u91cd\u201d", (String)"IndicatorCheckHelper_0", (String)"hrmp-bes-business", (Object[])new Object[0]);
    }

    private static String getFieldMax() {
        return ResManager.loadKDString((String)"\u201c\u6700\u5927\u503c\u201d", (String)"IndicatorCheckHelper_1", (String)"hrmp-bes-business", (Object[])new Object[0]);
    }

    private static String getFieldMin() {
        return ResManager.loadKDString((String)"\u201c\u6700\u5c0f\u503c\u201d", (String)"IndicatorCheckHelper_2", (String)"hrmp-bes-business", (Object[])new Object[0]);
    }

    private static String getFieldScore() {
        return ResManager.loadKDString((String)"\u201c\u9009\u9879\u5206\u503c\u201d", (String)"IndicatorCheckHelper_3", (String)"hrmp-bes-business", (Object[])new Object[0]);
    }

    private static String getFieldIndicator() {
        return ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u6d4b\u8bc4\u6307\u6807\u201c%1$s\u201d\u7684%2$s\u3002", (String)"IndicatorCheckHelper_4", (String)"hrmp-bes-business", (Object[])new Object[0]);
    }

    private static String getFieldLegal() {
        return ResManager.loadKDString((String)"\u6d4b\u8bc4\u6307\u6807\u201c%1$s\u201d\u7684%2$s\u3002", (String)"IndicatorCheckHelper_6", (String)"hrmp-bes-business", (Object[])new Object[0]);
    }

    private static String getFieldMaxMin() {
        return ResManager.loadKDString((String)"\u201c\u6700\u5927\u503c\u201d\u5fc5\u987b\u5927\u4e8e\u201c\u6700\u5c0f\u503c\u201d", (String)"IndicatorCheckHelper_7", (String)"hrmp-bes-business", (Object[])new Object[0]);
    }

    private static String getFieldBelowHigh() {
        return ResManager.loadKDString((String)"\u201c\u9700\u8981\u539f\u56e0\uff08\u5206\u503c\u9ad8\u4e8e\uff09\u201d\u5fc5\u987b\u5927\u4e8e\u201c\u9700\u8981\u539f\u56e0\uff08\u5206\u503c\u4f4e\u4e8e\uff09\u201d", (String)"IndicatorCheckHelper_8", (String)"hrmp-bes-business", (Object[])new Object[0]);
    }

    public static CheckValidateMsg scoreIndicatorSetSaveCheck(DynamicObject entity) {
        CheckValidateMsg msg = new CheckValidateMsg();
        try {
            IndicatorCheckHelper.checkIndicator(entity, msg);
            LOG.info("scoreIndicatorSetSaveCheck msg: {}", (Object)msg);
            return msg;
        }
        catch (Exception exception) {
            LOG.error("scoreIndicatorSetSaveCheck error: ", (Throwable)exception);
            msg.setPass(Boolean.FALSE);
            msg.getMsgList().add("data error");
            return msg;
        }
    }

    private static void checkIndicator(DynamicObject entity, CheckValidateMsg msg) {
        if (!msg.getPass().booleanValue()) {
            return;
        }
        DynamicObjectCollection indicatorEntryEntity = entity.getDynamicObjectCollection("indicatorentryentity");
        if (indicatorEntryEntity != null && indicatorEntryEntity.size() > 0) {
            int accuracy;
            LOG.info("checkIndicator begin indicatorEntryEntity size: {}", (Object)indicatorEntryEntity.size());
            List<DynamicObject> overAllScoreList = indicatorEntryEntity.stream().filter(entry -> "2".equals(entry.getString("areacode")) && HRStringUtils.equals((String)"C", (String)entry.getString("indicatortype")) && !HRStringUtils.equals((String)"2", (String)entry.getString("indicatorclassify"))).collect(Collectors.toList());
            List<DynamicObject> scoreList = indicatorEntryEntity.stream().filter(entry -> "0".equals(entry.getString("areacode"))).collect(Collectors.toList());
            List<DynamicObject> numberList = scoreList.stream().filter(dy -> HRStringUtils.equals((String)"C", (String)dy.getString("indicatortype"))).collect(Collectors.toList());
            List<DynamicObject> selectList = scoreList.stream().filter(dy -> HRStringUtils.equals((String)"A", (String)dy.getString("indicatortype"))).collect(Collectors.toList());
            DynamicObjectCollection optEntryEntity = entity.getDynamicObjectCollection("optentryentity");
            Map<Long, List<DynamicObject>> indicatorToOption = new HashMap<Long, List<DynamicObject>>(16);
            String method = entity.getString("calcmethod");
            if (numberList.size() > 0) {
                LOG.info("checkIndicator numberList size: {}", (Object)numberList.size());
                IndicatorCheckHelper.checkNumberIndicatorMustInput(numberList, msg, method);
            }
            if (selectList.size() > 0) {
                if (optEntryEntity != null && optEntryEntity.size() > 0) {
                    indicatorToOption = optEntryEntity.stream().collect(Collectors.groupingBy(dy -> dy.getLong("indicator")));
                }
                LOG.info("checkIndicator selectList size: {}", (Object)selectList.size());
                IndicatorCheckHelper.checkSelectIndicatorMustInput(selectList, msg, indicatorToOption, method);
            }
            if (overAllScoreList.size() > 0) {
                LOG.info("checkIndicator numberList size: {}", (Object)overAllScoreList.size());
                IndicatorCheckHelper.checkOverAllNumberIndicatorMustInput(overAllScoreList, msg);
            }
            if (!msg.getPass().booleanValue()) {
                int size = msg.getMsgList().size();
                String message = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6709%s\u4e2a\u6d4b\u8bc4\u6307\u6807\u7684\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u8bf7\u5148\u6309\u8981\u6c42\u586b\u5199\u76f8\u5173\u4fe1\u606f\u3002", (String)"IndicatorCheckHelper_5", (String)"hrmp-bes-business", (Object[])new Object[0]), size);
                msg.getMsgList().add(message);
                return;
            }
            IndicatorCheckHelper.checkSelectIndicatorLegal(selectList, indicatorToOption, msg);
            if (numberList.size() > 0) {
                accuracy = entity.getInt("scoreaccuracy");
                IndicatorCheckHelper.checkNumberIndicatorLegal(numberList, msg, accuracy);
            }
            if (overAllScoreList.size() > 0) {
                accuracy = entity.getInt("scoreaccuracy");
                IndicatorCheckHelper.checkNumberIndicatorLegal(overAllScoreList, msg, accuracy);
            }
            if (!msg.getPass().booleanValue()) {
                int size = msg.getMsgList().size();
                String message = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6709%s\u4e2a\u6d4b\u8bc4\u6307\u6807\u7684\u4fe1\u606f\u586b\u5199\u4e0d\u5408\u89c4\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"IndicatorCheckHelper_12", (String)"hrmp-bes-business", (Object[])new Object[0]), size);
                msg.getMsgList().add(message);
                return;
            }
            if (!HRStringUtils.equals((String)"2", (String)method)) {
                IndicatorCheckHelper.checkScoreWight(scoreList, msg);
            }
            if (!msg.getPass().booleanValue()) {
                return;
            }
            IndicatorCheckHelper.checkScore(numberList, selectList, indicatorToOption, msg, entity);
        }
    }

    private static void checkSelectIndicatorLegal(List<DynamicObject> selectList, Map<Long, List<DynamicObject>> indicatorToOption, CheckValidateMsg msg) {
        if (selectList != null && selectList.size() > 0) {
            for (DynamicObject dy : selectList) {
                long count;
                List<DynamicObject> options = indicatorToOption.get(dy.getLong("id"));
                if (options == null || options.size() <= 0 || (count = options.stream().collect(Collectors.groupingBy(option -> option.getBigDecimal("optscore"), Collectors.counting())).values().stream().filter(size -> size > 1L).count()) <= 0L) continue;
                String message = String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4\u6307\u6807\u201c%s\u201c\u7684\u6240\u6709\u9009\u9879\u5206\u503c\u4e0d\u80fd\u76f8\u540c\u3002", (String)"IndicatorCheckHelper_16", (String)"hrmp-bes-business", (Object[])new Object[0]), dy.getString("indicatorname"));
                msg.setPass(Boolean.FALSE);
                msg.setNoteType(1);
                msg.getMsgList().add(message);
            }
        }
    }

    private static void checkScore(List<DynamicObject> numberList, List<DynamicObject> selectList, Map<Long, List<DynamicObject>> indicatorToOption, CheckValidateMsg msg, DynamicObject entity) {
        String message;
        int score = entity.getInt("score");
        if (score == 0) {
            return;
        }
        double sum = 0.0;
        String method = entity.getString("calcmethod");
        if (numberList != null && numberList.size() > 0) {
            if (HRStringUtils.equals((String)"2", (String)method)) {
                for (DynamicObject dy : numberList) {
                    BigDecimal maximum = dy.getBigDecimal("maximum");
                    sum += maximum.doubleValue();
                }
            } else {
                for (DynamicObject dy : numberList) {
                    int weight = dy.getInt("weight");
                    BigDecimal maximum = dy.getBigDecimal("maximum");
                    sum += (double)weight * maximum.doubleValue() / 100.0;
                }
            }
        }
        if (selectList != null && selectList.size() > 0 && indicatorToOption != null && indicatorToOption.size() > 0) {
            List<DynamicObject> options;
            if (HRStringUtils.equals((String)"2", (String)method)) {
                for (DynamicObject dy : selectList) {
                    options = indicatorToOption.get(dy.getLong("id"));
                    if (options == null || options.size() <= 0) continue;
                    double optScore = options.stream().mapToDouble(option -> option.getBigDecimal("optscore").doubleValue()).max().getAsDouble();
                    sum += optScore;
                }
            } else {
                for (DynamicObject dy : selectList) {
                    options = indicatorToOption.get(dy.getLong("id"));
                    if (options == null || options.size() <= 0) continue;
                    double optScore = options.stream().mapToDouble(option -> option.getBigDecimal("optscore").doubleValue()).max().getAsDouble();
                    int weight = dy.getInt("weight");
                    sum += (double)weight * optScore / 100.0;
                }
            }
        }
        if (sum == 0.0) {
            return;
        }
        String carryType = entity.getString("carrytype");
        int total = 0;
        total = HRStringUtils.equals((String)"20", (String)carryType) ? (int)Math.ceil(sum) : (HRStringUtils.equals((String)"30", (String)carryType) ? (int)Math.floor(sum) : (int)Math.round(sum));
        LOG.info("checkScore score: {}, sum: {}", (Object)score, (Object)sum);
        if (total > score) {
            msg.setPass(Boolean.FALSE);
            msg.setNoteType(2);
            message = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u603b\u5206%1$s, \u8d85\u8fc7\u4e86\u603b\u5206%2$s\uff0c\u662f\u5426\u786e\u5b9a\uff1f", (String)"IndicatorCheckHelper_14", (String)"hrmp-bes-business", (Object[])new Object[0]), total, score);
            msg.getMsgList().add(message);
        } else if (total < score) {
            msg.setPass(Boolean.FALSE);
            msg.setNoteType(2);
            message = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u603b\u5206%1$s, \u4e0d\u6ee1\u8db3\u603b\u5206%2$s\uff0c\u662f\u5426\u4fee\u6539\u603b\u5206\u4e3a%3$s\uff1f", (String)"IndicatorCheckHelper_15", (String)"hrmp-bes-business", (Object[])new Object[0]), total, score, total);
            msg.getMsgList().add(message);
            HashMap<String, Integer> map = new HashMap<String, Integer>(16);
            map.put("score", total);
            msg.setCallBackFunParam(map);
            KdBiFunction & Serializable biFunction = (KdBiFunction & Serializable)(dynamicObject, callBackFunParam) -> {
                Object newScore = callBackFunParam.get("score");
                if (newScore != null) {
                    dynamicObject.set("score", callBackFunParam.get("score"));
                    IndicatorCheckHelper.setScoreIndicator(dynamicObject, callBackFunParam.get("score"));
                }
                return dynamicObject;
            };
            msg.setCallBackFun((KdBiFunction)biFunction);
        }
    }

    private static void setScoreIndicator(DynamicObject dynamicObject, Object score) {
        Optional<DynamicObject> overAllScore;
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("indicatorentryentity");
        DynamicObject scoreIndicator = IndicatorCheckHelper.getScoreDy(entryEntity, overAllScore = entryEntity.stream().filter(entry -> "2".equals(entry.getString("areacode")) && HRStringUtils.equals((String)"C", (String)entry.getString("indicatortype")) && HRStringUtils.equals((String)"2", (String)entry.getString("indicatorclassify"))).findFirst());
        if (Objects.nonNull(scoreIndicator)) {
            scoreIndicator.set("maximum", score);
        }
    }

    public static DynamicObject getScoreDy(DynamicObjectCollection entryEntity, Optional<DynamicObject> overAllScore) {
        for (int index = 0; index < entryEntity.size(); ++index) {
            Long contentId = ((DynamicObject)entryEntity.get(index)).getLong("id");
            if (!contentId.equals(overAllScore.get().getLong("id"))) continue;
            return (DynamicObject)entryEntity.get(index);
        }
        return new DynamicObject();
    }

    private static void checkScoreWight(List<DynamicObject> scoreList, CheckValidateMsg msg) {
        if (scoreList == null || scoreList.size() == 0) {
            return;
        }
        int sum = scoreList.stream().mapToInt(dy -> dy.getInt("weight")).sum();
        LOG.info("checkScoreWight sum: {}", (Object)sum);
        if (sum != 100) {
            msg.setPass(Boolean.FALSE);
            msg.setNoteType(0);
            String message = ResManager.loadKDString((String)"\u6307\u6807\u6743\u91cd\u4e4b\u548c\u9700\u8981\u4e3a100%\u3002", (String)"IndicatorCheckHelper_13", (String)"hrmp-bes-business", (Object[])new Object[0]);
            msg.getMsgList().add(message);
        }
    }

    private static void checkNumberIndicatorLegal(List<DynamicObject> numberList, CheckValidateMsg msg, int accuracy) {
        for (DynamicObject dy : numberList) {
            boolean reasonScore;
            boolean maxMinCheck;
            ArrayList<String> contentList = new ArrayList<String>(10);
            BigDecimal maximum = dy.getBigDecimal("maximum");
            BigDecimal minimum = dy.getBigDecimal("minimum");
            BigDecimal scoreBelow = dy.getBigDecimal("needresscorebelow");
            BigDecimal scoreHigh = dy.getBigDecimal("needresscorehigh");
            LOG.info("checkNumberIndicatorLegal max: {}, min: {}, below: {}, high: {}", new Object[]{maximum, minimum, scoreBelow, scoreHigh});
            boolean bl = maxMinCheck = maximum.compareTo(minimum) <= 0;
            if (maxMinCheck) {
                contentList.add(IndicatorCheckHelper.getFieldMaxMin());
            }
            boolean bl2 = reasonScore = scoreBelow != null && scoreHigh != null && scoreHigh.compareTo(scoreBelow) <= 0;
            if (reasonScore) {
                contentList.add(IndicatorCheckHelper.getFieldBelowHigh());
            }
            if (!maxMinCheck && !reasonScore && msg.getPass().booleanValue()) {
                String defaultMessage;
                BigDecimal defaultMum = dy.getBigDecimal("defaultmum");
                if (defaultMum != null && (defaultMum.compareTo(maximum) > 0 || defaultMum.compareTo(minimum) < 0)) {
                    defaultMessage = String.format(ResManager.loadKDString((String)"\u201c\u9ed8\u8ba4\u503c\u201d\u9700\u8981\u5728[%1$s - %2$s]\u4e4b\u95f4", (String)"IndicatorCheckHelper_9", (String)"hrmp-bes-business", (Object[])new Object[0]), minimum.setScale(accuracy).toString(), maximum.setScale(accuracy).toString());
                    contentList.add(defaultMessage);
                }
                if (scoreBelow != null && (scoreBelow.compareTo(maximum) >= 0 || scoreBelow.compareTo(minimum) <= 0)) {
                    defaultMessage = String.format(ResManager.loadKDString((String)"\u201c\u9700\u8981\u539f\u56e0\uff08\u5206\u503c\u4f4e\u4e8e\uff09\u201d\u9700\u8981\u5728(%1$s - %2$s)\u4e4b\u95f4", (String)"IndicatorCheckHelper_10", (String)"hrmp-bes-business", (Object[])new Object[0]), minimum.setScale(accuracy).toString(), maximum.setScale(accuracy).toString());
                    contentList.add(defaultMessage);
                }
                if (scoreHigh != null && (scoreHigh.compareTo(maximum) >= 0 || scoreHigh.compareTo(minimum) <= 0)) {
                    defaultMessage = String.format(ResManager.loadKDString((String)"\u201c\u9700\u8981\u539f\u56e0\uff08\u5206\u503c\u9ad8\u4e8e\uff09\u201d\u9700\u8981\u5728(%1$s - %2$s)\u4e4b\u95f4", (String)"IndicatorCheckHelper_11", (String)"hrmp-bes-business", (Object[])new Object[0]), minimum.setScale(accuracy).toString(), maximum.setScale(accuracy).toString());
                    contentList.add(defaultMessage);
                }
            }
            if (contentList.size() <= 0) continue;
            String message = String.format(IndicatorCheckHelper.getFieldLegal(), dy.getString("indicatorname"), String.join((CharSequence)"\u3001", contentList));
            msg.setPass(Boolean.FALSE);
            msg.setNoteType(1);
            msg.getMsgList().add(message);
            LOG.info("checkNumberIndicatorLegal msg: {}", (Object)msg);
        }
    }

    private static void checkSelectIndicatorMustInput(List<DynamicObject> selectList, CheckValidateMsg msg, Map<Long, List<DynamicObject>> indicatorToOption, String method) {
        for (DynamicObject dy : selectList) {
            List<DynamicObject> options;
            int weight;
            ArrayList<String> contentList = new ArrayList<String>(10);
            if (!HRStringUtils.equals((String)"2", (String)method) && (weight = dy.getInt("weight")) == 0) {
                contentList.add(IndicatorCheckHelper.getFieldWeight());
            }
            if ((options = indicatorToOption.get(dy.getLong("id"))) != null && options.size() > 0) {
                for (DynamicObject option : options) {
                    Object optScore = option.get("optscore");
                    if (optScore != null) continue;
                    contentList.add(IndicatorCheckHelper.getFieldScore());
                    break;
                }
            }
            if (contentList.size() <= 0) continue;
            String message = String.format(IndicatorCheckHelper.getFieldIndicator(), dy.getString("indicatorname"), String.join((CharSequence)"\u3001", contentList));
            msg.setPass(Boolean.FALSE);
            msg.setNoteType(1);
            msg.getMsgList().add(message);
            LOG.info("checkSelectIndicatorMustInput msg: {}", (Object)msg);
        }
    }

    private static void checkNumberIndicatorMustInput(List<DynamicObject> numberList, CheckValidateMsg msg, String method) {
        for (DynamicObject dy : numberList) {
            Object minimum;
            BigDecimal maximum;
            int weight;
            ArrayList<String> contentList = new ArrayList<String>(10);
            if (!HRStringUtils.equals((String)"2", (String)method) && (weight = dy.getInt("weight")) == 0) {
                contentList.add(IndicatorCheckHelper.getFieldWeight());
            }
            if ((maximum = dy.getBigDecimal("maximum")) == null) {
                contentList.add(IndicatorCheckHelper.getFieldMax());
            }
            if ((minimum = dy.get("minimum")) == null) {
                contentList.add(IndicatorCheckHelper.getFieldMin());
            }
            if (contentList.size() <= 0) continue;
            String message = String.format(IndicatorCheckHelper.getFieldIndicator(), dy.getString("indicatorname"), String.join((CharSequence)"\u3001", contentList));
            msg.setPass(Boolean.FALSE);
            msg.setNoteType(1);
            msg.getMsgList().add(message);
            LOG.info("checkNumberIndicatorMustInput msg: {}", (Object)msg);
        }
    }

    private static void checkOverAllNumberIndicatorMustInput(List<DynamicObject> numberList, CheckValidateMsg msg) {
        for (DynamicObject dy : numberList) {
            Object minimum;
            ArrayList<String> contentList = new ArrayList<String>(10);
            BigDecimal maximum = dy.getBigDecimal("maximum");
            if (maximum == null) {
                contentList.add(IndicatorCheckHelper.getFieldMax());
            }
            if ((minimum = dy.get("minimum")) == null) {
                contentList.add(IndicatorCheckHelper.getFieldMin());
            }
            if (contentList.size() <= 0) continue;
            String message = String.format(IndicatorCheckHelper.getFieldIndicator(), dy.getString("indicatorname"), String.join((CharSequence)"\u3001", contentList));
            msg.setPass(Boolean.FALSE);
            msg.setNoteType(1);
            msg.getMsgList().add(message);
            LOG.info("checkNumberIndicatorMustInput msg: {}", (Object)msg);
        }
    }
}

