/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.bes.business.domain.setanonevaluator.SetAnonEvaluatorHelper;

public class EvalParamConfigService {
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("bes_parameterconfig");
    private static final Long CONFIG_ID = 1010L;
    private static final String SUCCESS = "success";
    private static final String MESSAGE = "message";
    private static final String ACCOUNT_INFO = "accountInfo";
    private static final String EVAL_BODY_INFO = "evalbodyinfo";
    private static final String ACCOUNT_SIZE = "accountsize";
    private static final String ACCOUNT = "account";
    private static final String ACCOUNT_WORD = "accountPwd";
    private static final String EVAL_BODY_NAME = "evalbodyname";
    private static final String EVAL_BODY_WEIGHT = "evalbodyweight";
    private static final String EVAL_SUB_NAME = "evalSubName";
    private static final String EVAL_SUB_WEIGHT = "evalSubWeight";

    public static DynamicObject getConfigDyn() {
        return SERVICE_HELPER.loadDynamicObject(new QFilter("id", "=", (Object)CONFIG_ID));
    }

    public static Map<String, Object> generateAnonAccount(Map<String, Object> anonInfoMap) {
        HashMap<String, Object> accountMap = new HashMap<String, Object>(3);
        if (anonInfoMap == null || anonInfoMap.size() == 0) {
            accountMap.put(SUCCESS, false);
            accountMap.put(MESSAGE, "anonInfoMap is null");
            accountMap.put(ACCOUNT_INFO, null);
            return accountMap;
        }
        String mainBody = (String)anonInfoMap.get("evalmainbody");
        if (HRStringUtils.equals((String)"10", (String)mainBody)) {
            List bodyInfo = (List)anonInfoMap.get(EVAL_BODY_INFO);
            if (bodyInfo == null || bodyInfo.size() == 0) {
                accountMap.put(SUCCESS, false);
                accountMap.put(MESSAGE, "evalbodyinfo is wrong");
                accountMap.put(ACCOUNT_INFO, null);
                return accountMap;
            }
            int size = EvalParamConfigService.getBodyInfoSize(bodyInfo);
            if (size == 0 || size > 500) {
                accountMap.put(SUCCESS, false);
                accountMap.put(MESSAGE, "evalbodyinfo is wrong");
                accountMap.put(ACCOUNT_INFO, null);
                return accountMap;
            }
            Map<String, List<String>> accountAndPwdMap = EvalParamConfigService.getAccountAndPwd(anonInfoMap, accountMap, size);
            if (accountAndPwdMap == null) {
                return accountMap;
            }
            ArrayList accountInfoList = new ArrayList(size);
            List<String> accountList = accountAndPwdMap.get(ACCOUNT);
            List<String> pwdList = accountAndPwdMap.get(ACCOUNT_WORD);
            int accountIndex = 0;
            for (Map body : bodyInfo) {
                int number = (Integer)body.get("participantnumber");
                for (int index = 0; index < number; ++index) {
                    if (accountIndex >= size) {
                        accountMap.put(SUCCESS, false);
                        accountMap.put(MESSAGE, "account size is wrong");
                        accountMap.put(ACCOUNT_INFO, null);
                        return accountMap;
                    }
                    HashMap<String, String> map = new HashMap<String, String>(2);
                    map.put(ACCOUNT, accountList.get(accountIndex));
                    map.put(ACCOUNT_WORD, pwdList.get(accountIndex));
                    map.put(EVAL_SUB_NAME, (String)body.get(EVAL_BODY_NAME));
                    map.put(EVAL_SUB_WEIGHT, (String)body.get(EVAL_BODY_WEIGHT));
                    accountInfoList.add(map);
                    ++accountIndex;
                }
            }
            accountMap.put(SUCCESS, true);
            accountMap.put(MESSAGE, null);
            accountMap.put(ACCOUNT_INFO, accountInfoList);
        } else if (HRStringUtils.equals((String)"20", (String)mainBody)) {
            Map<String, List<String>> accountAndPwdMap;
            int size = (Integer)anonInfoMap.get(ACCOUNT_SIZE);
            if (size < 1 || size > 500) {
                accountMap.put(SUCCESS, false);
                accountMap.put(MESSAGE, "accountsize is wrong");
                accountMap.put(ACCOUNT_INFO, null);
            }
            if ((accountAndPwdMap = EvalParamConfigService.getAccountAndPwd(anonInfoMap, accountMap, size)) == null) {
                return accountMap;
            }
            ArrayList accountInfoList = new ArrayList(size);
            List<String> accountList = accountAndPwdMap.get(ACCOUNT);
            List<String> pwdList = accountAndPwdMap.get(ACCOUNT_WORD);
            for (int index = 0; index < size; ++index) {
                HashMap<String, String> map = new HashMap<String, String>(2);
                map.put(ACCOUNT, accountList.get(index));
                map.put(ACCOUNT_WORD, pwdList.get(index));
                accountInfoList.add(map);
            }
            accountMap.put(SUCCESS, true);
            accountMap.put(MESSAGE, null);
            accountMap.put(ACCOUNT_INFO, accountInfoList);
        } else {
            accountMap.put(SUCCESS, false);
            accountMap.put(MESSAGE, "mainBody is wrong");
            accountMap.put(ACCOUNT_INFO, null);
        }
        return accountMap;
    }

    private static int getBodyInfoSize(List<Map<String, Object>> bodyInfo) {
        int size = 0;
        for (Map<String, Object> body : bodyInfo) {
            String evalBodyName = (String)body.get(EVAL_BODY_NAME);
            int weight = (Integer)body.get(EVAL_BODY_WEIGHT);
            int number = (Integer)body.get("participantnumber");
            if (HRStringUtils.isEmpty((String)evalBodyName) || weight < 1 || weight > 100 || number < 1) {
                return 0;
            }
            size += number;
        }
        return size;
    }

    private static Map<String, List<String>> getAccountAndPwd(Map<String, Object> anonInfoMap, Map<String, Object> accountMap, int size) {
        String accountLetter = (String)anonInfoMap.get("accountletter");
        int accountNumDigit = (Integer)anonInfoMap.get("accountnumdigit");
        if (!SetAnonEvaluatorHelper.isMatchLetter(accountLetter)) {
            accountMap.put(SUCCESS, false);
            accountMap.put(MESSAGE, "accountLetter is wrong");
            accountMap.put(ACCOUNT_INFO, null);
            return null;
        }
        if (accountNumDigit < 3 || accountNumDigit > 8) {
            accountMap.put(SUCCESS, false);
            accountMap.put(MESSAGE, "accountNumDigit must in [3,8]");
            accountMap.put(ACCOUNT_INFO, null);
            return null;
        }
        String pwdLetter = (String)anonInfoMap.get("pwdletter");
        String symbol = (String)anonInfoMap.get("pwdspecialsymbol");
        int pwdNumDigit = (Integer)anonInfoMap.get("pwdnumdigit");
        if (!SetAnonEvaluatorHelper.isMatchLetter(pwdLetter)) {
            accountMap.put(SUCCESS, false);
            accountMap.put(MESSAGE, "pwdLetter is wrong");
            accountMap.put(ACCOUNT_INFO, null);
            return null;
        }
        if (!SetAnonEvaluatorHelper.isSpecialSymbol(symbol)) {
            accountMap.put(SUCCESS, false);
            accountMap.put(MESSAGE, "pwdSpecialSymbol is wrong");
            accountMap.put(ACCOUNT_INFO, null);
            return null;
        }
        if (pwdNumDigit < 3 || pwdNumDigit > 8) {
            accountMap.put(SUCCESS, false);
            accountMap.put(MESSAGE, "pwdNumDigit must in [3,8]");
            accountMap.put(ACCOUNT_INFO, null);
            return null;
        }
        List<String> accountList = SetAnonEvaluatorHelper.getAccountList(accountLetter, accountNumDigit, size);
        List<String> passWordList = SetAnonEvaluatorHelper.getPassWordList(pwdLetter, symbol, pwdNumDigit, size);
        if (accountList.size() != size || passWordList.size() != size) {
            accountMap.put(SUCCESS, false);
            accountMap.put(MESSAGE, "account or pwd size is wrong");
            accountMap.put(ACCOUNT_INFO, null);
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(2);
        map.put(ACCOUNT, accountList);
        map.put(ACCOUNT_WORD, passWordList);
        return map;
    }
}

