/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.entityservice.evalsubtask;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hrmp.bes.business.domain.common.entityservice.AbstractBaseEntityService;

public class EvalSubTaskEntityService
extends AbstractBaseEntityService {
    private static final Log LOG = LogFactory.getLog(EvalSubTaskEntityService.class);

    public EvalSubTaskEntityService() {
        super("bes_evalsubtask");
    }

    public DynamicObject[] queryEvalSubTaskByEvalObjPerId(Long evalTaskId, Long evalContentId, Long objInfoPerEntryId, String dataSource) {
        QFilter taskIdFilter = new QFilter("evaltask.id", "=", (Object)evalTaskId);
        QFilter contentFilter = new QFilter("taskcontentid", "=", (Object)evalContentId);
        QFilter infoPerEntryId = new QFilter("objinfoperentryid", "=", (Object)objInfoPerEntryId);
        QFilter dataSourceFilter = new QFilter("perdatasource", "=", (Object)dataSource);
        QFilter[] filters = new QFilter[]{taskIdFilter, contentFilter, infoPerEntryId, dataSourceFilter};
        return this.loadDynamicObjectArray(filters);
    }

    public DynamicObject[] querySubTaskByObj(Object taskId, Object contentId, List<Long> evaluatorRealIds, List<String> userAccounts, String realOrCryPtoNym) {
        QFilter removeFilter = new QFilter("removemark", "=", (Object)Boolean.FALSE);
        QFilter taskQFilter = new QFilter("evaltask.id", "=", taskId);
        QFilter contentQFilter = new QFilter("taskcontentid", "=", contentId);
        taskQFilter.and(contentQFilter).and(removeFilter);
        if (realOrCryPtoNym.equals("1")) {
            QFilter reaEntryQFilter = new QFilter("evalinternalper.id", "in", evaluatorRealIds);
            QFilter outEntryId = new QFilter("evaloutsiderentryid", "in", evaluatorRealIds);
            reaEntryQFilter.or(outEntryId);
            taskQFilter.and(reaEntryQFilter);
        } else {
            QFilter accountQFilter = new QFilter("accountanon", "in", userAccounts);
            taskQFilter.and(accountQFilter);
        }
        return this.query("taskstatus,endtime", taskQFilter.toArray());
    }

    public DynamicObject[] queryByEvalInterId(Object id, Object taskId, Object contentId) {
        QFilter idFilter = new QFilter("evalinternalper.id", "=", id);
        idFilter.and(new QFilter("evaltask.id", "=", taskId));
        idFilter.and(new QFilter("taskcontentid", "=", contentId));
        QFilter removeFilter = new QFilter("removemark", "=", (Object)Boolean.FALSE);
        idFilter.and(removeFilter);
        LOG.info("EvalSubTaskEntityService.queryByEvalInterId.query:{}", (Object)idFilter.toString());
        return this.loadDynamicObjectArray(idFilter.toArray());
    }

    public DynamicObject[] queryEvalSubTaskByEvalObjOrgId(Long evalTaskId, Long evalContentId, Long objInfoPerEntryId, String dataSource) {
        QFilter taskIdFilter = new QFilter("evaltask.id", "=", (Object)evalTaskId);
        QFilter contentFilter = new QFilter("taskcontentid", "=", (Object)evalContentId);
        QFilter infoPerEntryId = new QFilter("objinfoorgentryid", "=", (Object)objInfoPerEntryId);
        QFilter dataSourceFilter = new QFilter("perdatasource", "=", (Object)dataSource);
        QFilter[] filters = new QFilter[]{taskIdFilter, contentFilter, infoPerEntryId, dataSourceFilter};
        return this.loadDynamicObjectArray(filters);
    }

    public DynamicObject[] queryByEvalOutEntryId(Object id, Object taskId, Object contentId) {
        QFilter idFilter = new QFilter("evaloutsiderentryid", "=", id);
        idFilter.and(new QFilter("evaltask.id", "=", taskId));
        idFilter.and(new QFilter("taskcontentid", "=", contentId));
        QFilter removeFilter = new QFilter("removemark", "=", (Object)Boolean.FALSE);
        idFilter.and(removeFilter);
        return this.loadDynamicObjectArray(idFilter.toArray());
    }

    public DynamicObject[] queryByEvaluatorAnonEntryId(Object id, Object taskId, Object contentId) {
        QFilter idFilter = new QFilter("evaluatoranonentryid", "=", id);
        idFilter.and(new QFilter("evaltask.id", "=", taskId));
        idFilter.and(new QFilter("taskcontentid", "=", contentId));
        QFilter removeFilter = new QFilter("removemark", "=", (Object)Boolean.FALSE);
        idFilter.and(removeFilter);
        return this.loadDynamicObjectArray(idFilter.toArray());
    }

    public DynamicObject[] queryByEvaluatorAnonEntryIds(List<Long> ids, Object taskId, Object contentId) {
        QFilter idFilter = new QFilter("evaluatoranonentryid", "in", ids);
        idFilter.and(new QFilter("evaltask.id", "=", taskId));
        idFilter.and(new QFilter("taskcontentid", "=", contentId));
        return this.loadDynamicObjectArray(idFilter.toArray());
    }

    public DynamicObject[] queryByevaluatorNumber(Object id, Object taskId, Object contentId) {
        QFilter idFilter = new QFilter("evaluatornumber", "=", id);
        idFilter.and(new QFilter("evaltask.id", "=", taskId));
        idFilter.and(new QFilter("taskcontentid", "=", contentId));
        QFilter removeFilter = new QFilter("removemark", "=", (Object)Boolean.FALSE);
        idFilter.and(removeFilter);
        return this.loadDynamicObjectArray(idFilter.toArray());
    }

    public DynamicObject[] queryByEvaluatorAccountsPer(List<String> accounts, Object taskId, Object contentId, Long objInfoPerEntryId) {
        QFilter idFilter = new QFilter("accountanon", "in", accounts);
        idFilter.and(new QFilter("evaltask.id", "=", taskId));
        idFilter.and(new QFilter("taskcontentid", "=", contentId));
        idFilter.and(new QFilter("objinfoperentryid", "=", (Object)objInfoPerEntryId));
        return this.loadDynamicObjectArray(idFilter.toArray());
    }

    public DynamicObject[] queryByEvaluatorAccountsOrg(List<String> accounts, Object taskId, Object contentId, Long objInfoOrgEntryId) {
        QFilter idFilter = new QFilter("accountanon", "in", accounts);
        idFilter.and(new QFilter("evaltask.id", "=", taskId));
        idFilter.and(new QFilter("taskcontentid", "=", contentId));
        idFilter.and(new QFilter("objinfoorgentryid", "=", (Object)objInfoOrgEntryId));
        return this.loadDynamicObjectArray(idFilter.toArray());
    }

    public DynamicObject[] queryByEvaluatorNumbersPer(List<String> ids, Object taskId, Object contentId, Long objInfoPerEntryId) {
        QFilter idFilter = new QFilter("evaluatornumber", "in", ids);
        idFilter.and(new QFilter("evaltask.id", "=", taskId));
        idFilter.and(new QFilter("taskcontentid", "=", contentId));
        idFilter.and(new QFilter("objinfoperentryid", "=", (Object)objInfoPerEntryId));
        return this.loadDynamicObjectArray(idFilter.toArray());
    }

    public DynamicObject[] queryByEvaluatorNumbersOrg(List<String> ids, Object taskId, Object contentId, Long objInfoOrgEntryId) {
        QFilter idFilter = new QFilter("evaluatornumber", "in", ids);
        idFilter.and(new QFilter("evaltask.id", "=", taskId));
        idFilter.and(new QFilter("taskcontentid", "=", contentId));
        idFilter.and(new QFilter("objinfoorgentryid", "=", (Object)objInfoOrgEntryId));
        return this.loadDynamicObjectArray(idFilter.toArray());
    }

    public List<DynamicObject> queryListByEvalTaskIdList(List<Long> ids) {
        QFilter evalTaskFilter = new QFilter("evaltask.id", "in", ids);
        return this.queryOriginalList("id,taskcontentid,perdatasource,objinfoorgentryid,objinfoperentryid,evaluatorsource,evalinternalper,evaloutsiderentryid", evalTaskFilter.toArray());
    }

    public DynamicObject[] queryByIds(List<Long> ids) {
        return this.loadDynamicObjectArray(new QFilter("id", "in", ids).toArray());
    }
}

